#ifndef __ABSTRACTDBUSLISTENER_H__
#define __ABSTRACTDBUSLISTENER_H__

#include <dbus/dbus.h>
#include <list>
#include <syslog.h>
#include <stdio.h>
#include "AbstractListener.h"
#include "AbstractStateConverter.h"

#define STATE_ACTIVE 100
#define STATE_PASSIVE 101
#define SHUTDOWN 102
#define PWRSAVE_ON 103
#define PWRSAVE_OFF 104
#define CHECK_INT32 105
#define CHECK_UINT32 106
#define CHECK_INT64 107
#define CHECK_UINT64 108
#define CHECK_STRING 109
#define CHECK_LONG 110
#define CHECK_BOOL 111

#define ERR(format, msg...) printf(format "\n",## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif

struct SignalEntry {
	// Name of the interface
	std::string ifName;
	// Name of the signal
	std::string signalName;
	// Reaction to this signal, see definitions above
	int reaction;
	// Amount of parameters to check
	int amount;
};

struct MethodCall {
	std::string serviceName;
	std::string pathName;
	std::string ifName;
	std::string method;
	int reaction;
};

class MAbstractDBUSListener : public MAbstractListener
{
	
public:
	
	// MAbstractListener interface
	bool Connect();
	void Disconnect();
	void CheckInitialState();
	void CheckState();
	virtual const std::string& GetName() = 0;
	
protected:
	
	bool SetupConnection();
	bool RegisterSignals();
	void HandleMessage(DBusMessage* aMessage);
	
	// Following: To be implemented in the concrete class
	virtual std::list<MethodCall*>& GetMethodCalls() = 0;
	virtual std::list<SignalEntry*>& GetSignalList() = 0;
	
	virtual void InitialCheckInt32Param(dbus_int32_t aParam) = 0;
	virtual void InitialCheckUInt32Param(dbus_uint32_t aParam) = 0;
	virtual void InitialCheckCharParam(const char* aParam) = 0;
	virtual void InitialCheckBooleanParam(bool aParam) = 0;

	virtual void StateCheckInt32Param(std::string& aSignal, dbus_int32_t aParam) = 0;
	virtual void StateCheckUInt32Param(std::string& aSignal, dbus_uint32_t aParam) = 0;
	virtual void StateCheckCharParam(std::string& aSignal, const char* aParam) = 0;
	virtual void StateCheckBooleanParam(std::string& aSignal, bool aParam) = 0;
	
	
	// Connection object
	DBusConnection* iConnection;

	// Name of the listener
	std::string iName;

	// Owner
	MAbstractStateConverter* iConverter;

};

#endif /*ABSTRACTDBUSLISTENER_H_*/
