/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name WLANPlugin.h
 * @memo WLAN specific implementation of the PeerHood plugin interface.
 *
 * @version 0.1
 * date     30.06.2003
 * change   30.06.2003
 */

#ifndef __WLANPLUGIN_H__
#define __WLANPLUGIN_H__

#include <string>
#include <list>
#include <pthread.h>
#include "AbstractPlugin.h"
#include "DaemonDevice.h"
#include "ServiceCheck.h"
#include "IFSearch.h"
#include "TCPConnection.h"
#include "AbstractListener.h"

/**
 * @memo WLAN specific implementation of the PeerHood plugin interface.
 * @doc This class is WLAN specific implementation of the PeerHood plugin
 * interface. Other PeerHood capable devices are located using implemented
 * lookup service
 *
 * @see MAbstractPlugin
 */

class CWLANPlugin : public MAbstractPlugin
{
 public:
  CWLANPlugin();
  virtual ~CWLANPlugin();
  bool Advert();
  bool Unadvert();
  bool Start();
  void Stop();
  const std::string& GetName();
  void UpdateState();
  void LoadListeners();
  
  // Abstract state changer
  void RegisterListener(MAbstractListener* aListener);
  void SetState(bool aActive);
  void TriggerShutdown();
  void SetAdapter(const std::string& aInterface, int aId);
  const std::string& GetAdapter();
  
 private:
  static void* ThreadStarter(void *aArguments);
  static void* ListenStarter(void *aArguments);
  static void* AdvertStarter(void *aArguments);
  bool Listen();
  void UnListen();

  bool AddDevice(const std::string& aDeviceName);
  //bool FetchServices(CDaemonDevice* aDevice);
  bool HasPeerHood(const std::string& aAddress, int* aPSM);

  void AdvertThread();
  void InquiryThread();
  void ListenThread();

  bool FetchInformation(CDaemonDevice* aDevice);
  bool FetchDeviceInfo(CDaemonDevice* aDevice, CTCPConnection* aConnection);
  bool FetchServices(CDaemonDevice* aDevice);
  bool FetchServices(CDaemonDevice* aDevice, CTCPConnection* aConnection);
  bool FetchPrototypes(CDaemonDevice* aDevice, CTCPConnection* aConnection);
  bool FetchNeighbourhoodDevices(CDaemonDevice * aDevice, CTCPConnection* aConnection);

  bool MakeOlder();
  bool LoadParameter(std::string& aParameter);
  bool TestConnection(unsigned int aFd, unsigned int aBytes);

  void RemoveListeners();
  
  volatile bool iStarted;
  volatile bool iActive;
  volatile bool iInSdp;
  volatile bool iListen;
  std::string iName;
  pthread_t iInquiryThread;
  pthread_t iListenThread;
  pthread_t iAdvertThread;

  std::list<CDaemonDevice *> iDeviceList;
  std::list<CServiceCheck> iServiceCheckList;
  
  // List of listeners
   std::list<MAbstractListener*> iListenerList;
   
  int iServiceCheckInterval, iInquiryInterval;
  std::string iNDevice;
  struct IFInfo *iIFaces;
  volatile bool iAdvertFailed;
};

#endif //__WLANPLUGIN_H
