/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name PHListItem.h
 * @memo PeerHood list element template.
 *
 * @version 0.1
 * date     17.04.2003
 * change   17.04.2003
 */

#ifndef __PHLISTITEM_H__
#define __PHLISTITEM_H__

#ifdef __cplusplus

#include <string>

template <class T> class CPHList;
template <class T> class CPHIterator;

/**
 * @memo PeerHood list element template class.
 * @memo PeerHood list element template class. The functionality is almost the
 * same as in the STL library with the exception that the pointed data is
 * deleted within the list item itself. This template is used internally by the
 * PeerHood system. Users should not use this class directly!
 *
 * @see CPHIterator
 * @see CPHList
 */
template <class T>
class CPHListItem
{
 public:
  CPHListItem(const T& aData);
  ~CPHListItem();
 private:
  friend class CPHList<T>;
  friend class CPHIterator<T>;

  T iData;
  CPHListItem<T>* iNext;
  CPHListItem<T>* iPrev;
};


/**
 * @memo Copy constructor.
 * @doc Copy constructor. This constructor creates a list element that points
 * to the same data as the original item.
 *
 * @param aData The original list item.
 *
 * @return none
 */
template <class T>
CPHListItem<T>::CPHListItem(const T& aData)
{
  iData = aData;
}


/**
 * @memo Destructor.
 * @doc Destructor. Note that in addition to the list item itself also the
 * pointed data is destroyed.
 *
 * @return none.
 */
template <class T>
CPHListItem<T>::~CPHListItem()
{
  delete iData;
}

#else

#endif

#endif
