/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name IFSearch.h
 * @memo PeerHood's IFSearch class. This class is used for searching
 * currently available network interfaces.
 *
 * @version 0.1
 * date     22.07.2003
 * change   14.11.2003
 */

#ifndef __IFSEARCH_H__
#define __IFSEARCH_H__

#include <string>
#include <sys/socket.h>
#include <netinet/in.h>

#define IFI_NAME 16
#define IFI_ALIAS 1


// Struct to hold interface data
// contains structures for unicast and broadcast addresses
struct IFInfo {
  struct sockaddr_in iUcast, iBcast;
};

/**
 * @memo PeerHood's IFSearch class. This class is used for searching
 * currently available network interfaces.
 * @doc This class defines the functionality for searching currently
 * available network interfaces. These interfaces 
 * are queried by using ioctl -call. Every interface is then added to 
 * CFInfo struct which holds information about network interfaces. These
 * structures then form a linked list which can be easily read.
 */

class CIFSearch
{

 public:
  CIFSearch();
  struct IFInfo *GetIFInfo(const std::string& aIface);

private:
  
};
#endif //__IFSEARCH_H__
