##  This file is part of PeerHood.
##
##  PeerHood is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License 
##   version 2 as published by the Free Software Foundation.
##
##   PeerHood is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU Lesser General Public License for more details.
##
##   You should have received a copy of the GNU Lesser General Public
##   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
##

## template-module/ Makefile 

## 1. common defines
include ../MakeCommonDefs.mk

## 2. own defines
MODULE = libpeerhood
MODULEDIR = $(BUILDDIR)/$(MODULE)
SRCS = $(wildcard *.cc)
OBJS = $(addprefix $(MODULEDIR)/, $(SRCS:%.cc=%.o))
INCS = $(wildcard *.h)

## 3. common rules
include ../MakeCommonRules.mk

## 4. own rules
all:: $(MODULEDIR) includes depend

clean::
	rm -f $(OBJS)
	rm -f $(addprefix $(resultincludedir)/,$(INCS))


