/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2004 LUT. .
 *
 * @name GPRSgw.h
 * @memo GPRS Gateway
 *
 * @version 0.1
 * date     20.04.2004
 * change   20.04.2004
 */

#ifndef __GPRSGW_H__
#define __GPRSGW_H__

#include <vector>
#include <pthread.h>

#include <peerhood/TCPConnection.h>
#include <peerhood/DaemonDevice.h>
#include "GPRSDevice.h"

const int MAXCONNS = 10;

class CGPRSgwThread;
/**
 * @memo Implementation of the GPRS Gateway
 * @doc Implementation of the GPRS Gateway.
 * This component takes care of routing GPRS
 * connections between GPRS -plugin users.
 *
 */
class CGPRSgw
{
 public:
  CGPRSgw(const std::string& aIface);
  bool StartDataConnections();
  void StopDataConnections();
  bool HandleSignalConnections();
  bool iLoop;

 private:
  static void* DataThreadStarter(void *aArguments);
  static void* NewThreadStarter(void *aArguments);

  void NoticeError(int aFd);
  void NoticeDataError(int aFd);

  bool StartNewThread(int aOriginalFd, int aReplyFd);
  void StopNewThread();

  void NewThread(CGPRSgwThread& aThreadInfo);
  bool HandleDataConnections();

  bool SendDeviceList(unsigned int aTargetFd, unsigned int aTargetId, fd_set &aTempSet);
  bool AddDevice(unsigned int aId, unsigned int aFd);
  bool HandleServiceList(unsigned int aSourceId, unsigned int aTargetFd, int &aErrorType);

  bool EncapsulateSignal(int aTargetFd, CGPRSSignal& aSignal);
  bool DecapsulateSignal(int aSourceFd, CGPRSSignal& aSignal);

  bool CheckPresence(int aTargetFd);
  bool RemoveDevice(unsigned int aFd);
  bool DeleteConnectionObject(unsigned int aFd);
  bool DeleteDataConnectionObject(unsigned int aFd);

  bool TestConnection(unsigned int aFd, unsigned int aBytes);

  volatile bool iDataStarted;
  bool iDataFailed;
  pthread_t iDataThread;
  fd_set masterSet;
  pthread_mutex_t iLock;
  std::string iIface;
  std::list<CGPRSDevice *> iDeviceList;
  std::list<CGPRSDataConnection> iDataConnections;

  std::list<MAbstractConnection*> iConnectionObjects;
  std::list<MAbstractConnection*> iDataConnectionObjects;
};

/**
 * @memo Container for Data Thread
 * @doc Container for Data Thread. This container is used for passing
 * sockets to new Data Thread.
 */
class CGPRSgwThread
{
 public:
  CGPRSgw *iInstance;
  unsigned int iOriginalFd;
  unsigned int iReplyFd;
};

#endif // __GPRSGW_H__
