/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name PHObject.h
 * @memo Base class of the PeerHood service system.
 *
 * @version 0.1
 * date     17.04.2003
 * change   17.04.2003
 */

#ifndef __PHOBJECT_H__
#define __PHOBJECT_H__

#include <AbstractConnection.h>

/**
 * @memo Base class of the PeerHood service system.
 * @memo Base class of the PeerHood service system. Each service defined by the
 * IDL language will be derived from this base class. This class should not be
 * used directly by an application developer. Instead, the PeerHood IDL
 * compiler will generate all necessary stub and skeleton class automatically.
 */
class CPHObject
{
 public:
  CPHObject();
  virtual ~CPHObject();
  const char* GetName();
  const std::string& GetAddress() const;
  MAbstractConnection* GetConnection();
  const int GetPort() const;
  const std::string& GetPrototype() const;
  void SetConnection(MAbstractConnection* aConnection);

 protected:
  char* iName;
  int iPort;
  std::string iAddress;
  std::string iPrototype;
  MAbstractConnection* iConnection;
};

#endif
