/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name Factory.h
 * @memo Static abstract factory class used to create network technology
 * specific MAbstractConnection objects.
 *
 * @version 0.1
 * date     02.04.2003
 * change   04.04.2003
 */

#ifndef __FACTORY_H__
#define __FACTORY_H__

#include <list>
#include <AbstractCreator.h>
//#include <AbstractPinger.h>
//#include <AbstractMonitor.h>

/**
 * @memo Static abstract factory class used to create network technology
 * specific MAbstractConnection objects. 
 * @doc Static abstract factory class used to create network technology
 * specific MAbstractConnection objects. This class holds a list of
 * MAbstractCreator objects that include the actual network technology 
 * specified functionality. The usage of the abstract factory pattern enables
 * transparent creation of MAbstractConnection objects of the right type.
 *
 * @see MAbstractCreator
 * @see MAbstractConnection
 * @see MAbstractPinger
 */
class Factory
{
 public:
  static void Register(MAbstractCreator* aCreator);
  static MAbstractConnection* CreateConnectionL(const std::string& aProto);
  static MAbstractPinger* CreatePingerL(const std::string& aProto, const std::string& aAddress);
  static MAbstractMonitor* CreateMonitorL(const std::string& aProto, const std::string& aAddress);
  static std::string* GetPluginNamesL(int* aSize);

 private:
  static std::list<MAbstractCreator *> iCreators;
};

#endif
