/* $Id: rpc.h,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBOSSOMM_INIT_H
#define LIBOSSOMM_INIT_H

#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>
#include <libosso.h> //TODO: Hide this?

namespace Osso
{

/** This callback is called
 * every time a method is requested on the registered interface.
 *
 * For instance,
 * @code
 * int on_rpc(const std::string& interface, const const std::string& method, GArray* arguments, osso_rpc_t& retval);
 * @endcode
 *
 * @param interface The interface that the method is called on.
 * @param method The method that is called.
 * @param arguments A GArray of #osso_rpc_t structures.  This array
 * and the osso_rpc_t values in it are only valid until the callback
 * returns.
 * @param retval The return value of the method. This should be set to
 * DBUS_TYPE_INVALID for no reply.  See #osso_rpc_set_cb_f and
 * #osso_rpc_free_val for how the memory associated with retval is
 * managed.
 * @param data An application specific pointer.
 * @return #OSSO_OK if the function executed successfully. retval is set to
 * DBUS_TYPE_INVALID for no reply. #OSSO_ERROR, if an error occured, a
 * dbus_error will be returned, and the retval should be of type
 * DBUS_TYPE_STRING with an error message string as value.
 */
typedef sigc::slot<int, const std::string&, const std::string&, GArray*, osso_rpc_t&> SlotRPC;

/**
 * This function registers a callback function for handling RPC calls to
 * a given object of a service.
 * @param osso The library context as returned by #osso_initialize.
 * @param service The service name to set up, e.g. com.nokia.application.
 * @param object_path The object path that this object has.
 * @param interface The interface that this object implements.
 * @param slot The function to register.
 * @return #OSSO_OK on success, #OSSO_INVALID if a parameter is
 * invalid, and #OSSO_ERROR if an error occurred.
 */
osso_return_t rpc_set_cb (osso_context_t* osso, const std::string& service,
				 const std::string& object_path,
				 const std::string& interface, const SlotRPC& slot);


} //namespace Osso

#endif /* #ifndef LIBOSSOMM_INIT_H */
