/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of libobd.
 *
 *  libobd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  libobd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libobd.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __OBD_LOG__H__
#define __OBD_LOG__H__

#include <stdio.h>

typedef enum {
	OBDLOG_ERROR = 1,
	OBDLOG_WARNING = 2,
	OBDLOG_INFO = 3,
	OBDLOG_DEBUG = 4
} obdloglevel;

extern FILE* obdlog_file;
extern obdloglevel obdlog_level;

#define LOG_ERROR(fmt...)						\
	do {								\
		if(obdlog_file != 0 && obdlog_level >= OBDLOG_ERROR) {	\
			fprintf(obdlog_file, "libobd[ERROR](%s:%d): ",	\
					__func__, __LINE__);		\
			fprintf(obdlog_file, fmt);			\
			fprintf(obdlog_file, "\n");			\
			fflush(obdlog_file);				\
		}							\
	} while(0)

#define LOG_WARNING(fmt...)						\
	do {								\
		if(obdlog_file != 0 && obdlog_level >= OBDLOG_WARNING) {\
			fprintf(obdlog_file, "libobd[WARNING](%s:%d): ",\
					__func__, __LINE__);		\
			fprintf(obdlog_file, fmt);			\
			fprintf(obdlog_file, "\n");			\
			fflush(obdlog_file);				\
		}							\
	} while(0)

#define LOG_INFO(fmt...)						\
	do {								\
		if(obdlog_file != 0 && obdlog_level >= OBDLOG_INFO) {	\
			fprintf(obdlog_file, "libobd[INFO](%s:%d): ",	\
					__func__, __LINE__);		\
			fprintf(obdlog_file, fmt);			\
			fprintf(obdlog_file, "\n");			\
			fflush(obdlog_file);				\
		}							\
	} while(0)

#define LOG_DEBUG(fmt...)						\
	do {								\
		if(obdlog_file != 0 && obdlog_level >= OBDLOG_DEBUG) {	\
			fprintf(obdlog_file, "libobd[INFO](%s:%d): ",	\
					__func__, __LINE__);		\
			fprintf(obdlog_file, fmt);			\
			fprintf(obdlog_file, "\n");			\
			fflush(obdlog_file);				\
		}							\
	} while(0)

#define LOG_NOESCAPE(level, str, buffer, size) if(obdlog_file != 0 && level <= obdlog_level) { \
		obdlog_write_noescape(level, str, buffer, size); \
	}

#define LOG_BINARY(level, str, buffer, size) if(obdlog_file != 0 && level <= obdlog_level) { \
		obdlog_write_binary(level, str, buffer, size); \
	}

void obdlog_setup(FILE* file, obdloglevel level);
void obdlog_write_noescape(obdloglevel level, char* str, char* buffer, unsigned int size);
void obdlog_write_binary(obdloglevel level, char* str, unsigned char* buffer, unsigned int size);

#endif /*__OBD_LOG__H__*/
