/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of libobd.
 *
 *  libobd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  libobd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libobd.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __OBD_CHAN__H__
#define __OBD_CHAN__H__

#include "libobd.h"
#include "obd-conn.h"

typedef enum {
	OBDCHAN_UNDEFINED,
	OBDCHAN_SIMULATOR,
	OBDCHAN_FILE,
	OBDCHAN_ELM,
	OBDCHAN_OZEN
} obdchan_type;

typedef enum {
	OBDCHANERR_ERROR = -1,
	OBDCHANERR_TIMEOUT = -2,
	OBDCHANERR_DEVICE_ERROR = -3,
	OBDCHANERR_PROTOCOL_ERROR = -4,
	OBDCHANERR_INVALID_ARGS = -5,
	OBDCHANERR_NOT_SETUP = -6,
	OBDCHANERR_ALREADY_SETUP = -7,
	OBDCHANERR_SETUP_ERROR = -8
} obchan_err;

struct obdchan {
	struct obdcon* con;
	obdchan_type type;
	int (*name) (char* buffer, unsigned int len);
	int (*sendpid) (struct obdchan* chan, struct obd_sensor_data* sensor_data, unsigned int timeout);
	int (*senddtc) (struct obdchan* chan, struct obd_dtc_data* dtc_data, unsigned int timeout);
	int (*close) (struct obdchan* chan);
	void* data;
};

int obdchan_init(struct obdchan* chan);
int obdchan_name(struct obdchan* chan, char* buffer, unsigned int len);
int obdchan_setup_simulator(struct obdchan* chan);
int obdchan_setup_file(struct obdchan* chan, char* filename);
int obdchan_setup_channel(struct obdchan* chan, struct obdcon* con);
int obdchan_sendpid(struct obdchan* chan, struct obd_sensor_data* sensor_data, unsigned int timeout);
int obdchan_senddtc(struct obdchan* chan, struct obd_dtc_data* dtc_data, unsigned int timeout);
int obdchan_close(struct obdchan* chan);

#endif /*__OBD_CHAN__H__*/
