<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_guestbook_get"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_guestbook_get">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getListWallMessages</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:if test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/>
                </xsl:if>
                <xsl:if test="not(/data/Request/Params/@id)">
                    <xsl:text>mm</xsl:text>
                    <xsl:value-of select="$MID"/>
                </xsl:if>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(event)"/>

                <xsl:attribute name="name">messageList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                    <xsl:if test="number($quantity) > 0">
                        <xsl:value-of select="number($quantity) - 1"/>
                    </xsl:if>
                    <xsl:if test="number($quantity) = 0">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                </xsl:attribute>

                <xsl:for-each select="event">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">message</xsl:attribute>
                            <xsl:attribute name="id">
                                <xsl:text>mm</xsl:text>
                            <xsl:value-of select="id"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">SenderId</xsl:attribute>
                                <xsl:text>mm</xsl:text>
                               <xsl:value-of select="user/uid"/>
                            </xsl:element>

                                    <xsl:element name="{$STRING}">
                                       <xsl:attribute name="name">SenderName</xsl:attribute>
                                            <xsl:value-of select="user/first_name"/>
                                            <xsl:text> </xsl:text>
                                            <xsl:value-of select="user/last_name"/>
                                    </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="time"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:if test="user_text">
                                    <xsl:value-of select="user_text"/>
                                    <xsl:text>  </xsl:text>
                                </xsl:if>
                                    <xsl:value-of select="description"/>
                            </xsl:element>

                            <xsl:for-each select="attachments">
                            <xsl:element name="{$STRUCT}">
                                <xsl:attribute name="name">attachment</xsl:attribute>

                              <xsl:choose>
                                <xsl:when test="object = 'image'">
                                    <xsl:attribute name="type">
                                        <xsl:text>image</xsl:text>
                                    </xsl:attribute>

                                    <xsl:attribute name="ownerId">
                                        <xsl:text>mm</xsl:text>
                                    <xsl:value-of select="../user/uid"/>
                                    </xsl:attribute>

                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">urlSmall</xsl:attribute>
                                        <xsl:value-of select="src"/>
                                    </xsl:element>
                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">urlBig</xsl:attribute>
                                        <xsl:value-of select="src"/>
                                    </xsl:element>
                                </xsl:when>
                                <xsl:when test="object = 'video'">
                                    <xsl:attribute name="type">
                                        <xsl:text>video</xsl:text>
                                    </xsl:attribute>

                                    <xsl:attribute name="ownerId">
                                        <xsl:text>mm</xsl:text>
                                    <xsl:value-of select="../user/uid"/>
                                    </xsl:attribute>

                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">urlImage</xsl:attribute>
                                        <xsl:value-of select="src"/>
                                    </xsl:element>
                                </xsl:when>
                                <xsl:when test="object = 'audio'">
                                    <xsl:attribute name="type">
                                        <xsl:text>audio</xsl:text>
                                    </xsl:attribute>
                                    <xsl:attribute name="id">
                                        <xsl:text>mm</xsl:text>
                                    <xsl:value-of select="mid"/>
                                    </xsl:attribute>
                                    <xsl:attribute name="ownerId">
                                        <xsl:text>mm</xsl:text>
                                    <xsl:value-of select="owner"/>
                                    </xsl:attribute>

                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">name</xsl:attribute>
                                        <xsl:value-of select="title"/>
                                    </xsl:element>
                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">url</xsl:attribute>
                                        <xsl:value-of select="link"/>
                                    </xsl:element>
                                    <xsl:element name="{$NUMBER}">
                                        <xsl:attribute name="name">duration</xsl:attribute>
                                        <xsl:value-of select="duration"/>
                                    </xsl:element>

                                </xsl:when>

                                <xsl:otherwise>
                                    <xsl:if test="href">
                                    <xsl:attribute name="type">
                                        <xsl:text>image</xsl:text>
                                    </xsl:attribute>

                                    <xsl:attribute name="ownerId">
                                        <xsl:text>mm</xsl:text>
                                    <xsl:value-of select="../user/uid"/>
                                    </xsl:attribute>

                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">urlSmall</xsl:attribute>
                                        <xsl:value-of select="href"/>
                                    </xsl:element>
                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">urlBig</xsl:attribute>
                                        <xsl:value-of select="href"/>
                                    </xsl:element>
                                    </xsl:if>
                                </xsl:otherwise>
                              </xsl:choose>
                              </xsl:element>
                            </xsl:for-each>

                        </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
