/*
 * driver.h -  MySocials driver
 * This file is part of MSA program.
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _DRIVER_H_
#define _DRIVER_H_

#define PAGE_SIZE 20
#define MAX_COUNTER 200
#define MID_SIZE 100
#define URL_SIZE 1024

#include <unistd.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <libxml/tree.h>
#include <libxml/xmlmemory.h>
#include <libxml/debugXML.h>
#include <libxml/HTMLtree.h>
#include <libxml/xmlIO.h>
/*#include <libxml/DOCBparser.h>*/
#include <libxml/xinclude.h>
#include <libxml/catalog.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/transform.h>
#include <libxslt/xsltutils.h>

#include <string.h>
#include <glib.h>
#include <time.h>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <glib/gprintf.h>

/* get system proxy from gconf (linux) */
#include <gconf/gconf-client.h>

#include "mysocials_driver.h"
#include "driver_config.h"
#include "profile.h"
#include "parser.h"
#include "dbus_functions.h"

#define XPATH_TAG_REQUEST "//Request"
#define XPATH_TAG_RESPONSE "//Response"
#define XPATH_TAG_NOTERROR "//Response[@function!='errorMessage']"
#define XPATH_TAG_ERROR "//Response[@function='errorMessage']"
#define XPATH_TAG_ERROR_CODE "//Response[@function='errorMessage']/Params/string[@name='code']"

#define PARSER_JSON "json"
#define PARSER_SETTINGS "settings"
#define PARSER_EMPTY "empty"
#define PARSER_DOWNLOAD "download"
#define PARSER_TEXT "text"
#define PARSER_WEBAUTH "webauth"
#define PARSER_WEBCAPTCHA "webcaptcha"

#define UTF8 "utf-8"
#define CP1251 "cp1251"
#define PARAMS "Params"
#define ERROR "error"
#define CLASS "class"
#define FUNCTION "function"

#define STRING "string"
#define IMG "img"
#define BOOLEAN "boolean"
#define NUMBER "number"
#define NAME "name"
#define LOGIN "login"
#define PASSWORD "password"

#define ERROR_RESPONSE "<Response class='systemMessages' function='errorMessage'>\
<Params>\
<string name=\"moduleName\">%s</string>\
<string name=\"code\">%s</string>\
<string name=\"text\">%s</string>\
<string name=\"comment\">%s</string>\
</Params></Response>"

/* get system proxy from gconf (linux) */
#define GCONF_PROXY_HOST "/system/http_proxy/host"
#define GCONF_PROXY_PORT "/system/http_proxy/port"
#define GCONF_PROXY_USE "/system/http_proxy/use_http_proxy"

gchar *info_proxy;
gint info_port;
gint upload_size;
gint download_size;


struct MemoryStruct {
    char* memory;
    size_t size;
};

/*
 * Struct contains information of file for upload.
 */
struct UpFile {
    gchar *name;
    gchar *file_path;
    gchar *file_name;
    gchar **params;
};

void upfile_remove(struct UpFile *file);
void* myrealloc(void* ptr, size_t size);
int authorize(struct ProfileData *cp, xmlDocPtr* response);
int request(xmlDocPtr reqXml, xmlDocPtr* doc, const struct msa_module* info);
xmlChar* get_req_class(xmlDocPtr reqXml);
xmlChar* get_req_function(xmlDocPtr reqXml);
int http_get(const char* url, const char* proxy, const int port, gchar** body, int* data_size);
int http_upload_file(const char* url, const char* proxy, const int port, gchar** body, struct UpFile *file);
int http_post(const char* url, const char* proxy, const int port, char* post_data, char** body, int* data_size);
void error_message(gchar* code, xmlDocPtr *doc, gchar* message, gchar *comment);
xmlXPathObject* xpath(char* req, xmlDocPtr doc);
xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc);

xmlDocPtr apply_parser(xmlDocPtr request, gchar* parser, struct ProfileData *pr);
int process_request(struct ProfileData *pr, xmlDocPtr request, xmlDocPtr* response);
int process_inner_request(struct ProfileData *pr, xmlDocPtr inner_req);
int save_file (xmlDocPtr reqXml, char* data, int data_size);
gchar* call_webauth(gchar* url, struct ProfileData *cp);
gchar* call_webcaptcha(gchar* strBase64, struct ProfileData *cp);
#endif
