<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_users_getInfo"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>


<xsl:template match="response_users_getInfo">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>mm</xsl:text>
                <xsl:value-of select="user/uid"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">FirstName</xsl:attribute>
                <xsl:value-of select="user/first_name"/>
            </xsl:element> 

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">LastName</xsl:attribute>
                <xsl:value-of select="user/last_name"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Gender</xsl:attribute>
                <xsl:if test="number(user/sex) = 1">
                <xsl:text>female</xsl:text>
                </xsl:if>
                <xsl:if test="number(user/sex) = 0">
                <xsl:text>male</xsl:text>
                </xsl:if>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Birthday</xsl:attribute>
                <xsl:value-of select="user/birthday"/>
            </xsl:element>
<!--
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">MobilePhone</xsl:attribute>
                <xsl:value-of select="user/mobile_phone"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">HomePhone</xsl:attribute>
                <xsl:value-of select="user/home_phone"/>
            </xsl:element>
-->
            <xsl:element name="{$IMG}">
                <xsl:attribute name="name">Img</xsl:attribute>
                <xsl:value-of select="user/pic_big"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">City</xsl:attribute>
                <xsl:value-of select="user/location/city/name"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Country</xsl:attribute>
                <xsl:value-of select="user/location/country/name"/>
            </xsl:element>


        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
