<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="USERNAME"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="SECRET"/>  
<xsl:param name="TIME"/>  
<xsl:param name="NONCE"/>
<xsl:param name="SUBDOMAIN"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="PARSER" select="'parser'"/>
<xsl:variable name="POST_PARAM" select="'post_param'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS" select="/Request/Params"/>  
<xsl:variable name="PARAMS_ALL" select="document('requests.xml')//requests/request[@function=$FUNCTION]"/>  

<xsl:template match="//Request">
    <xsl:choose>
          <xsl:when test="$FUNCTION = document('requests.xml')//requests/request/@function">
                <xsl:element name="{$INNER_REQUEST}">
                    <xsl:attribute name="type">
                       <xsl:value-of select="$PARAMS_ALL/type"/>
                    </xsl:attribute>

                    <xsl:if test="($PARAMS_ALL/type = 'get') or ($PARAMS_ALL/type = 'webauth') or ($PARAMS_ALL/type = 'post') or ($PARAMS_ALL/type = 'upload')">

                    <xsl:element name="{$URL}">
                        <xsl:call-template name="url-replace">
                          <xsl:with-param name="text" select="$PARAMS_ALL/url" />
                          <xsl:with-param name="replace" select="1" />
                        </xsl:call-template>
                    </xsl:element>
                   <xsl:for-each select="$PARAMS_ALL/file_param"> 
                        <xsl:element name="{@name}">
                            <xsl:choose>
                            <xsl:when test="@select != '.'">
                                <xsl:apply-templates select="$PARAMS">
                                  <xsl:with-param name="node">
                                    <xsl:value-of select="@select"/>
                                  </xsl:with-param>
                                </xsl:apply-templates>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="."/>
                            </xsl:otherwise>
                            </xsl:choose>
                        </xsl:element>
                   </xsl:for-each>        


                    <xsl:element name="{'params'}">
                       <xsl:for-each select="$PARAMS_ALL/param"> 
                          <xsl:sort order="ascending" select="@name"/>
                           <xsl:if test="not(@id)">
                              <xsl:value-of select="@name"/>
                              <xsl:text>=</xsl:text>
                              <xsl:choose>
                              <xsl:when test="@multiple = 'true'">
			                        <xsl:call-template name="arg-replace">
			                          <xsl:with-param name="text" select="." />
			                          <xsl:with-param name="replace" select="1" />
			                        </xsl:call-template>
                              </xsl:when>
                              <xsl:when test="@select != '.'">
                                  <xsl:apply-templates select="$PARAMS">
                                    <xsl:with-param name="node">
                                        <xsl:value-of select="@select"/>
                                    </xsl:with-param>
                                  </xsl:apply-templates>
                              </xsl:when>
                              <xsl:otherwise>
                                      <xsl:value-of select="."/>
                              </xsl:otherwise>
                              </xsl:choose>
                              <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
                           </xsl:if>
                       </xsl:for-each>        
                    </xsl:element>

                    <xsl:if test = "$PARAMS_ALL/url/@sig != 'false'">
                        <xsl:element name="{$SIG}">
                        <xsl:element name="{'type'}">
                            <xsl:if test="($PARAMS_ALL/type = 'get') or ($PARAMS_ALL/type = 'webauth')">
                                                    <xsl:value-of select="'GET'"/>
                            </xsl:if>
                            <xsl:if test="($PARAMS_ALL/type = 'post') or ($PARAMS_ALL/type = 'upload')">
                                                    <xsl:value-of select="'POST'"/>
                            </xsl:if>
                        </xsl:element>
                        <xsl:element name="{'url'}">

                        <xsl:call-template name="url-replace">
                          <xsl:with-param name="text" select="$PARAMS_ALL/url2" />
                          <xsl:with-param name="replace" select="2" />
                        </xsl:call-template>

                        </xsl:element>
                        <xsl:element name="{'params'}">

                           <xsl:for-each select="$PARAMS_ALL/param"> 
                                  <xsl:sort order="ascending" select="@name"/>
                                  <xsl:if  test="not(@id)">
                                      <xsl:value-of select="@name"/>
                                      <xsl:text>=</xsl:text>
                                      <xsl:choose>
                                      <xsl:when test="@multiple = 'true'">
			                                <xsl:call-template name="arg-replace">
			                                  <xsl:with-param name="text" select="." />
			                                  <xsl:with-param name="replace" select="1" />
			                                </xsl:call-template>
                                      </xsl:when>
                                      <xsl:when test="@select != '.'">
                                          <xsl:apply-templates select="$PARAMS">
                                            <xsl:with-param name="node">
                                                <xsl:value-of select="@select"/>
                                            </xsl:with-param>
                                          </xsl:apply-templates>
                                      </xsl:when>
                                      <xsl:otherwise>
                                          <xsl:value-of select="."/>
                                      </xsl:otherwise>

                                      </xsl:choose>
                                   <xsl:if test="position() != last()">
                        <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
<!--
                                      <xsl:text>%26</xsl:text>
-->
                                   </xsl:if>
                                  </xsl:if>
                           </xsl:for-each>        
                        </xsl:element>
                        </xsl:element>
                        <xsl:if test="$PARAMS/string[@name='secret']">
                            <xsl:element name="{'token_secret'}">
                               <xsl:value-of select="$PARAMS/string[@name='secret']"/>
                            </xsl:element>
                        </xsl:if>
                        <xsl:if test="$SECRET != '(null)'">
                            <xsl:element name="{'token_secret'}">
                               <xsl:value-of select="$SECRET"/>
                            </xsl:element>
                        </xsl:if>

                    </xsl:if>
                    </xsl:if>
                    
                    <xsl:if test="$PARAMS_ALL/type = 'download'">
                        <xsl:element name="{$URL}">
                           <xsl:value-of select="$PARAMS/string[@name='url']"/>
                        </xsl:element>
                        <xsl:copy-of select="$PARAMS"/>                    
                    </xsl:if>

                    <xsl:if test="$PARAMS_ALL/type = 'settings'">
                        <xsl:copy-of select="$PARAMS"/>                    
                    </xsl:if>

                       <xsl:copy-of select="$PARAMS_ALL/parser"/>
                </xsl:element> 
          </xsl:when>
          <xsl:otherwise>
              <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">systemMessages</xsl:attribute>
                <xsl:attribute name="function">errorMessage</xsl:attribute>
                <xsl:element name="{'Params'}">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">moduleName</xsl:attribute>
                        <xsl:text>vkontakte</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:text>201</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:text>Unable to perform request</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">comment</xsl:attribute>
			<xsl:text>Request not supported</xsl:text>
		    </xsl:element> 									
	    </xsl:element>
              </xsl:element>
          </xsl:otherwise>
    </xsl:choose> 
</xsl:template>

<xsl:template match="Params">
<xsl:param name="node"/>

    <xsl:if test="$node = 'id'">
        <xsl:choose>
              <xsl:when test="string-length(@id) != 0">
                  <xsl:value-of select="@id"/>
              </xsl:when>
              <xsl:otherwise>
                  <xsl:value-of select="$USERNAME"/>
              </xsl:otherwise>
        </xsl:choose> 
    </xsl:if>

    <xsl:if test="$node != 'id'">
      <xsl:choose>
        <xsl:when test="//*[@name=$node]">
            <xsl:value-of select="//*[@name=$node]"/>
        </xsl:when>

        <xsl:when test="$node = 'token'">
            <xsl:value-of select="$TOKEN"/>
        </xsl:when>
        <xsl:when test="$node = 'secret'">
            <xsl:value-of select="$SECRET"/>
        </xsl:when>
        <xsl:when test="$node = 'oauth_timestamp'">
            <xsl:value-of select="$TIME"/>
        </xsl:when>
        <xsl:when test="$node = 'oauth_nonce'">
            <xsl:value-of select="$NONCE"/>
        </xsl:when>
        <xsl:when test="$node = 'subdomain'">
            <xsl:value-of select="$SUBDOMAIN"/>
        </xsl:when>

        <xsl:when test="not(//*[@name=$node])">
            <xsl:value-of select="$PARAMS_ALL/param[@select=$node]"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="//*[@name=$node]"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>

</xsl:template>

 <xsl:template name="arg-replace">
    <xsl:param name="text" />
    <xsl:param name="replace" />
    <xsl:variable name="rs" select="concat('%',$replace)"/>
    <xsl:choose>
      <xsl:when test="contains($text, $rs)">
      <xsl:value-of select="substring-before($text,$rs)" />
      <xsl:choose>
      <xsl:when test="$PARAMS_ALL/param[@id = $replace]/@select != '.'">
          <xsl:apply-templates select="$PARAMS">
            <xsl:with-param name="node">
                <xsl:value-of select="$PARAMS_ALL/param[@id = $replace]/@select"/>
            </xsl:with-param>
          </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
      <xsl:value-of select="$PARAMS_ALL/param[@id = $replace]/."/>
      </xsl:otherwise>
      </xsl:choose>
        <xsl:call-template name="arg-replace">
          <xsl:with-param name="text" select="substring-after($text,$rs)" />
          <xsl:with-param name="replace" select="$replace + 1" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
      <xsl:value-of select="$text" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

    <xsl:template name="url-replace">
      <xsl:param name="text" />
      <xsl:param name="replace" />
      <xsl:variable name="rs" select="concat('%',$replace)"/>
      <xsl:choose>
        <xsl:when test="contains($text, $rs)">
        <xsl:value-of select="substring-before($text,$rs)" />
        <xsl:choose>
            <xsl:when test="$PARAMS_ALL/urlparam[@id = $replace]/@select != '.'">
                <xsl:apply-templates select="$PARAMS">
                  <xsl:with-param name="node">
                      <xsl:value-of select="$PARAMS_ALL/urlparam[@id = $replace]/@select"/>
                  </xsl:with-param>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$PARAMS_ALL/urlparam[@id = $replace]/."/>
            </xsl:otherwise>
        </xsl:choose>
          <xsl:call-template name="url-replace">
            <xsl:with-param name="text" select="substring-after($text,$rs)" />
            <xsl:with-param name="replace" select="$replace + 1" />
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
        <xsl:value-of select="$text" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:template>    

</xsl:stylesheet>
