<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="USERNAME"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="SECRET"/>  
<xsl:param name="TIME"/>  
<xsl:param name="NONCE"/>
<xsl:param name="SUBDOMAIN"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>
<xsl:include href="url-encode.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListPhotos</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(content/album/media)"/>

                <xsl:attribute name="name">photosList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                        <xsl:value-of select="number($quantity)"/>
                </xsl:attribute>

                <xsl:attribute name="ownerId">
                    <xsl:value-of select="content/album/@username"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:call-template name="url-encode">
                      <xsl:with-param name="str" select="content/album/@name" />
                    </xsl:call-template>
                </xsl:attribute>

                <xsl:for-each select="content/album/media">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">photo</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:call-template name="url-encode">
                              <xsl:with-param name="str" select="url" />
                            </xsl:call-template>
                        </xsl:attribute>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">urlSmall</xsl:attribute>
                           <xsl:value-of select="thumb"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">urlBig</xsl:attribute>
                            <xsl:value-of select="url"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">description</xsl:attribute>
                           <xsl:value-of select="description"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="@uploaddate"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
