#!/bin/bash

if [$1 -eq ""]; then
    echo "Must specify target platform"
    exit
fi

#SVN_LOC=http://uv-desktop/svn/home/external/mosquitto
SVN_LOC=http://192.168.15.50/svn/home/external/mosquitto

rm build-stamp configure-stamp
rm -rf ./mosquitto*
rm -rf ./libmosquitto*

svn export $SVN_LOC libmosquitto-0.9.1
pushd libmosquitto-0.9.1
echo y | dh_make --createorig --single -e yuvraaj@gmail.com -c lgpl

# First create everything for libmosquitto
cp build-files/postinst.libmosquitto debian/postinst
cp build-files/libmosquitto.control debian/control
cp build-files/libmosquitto.rules debian/rules
cp build-files/libmosquitto.install debian/
dpkg-buildpackage -rfakeroot -sa -S
dput -f $1-extras-builder ../libmosquitto*.changes

popd

# Cleanup from the first creation
rm -rf ./libmosquitto*
svn export $SVN_LOC mosquitto-0.9.1
pushd mosquitto-0.9.1
echo y | dh_make --createorig --single -e yuvraaj@gmail.com -c lgpl

# Create everything for mosquitto
cp build-files/postinst.mosquitto debian/postinst
cp build-files/mosquitto.control debian/control
cp build-files/mosquitto.rules debian/rules
cp build-files/mosquitto.install debian/
dpkg-buildpackage -rfakeroot -sa -S
dput -f $1-extras-builder ../mosquitto*.changes

popd

