#!/bin/bash

if [ $1 == "" ]; then
    echo "Must specify target platform"
    exit
fi

#SVN_LOC=http://uv-desktop/svn/home/external/mosquitto
SVN_LOC=http://192.168.15.50/svn/home/external/mosquitto
MQVER=0.15
SVNVER=`svn log $SVN_LOC --limit=1 | grep '^r' | sed 's/^r\([0-9]*\).*/\1/'`

rm build-stamp configure-stamp
rm -rf ./mosquitto*
rm -rf ./libmosquitto*

svn export $SVN_LOC libmosquitto-$MQVER.$SVNVER
pushd libmosquitto-$MQVER.$SVNVER
echo y | dh_make --createorig --single -e yuvraaj@gmail.com -c lgpl

# First create everything for libmosquitto
cp build-files/libmosquitto.control debian/control
cp build-files/libmosquitto.rules debian/rules
#cp build-files/libmosquitto.install debian/

# Fix the changelog to use the changelog we created.
head -1 ./debian/changelog >dest.txt ; cat ./build-files/changelog >>dest.txt ; tail -2 ./debian/changelog | head -1 | sed 's/unknown/Yuvraaj Kelkar/g' >>dest.txt
mv dest.txt ./debian/changelog

# Fix the python library so that it can work in Maemo.
sed 's/from ctypes import \*/from ctypes import \*\nc_bool = c_int/g' lib/python/mosquitto.py >mosquitto.py
mv mosquitto.py lib/python/mosquitto.py

dpkg-buildpackage -rfakeroot -sa -S
dput -f $1-extras-builder ../libmosquitto*.changes
#dpkg-buildpackage -rfakeroot

popd
