#include <microfeed-provider/microfeeddatabase.h>
#include <microfeed-common/microfeeditem.h>
#include <microfeed-common/microfeedobject.h>
#include <microfeed-common/microfeedmisc.h>
#include <microfeed-common/microfeedstore.h>
#include <stdio.h>
#include <string.h>

static void check_marshalled_item(MicrofeedItem* item, void* data, size_t size) {
	MicrofeedItem* db_item;
	MicrofeedItemIterator* iterator;
	MicrofeedItemIterator* db_iterator;
	int next;
	const char* key;
	const char* value;
	const char* db_key;
	const char* db_value;

	db_item = microfeed_item_new_from_marshalled(data, size);
	for (iterator = microfeed_item_iterate_properties(item, NULL), db_iterator = microfeed_item_iterate_properties(db_item, NULL);
	     (next = microfeed_item_iterator_get(iterator, &key, &value)) && microfeed_item_iterator_get(db_iterator, &db_key, &db_value);
	     microfeed_item_iterator_next(iterator), microfeed_item_iterator_next(db_iterator)) {
		microfeed_assert(!strcmp(key, db_key));
		microfeed_assert(!strcmp(value, db_value));
	}
	microfeed_assert(!next);
	
	microfeed_item_iterator_free(iterator);
	microfeed_item_iterator_free(db_iterator);	
	microfeed_item_free(db_item);
}

#define COUNT 1000

int main(void) {
	MicrofeedDatabase* database;
	MicrofeedDatabaseTable* table[COUNT];
	MicrofeedDatabaseIndex* uid_index[COUNT];
	MicrofeedDatabaseIndex* timestamp_uid_index[COUNT];
	MicrofeedStore* store[COUNT];
	long int i, k, n;
	char buffer1[1024];
	char buffer2[1024];
	MicrofeedItem* item;
	const void* const_data;
	MicrofeedDatabaseIterator* iterator;
	void* data;
	void* data2;
	size_t size;
	const void* key;
	int count = 0;
	
	unlink("/tmp/test-db");
	
	database = microfeed_database_new("test-db", "/tmp");

	snprintf(buffer1, 1024, "table-%d", count);
	table[count] = microfeed_database_get_table(database, buffer1);
	uid_index[count] = microfeed_database_table_get_index(table[count], "uid", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_uid, microfeed_database_compare_keys_direct);
	timestamp_uid_index[count] = microfeed_database_table_get_index(table[count], "timestamp", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_timestamp_uid, (MicrofeedDatabaseCompareFunction)microfeed_database_compare_keys_direct);
	microfeed_assert(uid_index[count] && timestamp_uid_index[count]);
	store[count] = microfeed_store_new_sorted_data((MicrofeedStoreCompareKeysFunction)strcmp, (MicrofeedStoreGetKeyFunction)microfeed_item_get_uid);
	count++;

	for (i = 0; i < 100000; i++) {
		n = random() % count;
		switch (random() % 10) {
			case 0:
			case 1:
			case 2:
				snprintf(buffer1, 1024, "uid-%ld", random());
				item = microfeed_item_new(buffer1, random());
				for (k = 0; k < random() % 25; k++) {
					snprintf(buffer1, 1024, "property-%ld", random());
					snprintf(buffer2, 1024, "value-%ld", random());
					microfeed_item_set_property(item, buffer1, buffer2);
				}

				microfeed_item_marshal(item, &const_data, &size);
				microfeed_database_index_replace_data(uid_index[n], const_data, size);
				microfeed_database_index_replace_data(timestamp_uid_index[n], const_data, size);
				
				if ((item = microfeed_store_replace(store[n], item, MicrofeedItem))) {
					microfeed_item_free(item);
				}
				break;
			case 3:
				if (microfeed_store_get_size(store[n]) > 0) {
					item = microfeed_store_get_index(store[n], random() % microfeed_store_get_size(store[n]), MicrofeedItem);
					microfeed_assert(microfeed_database_index_get_data(uid_index[n], microfeed_item_get_uid(item), strlen(microfeed_item_get_uid(item)) + 1, &data, &size));
					check_marshalled_item(item, data, size);
					microfeed_item_marshalled_get_timestamp_uid(data, size, &key, &size);
					microfeed_assert(microfeed_database_index_get_data(timestamp_uid_index[n], key, size, &data2, &size));
					check_marshalled_item(item, data2, size);
					free(data);
					free(data2);
					microfeed_database_index_remove_data(uid_index[n], microfeed_item_get_uid(item), strlen(microfeed_item_get_uid(item)) + 1);
					microfeed_store_remove(store[n], item);
					microfeed_item_free(item);
				}
				break;
			case 4:
				if (count < COUNT) {
					snprintf(buffer1, 1024, "table-%d", count);
					table[count] = microfeed_database_get_table(database, buffer1);
					uid_index[count] = microfeed_database_table_get_index(table[count], "uid", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_uid, microfeed_database_compare_keys_direct);
					timestamp_uid_index[count] = microfeed_database_table_get_index(table[count], "timestamp", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_timestamp_uid, (MicrofeedDatabaseCompareFunction)microfeed_database_compare_keys_direct);
					microfeed_assert(uid_index[count] && timestamp_uid_index[count]);
					store[count] = microfeed_store_new_sorted_data((MicrofeedStoreCompareKeysFunction)strcmp, (MicrofeedStoreGetKeyFunction)microfeed_item_get_uid);
					count++;
				}
				break;
		}
		microfeed_assert(microfeed_database_table_get_data_count(table[n]) == microfeed_store_get_size(store[n]));
		printf(" %ld \t%d \t%d\r", i, microfeed_store_get_size(store[n]), count);
		if (i % 10000 == 0) {
		}
	}

/*	for (i = 0; i < 100; i++) {
		snprintf(buffer, 1024, "uid-%d", i);
		item = microfeed_item_new(buffer, random());
		microfeed_item_set_property(item, "property", "value");
	}

	printf("uid:\n");
	for (iterator = microfeed_database_index_iterate(uid_index, NULL, 0, 0), i = 0;
	     microfeed_database_iterator_get(iterator, &data, &size);
	     microfeed_database_iterator_next(iterator), i++) {
	 	item = microfeed_item_new_from_marshalled(data, size);
		free(data);
		printf("item: %s %ld\n", microfeed_item_get_uid(item), microfeed_item_get_timestamp(item));
		microfeed_item_set_timestamp(item, random());
		microfeed_item_marshal(item, &const_data, &size);
		microfeed_database_index_replace_data(uid_index, const_data, size);
		microfeed_item_free(item);
		if (i == 10) {
			printf("REMOVED\n");
			microfeed_database_index_remove_data(uid_index, "uid-20", strlen("uid-20") + 1);
		}
	}
	microfeed_database_iterator_free(iterator);

	printf("timestamp_uid:\n");
	for (iterator = microfeed_database_index_iterate(timestamp_uid_index, NULL, 0, 0);
	     microfeed_database_iterator_get(iterator, &data, &size);
	     microfeed_database_iterator_next(iterator)) {
	 	item = microfeed_item_new_from_marshalled(data, size);
		printf("item: %s %ld\n", microfeed_item_get_uid(item), microfeed_item_get_timestamp(item));
		microfeed_item_free(item);
		free(data);
	}
	microfeed_database_iterator_free(iterator);
*/	
	for (i = 0; i < COUNT; i++) {
		microfeed_object_unref(uid_index[i], MicrofeedDatabaseIndex);
		microfeed_object_unref(timestamp_uid_index[i], MicrofeedDatabaseIndex);
		microfeed_object_unref(table[i], MicrofeedDatabaseTable);
		microfeed_store_foreach(store[i], (MicrofeedStoreForeachFunction)microfeed_item_free, NULL);
		microfeed_store_free(store[i]);
	}
	microfeed_object_unref(database, MicrofeedDatabase);

	return 0;
}

