#include <hildon/hildon.h>
#include "he-menu-view-column.h"
#include "he-menu-store.h"
#include "he-menu-view_priv.h"

struct _HeMenuViewColumn
{
	HildonPannableArea __parent_instance__;

	GtkWidget *tv;
	GtkWidget *menu_widget;
	guint row_changed_id;
	guint row_deleted_id;
};

struct _HeMenuViewColumnClass
{
	HildonPannableAreaClass __parent_class__;
};

G_DEFINE_TYPE(HeMenuViewColumn, he_menu_view_column, HILDON_TYPE_PANNABLE_AREA);

enum {
	HE_MENU_VIEW_COLUMN_MENU_PROPERTY = 1,
	HE_MENU_VIEW_COLUMN_MENU_WIDGET_PROPERTY,
};

static void
size_request(GtkWidget *widget, GtkRequisition *rq)
{
	HeMenuViewColumn *hmvc = HE_MENU_VIEW_COLUMN(widget);
	GtkRequisition rq_tv = {.width = 0, .height = 0};
	guint indicator_width;

	gtk_widget_style_get(widget, "indicator-width", &indicator_width, NULL);
	gtk_widget_size_request(hmvc->tv, &rq_tv);

	rq->width  = 2 * GTK_CONTAINER(widget)->border_width + rq_tv.width + indicator_width;
	rq->height = 2 * GTK_CONTAINER(widget)->border_width + rq_tv.height;

//	g_print("%s: size_request: width  = 2 * %3d + %3d + %3d = %3d\n", 
//		gtk_widget_get_name(widget), GTK_CONTAINER(widget)->border_width, rq_tv.width, indicator_width, rq->width);
//	g_print("%s: size_request: height = 2 * %3d + %3d       = %3d\n",
//		gtk_widget_get_name(widget), GTK_CONTAINER(widget)->border_width, rq_tv.height, rq->height);
}

static void
set_property(GObject *obj, guint property_id, const GValue *val, GParamSpec *pspec)
{
	switch (property_id) {
		case HE_MENU_VIEW_COLUMN_MENU_PROPERTY:
			he_menu_view_column_set_menu(HE_MENU_VIEW_COLUMN(obj), GTK_MENU(g_value_get_object(val)));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(obj, property_id, pspec);
			break;
	}
}

static void
get_property(GObject *obj, guint property_id, GValue *val, GParamSpec *pspec)
{
	HeMenuViewColumn *hmvc = HE_MENU_VIEW_COLUMN(obj);

	switch (property_id) {
		case HE_MENU_VIEW_COLUMN_MENU_PROPERTY:
			g_value_set_object(val, he_menu_view_column_get_menu(hmvc));
			break;

		case HE_MENU_VIEW_COLUMN_MENU_WIDGET_PROPERTY:
			g_value_set_object(val, hmvc->menu_widget);
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(obj, property_id, pspec);
			break;
	}
}

static void
he_menu_view_column_class_init(HeMenuViewColumnClass *hmvc_class)
{
	GObjectClass   *gobject_class = G_OBJECT_CLASS(hmvc_class);
	GtkWidgetClass *gtkwidget_class = GTK_WIDGET_CLASS(hmvc_class);

	gobject_class->set_property = set_property;
	gobject_class->get_property = get_property;

	gtkwidget_class->size_request  = size_request;

	g_object_class_install_property(gobject_class, HE_MENU_VIEW_COLUMN_MENU_PROPERTY,
		g_param_spec_object("menu", "Menu", "The menu to display",
			GTK_TYPE_MENU, G_PARAM_READWRITE));

	g_object_class_install_property(gobject_class, HE_MENU_VIEW_COLUMN_MENU_WIDGET_PROPERTY,
		g_param_spec_object("menu-widget", "Menu Widget", "The last menu widget that was activated",
			GTK_TYPE_WIDGET, G_PARAM_READABLE));
}

static void
tv_row_activated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, HeMenuViewColumn *hmvc)
{
	GtkWidget *menu_widget = NULL;
	GtkTreeIter itr;
	GtkTreeModel *tm = gtk_tree_view_get_model(tv);

	g_print("HMVC: tv_row_activated\n");

	gtk_tree_model_get_iter(tm, &itr, tp);

	gtk_tree_model_get(tm, &itr, HE_MENU_STORE_MENU_WIDGET, &menu_widget, -1);

	if (menu_widget)
		if (GTK_WIDGET_SENSITIVE(menu_widget)) {
			hmvc->menu_widget = menu_widget;
			gtk_menu_item_activate(GTK_MENU_ITEM(menu_widget));
			g_object_notify(G_OBJECT(hmvc), "menu-widget");
		}
}

/* For some reason we need to emit row-activate for check menu items */
static gboolean
tv_button_release(GtkTreeView *tv, GdkEventButton *event, HeMenuViewColumn *col)
{
	GtkTreePath *tp;

	if (gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(tv), event->x, event->y, &tp, NULL, NULL, NULL)) {
		GtkTreeModel *tm;

		g_object_get(G_OBJECT(tv), "model", &tm, NULL);

		if (tm) {
			GtkTreeIter itr;

			if (gtk_tree_model_get_iter(tm, &itr, tp)) {
				GtkWidget *widget = NULL;

				gtk_tree_model_get(tm, &itr, HE_MENU_STORE_MENU_WIDGET, &widget, -1);
				if (widget) {
					if (GTK_IS_CHECK_MENU_ITEM(widget))
						gtk_tree_view_row_activated(tv, tp, gtk_tree_view_get_column(tv, 0));
				}
			}
		}

		gtk_tree_path_free(tp);
	}

	return FALSE;
}

static void
he_menu_view_column_init(HeMenuViewColumn *hmvc)
{
	GtkCellRenderer *cr;
	GtkTreeViewColumn *col = gtk_tree_view_column_new();

	cr = g_object_new(GTK_TYPE_CELL_RENDERER_PIXBUF, NULL);
	gtk_tree_view_column_pack_start(col, cr, FALSE);
	gtk_tree_view_column_set_attributes(col, cr,
		"pixbuf",     HE_MENU_STORE_IMAGE_PIXBUF,
		"visible",    HE_MENU_STORE_IS_IMAGE_ITEM,
		"sensitive",  HE_MENU_STORE_SENSITIVE,
		NULL);

	cr = g_object_new(GTK_TYPE_CELL_RENDERER_TOGGLE, NULL);
	gtk_tree_view_column_pack_start(col, cr, FALSE);
	gtk_tree_view_column_set_attributes(col, cr,
		"sensitive",    HE_MENU_STORE_SENSITIVE,
		"active",       HE_MENU_STORE_ACTIVE,
		"inconsistent", HE_MENU_STORE_INCONSISTENT,
		"radio",        HE_MENU_STORE_IS_RADIO_ITEM,
		"visible",      HE_MENU_STORE_IS_CHECK_ITEM,
		NULL);

	cr = g_object_new(GTK_TYPE_CELL_RENDERER_TEXT, NULL);
	gtk_tree_view_column_pack_start(col, cr, TRUE);
	gtk_tree_view_column_set_attributes(col, cr,
		"sensitive", HE_MENU_STORE_SENSITIVE,
		"text",      HE_MENU_STORE_TEXT,
		NULL);

	cr = g_object_new(GTK_TYPE_CELL_RENDERER_PIXBUF, "stock-id", GTK_STOCK_GO_FORWARD, NULL);
	gtk_tree_view_column_pack_start(col, cr, FALSE);
	gtk_tree_view_column_set_attributes(col, cr,
		"visible",   HE_MENU_STORE_HAS_CHILDREN,
		"sensitive", HE_MENU_STORE_SENSITIVE,
		NULL);

	hmvc->tv = g_object_new(GTK_TYPE_TREE_VIEW, "visible", TRUE, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(hmvc->tv), col);
	gtk_container_add(GTK_CONTAINER(hmvc), hmvc->tv);
	g_signal_connect(G_OBJECT(hmvc->tv), "row-activated", (GCallback)tv_row_activated, hmvc);
	g_signal_connect(G_OBJECT(hmvc->tv), "button-release-event", (GCallback)tv_button_release, hmvc);

	hmvc->menu_widget = NULL;
	hmvc->row_changed_id = 0;
	hmvc->row_deleted_id = 0;
}

GtkWidget *
he_menu_view_column_get_menu(HeMenuViewColumn *hmvc)
{
	GObject *model = NULL;
	GtkWidget *menu = NULL;

	g_return_val_if_fail(HE_IS_MENU_VIEW_COLUMN(hmvc), NULL);

	g_object_get(G_OBJECT(hmvc->tv), "model", &model, NULL);
	if (model)
		g_object_get(G_OBJECT(model), "child-model", &model, NULL);
	if (model)
		g_object_get(G_OBJECT(model), "menu", &menu, NULL);

	return menu;
}

void
he_menu_view_column_set_menu(HeMenuViewColumn *hmvc, GtkMenu *menu)
{
	GObject *old_tm;

	g_return_if_fail(HE_IS_MENU_VIEW_COLUMN(hmvc));
	g_return_if_fail(GTK_IS_MENU(menu));

	g_object_get(G_OBJECT(hmvc->tv), "model", &old_tm, NULL);

	if (old_tm) {
		if (hmvc->row_changed_id) {
			g_signal_handler_disconnect(old_tm, hmvc->row_changed_id);
			hmvc->row_changed_id = 0;
		}
		if (hmvc->row_deleted_id) {
			g_signal_handler_disconnect(old_tm, hmvc->row_deleted_id);
			hmvc->row_deleted_id = 0;
		}
	}

	if (menu) {
		GtkTreeModel *hms = g_object_new(HE_TYPE_MENU_STORE, "menu", menu, NULL);
		GtkTreeModel *tm = g_object_new(GTK_TYPE_TREE_MODEL_FILTER, "child-model", hms, NULL);

		g_object_unref(hms);
		gtk_tree_model_filter_set_visible_column(GTK_TREE_MODEL_FILTER(tm), HE_MENU_STORE_VISIBLE);
		gtk_widget_set_name(GTK_WIDGET(hmvc), gtk_widget_get_name(GTK_WIDGET(menu)));
		g_object_set(G_OBJECT(hmvc->tv), "model", tm, NULL);
		g_object_unref(tm);
	}
}
