/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2009 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _HE_FANCY_BUTTON_H_
#define _HE_FANCY_BUTTON_H_

#include <gtk/gtk.h>
#include <hildon/hildon.h>

G_BEGIN_DECLS

typedef struct _HeFancyButton        HeFancyButton;
typedef struct _HeFancyButtonClass   HeFancyButtonClass;
typedef struct _HeFancyButtonPrivate HeFancyButtonPrivate;

struct _HeFancyButton {
  GtkEventBox __parent_instance__;
	HeFancyButtonPrivate *priv;
};

struct _HeFancyButtonClass {
  GtkEventBoxClass __parent_class__;
  void (*clicked) (GtkWidget *widget);
};

#define HE_ICON_SIZE_FANCY_BUTTON gtk_icon_size_from_name("he-fancy-button")
#define HE_ICON_PIXEL_SIZE_FANCY_BUTTON hildon_get_icon_pixel_size(HE_ICON_SIZE_FANCY_BUTTON)

GType he_fancy_button_get_type (void);

#define HE_TYPE_FANCY_BUTTON (he_fancy_button_get_type ())
#define HE_FANCY_BUTTON(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), HE_TYPE_FANCY_BUTTON, HeFancyButton))
#define HE_IS_FANCY_BUTTON(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), HE_TYPE_FANCY_BUTTON))
#define HE_FANCY_BUTTON_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object),  HE_TYPE_FANCY_BUTTON, HeFancyButtonClass))
#define HE_FANCY_BUTTON_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass),     HE_TYPE_FANCY_BUTTON, HeFancyButtonClass))
#define HE_IS_FANCY_BUTTON_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass),     HE_TYPE_FANCY_BUTTON))

G_END_DECLS

#endif /* !_HE_FANCY_BUTTON_H_ */
