/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2010 Gabriel Schulhof <nix@go-nix.ca>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "he-menu-view_priv.h"

G_GNUC_INTERNAL
void
_hmv_private_get_first_label_found(GtkWidget *widget, GtkWidget **p_label)
{
	if (GTK_IS_LABEL(widget))
		(*p_label) = widget;
	else
	if (GTK_IS_CONTAINER(widget))
		gtk_container_forall(GTK_CONTAINER(widget), (GtkCallback)_hmv_private_get_first_label_found, p_label);
}

G_GNUC_INTERNAL
GtkMenuItem *
_hmv_private_get_attach_widget(GtkWidget *widget)
{
	GtkWidget *attach_widget = gtk_menu_get_attach_widget(GTK_MENU(widget));

	if (!GTK_IS_MENU_ITEM(attach_widget))
		attach_widget = NULL;

	return GTK_MENU_ITEM(attach_widget);
}

G_GNUC_INTERNAL
const char *
_hmv_private_menu_item_get_label(GtkWidget *menu_item, GtkWidget **p_label)
{
	GtkWidget *label = NULL;

	g_return_val_if_fail(GTK_IS_MENU_ITEM(menu_item), NULL);

	_hmv_private_get_first_label_found(menu_item, &label);

	if (p_label)
		(*p_label) = label;

	return label ? gtk_label_get_text(GTK_LABEL(label)) : NULL;
}

G_GNUC_INTERNAL
GtkWidget *
_hmv_private_menu_get_parent_menu(GtkWidget *menu)
{
	GtkWidget *ret = NULL;

	if (menu) {
		g_return_val_if_fail(GTK_IS_MENU(menu), NULL);

		menu = GTK_WIDGET(_hmv_private_get_attach_widget(menu));

		if (menu) {
			menu = gtk_widget_get_parent(menu);
			if (GTK_IS_MENU(menu))
				ret = menu;
		}
	}

	return ret;	
}
