/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2010 Gabriel Schulhof <nix@go-nix.ca>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HE_MENU_STORE_H__
#define __HE_MENU_STORE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define HE_TYPE_MENU_STORE (he_menu_store_get_type())
#define HE_MENU_STORE(object)           (G_TYPE_CHECK_INSTANCE_CAST((object), HE_TYPE_MENU_STORE, HeMenuStore))
#define HE_MENU_STORE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass),     HE_TYPE_MENU_STORE, HeMenuStoreClass))
#define HE_IS_MENU_STORE(object)        (G_TYPE_CHECK_INSTANCE_TYPE((object), HE_TYPE_MENU_STORE))
#define HE_IS_MENU_STORE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass),     HE_TYPE_MENU_STORE))
#define HE_MENU_STORE_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS((object),  HE_TYPE_MENU_STORE, HeMenuStoreClass))

typedef struct _HeMenuStore        HeMenuStore;
typedef struct _HeMenuStoreClass   HeMenuStoreClass;
typedef struct _HeMenuStorePrivate HeMenuStorePrivate;

struct _HeMenuStore
{
	GObject __parent_instance__;
	HeMenuStorePrivate *priv;
};

struct _HeMenuStoreClass
{
	GObjectClass __parent_class__;
	void (*gtk_menu_shell_insert)(GtkMenuShell *, GtkWidget *, gint);
};

GType he_menu_store_get_type(void) G_GNUC_CONST;

GtkTreeModel *he_menu_store_new(GtkMenu *menu);

/**
 * HeMenuStoreColumn:
 * @HE_MENU_STORE_IMAGE_PIXBUF: Index of the column containing the #GtkImageMenuItem's #GdkPixbuf 
 * @HE_MENU_STORE_IS_IMAGE_ITEM: Index of the column indicating whether this is a #GtkImageMenuItem
 * @HE_MENU_STORE_IS_CHECK_ITEM: Index of the column indicating whether this is a #GtkCheckMenuItem
 * @HE_MENU_STORE_IS_RADIO_ITEM: Index of the column indicating wheather this is a #GtkRadioMenuItem
 * @HE_MENU_STORE_TEXT: Index of the column containing the #GtkMenuItem's text (Note: Mnemonic underscores are removed)
 * @HE_MENU_STORE_VISIBLE: Index of the column indicating wheather this #GtkMenuItem is visible
 * @HE_MENU_STORE_SENSITIVE: Index of the column indicating wheather this #GtkMenuItem is sensitive
 * @HE_MENU_STORE_ACTIVE: Index of the column indicating wheather this #GtkCheckMenuItem is active
 * @HE_MENU_STORE_INCONSISTENT: Index of the column indicating wheather this #GtkCheckMenuItem is inconsistent
 * @HE_MENU_STORE_MENU_WIDGET: Index of the column containing the #GtkMenuItem
 * @HE_MENU_STORE_HAS_CHILDREN: Index of the column indicating wheather this #GtkCheckMenuItem has a submenu
 * @HE_MENU_STORE_N_COLUMNS: Number of columns in a #HeMenuStore
 *
 * These are the column indices and the column count of a #HeMenuStore.
 */
typedef enum {
	HE_MENU_STORE_IMAGE_PIXBUF,
	HE_MENU_STORE_IS_IMAGE_ITEM,
	HE_MENU_STORE_IS_CHECK_ITEM,
	HE_MENU_STORE_IS_RADIO_ITEM,
	HE_MENU_STORE_TEXT,
	HE_MENU_STORE_VISIBLE,
	HE_MENU_STORE_SENSITIVE,
	HE_MENU_STORE_ACTIVE,
	HE_MENU_STORE_INCONSISTENT,
	HE_MENU_STORE_MENU_WIDGET,
	HE_MENU_STORE_HAS_CHILDREN,
	HE_MENU_STORE_N_COLUMNS
} HeMenuStoreColumn;
//HE_MENU_STORE_IMAGE_GICON,
//HE_MENU_STORE_IMAGE_ICON_NAME,
//HE_MENU_STORE_IMAGE_STOCK_ID,
//HE_MENU_STORE_IMAGE_ICON_SIZE,
//HE_MENU_STORE_ACCEL,

G_END_DECLS

#endif /* !__HE_MENU_STORE_H__ */
