#include "he-menu-view_priv.h"

static void
get_first_label_found(GtkWidget *widget, GtkWidget **p_label)
{
	if (GTK_IS_LABEL(widget))
		(*p_label) = widget;
	else
	if (GTK_IS_CONTAINER(widget))
		gtk_container_forall(GTK_CONTAINER(widget), (GtkCallback)get_first_label_found, p_label);
}

G_GNUC_INTERNAL
GtkMenuItem *
_hmv_private_get_attach_widget(GtkWidget *widget)
{
	GtkWidget *attach_widget = gtk_menu_get_attach_widget(GTK_MENU(widget));

	if (!GTK_IS_MENU_ITEM(attach_widget))
		attach_widget = NULL;

	return GTK_MENU_ITEM(attach_widget);
}

G_GNUC_INTERNAL
const char *
_hmv_private_menu_item_get_label(GtkWidget *menu_item, GtkWidget **p_label)
{
	GtkWidget *label = NULL;

	g_return_val_if_fail(GTK_IS_MENU_ITEM(menu_item), NULL);

	get_first_label_found(menu_item, &label);

	if (p_label)
		(*p_label) = label;

	return label ? gtk_label_get_text(GTK_LABEL(label)) : NULL;
}

G_GNUC_INTERNAL
GtkWidget *
_hmv_private_menu_get_parent_menu(GtkWidget *menu)
{
	GtkWidget *ret = NULL;

	if (menu) {
		g_return_val_if_fail(GTK_IS_MENU(menu), NULL);

		menu = GTK_WIDGET(_hmv_private_get_attach_widget(menu));

		if (menu) {
			menu = gtk_widget_get_parent(menu);
			if (GTK_IS_MENU(menu))
				ret = menu;
		}
	}

	return ret;	
}
