<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/data/rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListPhotoComments</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">commentsList</xsl:attribute>

                <xsl:attribute name="ownerId">
                    <xsl:value-of select="//Request/Params/string[@name='ownerId']"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:value-of select="//Request/Params/string[@name='albumId']"/>
                </xsl:attribute>

                <xsl:attribute name="photoId">
                    <xsl:text>fl</xsl:text>
                    <xsl:value-of select="comments/@photo_id"/>
                </xsl:attribute>

                <xsl:apply-templates select="comments/comment"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

<xsl:template match="comment">
        <xsl:element name="{$STRUCT}">
            <xsl:attribute name="name">comment</xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>fl</xsl:text>
            <xsl:value-of select="@id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
               <xsl:attribute name="name">SenderId</xsl:attribute>
                <xsl:text>fl</xsl:text>
               <xsl:value-of select="@author"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Time</xsl:attribute>
                <xsl:value-of select="@datecreate"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Text</xsl:attribute>
                <xsl:value-of select="."/>
            </xsl:element>

        </xsl:element>
</xsl:template>
</xsl:stylesheet>
