<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="yes"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/rsp[@stat = 'ok']"/>
 <xsl:apply-templates select="/data/rsp[@stat = 'fail']"/>
</xsl:template>

<xsl:template match="rsp[@stat = 'ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListPhotoTags</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">tagsList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(people/person)"/>
                </xsl:attribute>

                <xsl:attribute name="ownerId">
                    <xsl:value-of select="/data/Request/Params/string[@name = 'ownerId']"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:value-of select="/data/Request/Params/string[@name = 'albumId']"/>
                </xsl:attribute>

                <xsl:attribute name="photoId">
                    <xsl:value-of select="/data/Request/Params/string[@name = 'photoId']"/>
                </xsl:attribute>

                <xsl:for-each select="people/person">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">tag</xsl:attribute>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">userId</xsl:attribute>
                            <xsl:text>fl</xsl:text>
                           <xsl:value-of select="@nsid"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">text</xsl:attribute>
                            <xsl:value-of select="@realname"/>
                        </xsl:element>

                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
