<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/data/rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>                         
               <xsl:attribute name="ownerId">
                    <xsl:value-of select="//Request/Params/@id"/>
                </xsl:attribute>                             

                <xsl:for-each select="photosets/photoset">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">album</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>fl</xsl:text>
                        <xsl:value-of select="@id"/>
                        </xsl:attribute>
                 
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">title</xsl:attribute>
                           <xsl:value-of select="title"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="description"/>
                        </xsl:element>

			 <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">thumbId</xsl:attribute>
                            <xsl:text>fl</xsl:text>
                            <xsl:value-of select="@primary"/>
                        </xsl:element>

			<xsl:element name="{$IMG}">
                            <xsl:attribute name="name">Img</xsl:attribute>http://farm<xsl:value-of select="@farm"/>.static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@primary"/>_<xsl:value-of select="@secret"/>_t.jpg</xsl:element>
                    
			 <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">size</xsl:attribute>
                            <xsl:value-of select="number(@photos) + number(@videos)"/>
                        </xsl:element>
                       
                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 
        </xsl:element> 
    </xsl:element>  
</xsl:template>

</xsl:stylesheet>
