<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="xml" />
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">
            <xsl:choose>
                <xsl:when test="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:anon = '1'">
                    <xsl:text>getTotalCountOutbox</xsl:text>
	        </xsl:when>
                <xsl:otherwise>
                    <xsl:text>getTotalCountInbox</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:uid"/>
            </xsl:attribute>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">quantity</xsl:attribute>
                    <xsl:value-of select="sum(/df:fql_multiquery_response/df:fql_result[df:name='count']/df:fql_result_set/df:thread[*]/df:message_count)"/>
            </xsl:element>
        </xsl:element>
    </xsl:element>
 </xsl:template>
</xsl:stylesheet>
