/*
 * driver.c -  driver facebook of MSA program
 * This file is part of MSA program.
 *
 * Copyright (C) 2009-2010 - Sergey Zakharov
 * Copyright (C) 2010 - Pavel Shiryaev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include <libxml2/libxml/tree.h>

#include "driver.h"
#include "facebook.h"
#include "parser.h"
#include "profile.h"
#include "dbus_functions.h"
#ifdef DEBUG
#	define msa_xmlDocDump(F,D) xmlDocDump(F,D)
#else
#	define msa_xmlDocDump(F,D)
#endif
/*
#define TEST
#define ACCESS_TOKEN ""
*/
#define ERROR_RESPONSE "<error_response xmlns='http://api.facebook.com/1.0/' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd'>"
#define MSG_NETWORK_ERROR \
ERROR_RESPONSE\
"<error_code>"DRV_NETW_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_NETW_ERROR"</error_msg>"\
"</error_response>"

#define MSG_NETWORK_SERVER_ERROR \
ERROR_RESPONSE\
"<error_code>"DRV_SERVER_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_SERVER_ERROR"</error_msg>"\
"</error_response>"

#define MSG_SETTINGS_SAVED \
"<info_response>"\
"<info_code>"DRV_SETT_SAVED_CODE"</info_code>"\
"<info_msg>"DRV_SETT_SAVED"</info_msg>"\
"</info_response>"

#define MSG_SETTINGS_SAVED_ERROR \
ERROR_RESPONSE\
"<error_code>"DRV_SETT_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_SETT_ERROR"</error_msg>"\
"</error_response>"

/*FIXME*/
#define MSG_FILE_DOWNLOAD \
"<info_response><info_code>600</info_code>"\
"<info_msg>File downloaded</info_msg></info_response>"

#define MSG_FILE_DOWNLOAD_ERROR \
ERROR_RESPONSE\
"<error_code>601</error_code>"\
"<error_msg>Can't download file</error_msg>"\
"</error_response>"


#define XSL_URL DATADIR "/msa/drivers/facebook/make_url.xsl"
#define XSL_CONFIG_DIR DATADIR"/msa/drivers/facebook/"
#define SSL_ROOT_CERT DATADIR"/msa/drivers/facebook/EquifaxSecureCA.pem"

/*We don't to use offline_access*/
#define AUTH_URL "https://graph.facebook.com/oauth/authorize?client_id=133410120012716&redirect_uri=https://www.facebook.com/connect/login_success.html&type=user_agent&display=touch&scope=user_birthday,friends_birthday,user_photos,friends_photos,user_location,friends_location,user_relationships,friends_relationships,user_religion_politics,friends_religion_politics,publish_stream,user_online_presence,user_about_me,user_education_history,friends_education_history,user_status,friends_status,user_religion_politics,friends_religion_politics,user_about_me,friends_about_me,user_hometown,friends_hometown,read_mailbox"
#define SUCCESS_LINK "http://www.facebook.com/connect/login_success.html#access_token"ACCESS_TOKEN"=&expires_in=0"
#define REGEXP_PARAM "regexp"
#define LOGIN_SUCCESS1 "^https://www\\.facebook\\.com/connect/login_success\\.html.*"
#define LOGIN_SUCCESS2 "^http://www\\.facebook\\.com/connect/login_success\\.html.*"
#define TITLE_PARAM "title"
#define TITLE_FACEBOOK "facebook"
#define CLIENT_ID_PARAM "ClientID"
#define ACCOUNT_ID_PARAM "accountID_RET"
#ifdef TEST
#include "../test/CTF/src/ctf.h"
CTF_TEST_DATA_FILE_NAME_DECL;
#endif

int counter = 0;
int max_count = 0;
static int global_temp = 0;
int attempts = 0;
int captch = 0;



/**
 * Allocate memory
 *
 * @param ptr - pointer
 * @param size - size of data
* @return 0 on success or 1 otherwise.
 */
void* myrealloc(void* ptr, size_t size)
{
/* There might be a realloc() out there that doesn't like reallocing
NULL pointers, so we take care of it here */
    if(ptr)
        return realloc(ptr, size);
    else
        return malloc(size);
}

/**
 * Callbak for libcurl for receiving data
 *
 * @param ptr - pointer
 * @param size - size of chunk of data
 * @param nmemb - number of chunks of data
 * @param data - pointer to data
* @return 0 on success or 1 otherwise.
 */
 static size_t
WriteMemoryCallback(void* ptr, size_t size, size_t nmemb, void* data)
{
    size_t realsize = size * nmemb;
    struct MemoryStruct *mem = (struct MemoryStruct *)data;
    mem->memory = myrealloc(mem->memory, mem->size + realsize + 1);
    if (mem->memory) {
        memcpy(&(mem->memory[mem->size]), ptr, realsize);
        mem->size += realsize;
        mem->memory[mem->size] = 0;
    }
    return realsize;
}


/*
 * Process all internal requests in xml request
 *
 * @param pr - profile data
 * @param inner_req - xml request
 * @return 0 on success, 1 otherwise
 */
int process_inner_request(struct ProfileData *pr, xmlDocPtr inner_req)
{   
    int ret_code = 0;
    xmlDocPtr inner_request = NULL, inner_response = NULL;
    xmlNodePtr node = NULL, node_request = NULL, tmp_node = NULL;

    while ((node = xpath_get_node("//Request", inner_req)) != NULL){
        node_request = xmlCopyNode(node, 1);
        xmlUnlinkNode(node_request);
        inner_request = xmlNewDoc(BAD_CAST "1.0");
        xmlDocSetRootElement(inner_request, node_request);
    
        process_request(pr, inner_request, &inner_response);        
        xmlFreeDoc(inner_request); 

        if (xpath_get_node("//Response", inner_response) != NULL){
            node = xmlDocGetRootElement(inner_req);
            ret_code = 1;
        }

        tmp_node = xmlCopyNode(xmlDocGetRootElement(inner_response),1);
        xmlFreeDoc(inner_response);
        node = xmlReplaceNode(node, tmp_node);
        xmlFreeNode(node);
        if (ret_code)
            break;
    }
    return ret_code;
}

/*
 * Recursively process request 
 *
 * @param pr - profile data
 * @param inner_req - xml request
 * @return 0 on success or 1 otherwise.
 */

int process_request(struct ProfileData *pr, xmlDocPtr request, xmlDocPtr* response)
{   
    xmlDocPtr inner_req = NULL;
    xmlDocPtr server_response, resp = NULL;
    xmlNodePtr node = NULL; /*, sig_node = NULL;*/
    gchar* parser = NULL;
    gchar* parser_type = NULL;
    gchar *url = NULL;
/*    gchar *sig = NULL;*/
    gchar *tmp = NULL;
    gchar *resp_str = NULL;
/*    gchar *md5_sig = NULL;*/
    gchar* data = NULL;
    gchar* http_type = NULL;
    int http_code = 0;
    int resp_code = 0;
    int data_size = 0;
    struct UpFile *file;

    
    msa_debug("\n\nRequest in process");
    msa_xmlDocDump(stdout, request);

    if (xpath_get_node("//Request", request) != NULL) {
        node = xpath_get_node("//Request/parser", request);

        if (node != NULL){
            tmp = (gchar*)xmlNodeGetContent(node);
            parser = g_strconcat(XSL_CONFIG_DIR, tmp, NULL);
            g_free(tmp);
        } else {          
            /*use standart parser*/
            parser = g_strconcat(XSL_CONFIG_DIR, "parser.xsl", NULL);       
        }

        /*create inner request*/
        inner_req = apply_parser(request, parser, pr);
        g_free(parser);
        msa_xmlDocDump(stdout, inner_req);
        
        /*unknown request */
        if (xpath_get_node("//InnerRequest", inner_req) == NULL){
            *response = xmlCopyDoc(inner_req, 1);
            xmlFreeDoc(inner_req);
            return 0;
        }
        if ((resp_code = process_inner_request(pr, inner_req)) == 1){
            *response = xmlCopyDoc(inner_req, 1);
            xmlFreeDoc(inner_req);
            return 0;
        }

        node = xpath_get_node("//InnerRequest", inner_req);
        if (node == NULL){
            xmlFreeDoc(inner_req);
            return 1;
        }
        http_type = (gchar*)xmlGetProp(node, BAD_CAST "type");

        if (g_strcmp0(http_type, "post") == 0 || g_strcmp0(http_type, "get") ==0) {
            node = xpath_get_node("//InnerRequest/url", inner_req);
            if (node != NULL)
                tmp = (gchar*)xmlNodeGetContent(node);

            /*sig_node = xpath_get_node("//InnerRequest/sig", inner_req);
            if (sig_node != NULL){
                sig = (gchar*)xmlNodeGetContent(sig_node);
                md5_sig = g_compute_checksum_for_string(G_CHECKSUM_MD5, sig, strlen(sig));
                g_free(sig);

                url = g_strconcat(tmp, "sig=", md5_sig, NULL);
                g_free(md5_sig);
            } else */
                url = g_strdup(tmp);
            g_free(tmp);

            msa_debug("URL = %s\n", url);
                
            if (g_strcmp0(http_type, "get") == 0) {
                http_code = http_get(url, info_proxy, info_port, NULL, &data, &data_size);
            }
            else
            if (g_strcmp0(http_type, "post") == 0) {
                msa_debug("UPLOADING...");
                file = (struct UpFile *)malloc(sizeof (struct UpFile));
                node = xpath_get_node("//InnerRequest/post_param[@name='name']", inner_req);
                file->name = (gchar*)xmlNodeGetContent(node);
                node = xpath_get_node("//InnerRequest/post_param[@name='file']", inner_req);
                file->file_path = (gchar*)xmlNodeGetContent(node);
                node = xpath_get_node("//InnerRequest/post_param[@name='file_name']", inner_req);
                file->file_name = (gchar*)xmlNodeGetContent(node);
                
                http_code = http_upload_file(url, info_proxy, info_port, NULL, &data, file);
                upfile_remove(file);
                /*msa_debug(data);*/
            }
            g_free(http_type);
            g_free(url);

            if (http_code >= 500) {
                g_free(data);
                data = g_strdup(MSG_NETWORK_SERVER_ERROR);
            } else
            if (http_code >= 300) {
                g_free(data);
                data = g_strdup(MSG_NETWORK_ERROR);
            } 
        }

        /*msa_xmlDocDump(stdout, inner_req);*/
        
        /*Parse server response*/
        node = xpath_get_node("//InnerRequest/parser", inner_req);
        if (node != NULL){
            parser_type = (gchar*)xmlGetProp(node, BAD_CAST "type");
            tmp = (gchar*)xmlNodeGetContent(node);

            if(http_code < 300){
                if (g_strcmp0(parser_type, "json") == 0) {
                    parse_upload(data, &resp_str);
                    g_free(data);
                    data = g_strdup(resp_str);
                    g_free(resp_str);
                }
                if (g_strcmp0(parser_type, "settings") == 0) {
                    msa_debug("SETTINGS");
                    g_free(data);
                    if (set_settings(inner_req, pr))
                        data = g_strdup(MSG_SETTINGS_SAVED_ERROR);
                    else
                        data = g_strdup(MSG_SETTINGS_SAVED);
                }
                if (g_strcmp0(parser_type, "download") == 0) {
                    if (save_file (inner_req, data, data_size)) {
                        g_free(data);
                        data = g_strdup(MSG_FILE_DOWNLOAD_ERROR);
                    } else {
                        g_free(data);
                        data = g_strdup(MSG_FILE_DOWNLOAD);
                    }
                    msa_debug("response = %s",data);
                }
            }
            server_response = xmlParseDoc((xmlChar*)data);

            parser = g_strconcat(XSL_CONFIG_DIR, tmp, NULL);

            resp = apply_parser(server_response, parser, pr);
 
            g_free(parser);
            xmlFreeDoc(server_response);
            g_free(tmp);
            g_free(parser_type);
            g_free(data);
            xmlFreeDoc(inner_req);
        }
        /*Search for requests*/
        resp_code = process_inner_request(pr, resp);
         *response = xmlCopyDoc(resp, 1);
        xmlFreeDoc(resp);
        return resp_code;
    }
    return 1;
}


xmlDocPtr apply_parser(xmlDocPtr request, gchar* parser, struct ProfileData *pr)
{
    xmlDocPtr proc = NULL; 
    xsltStylesheetPtr cur = NULL;
    gchar *params[7];
    cur = xsltParseStylesheetFile((xmlChar*)parser);
    msa_debug("Aply parser: %s", parser);

    params[0] = g_strdup("MID");
    params[1] = g_strdup("\"me()\"");
    params[2] = g_strdup("SID");
    params[3] = g_strdup_printf("\"%s\"", pr->remixsid);
    params[4] = g_strdup("SECRET");
    params[5] = g_strdup("\"\"");
    params[6] = NULL;

    if(cur != NULL && request != NULL) {
        proc = xsltApplyStylesheet(cur, request, (const char**)params);
    } else {
	g_warning("Internal error");
  	return NULL;
    }

    xsltFreeStylesheet(cur);
    g_free((gpointer*)params[0]);
    g_free((gpointer*)params[1]);
    g_free((gpointer*)params[2]);
    g_free((gpointer*)params[3]);
    g_free((gpointer*)params[4]);
    g_free((gpointer*)params[5]);

    return proc;
}
/*
 * Parse back url, fill profileData struct
 *
 * @param pr - profile
 * @param back_url - redirect url from server
 * @return 0 if login success, 1 if login failure
 */

int parse_auth(struct ProfileData *pr, gchar *back_url)
{
    gchar *begin, *end;
    if (back_url == NULL)
        return 1;
    begin = strstr(back_url, "access_token=");
    if (!begin) {
        return 1;
    }
    while(*begin != '=' && *begin != '\0')
        ++begin;
    if (*begin == '\0')
        return 1;
    ++begin;
    end = strstr(begin, "&");
    if (end)
        *end='\0';
    pr->remixsid = g_strdup(begin);
    pr->remixmid = g_strdup("\"me()\"");
    pr->secret = g_strdup("");
    return 0;
}

/**
 * Perform request
 *
 * @param reqXml - request
 * @param doc - response
 * @return 0 on success or 1 otherwise.
 */
int fb_req(xmlDocPtr reqXml, xmlDocPtr* doc, const struct msa_module* info)
{
    int init_status = 0;
    char* error_code = NULL;
    xmlChar* class_val = NULL;
    xmlNodePtr node = NULL;

    struct ProfileData *cp = (struct ProfileData *)profile_get_by_id(info->id);
    captch = 0;

    msa_debug("%s:%d:%s: id=%s, cp->login=%s", __FILE__, __LINE__, __FUNCTION__, info->id, cp->login);
    info_proxy = info->proxy;
    info_port = info->port;

    global_temp++;
    
    g_print("IN FB_REQ!!! %d\n", global_temp);
    counter = 0;
    msa_xmlDocDump(stdout, reqXml);

    class_val = get_req_class(reqXml);
    if (g_strcmp0((char*) class_val, "settings") != 0)
        init_status = initialization(cp);
    g_free(class_val);

    attempts = 0;
    if (init_status != 0) {
        msa_debug("init_status = %d", init_status);
        if (init_status == 2){
            info_message(DRV_NETW_ERROR_CODE, *doc, DRV_NETW_ERROR, 1);
            return 0;
        }
        if(init_status == 1) {
            info_message(DRV_AUTH_ERROR_CODE, *doc, DRV_AUTH_ERROR, 1);
            return 0;
        }
                 
    }

    if (process_request(cp, reqXml, doc) == 1) {
        info_message(DRV_REQ_ERROR_CODE, *doc, DRV_REQ_ERROR, 1);
        return 0;
    }

    node = xpath_get_node("//Response[@function='errorMessage']/Params/string[@name='code']", *doc);
    if (node != NULL){
        msa_debug("error occured");
        error_code = (gchar *)xmlNodeGetContent(node);
        if(g_strcmp0(error_code, DRV_AUTH_ERROR_CODE) == 0 
            || g_strcmp0(error_code, "190") == 0){
            if (authorize(cp) == 0) {
                xmlFreeDoc(*doc);
                process_request(cp, reqXml, doc);
            }
        }
        g_free(error_code);
            
    }
    return 0;
}

/**
 * Perform authorization
 *
 * @param cp - current profile settings
 * @return 0 on success or 1 otherwise.
 */
int initialization(struct ProfileData *cp)
{
    int auth_status = 0;
    msa_debug("init START");

    if(cp->remixmid == NULL || cp->remixsid == NULL || cp->secret == NULL) {

        g_print("dr_fb: authorization\n");
        auth_status = authorize(cp);
        if (auth_status != 0 ) {
            msa_debug("dr_fb: Could not get remixmid, remixsid, auth_status = %d \n", auth_status); 
            return auth_status;
        }
    }
    msa_debug("init END");
    return 0;
}

/**
 * Get settings from current profile
 *
 * @param doc - response
 * @return 0 on success or 1 otherwise.
 */
int get_settings(xmlDocPtr doc, const struct ProfileData *cp)
{
    xmlNodePtr rootNode, childNode;
    msa_debug("get_settings START");
    
    rootNode = xmlDocGetRootElement(doc);
    rootNode = rootNode->children;
    
    childNode = xmlNewDocNode(doc, NULL, BAD_CAST STRING, BAD_CAST cp->login);
    xmlSetProp(childNode, BAD_CAST NAME, BAD_CAST LOGIN);
    childNode = xmlAddChild(rootNode, childNode);

    childNode = xmlNewDocNode(doc, NULL, BAD_CAST STRING, BAD_CAST cp->password);
    xmlSetProp(childNode, BAD_CAST NAME, BAD_CAST PASSWORD);
    childNode = xmlAddChild(rootNode, childNode);

    msa_debug("get_settings END");
   return 0;
}

/**
 * Set settings in to current profile
 *
 * @param reqXml - request
 * @param cp - current profile
 * @return 0 on success or 1 otherwise.
 */
int set_settings (xmlDocPtr reqXml, struct ProfileData *cp)
{
    xmlNodePtr node;
    msa_debug("set_settings START");

    /*node = xpath_get_node("/ /Params/string[@name='mid']", reqXml);
    if (node == NULL)
        return 1;*/
    if (cp->remixmid != NULL)
    {
        g_free(cp->remixmid);
        cp->remixmid = NULL;
    }
    cp->remixmid = g_strdup("\"me()\""); /*  (gchar *)xmlNodeGetContent(node);*/

    node = xpath_get_node("//*/Params/string[@name='sid']", reqXml);
    if (node == NULL)
        return 1;
    if (cp->remixsid != NULL)
    {
        g_free(cp->remixsid);
        cp->remixsid = NULL;
    }
    cp->remixsid = (gchar *)xmlNodeGetContent(node);
/*
    node = xpath_get_node("/ /Params/string[@name='secret']", reqXml);
    if (node == NULL)
        return 1;*/
    if (cp->secret != NULL)
    {
        g_free(cp->secret);
        cp->secret = NULL;
    }
    cp->secret =  g_strdup(""); /*(gchar *)xmlNodeGetContent(node);*/

    return 0;
}

/**
 * Save file to path in reqXml
 *
 * @param reqXml - request
 * @param data - binary data
 * @return 0 on success or 1 otherwise.
 */
int save_file (xmlDocPtr reqXml, char* data, int data_size)
{
    xmlNodePtr node;
    gchar* path = NULL;

    node = xpath_get_node("//*/Params/string[@name='path']", reqXml);
    if (node == NULL)
        return 1;
    path = (gchar *)xmlNodeGetContent(node);
    msa_debug("try save file to \"%s\"", path);
    if (path != NULL)
    {
        if(g_file_set_contents(path, data, data_size, NULL))
            msa_debug("write to file");
        else 
            return 1;
    } else 
        return 1;
    return 0;
}

/**
 * Authorization (get remixsid and remixmid for future requests)
 *
 * @param cp - current profile
 * @return 0 on success or 1 otherwise.
 */
int authorize(struct ProfileData *cp)
{
    int ret_code = 0;
/*use web authorisation*/
/*FIXME*/

    gchar* back_url = NULL;
    gchar* port = g_strdup_printf("%d", info_port);

#ifdef TEST
    back_url = g_strdup( SUCCESS_LINK );
#else
    char *patterns[] = { REGEXP_PARAM, LOGIN_SUCCESS1, REGEXP_PARAM, LOGIN_SUCCESS2, TITLE_PARAM, cp->id, CLIENT_ID_PARAM, TITLE_FACEBOOK, ACCOUNT_ID_PARAM, cp->id};
    char **patt_arr = patterns;
    back_url = webauth(AUTH_URL, info_proxy, port, "", "", patt_arr, 10, cp->id);
#endif
    /*msa_debug("back_url = %s", back_url);*/
    ret_code = parse_auth(cp, back_url);
    /*g_free(back_url);*/
    g_free(port);
   return ret_code;
}

/**
 * Get class of request
 *
 * @param reqXml - request
 * @return class of request.
 */
xmlChar* get_req_class(xmlDocPtr reqXml)
{
    xmlNodePtr rootNode = NULL;
    if(reqXml != NULL)
        rootNode = xmlDocGetRootElement(reqXml);
    if (rootNode != NULL)
        return xmlGetProp(rootNode, BAD_CAST CLASS);
    return NULL;
}

/**
 * Get function of request
 *
 * @param reqXml - request
 * @return function of request.
 */
xmlChar* get_req_function(xmlDocPtr reqXml)
{
    xmlNodePtr rootNode = NULL;
    if (reqXml != NULL)
	rootNode = xmlDocGetRootElement(reqXml);
    if (rootNode != NULL)
	return xmlGetProp(rootNode, BAD_CAST FUNCTION);
    return NULL;
}


/**
 * Form INFO or ERROR message
 *
 * @param code - error code
 * @param doc - response (buffer for message)
 * @param message - text of message
 * @param type - 0 for info message or 1 for error message
* @return 0 on success or 1 otherwise.
 */
int info_message(char* code, xmlDocPtr doc, char* message, int type)
{
    xmlNodePtr rootNode, node, childNode, oldroot;
    rootNode = xmlNewDocNode(doc, NULL, BAD_CAST "Response", NULL);
    oldroot = xmlDocSetRootElement(doc, rootNode);
    if (oldroot != NULL)
        xmlFreeNode(oldroot);

    xmlSetProp(rootNode, BAD_CAST CLASS, BAD_CAST "systemMessages");

    if (type == 1)
        xmlSetProp(rootNode, BAD_CAST FUNCTION, BAD_CAST "errorMessage");
    else if (type == 0)
        xmlSetProp(rootNode, BAD_CAST FUNCTION, BAD_CAST "infoMessage");
    else if (type == 2)
        xmlSetProp(rootNode, BAD_CAST FUNCTION, BAD_CAST "captchaMessage");
    else
        return 1;

    node = xmlNewDocNode(doc, NULL, BAD_CAST PARAMS, NULL);
    childNode = xmlAddChild(rootNode, node);

    node = xmlNewDocNode(doc, NULL, BAD_CAST STRING, BAD_CAST DRIVER_NAME);
    xmlSetProp(node, BAD_CAST NAME, BAD_CAST "moduleName");
    node = xmlAddChild(childNode, node);

    node = xmlNewDocNode(doc, NULL, BAD_CAST STRING, BAD_CAST code);
    xmlSetProp(node, BAD_CAST NAME, BAD_CAST "code");
    node = xmlAddChild(childNode, node);

    node = xmlNewDocNode(doc, NULL, BAD_CAST STRING, BAD_CAST message);
    xmlSetProp(node, BAD_CAST NAME, BAD_CAST "text");
    node = xmlAddChild(childNode, node);
    return 0;
}


/**
 * Perform HTTP GET request
 *
 * @param url - request
 * @param proxy - proxy address 
 * @param port - proxy port
 * @param header - buffer for header of response
 * @param body - buffer for body of response
 * @return http server response code 
 */
int http_get(const char* url, const char* proxy, int port, char** header, gchar** body, int* data_size)
{
    CURL* c;
    long code;
    char* type2;
    char* encoded_url = NULL;
    struct MemoryStruct chunk, chunk2;
    CURLcode curlResult;

    /* dummy test */
    if ((url == NULL) || (*url=='\0')) {
        msa_debug("Requested an empty string. Your client is stupid!");
        return 404;
    }

    global_temp++;
    g_print("IN HTTP GET!!! %d\n", global_temp);
    
    chunk.memory = NULL; 
    chunk.size = 0;

    chunk2.memory = NULL; 
    chunk2.size = 0;

    c = curl_easy_init();

    /*encoded_url = curl_easy_escape(c, url, strlen(url));*/
    /*msa_debug("%s:%d:%s:url in http_get %s, proxy=%s, port=%d", __FILE__, __LINE__, __FUNCTION__, encoded_url, proxy, port);*/
    msa_debug("%s:%d:%s:url in http_get %s, proxy=%s, port=%d", __FILE__, __LINE__, __FUNCTION__, url, proxy, port);

    /* disable callbacks for working in multithreads*/
    curl_easy_setopt(c, CURLOPT_NOSIGNAL, 1);

    curl_easy_setopt(c, CURLOPT_SSL_VERIFYPEER, 0);
    curl_easy_setopt(c, CURLOPT_SSL_VERIFYHOST, 2);
    /*curl_easy_setopt(c, CURLOPT_CAINFO, SSL_ROOT_CERT);
    msa_debug("USE This cert: %s", SSL_ROOT_CERT);*/

    curl_easy_setopt(c, CURLOPT_URL, url);

    curl_easy_setopt(c, CURLOPT_PROXY, proxy);
    curl_easy_setopt(c, CURLOPT_PROXYPORT, port);
    curl_easy_setopt(c, CURLOPT_TIMEOUT, 120);

    curl_easy_setopt(c, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
    curl_easy_setopt(c, CURLOPT_HEADERFUNCTION, WriteMemoryCallback);

    curl_easy_setopt(c, CURLOPT_WRITEDATA, (void *)&chunk);
    curl_easy_setopt(c, CURLOPT_WRITEHEADER, (void *)&chunk2);
    msa_debug("send request");

    curlResult = curl_easy_perform(c);
    if (curlResult != 0) {
        msa_debug("Can't perform the request\n");
        msa_debug("CURL CODE %u", curlResult);
        curl_easy_cleanup(c);
        return 400;
    }

    free(encoded_url);
    curlResult = curl_easy_getinfo(c, CURLINFO_RESPONSE_CODE, &code );
    msa_debug("CODE %ld", code);

    /*type2 = g_malloc(sizeof(char)*50);*/
    curlResult = curl_easy_getinfo(c, CURLINFO_CONTENT_TYPE, &type2 );
    msa_debug("TYPE %s", type2);

    if (header != NULL) {
        *header = g_strdup(chunk2.memory);
    }

    g_print("HEADER  %s\n", chunk2.memory);
    if(chunk2.memory)
        free(chunk2.memory);

    if (body != NULL) {
	/*if (g_strcmp0(type2, "text/xml;charset=utf-8") == 0)
            msa_debug("TYPE %s", body);
        if (g_strcmp0(type2, "image/jpeg") == 0) {
            *body = g_base64_encode((guchar *)chunk.memory, chunk.size);
        } else {*/
            *data_size = chunk.size;
    	    *body = chunk.memory;
        /*}*/
    } else 
        if(chunk.memory)
            free(chunk.memory);

    /*g_print("CONTENT  %s\n", *body);

    g_free(type2);*/
    curl_easy_cleanup(c);

    return code;
}

/**
 * Perform HTTP POST request
 *
 * @param url - request
 * @param proxy - proxy address
 * @param port - proxy port
 * @param post_data - data to send
 * @param header - buffer for header of response
 * @param body - buffer for body of response
 * @param cookies - list of cookies from server
 * @return http server response code
 */

int http_post(const char* url, const char* proxy, int port, char* post_data, char** header, char** body, struct curl_slist** cookies)
{
    CURL* c;
    long code;
    CURLcode res;
    struct MemoryStruct chunk,chunk2;

    chunk.memory = NULL;
    chunk.size = 0;

    chunk2.memory = NULL;
    chunk2.size = 0;


    c = curl_easy_init();
    msa_debug("%s:%d:%s:url in http_post %s, proxy=%s:%d", __FILE__, __LINE__, __FUNCTION__, url, proxy, port);

    /* disable callbacks for working in multithreads*/
    curl_easy_setopt(c, CURLOPT_NOSIGNAL, 1);

    curl_easy_setopt(c, CURLOPT_SSL_VERIFYPEER, 0);
    curl_easy_setopt(c, CURLOPT_SSL_VERIFYHOST, 2);
    /*curl_easy_setopt(c, CURLOPT_CAINFO, SSL_ROOT_CERT);*/

    curl_easy_setopt(c, CURLOPT_URL, url);

    curl_easy_setopt(c, CURLOPT_PROXY, proxy);
    curl_easy_setopt(c, CURLOPT_PROXYPORT, port);
    curl_easy_setopt(c, CURLOPT_TIMEOUT, 120);


    curl_easy_setopt(c, CURLOPT_POST, 1);
    curl_easy_setopt(c, CURLOPT_POSTFIELDS, post_data);
    curl_easy_setopt(c, CURLOPT_POSTFIELDSIZE, strlen(post_data));
    curl_easy_setopt(c, CURLOPT_FOLLOWLOCATION, 1);

    curl_easy_setopt(c, CURLOPT_COOKIEFILE, "");

    curl_easy_setopt(c, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
    curl_easy_setopt(c, CURLOPT_HEADERFUNCTION, WriteMemoryCallback);

    curl_easy_setopt(c, CURLOPT_WRITEDATA, (void *)&chunk);
    curl_easy_setopt(c, CURLOPT_WRITEHEADER, (void *)&chunk2);
    msa_debug("%s:%d:%s():send request", __FILE__, __LINE__, __FUNCTION__);
    
    res = curl_easy_perform(c);
    if (res != 0) {
        msa_debug("%s:%d:%s: Can't perform the request: %s", __FILE__, __LINE__, __FUNCTION__, curl_easy_strerror(res));
        curl_easy_cleanup(c);
        return 400;
    }
    
    res = curl_easy_getinfo(c, CURLINFO_COOKIELIST, &*cookies);
    if (res != CURLE_OK) {
        curl_easy_cleanup(c);
        curl_slist_free_all(*cookies);
        *cookies = NULL;
        return 400;
    }
    
    res = curl_easy_getinfo(c, CURLINFO_RESPONSE_CODE, &code );
    msa_debug("CODE %ld", code);
    msa_debug("HEADER\n  %s", chunk2.memory);
    /*msa_debug("BODY====\n  %s\n=====BODY_END======", chunk.memory);*/
    
    
    if (header != NULL) {
        *header = g_strdup(chunk2.memory);
    }
    
    if(chunk2.memory)
        g_free(chunk2.memory);
    
    if (body != NULL) {
        *body = g_strdup(chunk.memory);
        if(chunk.memory) 
	    g_free(chunk.memory);
    }
    
    curl_easy_cleanup(c);
    return code;
}

int http_upload_file(const char* url, const char* proxy, const int port, char** header, gchar** body, struct UpFile *file)
{
    CURL *curl;
    CURLcode res;
    long code;
    struct curl_httppost *formpost=NULL;
    struct curl_httppost *lastptr=NULL;
    struct curl_slist *headerlist=NULL;
    static const char buf[] = "Expect:";

    struct MemoryStruct chunk,chunk2;
    chunk.memory = NULL;
    chunk.size = 0;

    chunk2.memory = NULL;
    chunk2.size = 0;


    curl_global_init(CURL_GLOBAL_ALL);

    /* Fill in the file upload field */
    curl_formadd(&formpost,
                  &lastptr,
         CURLFORM_COPYNAME, file->name,
             CURLFORM_FILE, file->file_path,
         CURLFORM_FILENAME, file->file_name,
              CURLFORM_END);

    curl = curl_easy_init();
    /* initalize custom header list (stating that Expect: 100-continue is not
     *      wanted */
    headerlist = curl_slist_append(headerlist, buf);

    if(curl) {
	/* disable callbacks for working in multithreads */
	curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1);

     /* what URL that receives this POST */
        curl_easy_setopt(curl, CURLOPT_URL, url);

     /* only disable 100-continue header if explicitly requested */
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headerlist);
        curl_easy_setopt(curl, CURLOPT_HTTPPOST, formpost);
        curl_easy_setopt(curl, CURLOPT_PROXY, proxy);
        curl_easy_setopt(curl, CURLOPT_PROXYPORT, port);
        curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1);

        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
        curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, WriteMemoryCallback);

        curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&chunk);
        curl_easy_setopt(curl, CURLOPT_WRITEHEADER, (void *)&chunk2);

        res = curl_easy_perform(curl);

        res = curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &code );
        msa_debug("CODE %ld", code);
        msa_debug("HEADER\n  %s", chunk2.memory);        
        
        if (header != NULL) {
            *header = g_strdup(chunk2.memory);
        }
        
        if(chunk2.memory)
            g_free(chunk2.memory);
        
        if (body != NULL) {
            *body = g_strdup(chunk.memory);
        if(chunk.memory) 
	        g_free(chunk.memory);
        }
        /* always cleanup */
        curl_easy_cleanup(curl);
        /* then cleanup the formpost chain */
        curl_formfree(formpost);
        /* free slist */
        curl_slist_free_all (headerlist);
    }
   return code;
}

xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc)
{
    xmlXPathObject *Obj = NULL;
    xmlNodePtr node = NULL;
    Obj = xpath(path, doc);
    if(Obj == NULL)
        return NULL;
    if(!xmlXPathNodeSetIsEmpty(Obj->nodesetval))
        node = xmlXPathNodeSetItem(Obj->nodesetval, 0);
    xmlXPathFreeObject(Obj);
    return node;
}

/**
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
xmlXPathObject* xpath(gchar* req, xmlDocPtr doc)
{
	xmlXPathObject *Obj;
	xmlXPathContextPtr Ctx;
	
        if ((doc == NULL) || (req == NULL)) {
            msa_debug("fb_xpath: null xpath request.");
            return NULL;
        }

        msa_debug("fb_xpath: %s", req);

	Ctx = xmlXPathNewContext(doc);
	
	if (Ctx == NULL) {
		msa_debug("fb_xpath: error wrong request format!");
		return NULL;	
	}

	Obj = xmlXPathEvalExpression(BAD_CAST req, Ctx);

	msa_debug("fb_xpath: end");

        xmlXPathFreeContext(Ctx);

	return Obj;

}

void upfile_remove(struct UpFile *file)
{
    if (file->name != NULL)
	g_free(file->name);
    if (file->file_path != NULL)
	g_free(file->file_path);
    if (file->file_name != NULL)
	g_free(file->file_name);

    free(file);
    file = NULL;
}

