"""The main class for the application"""
import gtk
import hildon
import os.path
import gobject          
import osso
import sys
import dbus
import location
import time
import urllib
import pango

from qype import Qype as placesprovider
import provider
import config
import menu

PROVIDERS = ('Qype', 'Yahoo Local search')

APPNAME = 'Libellule'
APPVERSION = '0.0.1'
MAP_URL = """http://gmap-app.appspot.com/libellule?app=libellule\
&lat_src=%s&long_src=%s&lat_dest=%s&long_dest=%s"""
MEDIA_PATH = "/usr/share/libellule/"
MAP_ICON = '/usr/share/icons/hicolor/48x48/hildon/general_web.png'
CALL_ICON = '/usr/share/icons/hicolor/48x48/hildon/general_call.png'
FIRSTPAGE_ICON = '/usr/share/icons/hicolor/48x48/hildon/pdf_viewer_first_page.png'
LASTPAGE_ICON = '/usr/share/icons/hicolor/48x48/hildon/pdf_viewer_last_page.png'
PREVIOUSPAGE_ICON = '/usr/share/icons/hicolor/48x48/hildon/general_back.png'
NEXTPAGE_ICON = '/usr/share/icons/hicolor/48x48/hildon/general_forward.png'
MAIL_ICON = '/usr/share/icons/hicolor/48x48/hildon/general_email.png'
   

class  libelluleApp(hildon.Program):

    def __init__(self):
        """Contains main methods for the app class"""
        
        self.config = config.Config()
        self.load_provider(self.config.provider)

        #Initializing GPS
        self.previousfixtime = float("nan")
        if not os.path.isfile('scratchbox'):
            self.latitude = None
            self.longitude = None
            self.control = location.GPSDControl.get_default()
            self.device = location.GPSDevice()
            self.device.reset_last_known()
            self.control.set_properties(
                                    preferred_method=location.METHOD_USER_SELECTED,
                                    preferred_interval=location.INTERVAL_DEFAULT)
            self.device.connect("changed", self.gps_on_changed, self.control)
            self.control.start()
        else:
            self.latitude = 37.788022
            self.longitude = -122.399797

        hildon.Program.__init__(self)
        self.window = hildon.StackableWindow()
        self.add_window(self.window)        
        self.window.set_title(APPNAME)
        
        self.osso_c = osso.Context(APPNAME, "0.0.1", False)
        self.osso_r = osso.Rpc(self.osso_c)

        self.menu = menu.create_menu(self.window, self)
        self.window.set_app_menu(self.menu)
        
        self.build_main_interface()
        
        self.window.show_all()
        self.window.connect("delete_event", self.quit, None)
       
        #self.nearbyme_places_window(None,  883)
        
        gtk.main()
        
        
    def build_main_interface(self):
        vbox = gtk.VBox(False, 0)

        selector = hildon.TouchSelector(text=True)
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        selector.connect("changed", self.provider_selector_changed)

        i = 0
        for item_provider in PROVIDERS:
            print item_provider
            selector.append_text(item_provider)
            if item_provider == self.config.provider:
                selector.set_active(0, i)
            i += 1
        vbox.pack_start(selector)

        hbox = gtk.HBox(False, 0)
              
        self.searchentry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        hbox.pack_start(self.searchentry, True)
        self.searchbutton = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)  
        self.searchbutton.set_label("Search...")
        self.searchbutton.connect("clicked", self.search_clicked)
        hbox.pack_start(self.searchbutton, False)
        
        vbox.pack_start(hbox, False)
        self.browsebutton = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.browsebutton.set_label("Browse categories")
        self.browsebutton.connect("clicked", self.categories_btn)
        vbox.pack_start(self.browsebutton, False)
        
        if not os.path.isfile('scratchbox'):
            self.browsebutton.set_sensitive(False)
            self.searchbutton.set_sensitive(False)
            self.searchentry.set_sensitive(False)        
            #self.searchentry.set_text("restaurant")
        self.window.add(vbox)


    def provider_selector_changed(self,  selector, user_data):
        current_selection = selector.get_current_text()
        self.config.set_provider(current_selection)
        self.load_provider(current_selection)
        self.gps_on_changed( self.device, None)


    def load_provider(self, provider):
        if provider == 'Qype':
            from qype import Qype as placesprovider
            self.provider = placesprovider()
        elif provider == 'Yahoo Local search':
            from yahoo import Yahoo as placesprovider
            self.provider = placesprovider()

        
    def categories_btn(self, widget):
        try:
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
            while gtk.events_pending():
                gtk.main_iteration(False)
            categories = self.provider.get_categories()
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
            return        
        self.categories_window(categories)

        
    def categories_window(self, categories):
        
        window = hildon.StackableWindow()       
        window.set_title(APPNAME)

        parea = hildon.PannableArea()
        window.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        window.treeview.eventid = None
        parea.add(window.treeview)

        window.store = gtk.ListStore(str)
        
        #Column 0 for the treeview
        renderer = gtk.CellRendererText()
        renderer.set_property('xalign', 0.5)

        column = gtk.TreeViewColumn("title", renderer, markup=0)
        column.set_property("expand", True)
        window.treeview.append_column(column)
        window.treeview.set_model(window.store)

        for category in categories:
            title = category['title'].replace("&", "&amp;")
            window.store.append([title])

        window.treeview.eventid = window.treeview.connect("row-activated", 
                        self.categories_tv_callback, categories, window)

        window.add(parea)
        window.show_all()


    def categories_tv_callback(self, widget, path, view_column, categories, window):
        hildon.hildon_gtk_window_set_progress_indicator(window, 1)
        while gtk.events_pending():
            gtk.main_iteration(False)
        try:
            data = self.provider.get(categories[path[0]]['id'],
                                 {'latitude' : self.latitude,
                                  'longitude' : self.longitude})
        except Exception, err:
            print '('
            self.warning_message(sys.exc_info()[0].__name__,  err)
            hildon.hildon_gtk_window_set_progress_indicator(window, 0)
            return 
        hildon.hildon_gtk_window_set_progress_indicator(window, 0)
        if isinstance(data, provider.CategoriesList):
            print "Is categories"
            self.categories_window(data)
        elif isinstance(data, provider.PlacesList):
            print "Is places"
            self.places_window(data)


    def places_window(self, places):       
        
        if len(places) == 0:
            hildon.hildon_banner_show_information(self.window, '', "No result")
            return
        window = self.build_places_window()        
        self.alter_places_window(None,  window,  places)
        window.set_title("Libellule")
        window.show_all()
        
        
    def build_places_window(self):
        places_window = hildon.StackableWindow()
        places_window.set_title("Libellule")
        
        parea = hildon.PannableArea()

        places_window.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        places_window.treeview.eventid = None
        parea.add(places_window.treeview)

        places_window.store = gtk.ListStore(str,  gtk.gdk.Pixbuf)
        
        #Column 0 for the treeview
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("title", renderer, markup=0)
        column.set_property("expand", True)
        places_window.treeview.append_column(column)
        places_window.treeview.set_model(places_window.store)
        #Column 1 for the treeview
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn()
        column.pack_start(renderer, False)
        column.add_attribute(renderer, "pixbuf", 1)
        column.set_min_width(40)
        places_window.treeview.append_column(column)                

        hbox = gtk.HBox(True, 0)
        places_window.first_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.first_button.set_image(gtk.image_new_from_file(FIRSTPAGE_ICON))
        places_window.first_button.eventid = None
        hbox.pack_start(places_window.first_button);
        places_window.previous_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.previous_button.set_image(gtk.image_new_from_file(PREVIOUSPAGE_ICON))
        places_window.previous_button.eventid = None
        hbox.pack_start(places_window.previous_button);
        places_window.next_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.next_button.set_image(gtk.image_new_from_file(NEXTPAGE_ICON))
        places_window.next_button.eventid = None
        hbox.pack_start(places_window.next_button);
        places_window.last_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.last_button.set_image(gtk.image_new_from_file(LASTPAGE_ICON))
        places_window.last_button.eventid = None
        hbox.pack_start(places_window.last_button);
        
        places_window.vbox = gtk.VBox(False, 0)
        places_window.vbox.pack_start(hbox,  expand=False);
        places_window.vbox.pack_start(parea,  expand=True);
        
        places_window.add(places_window.vbox)        
        
        places_window.show_all()
        return places_window
        
        
    def button_clicked(self, widget, window, target):
        try:
            hildon.hildon_gtk_window_set_progress_indicator(window, 1)
            while gtk.events_pending():
                gtk.main_iteration(False)
            places = self.provider.get(target,
                                 {'latitude' : self.latitude,
                                  'longitude' : self.longitude})                                        
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            hildon.hildon_gtk_window_set_progress_indicator(window, 0)
            return
        self.alter_places_window(None,  window, places)
        hildon.hildon_gtk_window_set_progress_indicator(window, 0)
        
        
    def search_clicked(self, widget):
        try:
            places = self.provider.search_query(
                                query = self.searchentry.get_text(),
                                latitude = self.latitude,
                                longitude = self.longitude) 
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            return
        if len(places) == 0:
            hildon.hildon_banner_show_information(self.window, '', "No result")
            return
        window = self.build_places_window()        
        self.alter_places_window(None,  window,  places)
        
        
    def alter_places_window(self,  widget,  window, places):
        
        print "Enter alter_places_window"
        if window.first_button.eventid:
            window.first_button.disconnect(window.first_button.eventid)
        if window.last_button.eventid:
            window.last_button.disconnect(window.last_button.eventid)
        if window.previous_button.eventid:
            window.previous_button.disconnect(window.previous_button.eventid)
        if window.next_button.eventid:
            window.next_button.disconnect(window.next_button.eventid)
        
        window.first_button.eventid = window.first_button.connect(
          "clicked", self.button_clicked, window,  places.first_page)
        window.last_button.eventid = window.last_button.connect(
          "clicked", self.button_clicked, window,  places.last_page)
        window.previous_button.eventid = window.previous_button.connect(
          "clicked", self.button_clicked, window,  places.previous_page)
        window.next_button.eventid = window.next_button.connect(
          "clicked", self.button_clicked, window,  places.next_page)
          
        if window.treeview.eventid:
           print "disconnecting events on treeview"
           window.treeview.disconnect(window.treeview.eventid)
        
        if places.first_page: 
            window.first_button.set_sensitive(True)
        else:
            window.first_button.set_sensitive(False)
        if places.last_page:
            window.last_button.set_sensitive(True)
        else:
            window.last_button.set_sensitive(False)
        if places.next_page:
            window.next_button.set_sensitive(True)
        else:
            window.next_button.set_sensitive(False)
        if places.previous_page:
            window.previous_button.set_sensitive(True)
        else:
            window.previous_button.set_sensitive(False)
        
        window.store.clear()
        for place in places:
            print "Adding %s in treeview" % place['title']
            if len(place['title'])<50:
                title = place['title']
            else:
                title = place['title'][0:50] + "..."
            label = "%s\n<small>%s km</small>" % (title,  place['distance'])   
            
            window.store.append([label, place['stars_img']])
        print "disable selected item"
        window.treeview.scroll_to_cell(0)
        window.treeview.eventid = window.treeview.connect("row-activated", self.places_tv_callback, places)


    def places_tv_callback(self, widget,  path,  view_column, places):
        print "place_tv_changed"
        window = hildon.StackableWindow()
        print path
        print path[0]
        print "Selected place : %s" % places[path[0]]['title']
        
        place = places[path[0]]
        print place
        
        place = self.provider.get_place(places[path[0]]['id'])
        print place
        
        table = place.get_table()
        
        vbox = gtk.VBox(False, 0)
        vbox.pack_start(place.get_hbox_title(), True, True, 0)        
        vbox.pack_start(gtk.HSeparator(),  False,  False)        
        
        hbox = gtk.HBox(False, 0)

        toolbar = gtk.Toolbar()
        toolbar.set_orientation(gtk.ORIENTATION_VERTICAL)

        #Phone
        if place.get_phone():
            toolitem = gtk.ToolButton(gtk.image_new_from_file(CALL_ICON),
                                 "Call")
            toolitem.connect("clicked", 
                        self.make_call,
                        place.get_phone())
            toolbar.insert(toolitem, 0)

        #Private link
        if place.get_privatelink():
            print type(place.get_privatelink()[0])
            toolitem = gtk.ToolButton(place.get_privatelink()[0],
                                 "privatepage")
            toolitem.connect("clicked", 
                        self.goto_providerpage,
                        place.get_privatelink()[1])
            toolbar.insert(toolitem, 0)
        
        #Map
        toolitem = gtk.ToolButton(gtk.image_new_from_file(MAP_ICON),
                         "Map")
        toolitem.connect("clicked",
                         self.view_gmap, place.get_coord())
        toolbar.insert(toolitem, 1)

        #Mail
        toolitem = gtk.ToolButton(gtk.image_new_from_file(MAIL_ICON),
                         "Mail")
        toolitem.connect("clicked",
                         self.send_mail, place.get_title(), place.get_astext())
        toolbar.insert(toolitem, 1)



        hbox.pack_start(table, True, True, 0) 
        hbox.pack_start(toolbar, False, False, 0) 
        
        vbox.pack_start(hbox, True, True, 0) 
        
        print "setting window title"
        window.set_title("Libellule - Details")
        
        window.add(vbox)        
        window.show_all()
   

    def send_mail(self, widget, title, message):
        dbus_cmd = "dbus-send --print-reply --type=method_call \
                              --dest=com.nokia.modest /com/nokia/modest \
                              com.nokia.modest.MailTo \
                              string:'mailto:?subject=%s&body=%s'" %(
                              title,
                              urllib.quote(message.encode('utf8')))
                              
        msg = "mailto:?subject=%s&body=%s" % (urllib.quote(title.encode('utf8')), 
                                                                        urllib.quote(message.encode('utf8')))
        """ %(
                              title,
                              urllib.quote(message.encode('utf8')))"""
        print msg
        self.osso_r.rpc_run('com.nokia.modest', 
                            '/com/nokia/modest', 
                            'com.nokia.modest', 
                            'MailTo', (msg, ),
                            False, True) 
     
        
    def make_call(self, widget, phone):
        bus = dbus.SystemBus()
        csd_call = dbus.Interface(bus.get_object('com.nokia.csd',
                                            '/com/nokia/csd/call'),
                                            'com.nokia.csd.Call')
        csd_call.CreateWith(phone, dbus.UInt32(0))


    def goto_providerpage(self, widget, url):
        print url
        self.osso_r.rpc_run('com.nokia.osso_browser', 
                            '/com/nokia/osso_browser/request', 
                            'com.nokia.osso_browser', 
                            'load_url', (url, ),
                            False, True) 

        
    def quit(self,  control,  window,  widget):
        """Quit application"""
        gtk.main_quit()
        
        
    def warning_message(self,  exception, message):
        """"Display error dialog window"""
        
        if exception=='URLError':
            message = """Network error
            Check internet connection
            Or try later
            
            Internal error message :
            %s""" % message
        else:
            message = """Unknown error
            
            Internal error message :
            %s
            %s""" % (exception,  message)
        
        boite = gtk.Dialog("Error", self.window,
            gtk.DIALOG_MODAL,
            (gtk.STOCK_OK, gtk.RESPONSE_YES))
        msg_label = gtk.Label(message)
        msg_label.set_line_wrap(True)
        msg_label.set_size_request(-1, 300)
        boite.vbox.pack_start(msg_label, True, True, 0)
        boite.vbox.show_all()

        reponse = boite.run()
        boite.destroy()
        
        
    def gps_on_changed(self,  device,  user_data):
        """callback each time the location changes"""

        if device.fix:
            print self.previousfixtime,  device.fix[2]
            print str(device.fix[2])=='nan'
            if (str(device.fix[4]) != "nan") and (str(device.fix[5]) != "nan"):
                self.browsebutton.set_sensitive(self.provider.browse_categories)
                self.searchbutton.set_sensitive(self.provider.search)
                self.searchentry.set_sensitive(self.provider.search)
                self.latitude = device.fix[4]
                self.longitude = device.fix[5]
    
        
    def build_parameters_window(self,  widget,  data):
        dialog = gtk.Dialog("Parameters", self.window,
            gtk.DIALOG_MODAL,
            ('Save', gtk.RESPONSE_YES))
        dialog.set_title("Hello!")
        dialog.show_all()
        dialog.run()


    def view_gmap(self, widget, place_coord):
        lat_place, long_place = place_coord
        url = MAP_URL % (self.latitude,  self.longitude,  lat_place,  long_place)
        print url
        self.osso_r.rpc_run('com.nokia.osso_browser', 
                            '/com/nokia/osso_browser/request', 
                            'com.nokia.osso_browser', 
                            'load_url', (url, ),
                            False, True) 
                            
