# coding: latin-1
CONSUMER_KEY = 'LSZccyTV34FcEdr3UVDXUw_zmfYffFFpTcMRtJ4nUhqidYbV89WcRagy8V.0dCa1LKU-'
USER_AGENT = 'Firefox/3.5 Maemo Browser 1.5.6 RX-51 N900'
YAHOO_URL = 'http://local.yahooapis.com/LocalSearchService/V3/localSearch'
MEDIA_PATH = '/usr/share/libellule/'

import libellule.provider as provider
from lxml import etree
import gtk
import os

class Yahoo(provider.Provider):

    def __init__(self):
        provider.Provider.__init__(self)
        self.categories_cache = {}
        self.browse_categories = False
        self.search = True
        self.current_query = ''

    def get(self, data=None, params=None):

        print data,  params
        return self.search_query(latitude = params['latitude'], 
                                            longitude = params['longitude'], 
                                            query = self.current_query, 
                                            start = data)


    def search_query(self, latitude, longitude, query,  start=None):
        self.current_query = query
        http_params = {'query' : query,
                           'latitude' : latitude,
                           'longitude' : longitude,
                           'sort' : 'distance', 
                           'appid' : CONSUMER_KEY}
        if start:
            http_params.update({'start' : start})
        xml_data = self.retrieve_data(YAHOO_URL, http_params)
        xml_data = xml_data[xml_data.find('<?xml version='):]
        places = provider.PlacesList()
        root = etree.XML(xml_data)
        total_result = int(root.get('totalResultsAvailable'))
        current_result = int(root.get('firstResultPosition'))
        returned_result = int(root.get('totalResultsReturned'))
        print 'total_result ',  total_result
        print 'current_result ',  current_result
        print 'returned_result ',  returned_result
        if total_result == 0:
            return places
        #Parse navigation links
        places.first_page = 1
        if (current_result - returned_result) > 0:
            places.previous_page = current_result - returned_result
        if (current_result + returned_result < total_result) and (
            current_result + returned_result <= 241):
            places.next_page = current_result + returned_result
        if total_result < 241:
            places.last_page = (total_result / 10) * 10
        else:
            places.last_page = 241
        
        self.places_cache = {}
        ns = root.tag[:-9]
        result_iter = root.getiterator(ns + 'Result')
        for place in result_iter:
            print place
            print place.find(ns + 'Title').text
            rating = place.find(ns + 'Rating').findtext(ns + 'AverageRating')
            places.add({'title' : place.findtext(ns + 'Title'), 
                        #place.find('address').findtext('postcode'), 
                            'url' : place.findtext(ns + 'Url'), 
                            'id' : place.get('id'), 
                            'phone' : place.findtext(ns + 'Phone'), 
                            'rating' : rating, 
                            'distance' : place.findtext(ns + 'Distance'), 
                            'address' : place.findtext(ns + 'Address'), 
                            'city' : place.findtext(ns + 'City'), 
                            'latitude' : place.findtext(ns + 'Latitude'), 
                            'longitude' : place.findtext(ns + 'Longitude'), 
                            'stars_img' : rating_to_starimg(rating)})
            self.places_cache.update({place.get('id') : {
                            'title' : place.findtext(ns + 'Title'), 
                            'url' : place.findtext(ns + 'Url'), 
                            'id' : place.get('id'), 
                            'phone' : place.findtext(ns + 'Phone'), 
                            'rating' : rating, 
                            'distance' : place.findtext(ns + 'Distance'), 
                            'address' : place.findtext(ns + 'Address'), 
                            'city' : place.findtext(ns + 'City'), 
                            'latitude' : place.findtext(ns + 'Latitude'), 
                            'longitude' : place.findtext(ns + 'Longitude'), 
                            'stars_img' : rating_to_starimg(rating)}})
                    
        print places.get_list()
        return places


    def get_place(self, id):
        place = Place()
        place.data = self.places_cache[id]
        return place


class Place():
    def __init__(self):
        self.data = {}

    def phone(self):
        return self.data['phone']

    def get_table(self):
        table = gtk.Table(5,  2)        
        label = gtk.Label("Distance : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  0,  1,  gtk.SHRINK)
        label = gtk.Label("Address : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  1,  2,  gtk.SHRINK)
        label = gtk.Label("Phone : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  2,  3,  gtk.SHRINK)
        
        distance = "%s km" % self.data['distance']
        label = gtk.Label(distance)
        label.set_alignment(0,  0)
        label.set_padding(0,  10)        
        table.attach(label, 1, 2,  0,  1)
        label = gtk.Label(self.get_address())
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label, 1,  2,  1,  2)
        label = gtk.Label(self.data['phone'])
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label,  1,  2,  2,  3)

        return table

    def get_address(self):
        address = ''
        if self.data['address']: address = self.data['address'] + "\n"
        if self.data['city']: address = address + self.data['city']
        return address

    def get_phone(self):
        if self.data['phone']:
            phone = self.data['phone'].replace(' ', '').replace('-', '')
            phone = phone.replace('(', '').replace(')', '')
            return phone

    def get_title(self):
        return self.data['title']

    def get_rating(self):
        return int(self.data['rating'])

    def get_coord(self):
        return (self.data['latitude'], self.data['longitude'])

    def get_privatelink(self):
        id = self.data['id'].split('/')[-1]
        current_path = os.path.dirname( os.path.realpath( __file__ ) )
        logo = gtk.image_new_from_file(MEDIA_PATH + 'yahoo_logo.png')
        return logo, self.data['url']

    def get_astext(self):
        text = "Title : " + self.data['title'] + "\n"
        text = text + "Address : " + self.get_address() + "\n"
        if self.data['phone']:
            text = text + "Phone : " + self.data['phone'] + "\n"
        text = text + "link : " + self.data['url'] + "\n"
        return text
        
    def get_starimg(self):
        return self.data['stars_img']
        
    def get_hbox_title(self):
        hbox = gtk.HBox(False, 0)
        label = gtk.Label()
        label.set_markup("<b>" + self.data['title'] + "</b>")
        hbox.pack_start(label, True, True, 0)
        hbox_star = gtk.HBox(False, 0)
        hbox_star.pack_start(gtk.image_new_from_pixbuf(self.get_starimg()),
                             False)
        hbox.pack_start(hbox_star,  False, False,   50);
        return hbox


def rating_to_starimg(rating):
    if (not rating) or (rating=='NaN') :
       rating = '0'
    else :
        rating = rating[0]
    print rating
    img = MEDIA_PATH + "star_%s.png" % rating
    return gtk.gdk.pixbuf_new_from_file(img)
    

if __name__ == "__main__":
    pv = Qype()
    #print pv.get().get()
    #print pv.get('http://api.qype.com/v1/place_categories/4/children').get_list()
    print pv.get('507', {'latitude' : 48.769065, 'longitude' : 2.027348}).get_list()



