/*
 * This file is part of libdicto
 *
 * Copyright (C) 2009 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>

#include "config.h"

#ifdef WITH_HILDON
#include <hildon/hildon.h>
#endif

#include "dicto.h"
#include "dicto-ui.h"

GtkWidget *window;
Dicto *d;

static gboolean
dicto_error_cb(Dicto *d, gpointer err, gpointer data)
{
GError *e=(GError *)err;

g_debug("Dicto reported error: (%d) %s", e->code, e->message);
return FALSE;
}

static gboolean
dicto_delete_query_cb(GtkWidget *dw, const gchar *file, gpointer data)
{
return dicto_widget_delete_query_dialog(GTK_WINDOW(window), file);
}

static gboolean
dicto_timed_cb(GtkWidget *dw, gpointer data)
{
dicto_record_timeout(d, "shortclip.wav", 3.0);
}

gint 
main(gint argc, gchar * argv[])
{
GtkWidget *dw, *v, *b;
DictoFormat f=FORMAT_DEFAULT;
gchar *sink, *src;

g_thread_init(NULL);
g_type_init();
gst_init(&argc, &argv);
#ifdef WITH_HILDON_2_2
hildon_gtk_init(&argc, &argv);
#else
gtk_init(&argc, &argv);
#endif
g_set_application_name("DictoUI");
gtk_window_set_default_icon_name("dicto");
g_setenv("PULSE_PROP_media.role", "phone", TRUE);

sink=NULL;
src=NULL;

if (argc>1)
	f=atoi(argv[1]);

if (argc>2)
	src=argv[2];

if (argc>3)
	sink=argv[3];

window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(window), "Dicto widget test");
gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
gtk_window_set_default_size(GTK_WINDOW(window), 400, 260);
g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

d=dicto_new_full("/tmp", f, sink, src);
if (!d) {
	g_warning("Dicto creation failed, exiting...");
	return 1;
}
dw=dicto_widget_new(d);
v=gtk_vbox_new(FALSE, 2);
gtk_container_add(GTK_CONTAINER(window), v);
gtk_container_add(GTK_CONTAINER(v), dw);

b=gtk_button_new_with_label("Record for 3 seconds");
gtk_container_add(GTK_CONTAINER(v), b);

g_signal_connect(G_OBJECT(d), "error", G_CALLBACK(dicto_error_cb), dw);
g_signal_connect(G_OBJECT(b), "clicked", G_CALLBACK(dicto_timed_cb), dw);
g_signal_connect(G_OBJECT(dw), "delete-query", G_CALLBACK(dicto_delete_query_cb), dw);
g_object_set(dw, "enable-delete", TRUE, NULL);

gtk_widget_show_all(window);
gtk_main();

return 0;
}

