#include "hid.h"
#include <gtk/gtk.h>
#include <dbus-1.0/dbus/dbus-glib.h>
#include <QDBusInterface>
#include <QDBusObjectPath>
#include <QString>
#include <QDBusReply>



void notify(
	    DBusGProxy       *proxy,
	    DBusGProxyCall   *call_id,
	    void             *user_data
    )
{

    GError *error = NULL;

    PHID_USER_DATA cud=(PHID_USER_DATA)user_data;
    if(dbus_g_proxy_end_call(proxy, call_id, &error, G_TYPE_INVALID))
	cud->callback(1,0,cud->context);
    else
    {
	bool success=false;

	if(dbus_g_error_has_name(error,"org.bluez.Error.InProgress"))
	    success=true;

	cud->callback(success,error->message,cud->context);

	g_clear_error (&error);
    }

    g_object_unref(G_OBJECT(cud->proxy));

    g_free(cud);
}

bool hid_connect_disconnect(char * deviceAddress, char *profile,BT_CALLBACK_FUNCION btCallback,void * BtContext,const char * method)
{
    Q_UNUSED(profile)

    QString devicePath = bluetooth_device_get_for_address(deviceAddress);
    if(devicePath.isEmpty())
	return 0;

    GError *error = 0;
    DBusGConnection *connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
    if (error)
    {
      g_clear_error (&error);
      return 0;
    }

    DBusGProxy *proxy = dbus_g_proxy_new_for_name (
	connection,
	"org.bluez",
	devicePath.toLatin1(),
	"org.bluez.Input");

    if(proxy == 0)
    {
	dbus_g_connection_unref(connection);
	return 0;
    }

    if(btCallback)
    {
	PHID_USER_DATA cud=(PHID_USER_DATA)g_malloc(sizeof(HID_USER_DATA));

	cud->proxy=proxy;
	cud->callback=btCallback;
	cud->context=BtContext;

	dbus_g_proxy_begin_call(proxy, method, notify,
				cud, NULL, G_TYPE_INVALID);
    }
    else
    {
	dbus_g_proxy_call_no_reply(proxy, method, G_TYPE_INVALID);
	g_object_unref(proxy);
    }

    dbus_g_connection_unref(connection);

    return 1;

}

extern "C" HIDSHARED_EXPORT bool connect(char * deviceAddress, char *profile,BT_CALLBACK_FUNCION btCallback,void * BtContext)
{
    return hid_connect_disconnect(deviceAddress, profile,btCallback,BtContext,"Connect");
}

extern "C" HIDSHARED_EXPORT int disconnect(char * deviceAddress, char *profile)
{
    return hid_connect_disconnect(deviceAddress, profile,0,0,"Disconnect");
}

extern "C" HIDSHARED_EXPORT int cancel_connect()
{
    return 0;
}

static QString bluetooth_device_get_for_address(const QString & address)
{
    QString result;
    QDBusInterface manager(    "org.bluez",
				"/",
				"org.bluez.Manager",
				QDBusConnection::systemBus()
    );
    QDBusReply<QDBusObjectPath> defaultAdapter=manager.call("DefaultAdapter");

    if(defaultAdapter.isValid())
    {
	QDBusInterface adapter(
			    "org.bluez",
			    defaultAdapter.value().path(),
			    "org.bluez.Adapter",
			    QDBusConnection::systemBus()
	);
	QDBusReply<QDBusObjectPath> devicePath = adapter.call("FindDevice",address);

	if(defaultAdapter.isValid())
	{
	    result = devicePath.value().path();
	}
    }
    return result;
}
extern "C" HIDSHARED_EXPORT const char * __profile_names[]={ "HID", 0 };

extern "C" HIDSHARED_EXPORT void activate()
{}

extern "C" HIDSHARED_EXPORT const char ** profile_names()
{return (__profile_names);}

extern "C" HIDSHARED_EXPORT int connect_automatically()
{return 1;}

extern "C" HIDSHARED_EXPORT int can_connect()
{
    return 1;
}
