#ifndef LUXWIDGET_H
#define LUXWIDGET_H

#include <QWidget>
#include <QPixmap>

#include "utils.h"




class QPaintEvent;
class QResizeEvent;


class LuxWidget : public QWidget
{
    Q_OBJECT
public:
    LuxWidget();

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void timerEvent(QTimerEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *);

private:
    QPixmap       cache;
    bool          dirty;

    int timerId;
    LuxusUnits currentUnit;


};

#endif
