#ifndef LUXWIDGET_H
#define LUXWIDGET_H

#include <QWidget>
#include <QPixmap>

class QPaintEvent;
class QSvgRenderer;
class QResizeEvent;

typedef enum {

    LuxusUnits_Lux = 0,
    LuxusUnits_CD_m2,
    LuxusUnits_CD_ft,
    LuxusUnits_EV_100

} LuxusUnits;

class LuxWidget : public QWidget
{
    Q_OBJECT
public:
    LuxWidget();

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void timerEvent(QTimerEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *);

private:
    QPixmap       cache;
    bool          dirty;

    int timerId;
    LuxusUnits currentUnit;

    int getLux();
    bool detectSB();

    qreal log2(qreal);
    QPair<int,int> Lux2EV(int);
};

#endif
