/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STATIONS_SIMPLE_PRIVATE_BARCELONE_H
#define STATIONS_SIMPLE_PRIVATE_BARCELONE_H

#include "stationspluginsimple_p.h"


static const struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        double x;
        double y;
} stations[] = {
	{ 1, 0, "1", "Gran Via Corts Catalanes", 41.397978, 2.180019 },
	{ 2, 0, "2", "Plaza Tetuán", 41.394381, 2.176414 },
	{ 3, 0, "3", "Ali Bei", 41.393750, 2.181164 },
	{ 4, 0, "4", "Ribes", 41.393364, 2.181400 },
	{ 5, 0, "5", "Pg Lluís Companys", 41.391072, 2.180214 },
	{ 6, 0, "6", "Pg Lluís Companys", 41.391272, 2.180508 },
	{ 7, 0, "7", "Pg Lluís Companys", 41.388867, 2.183183 },
	{ 8, 0, "8", "Passeig Lluís Companys", 41.389044, 2.183453 },
	{ 9, 0, "9", "Marquès De L'Argentera", 41.385006, 2.185294 },
	{ 10, 0, "14", "Avinguda Del Marques Argentera", 41.384875, 2.185206 },
	{ 11, 0, "10", "Comerç", 41.385394, 2.183622 },
	{ 12, 0, "11", "Trelawny", 41.381681, 2.193939 },
	{ 13, 0, "12", "Pg Marítim Barceloneta", 41.384522, 2.195661 },
	{ 14, 0, "125", "Passeig Maritim", 41.384417, 2.195603 },
	{ 15, 0, "69", "Avda. Litoral", 41.386811, 2.195706 },
	{ 16, 0, "13", "Avinguda Litoral", 41.386869, 2.195764 },
	{ 17, 0, "15", "Girona", 41.395161, 2.170775 },
	{ 18, 0, "16", "Av. Meridiana", 41.398258, 2.186700 },
	{ 19, 0, "17", "Padilla", 41.398181, 2.186697 },
	{ 20, 0, "18", "Rosselló", 41.405875, 2.174139 },
	{ 21, 0, "19", "Rossello", 41.403267, 2.170733 },
	{ 22, 0, "20", "Industria", 41.409756, 2.174628 },
	{ 23, 0, "22", "Sardenya", 41.402047, 2.175186 },
	{ 24, 0, "23", "Bruc", 41.392531, 2.171817 },
	{ 25, 0, "24", "Marina", 41.400008, 2.180325 },
	{ 26, 0, "25", "Bruc", 41.395169, 2.168350 },
	{ 27, 0, "27", "Provença", 41.396825, 2.164378 },
	{ 28, 0, "28", "Marina", 41.407253, 2.170847 },
	{ 29, 0, "29", "Provença", 41.401056, 2.170025 },
	{ 30, 0, "30", "Diagonal", 41.402058, 2.182269 },
	{ 31, 0, "31", "Passeig Joan Borbó", 41.375808, 2.189092 },
	{ 32, 0, "32", "Plaça Del Mar", 41.373644, 2.187797 },
	{ 33, 0, "33", "Judici", 41.376608, 2.190082 },
	{ 34, 0, "124", "Atlantida", 41.377128, 2.190847 },
	{ 35, 0, "34", "Sant Pere Més Alt", 41.387067, 2.175269 },
	{ 36, 0, "35", "Ramon Berenguer El Gran", 41.384258, 2.177886 },
	{ 37, 0, "36", "Catedral", 41.385153, 2.176797 },
	{ 38, 0, "37", "Pl. Antonio López", 41.381247, 2.181842 },
	{ 39, 0, "38", "Pl. Pau Vila", 41.381161, 2.186436 },
	{ 40, 0, "39", "Pl. Pau Vila", 41.381056, 2.186633 },
	{ 41, 0, "40", "Doctor Aiguader", 41.382236, 2.186267 },
	{ 42, 0, "41", "Almirall Churruca", 41.379047, 2.189700 },
	{ 43, 0, "43", "Av Meridiana", 41.404625, 2.187161 },
	{ 44, 0, "44", "Av Meridiana", 41.402169, 2.187139 },
	{ 45, 0, "45", "Marina", 41.391994, 2.190422 },
	{ 46, 0, "46", "Ramon Trias Fargas", 41.388350, 2.193006 },
	{ 47, 0, "47", "Ramon Trias Fargas", 41.389078, 2.192106 },
	{ 48, 0, "48", "Meridiana", 41.395275, 2.187081 },
	{ 49, 0, "49", "Rosa Sensat En Front", 41.391044, 2.196458 },
	{ 50, 0, "117", "Rosa Sensat", 41.390667, 2.197028 },
	{ 51, 0, "50", "Paral·Lel", 41.374931, 2.170878 },
	{ 52, 0, "51", "Pl. Vicenç Martorell", 41.384081, 2.169069 },
	{ 53, 0, "52", "Plaça De Sant Miquel", 41.381767, 2.177386 },
	{ 54, 0, "53", "Pl. Carles Pi I Sunyer", 41.385233, 2.173872 },
	{ 55, 0, "380", "Duran I Bas", 41.385500, 2.174239 },
	{ 56, 0, "54", "Sant Oleguer", 41.377536, 2.170736 },
	{ 57, 0, "55", "La Rambla", 41.381153, 2.173478 },
	{ 58, 0, "56", "Portal De Santa Madrona", 41.377006, 2.175836 },
	{ 59, 0, "57", "La Rambla", 41.376747, 2.177092 },
	{ 60, 0, "58", "Plaça Dels Àngels", 41.382822, 2.167156 },
	{ 61, 0, "59", "Plaça Dels Àngels", 41.382781, 2.167211 },
	{ 62, 0, "60", "Rambla Catalunya 47", 41.390297, 2.164350 },
	{ 63, 0, "61", "Rambla Catalunya", 41.390089, 2.164869 },
	{ 64, 0, "62", "Pl. Catalunya", 41.387133, 2.168844 },
	{ 65, 0, "63", "Pl. Catalunya", 41.386439, 2.169417 },
	{ 66, 0, "64", "Pl. Catalunya", 41.387450, 2.169017 },
	{ 67, 0, "65", "Pl. Catalunya", 41.387678, 2.169569 },
	{ 68, 0, "66", "Gran Via", 41.389100, 2.167933 },
	{ 69, 0, "287", "Gran Via", 41.389183, 2.168158 },
	{ 70, 0, "67", "Rocafort", 41.385031, 2.145844 },
	{ 71, 0, "68", "Rambla Catalunya", 41.395331, 2.157403 },
	{ 72, 0, "70", "Villarroel", 41.381356, 2.161817 },
	{ 73, 0, "71", "Floridablanca", 41.381903, 2.163019 },
	{ 74, 0, "72", "Passatge Mercader", 41.393192, 2.157106 },
	{ 75, 0, "73", "Enric Granados", 41.392819, 2.155750 },
	{ 76, 0, "74", "Josep Tarradellas", 41.389419, 2.143153 },
	{ 77, 0, "75", "Josep Tarradellas", 41.385083, 2.142864 },
	{ 78, 0, "76", "Casanova", 41.391778, 2.153100 },
	{ 79, 0, "77", "Casanova", 41.390044, 2.152903 },
	{ 80, 0, "78", "Pl. Universitat", 41.385658, 2.163456 },
	{ 81, 0, "79", "Pl. Universitat", 41.385756, 2.163572 },
	{ 82, 0, "80", "Enric Granados", 41.389678, 2.159869 },
	{ 83, 0, "81", "Vilamarí Davant", 41.378925, 2.149172 },
	{ 84, 0, "82", "Rocafort", 41.378983, 2.153764 },
	{ 85, 0, "83", "Compte Borrell", 41.384058, 2.153700 },
	{ 86, 0, "84", "Diputació", 41.383381, 2.157653 },
	{ 87, 0, "85", "Paral·Lel", 41.375072, 2.159078 },
	{ 88, 0, "86", "Paral·Le", 41.375025, 2.163644 },
	{ 89, 0, "87", "Mallorca", 41.383167, 2.148497 },
	{ 90, 0, "88", "Londres", 41.393519, 2.150811 },
	{ 91, 0, "89", "Rosselló", 41.387972, 2.150164 },
	{ 92, 0, "90", "Rosselló", 41.388270, 2.150744 },
	{ 93, 0, "91", "Comte Borrell", 41.380475, 2.158436 },
	{ 94, 0, "92", "Provença", 41.393831, 2.160258 },
	{ 95, 0, "93", "Gran Via", 41.375444, 2.149786 },
	{ 96, 0, "94", "Gran Via", 41.375617, 2.149903 },
	{ 97, 0, "95", "Tarragona", 41.376422, 2.147722 },
	{ 98, 0, "96", "Gran Via", 41.374114, 2.148125 },
	{ 99, 0, "97", "Tarragona", 41.378061, 2.145478 },
	{ 100, 0, "98", "Viriat", 41.380656, 2.141708 },
	{ 101, 0, "99", "Viriat", 41.380514, 2.141483 },
	{ 102, 0, "100", "Tarragona", 41.379167, 2.144147 },
	{ 103, 0, "101", "Av. Pau Casals", 41.392950, 2.143814 },
	{ 104, 0, "102", "Av. Pau Casals", 41.393089, 2.143389 },
	{ 105, 0, "103", "Aragó", 41.409867, 2.188217 },
	{ 106, 0, "104", "C/València", 41.410811, 2.187383 },
	{ 107, 0, "105", "Pl. Urquinaona", 41.389067, 2.173444 },
	{ 108, 0, "106", "Pl. Joanic", 41.405597, 2.162331 },
	{ 109, 0, "107", "Travessera De Gracia", 41.398286, 2.153111 },
	{ 110, 0, "108", "Industria", 41.402353, 2.165017 },
	{ 111, 0, "109", "C/ Londres", 41.390972, 2.147386 },
	{ 112, 0, "110", "Avda. Roma", 41.385556, 2.154803 },
	{ 113, 0, "111", "Calabria", 41.381000, 2.153028 },
	{ 114, 0, "112", "Floridablanca", 41.377703, 2.157281 },
	{ 115, 0, "113", "Comte Borrell", 41.378822, 2.160894 },
	{ 116, 0, "114", "Pl. Jean Genet", 41.376817, 2.173044 },
	{ 117, 0, "115", "Marquès D'Argentera", 41.383256, 2.183756 },
	{ 118, 0, "116", "Salvat Papaseit", 41.383739, 2.191567 },
	{ 119, 0, "118", "Pujades", 41.391878, 2.187331 },
	{ 120, 0, "119", "Ausias March", 41.396589, 2.182750 },
	{ 121, 0, "120", "Lepanto", 41.404658, 2.176506 },
	{ 122, 0, "121", "Cartagena", 41.406289, 2.178700 },
	{ 123, 0, "122", "Napols", 41.405436, 2.166247 },
	{ 124, 0, "123", "Girona", 41.397397, 2.167772 },
	{ 125, 0, "126", "Passeig De Colom", 41.380619, 2.182267 },
	{ 126, 0, "127", "Arago", 41.412331, 2.191444 },
	{ 127, 0, "128", "Rambla Guipúscoa", 41.415560, 2.195810 },
	{ 128, 0, "129", "Guipuscoa", 41.417340, 2.198100 },
	{ 129, 0, "130", "Guipuscoa", 41.419906, 2.201572 },
	{ 130, 0, "131", "Guipuscoa", 41.422853, 2.206064 },
	{ 131, 0, "132", "Pl. Valentí Amirall", 41.408431, 2.192178 },
	{ 132, 0, "133", "Gran Vía", 41.407394, 2.192842 },
	{ 133, 0, "134", "Gran Via", 41.411311, 2.198117 },
	{ 134, 0, "135", "Gran Vía", 41.411956, 2.197975 },
	{ 135, 0, "137", "Gran Vía, 1041/ Selva De Mar", 41.414750, 2.201522 },
	{ 136, 0, "139", "Gran Vía", 41.418047, 2.206025 },
	{ 137, 0, "140", "Gran Vía", 41.419719, 2.209078 },
	{ 138, 0, "141", "Gran Via", 41.409022, 2.194894 },
	{ 139, 0, "142", "Sancho De Ávila", 41.400556, 2.192497 },
	{ 140, 0, "143", "Sancho De Ávila", 41.402369, 2.195008 },
	{ 141, 0, "144", "Castella", 41.405633, 2.197617 },
	{ 142, 0, "145", "Pere Iv", 41.409844, 2.202931 },
	{ 143, 0, "146", "Pere Iv", 41.412394, 2.204831 },
	{ 144, 0, "147", "Rambla Prim", 41.416031, 2.212656 },
	{ 145, 0, "148", "Erasme De Jane", 41.379700, 2.166161 },
	{ 146, 0, "149", "Pujades", 41.395906, 2.192994 },
	{ 147, 0, "150", "Espronceda", 41.406547, 2.203108 },
	{ 148, 0, "151", "Pujades", 41.413186, 2.216053 },
	{ 149, 0, "152", "Pujades", 41.399253, 2.197453 },
	{ 150, 0, "153", "Pujades", 41.401758, 2.200797 },
	{ 151, 0, "154", "Pujades", 41.402450, 2.201667 },
	{ 152, 0, "155", "Pujades", 41.406986, 2.207636 },
	{ 153, 0, "156", "Diagonal", 41.408936, 2.208561 },
	{ 154, 0, "157", "C/Llull", 41.411642, 2.216303 },
	{ 155, 0, "158", "Rambla De Prim", 41.411664, 2.218733 },
	{ 156, 0, "160", "C/ De Taulat", 41.411028, 2.219381 },
	{ 157, 0, "161", "Ramon Turro", 41.395000, 2.196306 },
	{ 158, 0, "162", "Ramon Turro", 41.404364, 2.208775 },
	{ 159, 0, "163", "Avda. Icaria", 41.392611, 2.198950 },
	{ 160, 0, "164", "Independència", 41.411939, 2.178031 },
	{ 161, 0, "165", "Carrer Del Doctor Trueta", 41.399183, 2.204264 },
	{ 162, 0, "166", "Passeig De Taulat", 41.401075, 2.207650 },
	{ 163, 0, "167", "Passeig De Taulat", 41.403453, 2.211194 },
	{ 164, 0, "168", "Passeig De Taulat", 41.405164, 2.213458 },
	{ 165, 0, "169", "Avda. Litoral", 41.389900, 2.200056 },
	{ 166, 0, "170", "Avda. Litoral", 41.389739, 2.199933 },
	{ 167, 0, "171", "Avda. Litoral/ Jaume Vicen I Vives", 41.391978, 2.203711 },
	{ 168, 0, "172", "Avda. Litoral/ Jaume Vicen I Vives", 41.391850, 2.203464 },
	{ 169, 0, "173", "Avda. Litoral", 41.398206, 2.209108 },
	{ 170, 0, "174", "Passeig De Garcia Faria", 41.400372, 2.210314 },
	{ 171, 0, "175", "Passeig Marítim De La Mar Bella", 41.400169, 2.212703 },
	{ 172, 0, "176", "Passeig De Garcia Faria", 41.402533, 2.212647 },
	{ 173, 0, "177", "Rosselló", 41.411058, 2.181100 },
	{ 174, 0, "178", "Passeig De Garcia Faria", 41.405378, 2.216217 },
	{ 175, 0, "179", "Rambla Badal", 41.365317, 2.135672 },
	{ 176, 0, "180", "Gran Via", 41.368008, 2.139650 },
	{ 177, 0, "181", "Gran Via", 41.368403, 2.140169 },
	{ 178, 0, "182", "Gran Via", 41.371333, 2.143933 },
	{ 179, 0, "183", "Gavà", 41.372350, 2.141878 },
	{ 180, 0, "184", "Quetzal", 41.367506, 2.134100 },
	{ 181, 0, "187", "Carrer De Sant Pau", 41.376844, 2.169842 },
	{ 182, 0, "188", "Joan Güell", 41.375942, 2.134664 },
	{ 183, 0, "190", "Avinguda Litoral", 41.396075, 2.207797 },
	{ 184, 0, "191", "Rocafort", 41.382647, 2.149211 },
	{ 185, 0, "192", "Joan Güell", 41.379797, 2.132836 },
	{ 186, 0, "193", "Figols", 41.381308, 2.128936 },
	{ 187, 0, "194", "Joan Güell", 41.382272, 2.131692 },
	{ 188, 0, "195", "Comtes De Bell-Lloc", 41.382333, 2.136108 },
	{ 189, 0, "196", "Comte Bell-Lloch", 41.384453, 2.134628 },
	{ 190, 0, "197", "Taquigraf Serra", 41.386403, 2.139808 },
	{ 191, 0, "198", "Vallespir", 41.385139, 2.133331 },
	{ 192, 0, "199", "Mejía Lequerica", 41.381792, 2.126892 },
	{ 193, 0, "200", "Can Bruixa", 41.383733, 2.131308 },
	{ 194, 0, "201", "Deu I Mata", 41.388456, 2.135825 },
	{ 195, 0, "202", "Carrer De Les Corts", 41.385378, 2.128672 },
	{ 196, 0, "203", "Avda. Diagonal", 41.388767, 2.128553 },
	{ 197, 0, "204", "Avda. Diagonal", 41.388031, 2.125594 },
	{ 198, 0, "206", "Avda. Diagonal", 41.389889, 2.132961 },
	{ 199, 0, "284", "Ada. Diagonal", 41.389483, 2.131456 },
	{ 200, 0, "207", "Avda. Diagonal", 41.390856, 2.136656 },
	{ 201, 0, "208", "Avda. Diagonal", 41.391050, 2.137403 },
	{ 202, 0, "209", "Diputació", 41.385806, 2.161056 },
	{ 203, 0, "210", "Sant Crist", 41.374553, 2.142378 },
	{ 204, 0, "211", "Sancho De Ávila", 41.398844, 2.190294 },
	{ 205, 0, "212", "Numancia", 41.392192, 2.130331 },
	{ 206, 0, "213", "Doctor Fleming", 41.392508, 2.135661 },
	{ 207, 0, "214", "Doctor Fleming", 41.393969, 2.135033 },
	{ 208, 0, "215", "Carrer De Francesc Pérez Cabrero", 41.394467, 2.138647 },
	{ 209, 0, "216", "Madrazo", 41.396814, 2.144533 },
	{ 210, 0, "217", "Rector Ubach", 41.398986, 2.143525 },
	{ 211, 0, "218", "Consell De Cent", 41.404142, 2.183231 },
	{ 212, 0, "219", "Carre Laforja", 41.397825, 2.147625 },
	{ 213, 0, "220", "Tuset", 41.396261, 2.151528 },
	{ 214, 0, "221", "Gran De Gràcia", 41.402547, 2.152528 },
	{ 215, 0, "222", "Carrer Del Canó", 41.401247, 2.157489 },
	{ 216, 0, "223", "Carrer De Bonavista", 41.398314, 2.159881 },
	{ 217, 0, "224", "Girona", 41.399092, 2.165525 },
	{ 218, 0, "226", "Montmany", 41.403469, 2.161133 },
	{ 219, 0, "227", "Plaça Rovira I Trias", 41.407822, 2.158697 },
	{ 220, 0, "228", "Pl. Del Nord", 41.406936, 2.155800 },
	{ 221, 0, "229", "Carrer De La Santacreu", 41.405100, 2.156894 },
	{ 222, 0, "230", "C. De Nil Fabra", 41.405983, 2.151647 },
	{ 223, 0, "231", "C. Del Secretari Coloma", 41.409128, 2.163269 },
	{ 224, 0, "232", "Vilà I Vilà", 41.373492, 2.170989 },
	{ 225, 0, "233", "Nou De La Rambla", 41.371967, 2.166881 },
	{ 226, 0, "234", "Passeig De L'Exposició", 41.371522, 2.162156 },
	{ 227, 0, "235", "Elkano", 41.373747, 2.161647 },
	{ 228, 0, "236", "Carrer De La França Xica", 41.372147, 2.156564 },
	{ 229, 0, "237", "Rius I Taulet", 41.372911, 2.154464 },
	{ 230, 0, "238", "Espronceda", 41.415669, 2.190983 },
	{ 231, 0, "239", "Indústria", 41.417317, 2.184731 },
	{ 232, 0, "240", "Josep Estivill", 41.417753, 2.187583 },
	{ 233, 0, "241", "Pl. Maragall", 41.419817, 2.181300 },
	{ 234, 0, "242", "Ramon Albó", 41.424556, 2.177314 },
	{ 235, 0, "243", "Alenxadre Galí", 41.423950, 2.181331 },
	{ 236, 0, "244", "Felip Ii", 41.426906, 2.178517 },
	{ 237, 0, "246", "Juan De Garay", 41.422553, 2.185725 },
	{ 238, 0, "247", "Olesa", 41.422769, 2.185261 },
	{ 239, 0, "248", "Palència", 41.418203, 2.190414 },
	{ 240, 0, "250", "Portugal", 41.426228, 2.190131 },
	{ 241, 0, "251", "Cardenal Tedeschini", 41.425394, 2.185222 },
	{ 242, 0, "252", "Carrer Del Pare Manyanet", 41.428192, 2.193400 },
	{ 243, 0, "253", "Onze De Setembre", 41.429981, 2.191822 },
	{ 244, 0, "254", "Gran De Sant Andreu", 41.430350, 2.189600 },
	{ 245, 0, "255", "Irlanda", 41.431189, 2.185856 },
	{ 246, 0, "256", "Malats", 41.436008, 2.189536 },
	{ 247, 0, "257", "Sant Adrià", 41.433886, 2.189697 },
	{ 248, 0, "258", "Carrer De Palomar", 41.442000, 2.189108 },
	{ 249, 0, "259", "Carrer De Bartrina", 41.439119, 2.185819 },
	{ 250, 0, "260", "Plaça De L'Estació", 41.436192, 2.192969 },
	{ 251, 0, "261", "Villarroel", 41.382228, 2.160667 },
	{ 252, 0, "262", "Rocafort", 41.379833, 2.152558 },
	{ 253, 0, "263", "C/Joan Torras", 41.437675, 2.191383 },
	{ 254, 0, "264", "República Dominicana", 41.439953, 2.197031 },
	{ 255, 0, "267", "Passeig Torras I Bages", 41.443331, 2.190656 },
	{ 256, 0, "268", "Coronel Monasterio", 41.445703, 2.192911 },
	{ 257, 0, "269", "Via Barcino", 41.448147, 2.192900 },
	{ 258, 0, "270", "Mare De Déu De Lorda", 41.449878, 2.190967 },
	{ 259, 0, "272", "Concepció Arenal", 41.432572, 2.184289 },
	{ 260, 0, "274", "Avda. Meridiana", 41.431431, 2.183358 },
	{ 261, 0, "275", "Rio De Janeiro", 41.430703, 2.182206 },
	{ 262, 0, "277", "Travessera De Gràcia", 41.408369, 2.169133 },
	{ 263, 0, "278", "Rosalia De Castro", 41.411500, 2.172111 },
	{ 264, 0, "279", "Ronda Guinardo", 41.416681, 2.174603 },
	{ 265, 0, "280", "Industria", 41.412808, 2.178528 },
	{ 266, 0, "281", "Ronda Guinardo", 41.419394, 2.176522 },
	{ 267, 0, "282", "Font D'En Fargues", 41.427575, 2.166033 },
	{ 268, 0, "283", "Plaça Eivissa", 41.430739, 2.160781 },
	{ 269, 0, "285", "Malats", 41.436683, 2.186028 },
	{ 270, 0, "286", "Bolívia", 41.403111, 2.191439 },
	{ 271, 0, "288", "Pl. Virrei Amat", 41.429631, 2.174506 },
	{ 272, 0, "289", "P. Fabra I Puig", 41.416894, 2.191092 },
	{ 273, 0, "290", "Plaça Dels Jardins D'Alfàbia", 41.437142, 2.174014 },
	{ 274, 0, "291", "Subirats", 41.426969, 2.174661 },
	{ 275, 0, "292", "Amilcar", 41.430050, 2.171969 },
	{ 276, 0, "293", "Petrarca", 41.428725, 2.164567 },
	{ 277, 0, "294", "Seu Del Districte (Nou Barris)", 41.436375, 2.170689 },
	{ 278, 0, "295", "Sant Iscle", 41.433458, 2.171483 },
	{ 279, 0, "296", "Carrer De Rosselló I Porcel/Avda. Meridiana", 41.436553, 2.183875 },
	{ 280, 0, "297", "Carrer Turó Blau", 41.438853, 2.176833 },
	{ 281, 0, "298", "Andreu Nin", 41.434622, 2.181733 },
	{ 282, 0, "299", "Carrer De L'Escultor Ordóñez", 41.433964, 2.175206 },
	{ 283, 0, "300", "Carrer De Maladeta", 41.431547, 2.176933 },
	{ 284, 0, "301", "Marie Curie", 41.437081, 2.169633 },
	{ 285, 0, "302", "Cavallers", 41.390650, 2.111631 },
	{ 286, 0, "304", "Jiménez Iglesias", 41.389892, 2.121853 },
	{ 287, 0, "305", "Diagonal", 41.387519, 2.123631 },
	{ 288, 0, "306", "Doctor Salvador Cardenal", 41.385375, 2.122725 },
	{ 289, 0, "307", "Pintor Ribalta", 41.379206, 2.113525 },
	{ 290, 0, "308", "Cardenal Reig", 41.376758, 2.113908 },
	{ 291, 0, "309", "Sant Ramón Nonat", 41.376722, 2.116917 },
	{ 292, 0, "310", "Josep Samitier", 41.381228, 2.119081 },
	{ 293, 0, "311", "Travessera De Les Corts", 41.378089, 2.121903 },
	{ 294, 0, "312", "Felipe De Paz", 41.379775, 2.126639 },
	{ 295, 0, "313", "Cáceres", 41.374561, 2.131019 },
	{ 296, 0, "314", "Rambla Del Brasil", 41.378258, 2.129667 },
	{ 297, 0, "315", "Guinardó", 41.415669, 2.181911 },
	{ 298, 0, "316", "Cantàbria", 41.422217, 2.198314 },
	{ 299, 0, "317", "Rambla Prim", 41.425564, 2.200692 },
	{ 300, 0, "318", "Ronda Guinardo", 41.414097, 2.170867 },
	{ 301, 0, "319", "Amigó", 41.394739, 2.145175 },
	{ 302, 0, "321", "Carrer De Pádua", 41.404036, 2.143672 },
	{ 303, 0, "322", "Santaló", 41.401017, 2.139122 },
	{ 304, 0, "323", "Vallmajor", 41.398011, 2.138725 },
	{ 305, 0, "324", "Reina Victoria", 41.396961, 2.136192 },
	{ 306, 0, "325", "Alt De Gironella", 41.394950, 2.130322 },
	{ 307, 0, "326", "Castanyer", 41.407022, 2.137744 },
	{ 308, 0, "327", "Reus", 41.406028, 2.133817 },
	{ 309, 0, "328", "Artesa De Segre", 41.402458, 2.134942 },
	{ 310, 0, "329", "Carrer De Les Escoles Pies", 41.402894, 2.128556 },
	{ 311, 0, "330", "Doctor Carulla", 41.400583, 2.130664 },
	{ 312, 0, "331", "Castellnou", 41.397383, 2.127811 },
	{ 313, 0, "332", "Doctor Roux", 41.399850, 2.128117 },
	{ 314, 0, "333", "Passatge De Senillosa", 41.395661, 2.125103 },
	{ 315, 0, "334", "Via Augusta", 41.400725, 2.123269 },
	{ 316, 0, "335", "Santa Amèlia", 41.393647, 2.123231 },
	{ 317, 0, "336", "Caponata", 41.395286, 2.121069 },
	{ 318, 0, "338", "Avinguda De J.Foix", 41.397586, 2.119525 },
	{ 319, 0, "339", "Treball", 41.419589, 2.197142 },
	{ 320, 0, "340", "Sant Adrià", 41.436144, 2.204636 },
	{ 321, 0, "341", "Passeig Enric Sanchís", 41.434189, 2.205883 },
	{ 322, 0, "343", "Campana De La Maquinista", 41.438872, 2.199658 },
	{ 323, 0, "344", "Ciutat D'Asuncion", 41.443164, 2.199650 },
	{ 324, 0, "345", "Pl. Teresa De Claramunt", 41.363125, 2.139800 },
	{ 325, 0, "346", "Carrer De La Foneria", 41.360672, 2.139106 },
	{ 326, 0, "347", "Mare De Déu Dels Ports", 41.358256, 2.143436 },
	{ 327, 0, "348", "Jardins De Can Ferrero", 41.357081, 2.141589 },
	{ 328, 0, "349", "Carrer De L'Energia", 41.357336, 2.137167 },
	{ 329, 0, "350", "Villarroel", 41.391828, 2.148078 },
	{ 330, 0, "351", "Jane Adams", 41.362144, 2.135600 },
	{ 331, 0, "352", "Radi", 41.363347, 2.134122 },
	{ 332, 0, "353", "Munné", 41.375425, 2.123211 },
	{ 333, 0, "354", "Rambla Del Brasil", 41.375667, 2.130142 },
	{ 334, 0, "355", "Canalejas", 41.372478, 2.129506 },
	{ 335, 0, "356", "Balcells", 41.411075, 2.161072 },
	{ 336, 0, "357", "Cardener", 41.410536, 2.158094 },
	{ 337, 0, "358", "Gombau", 41.387094, 2.178908 },
	{ 338, 0, "359", "Méndez Núñez", 41.390017, 2.177550 },
	{ 339, 0, "360", "Bailén", 41.395194, 2.173017 },
	{ 340, 0, "361", "Passeig De Colom", 41.376286, 2.178581 },
	{ 341, 0, "362", "Bailén", 41.396947, 2.170669 },
	{ 342, 0, "363", "Bruc", 41.390764, 2.174369 },
	{ 343, 0, "364", "Passeig De Gràcia", 41.393108, 2.163400 },
	{ 344, 0, "365", "Viladomat", 41.387492, 2.146989 },
	{ 345, 0, "366", "Loreto", 41.391808, 2.142661 },
	{ 346, 0, "367", "Nicaragua", 41.385517, 2.138697 },
	{ 347, 0, "368", "Diputació", 41.396839, 2.175719 },
	{ 348, 0, "369", "Consell De Cent", 41.400817, 2.178625 },
	{ 349, 0, "370", "Sardenya", 41.403728, 2.172997 },
	{ 350, 0, "371", "Carrer Dels Enamorats", 41.404022, 2.181292 },
	{ 351, 0, "372", "Padilla", 41.400025, 2.184450 },
	{ 352, 0, "373", "Paral.Lel", 41.375150, 2.161297 },
	{ 353, 0, "374", "Passeig De Gràcia", 41.394797, 2.161308 },
	{ 354, 0, "375", "World Trade Center", 41.372172, 2.180694 },
	{ 355, 0, "376", "World Trade Center", 41.371703, 2.180286 },
	{ 356, 0, "377", "Pl. Ictíneo", 41.377497, 2.183761 },
	{ 357, 0, "378", "Pl.Joaquim Xira I Palau", 41.378517, 2.176722 },
	{ 358, 0, "379", "Pl. Sant Miquel", 41.381714, 2.177300 },
	{ 359, 0, "381", "Agustí Duran I Sanpere", 41.381606, 2.167750 },
	{ 360, 0, "382", "Lope De Vega", 41.403947, 2.204194 },
	{ 361, 0, "384", "Vilamarí", 41.380592, 2.146856 },
	{ 362, 0, "385", "Casanova", 41.387975, 2.155269 },
	{ 363, 0, "386", "Paral.Lel", 41.375081, 2.156844 },
	{ 364, 0, "387", "Nàpols", 41.395803, 2.178817 },
	{ 365, 0, "388", "Riera Alta", 41.380542, 2.167475 },
	{ 366, 0, "389", "Recinte Parc De La Ciutadella", 41.388136, 2.187692 },
	{ 367, 0, "390", "Comerç, 36", 41.386961, 2.181961 },
	{ 368, 0, "391", "Jaume Brossa", 41.430058, 2.199978 },
	{ 369, 0, "392", "Ramon Turró", 41.390692, 2.190567 },
	{ 370, 0, "393", "Llacuna", 41.402147, 2.197608 },
	{ 371, 0, "395", "Pl. Catalunya", 41.386008, 2.170208 },
	{ 372, 0, "396", "Joan Miró", 41.389028, 2.196842 },
	{ 373, 0, "397", "Av. Del Litoral", 41.388892, 2.199339 },
	{ 374, 0, "398", "Passeig Marítim De La Barceloneta", 41.381000, 2.193536 },
	{ 375, 0, "400", "Nova Bocana", 41.370317, 2.187797 },
	{ 376, 0, "402", "Passeig De Colom/Laietana S/N", 41.380539, 2.182175 },
	{ 377, 0, "404", "Juan Gris, 28", 41.365336, 2.133181 },
	{ 378, 0, "405", "Plaça Comercial (Annexa A L'Estació 10)", 41.385658, 2.183353 },
	{ 379, 0, "406", "Terciana A Continuació De La Plaça Universitat", 41.386539, 2.164597 },
	{ 380, 0, "407", "Ramon Trias Fargas, 19", 41.388467, 2.192836 },
	{ 381, 0, "408", "Villena, 11", 41.388619, 2.192306 },
	{ 382, 0, "409", "Joan D'Austria,50", 41.392419, 2.192422 },
	{ 383, 0, "410", "Passeig De Colom, S/N", 41.376433, 2.178739 },
	{ 384, 0, "412", "Pl. Urquinaona (Illeta)", 41.389017, 2.172683 },
	{ 385, 0, "413", "Bruc, 66", 41.393514, 2.170722 },
	{ 386, 0, "414", "Casp, 67", 41.393753, 2.176458 },
	{ 387, 0, "415", "Rambla Del Raval, 13", 41.379381, 2.168928 },
	{ 388, 0, "416", "Rambla Del Raval, 20", 41.378131, 2.169653 },
	{ 389, 0, "418", "Passeig De Lluís Companys", 41.390956, 2.180233 },
	{ 390, 0, "419", "Passeig De Lluís Companys", 41.391303, 2.180819 },
	{ 391, 0, "420", "Gran Via, 361", 41.374217, 2.148086 },
	{ 392, 0, "421", "Plaça De Joan Peiró", 41.377650, 2.138578 },
	{ 393, 0, "423", "Carrer D'Hondures, 32", 41.420197, 2.189553 },
	{ 394, 0, "424", "Passeig Marítim De La Barceloneta, Devant Del 5-7", 41.379631, 2.192669 },
	{ 395, 0, "425", "Carrer De Cervelló, 5", 41.376525, 2.174906 },
	{ 396, 0, "426", "Carrer De Ribes, 59B", 41.398319, 2.183022 },
	{0, 0, NULL, NULL, 0., 0.}
};


struct StationsPluginSimplePrivateBarcelone : StationsPluginSimplePrivate {
  StationsPluginSimplePrivateBarcelone() {
    rect = QRectF(QPointF(41.187917, 1.969919), QPointF(41.587917, 2.369919));
    center = QPointF(41.387917, 2.169919);
    statusUrl = "";
    infosUrl = "http://www.bicing.cat/localizaciones/localizaciones.php";
  }

  QList < Station * > fetchAll(StationsPlugin *plugin) {
    QList < Station * > list;

    for (int i = 0; stations[i].name; ++i) {
      Station *station = new Station(plugin);

      station->setId(stations[i].number);
      station->setName(QString::fromUtf8(stations[i].name));
      station->setDescription(QString::fromUtf8(stations[i].address));
      station->setPos(QPointF(stations[i].x, stations[i].y));
      station->setRegion(QString("Barcelone %1").arg(stations[i].arrondissementNumber));
      list.append(station);
    }

    return list;
  }

  QStringList regions() {
    QStringList ret;


    return ret;
  }
};

#endif /* STATIONS_SIMPLE_PRIVATE_BARCELONE_H */

