/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STATIONS_SIMPLE_PRIVATE_PARIS_H
#define STATIONS_SIMPLE_PRIVATE_PARIS_H

#include "stationspluginsimple_p.h"


static const struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        double x;
        double y;
} stations[] = {
	{ 20020, 20, "20020 - Pyrenees Renouvier", "183 Rue Des Pyrenees -", 48.861079, 2.400362 },
	{ 20017, 20, "20017 - Rue Saint Blaise", "69 Rue Saint Blaise -", 48.856814, 2.409033 },
	{ 20016, 20, "20016 - Pyrenees Vitruve", "114 Bis Rue Des Pyrenees -", 48.856745, 2.404620 },
	{ 12027, 20, "12027 - Montgallet Charenton", "2 Rue Montgallet -", 48.842679, 2.386573 },
	{ 12026, 20, "12026 - Parc De Bercy", "61 Rue De Bercy -", 48.837603, 2.382239 },
	{ 20013, 20, "20013 - Place De La Reunion", "106 Rue Alexandre Dumas -", 48.855319, 2.399211 },
	{ 20012, 20, "20012 - Buzenval Vignoles", "90 Rue Buzenval -", 48.853934, 2.400244 },
	{ 20011, 20, "20011 - Pyrénées-Dagorno", "103 Rue Des Pyrennees -", 48.855603, 2.405109 },
	{ 20008, 20, "20008 - Maraichers", "73 Rue Des Pyrenees -", 48.853167, 2.405882 },
	{ 20007, 20, "20007 - Buzenval", "52 Rue Buzenval -", 48.851570, 2.401358 },
	{ 20005, 20, "20005 - Rue De Lagny Saint Mande", "2 Rue Reynaldo Hahn -", 48.849263, 2.412141 },
	{ 20004, 20, "20004 - Porte De Vincennes Bis", "2 Rue Du Commandant L'Herminier -", 48.847076, 2.416019 },
	{ 20002, 20, "20002 - Pixerecourt", "Face 65 Rue Pixerecourt -", 48.873654, 2.395936 },
	{ 20001, 20, "20001 - Place De La Nation", "1 Cours De Vincennes -", 48.848533, 2.399652 },
	{ 13055, 20, "13055 - Lagroua", "18 Rue Marie Andree Lagroua -", 48.828499, 2.380312 },
	{ 13054, 20, "13054 - Pau Casals", "1 Rue Pau Casals -", 48.831160, 2.377346 },
	{ 10041, 10, "10041 - Chartres (18 Arr.)", "Face 39 Boulevard De La Chapelle -", 48.884066, 2.355842 },
	{ 10039, 20, "10039 - Sambre Et Meuse", "37 Rue Sambre Et Meuse -", 48.874274, 2.374014 },
	{ 10038, 20, "10038 - Colonel Fabien", "69 Rue De La Grange Aux Belles -", 48.877565, 2.369847 },
	{ 10037, 10, "10037 - Version 2 Jaures", "Eglise Saint Joseph Artisan -", 48.881106, 2.367983 },
	{ 10035, 10, "10035 - Aubervilliers", "1 Boulevard De La Chapelle -", 48.884253, 2.364387 },
	{ 10034, 10, "10034 - Chapelle Louis Blanc", "68 Rue Louis Blanc -", 48.883849, 2.360053 },
	{ 10033, 10, "10033 - Lariboisiere", "15 Rue Saint Vincent De Paul -", 48.880840, 2.352380 },
	{ 10031, 10, "10031 - Aqueduc", "48 Rue Louis Blanc -", 48.882015, 2.363459 },
	{ 10029, 10, "10029 - Place De Roubaix", "39 Rue De Dunkerque -", 48.880741, 2.351290 },
	{ 10028, 10, "10028 - Gare Du Nord Denan", "24 Rue De Dunkerque -", 48.880471, 2.352612 },
	{ 10027, 10, "10027 - Dunkerque", "4 Rue De Dunkerque -", 48.879365, 2.358239 },
	{ 10026, 10, "10026 - Chateau Landon", "2 Rue De Chateau Landon -", 48.879104, 2.362476 },
	{ 10025, 20, "10025 - Ecluses Saint Martin", "148 Quai De Jemmapes -", 48.877350, 2.366073 },
	{ 10023, 20, "10023 - Verdun", "1 Avenue De Verdun -", 48.876057, 2.360799 },
	{ 10022, 20, "10022 - Chabrol Saint Quentin", "Face 124 Rue Du Faubourg Saint Denis -", 48.876669, 2.355894 },
	{ 10021, 20, "10021 - Marche St Quentin", "4 Rue Des Petits Hotels -", 48.877263, 2.354750 },
	{ 10020, 20, "10020 - Chabrol", "59 Rue Chabrol -", 48.877074, 2.351234 },
	{ 10019, 20, "10019 - Paradis", "23 Rue Paradis -", 48.874962, 2.352501 },
	{ 10018, 20, "10018 - Alban Satragne", "110-112 Rue Faubourg Saint Denis -", 48.875627, 2.356071 },
	{ 10017, 20, "10017 - Gare De L'Est Saint Laurent", "1 Rue De La Fidelite -", 48.874692, 2.357024 },
	{ 10016, 20, "10016 - Villemin", "29 Rue Des Recollets -", 48.875114, 2.359477 },
	{ 10015, 20, "10015 - Recollets", "46 Rue Lucie Sampaix -", 48.874107, 2.362474 },
	{ 10014, 20, "10014 - Beaurepaire", "14 Rue De Marseille -", 48.871608, 2.364108 },
	{ 10013, 20, "10013 - Saint Louis", "2 Rue Alibert -", 48.870996, 2.366137 },
	{ 10012, 20, "10012 - Vinaigriers", "58 Rue Des Vinaigriers -", 48.873298, 2.358986 },
	{ 10011, 20, "10011 - Bourse Du Travail", "3 Rue Du Chateau D'Eau -", 48.869272, 2.362158 },
	{ 10010, 20, "10010 - Jacques Bonsergent", "Face 8 Place Jacques Bonsergent -", 48.870880, 2.361205 },
	{ 10009, 20, "10009 - Hittorff", "Face 14 Rue Hittorff -", 48.872049, 2.357541 },
	{ 10007, 20, "10007 - Chateau D'Eau", "57 Rue Du Chateau D'Eau -", 48.872346, 2.355579 },
	{ 10006, 20, "10006 - Petites Ecuries", "5 Rue Des Petites Ecuries -", 48.873066, 2.353972 },
	{ 10005, 20, "10005 - Conservatoire", "59 Rue Des Petites Ecuries -", 48.873992, 2.348195 },
	{ 10004, 20, "10004 - Metz", "7 Rue De Metz -", 48.871044, 2.353385 },
	{ 10003, 20, "10003 - Hauteville", "1 Rue D'Hauteville -", 48.870496, 2.349516 },
	{ 10002, 20, "10002 - Strasbourg", "3 Bd Strasbourg -", 48.869426, 2.354161 },
	{ 10001, 20, "10001 - Johann Strauss", "Face 50 Rue Rene Boulanger -", 48.868463, 2.359965 },
	{ 13011, 20, "13011 - Compo Formio", "112 Bd De L'Hopital -", 48.835614, 2.358507 },
	{ 11102, 20, "11102 - Rue Des Boulets ( Complementaire )", "3 Rue Alexandre Dumas -", 48.852735, 2.389062 },
	{ 13006, 20, "13006 - Saint Marcel Jeanne D'Arc", "02 Rue Dumeril -", 48.837969, 2.357092 },
	{ 13005, 20, "13005 - Arago Cordeliere - Version 2", "2 Rue Des Cordelieres -", 48.835481, 2.348282 },
	{ 13004, 20, "13004 - Glaciere", "88 Boulevard Auguste Blanqui (Sur Tpc) -", 48.830691, 2.346457 },
	{ 13001, 20, "13001 - Port Royal", "51 Boulevard Port Royal -", 48.837440, 2.346145 },
	{ 20015, 20, "20015 - Bagnolet-Orteaux", "44 Bis Rue De Bagnolet -", 48.857072, 2.398396 },
	{ 20014, 20, "20014 - Alexandre Dumas", "142 Bd Charonne -", 48.856103, 2.395058 },
	{ 16026, 10, "16026 - Ranelagh", "91 Rue Du Ranelagh -", 48.855415, 2.270327 },
	{ 11045, 20, "11045 - Saint Sebastien Froissard", "12 Bd Des Filles Du Calvaire -", 48.861326, 2.367276 },
	{ 11044, 20, "11044 - Richard Lenoir Voltaire Nord", "Face 104 Boulevard Richard Lenoir -", 48.863149, 2.371663 },
	{ 11043, 20, "11043 - Cirque D Hiver", "Place Pasdeloup -", 48.862710, 2.367141 },
	{ 11042, 20, "11042 - Oberkampf", "1 Rue Du Grand Prieure -", 48.864632, 2.369417 },
	{ 11041, 20, "11041 - Saint Ambroise", "2 Rue Lacharriere -", 48.860694, 2.375666 },
	{ 11040, 20, "11040 - Temple Jean Pierre Timbaud", "18 Bd Du Temple -", 48.864480, 2.366188 },
	{ 11039, 20, "11039 - Jules Ferry Republique", "Face 121 Boulevard Richard Lenoir -", 48.865738, 2.369445 },
	{ 11038, 20, "11038 - Temple Republique", "44 Bd Du Temple -", 48.865694, 2.365154 },
	{ 11037, 20, "11037 - Faubourg Du Temple Place De La Republique", "2 Rue Du Faubourg Du Temple -", 48.867689, 2.364746 },
	{ 11036, 20, "11036 - Jules Ferry Faubourg Du Temple", "Face 28 Rue Jules Ferry -", 48.868434, 2.367743 },
	{ 11035, 20, "11035 - Goncourt", "140 Avenue Parmentier -", 48.869098, 2.371899 },
	{ 11034, 20, "11034 - Parmentier Fontaine Au Roi", "124 Avenue Parmentier -", 48.867840, 2.372906 },
	{ 11033, 20, "11033 - Breguet Sabin", "Face 23 Bd Richard Lenoir -", 48.856705, 2.370678 },
	{ 11032, 20, "11032 - Metallos", "81 Bis Rue Jp Timbaud -", 48.867919, 2.377511 },
	{ 11031, 20, "11031 - Parmentier", "1 Rue Jacquard -", 48.864425, 2.372904 },
	{ 11030, 20, "11030 - Saint Maur Oberkampf", "80 Rue Oberkampf -", 48.865044, 2.376160 },
	{ 1102, 20, "01102 - Francaise", "6 Rue Francaise -", 48.863989, 2.347621 },
	{ 11028, 20, "11028 - Bluets Republique", "Face 20 Rue Guillaume Bertrand -", 48.863901, 2.380654 },
	{ 11027, 20, "11027 - Saint Ambroise Parmentier", "17 Rue Saint Ambroise -", 48.861988, 2.377302 },
	{ 11026, 20, "11026 - Chemin Vert Saint Maur", "105 Rue Du Chemin Vert -", 48.861051, 2.381510 },
	{ 11025, 20, "11025 - Froment Breguet", "9 Rue Froment -", 48.856911, 2.372722 },
	{ 11024, 20, "11024 - Boulevard Voltaire", "82 Rue Sedaine -", 48.858734, 2.379002 },
	{ 11023, 20, "11023 - Leo Frot Roquette", "2 Rue Saint Maur -", 48.858732, 2.383701 },
	{ 11022, 20, "11022 - Leon Blum Roquette", "142 Rue De La Roquette -", 48.857834, 2.381971 },
	{ 11020, 20, "11020 - Charonne", "1 Rue De Belfort -", 48.856395, 2.382923 },
	{ 11019, 20, "11019 - Charonne Philippe Auguste", "156 Rue De Charonne -", 48.855404, 2.390563 },
	{ 11018, 20, "11018 - Saint Maur Avenue De La Republique", "87 Rue De Saint Maur -", 48.864378, 2.377944 },
	{ 11016, 20, "11016 - Philippe Auguste", "5 Rue Du Passage Philippe Auguste -", 48.851619, 2.393146 },
	{ 11012, 20, "11012 - Montreuil Voltaire", "93 Rue De Montreuil -", 48.850549, 2.393240 },
	{ 11010, 20, "11010 - St Antoine Gonnet", "1 Rue Des Boulets -", 48.849148, 2.391537 },
	{ 11009, 20, "11009 - Rue Des Boulets", "45 Rue Des Boulets -", 48.852016, 2.388829 },
	{ 11008, 20, "11008 - Faidherbe Chaligny", "223 Rue Du Faubourg Saint Antoine -", 48.850364, 2.384157 },
	{ 11007, 20, "11007 - Faidherbe Palais De La Femme", "17 Rue Jean Mace -", 48.852989, 2.383233 },
	{ 11006, 20, "11006 - Ledru Rollin-Basfroi", "169 Avenue Ledru Rollin -", 48.856280, 2.379204 },
	{ 11004, 20, "11004 - Charonne Saint Antoine", "3 Rue De Charonne -", 48.852192, 2.374271 },
	{ 11003, 20, "11003 - Roquette Dallery", "29 Rue Keller -", 48.855580, 2.375404 },
	{ 11001, 20, "11001 - Bastille Richard Lenoir", "2 Boulevard Richard Lenoir -", 48.853605, 2.369778 },
	{ 15048, 13, "15048 - Olivier De Serre", "Place Amedee Giordani -", 48.830224, 2.290983 },
	{ 15044, 13, "15044 - J Dupre", "65 Rue Dantzig -", 48.830585, 2.296347 },
	{ 15043, 13, "15043 - Brancion", "122 Rue Brancion -", 48.829050, 2.301412 },
	{ 15042, 13, "15042 - Farman", "52 Rue Henry Farman -", 48.834097, 2.271852 },
	{ 15041, 20, "15041 - Labrouste", "13 Rue Franquet -", 48.832835, 2.306855 },
	{ 15040, 20, "15040 - Monclar", "33 Bis Rue Saint Armand -", 48.833959, 2.308924 },
	{ 16027, 10, "16027 - Jasmin", "79 Av Mozart-", 48.852690, 2.268492 },
	{ 15027, 20, "15027 - Gide", "2 Rue Georges Duhamel -", 48.838598, 2.314054 },
	{ 16021, 10, "16021 - Rue Francois Ponsard", "1 Rue Francois Ponsard -", 48.858284, 2.274301 },
	{ 15020, 13, "15020 - Mairie Du 15Eme", "4 Rue Leon Seche -", 48.841739, 2.298421 },
	{ 15013, 20, "15013 - Lecourbe Volontaire", "Dev 1 Rue Des Volontaires -", 48.843467, 2.306358 },
	{ 15011, 10, "15011 - Thebaud Rue De Cambronne", "32 Rue Cambronne -", 48.845803, 2.301863 },
	{ 1025, 20, "01025 - Temple De L'Oratoire", "2 Rue De L'Oratoire -", 48.861266, 2.340020 },
	{ 1024, 20, "01024 - Louvre Coq Heron", "20 Rue Coquilliere -", 48.863738, 2.342581 },
	{ 1023, 20, "01023 - Andre Malraux Musee Du Louvre", "165 Rue Saint Honore -", 48.863513, 2.334639 },
	{ 1022, 20, "01022 - Rue De La Paix", "37 Rue Casanova -", 48.868168, 2.330443 },
	{ 1020, 20, "01020 - Rivoli Concorde", "2 Rue Cambon -", 48.866101, 2.325226 },
	{ 1019, 20, "01019 - Saint Honore Vendome", "237 Rue Saint Honore -", 48.866596, 2.328345 },
	{ 1018, 20, "01018 - Rivoli Tuilerie", "2 Rue D'Alger -", 48.864753, 2.329490 },
	{ 1017, 20, "01017 - Saint Honore", "215 Rue Saint Honore -", 48.865472, 2.330593 },
	{ 1016, 20, "01016 - Opera Pyramides", "27 Rue Therese -", 48.866362, 2.334367 },
	{ 1015, 20, "01015 - Place Andre Malraux", "2 Place Andre Malraux -", 48.863954, 2.335661 },
	{ 1014, 20, "01014 - Rivoli Musee Du Louvre", "5 Rue De L'Echelle -", 48.863702, 2.334081 },
	{ 1013, 20, "01013 - Saint Honore", "186 Rue Saint Honore -", 48.862426, 2.338222 },
	{ 1012, 20, "01012 - Bourse Du Commerce", "Face 29 Rue Jean Jacques Rousseau -", 48.862848, 2.341477 },
	{ 12040, 20, "12040 - Porte De Charenton", "Face 2 Av. De La Porte De Charenton -", 48.831475, 2.398720 },
	{ 12039, 20, "12039 - Decaen", "45 Avenue Du General Michel Bizot -", 48.834745, 2.401106 },
	{ 12038, 20, "12038 - Bel Air", "Face 12 Boulevard Picpus -", 48.839931, 2.400827 },
	{ 12036, 20, "12036 - Reuilly", "116 Rue De Reuilly -", 48.840105, 2.394727 },
	{ 12035, 20, "12035 - Madagascar", "4 Rue De Madagascar -", 48.834612, 2.397307 },
	{ 12034, 20, "12034 - Pirogues De Bercy", "20 Rue Des Pirogues De Bercy -", 48.832298, 2.386387 },
	{ 12033, 20, "12033 - Saint Emilion", "Face 28 Rue Francois Truffaut -", 48.833341, 2.385870 },
	{ 12031, 20, "12031 - Lame", "49 Rue Gabriel Lame -", 48.835184, 2.385613 },
	{ 12029, 20, "12029 - Dugommier", "Face 4 Boulevard De Reuilly -", 48.838705, 2.389933 },
	{ 12022, 20, "12022 - Bizot", "Face 29 Rue Du Sahel -", 48.840999, 2.404409 },
	{ 12021, 20, "12021 - Courteline", "1 Avenue Courteline -", 48.844473, 2.410636 },
	{ 12019, 20, "12019 - Gare De Reuilly", "58 Rue De La Gare De Reuilly -", 48.842431, 2.397317 },
	{ 12018, 20, "12018 - Saint Mande - Favre", "5 Avenue Saint Mande -", 48.845569, 2.396108 },
	{ 12017, 20, "12017 - St Mande Netter", "82 Avenue Saint Mande -", 48.844728, 2.405367 },
	{ 12016, 20, "12016 - Picpus", "43 Avenue De Saint Mande -", 48.845126, 2.401350 },
	{ 12015, 20, "12015 - Nation Picpus", "Face 67 Boulevard De Picpus -", 48.846690, 2.400317 },
	{ 12014, 20, "12014 - Nation", "16 Place De La Nation Sur Tpc -", 48.847313, 2.395252 },
	{ 12013, 20, "12013 - Rue Montgallet", "Face 39 Rue Montgallet -", 48.844197, 2.389680 },
	{ 12012, 20, "12012 - Reuilly Diderot", "71 Boulevard Diderot -", 48.847434, 2.385992 },
	{ 12011, 20, "12011 - Charenton", "160 Rue Charenton -", 48.844757, 2.382449 },
	{ 12010, 20, "12010 - Michel Bizot", "251 Avenue Daumesnil -", 48.837540, 2.401858 },
	{ 12009, 20, "12009 - Diderot", "Face 124 Rue De Charenton -", 48.846223, 2.379060 },
	{ 12008, 20, "12008 - Hector Malot", "15 Bis Rue Hector Malot -", 48.846413, 2.376718 },
	{ 12007, 20, "12007 - Gare De Lyon Chalon", "Face 54 Rue De Chalon -", 48.845173, 2.374130 },
	{ 12006, 20, "12006 - Gare De Lyon Van Gogh", "15 Rue Van Gogh -", 48.844032, 2.372400 },
	{ 12005, 20, "12005 - Crozatier", "74 Rue Crozatier -", 48.850348, 2.378682 },
	{ 12004, 20, "12004 - Traversiere", "76 Rue Traversiere -", 48.850538, 2.375999 },
	{ 12003, 20, "12003 - Quai De La Rapee", "Face 98 Quai De La Rapee -", 48.845840, 2.367349 },
	{ 12002, 20, "12002 - Lacuee", "17 Rue Lacuee -", 48.849192, 2.370551 },
	{ 12001, 20, "12001 - Bastille", "48 Boulevard De La Bastille -", 48.851699, 2.369518 },
	{ 16011, 10, "16011 - Victor Hugo Rue De La Pompe", "118 Avenue Victor Hugo -", 48.867985, 2.281237 },
	{ 2102, 20, "02102 - Saint Marc", "8 Rue Saint Marc -", 48.870299, 2.341832 },
	{ 16004, 10, "16004 - Boulevard Lannes", "Face 2 Boulevard Lannes -", 48.870777, 2.274749 },
	{ 16003, 10, "16003 - Andre Maurois", "2 Bis Boulevard Andre Maurois -", 48.877825, 2.279400 },
	{ 16002, 10, "16002 - Pergolese", "Face 25 Rue Pergolese -", 48.875086, 2.284294 },
	{ 1026, 20, "01026 - Colonel Driant", "Place Du Lieutenant Henri Karcher -", 48.863342, 2.339979 },
	{ 1011, 20, "01011 - Rivoli Mairie Du 1Er", "36 Rue De L'Arbre Sec -", 48.860143, 2.342294 },
	{ 1010, 20, "01010 - Pont Neuf", "10 Rue Boucher -", 48.859271, 2.344160 },
	{ 1007, 20, "01007 - Etienne Marcel", "2 Rue De Turbigo -", 48.863441, 2.347621 },
	{ 1006, 20, "01006 - Les Halles - Pierre Lescot", "91 Rue Rambuteau -", 48.862111, 2.348084 },
	{ 1005, 20, "01005 - Les Halles - Sebastopol", "3 Rue De La Cossonnerie -", 48.861239, 2.349636 },
	{ 1004, 20, "01004 - Marguerite De Navarre", "1 Place Marguerite De Navarre -", 48.860277, 2.346381 },
	{ 1003, 20, "01003 - Rivoli Saint Denis", "7 Rue Saint Denis -", 48.858965, 2.347102 },
	{ 1002, 20, "01002 - Place Du Chatelet", "14 Avenue Victoria -", 48.857941, 2.346952 },
	{ 17043, 10, "17043 - Place General Koenig", "10 Rue Belidor -", 48.880272, 2.285407 },
	{ 13053, 20, "13053 - Chevaleret Tolbiac", "56 Rue Chevaleret -", 48.830307, 2.374718 },
	{ 13052, 20, "13052 - Tolbiac Lerrede", "2 Rue Leredde -", 48.829031, 2.374459 },
	{ 13051, 20, "13051 - Quai Francois Mauriac Tolbiac", "9 Quai Francois Mauriac -", 48.832760, 2.378872 },
	{ 13050, 20, "13050 - Quai Panhard Et Levassor", "23 Quai Panhard Et Levassor -", 48.828264, 2.384341 },
	{ 17036, 10, "17036 - Avenue De Ternes", "2-4 Place Tristan Bernard -", 48.879385, 2.291635 },
	{ 13047, 20, "13047 - Boutroux Vitry", "1 Avenue Boutroux -", 48.822739, 2.377680 },
	{ 13046, 20, "13046 - Oudine Patay", "10 Rue Eugene Dudine -", 48.825706, 2.374974 },
	{ 13045, 20, "13045 - Tolbiac Albert", "Face 1 Rue Jean Colly -", 48.827774, 2.370891 },
	{ 13043, 20, "13043 - Dunois Clisson", "55 Rue Dunois -", 48.832224, 2.367436 },
	{ 13042, 20, "13042 - Nationale Bach", "150 Rue Nationale -", 48.831128, 2.364236 },
	{ 2011, 20, "02011 - Bibliotheque Nationale", "71 Rue De Richelieu -", 48.868115, 2.338086 },
	{ 13040, 20, "13040 - Porte De Choisy", "111 Boulevard Massena -", 48.820019, 2.364925 },
	{ 13039, 20, "13039 - Ivry Pointe D'Ivry", "2 Rue De La Pointe D'Ivry -", 48.823219, 2.365444 },
	{ 2008, 20, "02008 - Mairie Du 2Eme", "11 Rue De La Banque -", 48.867009, 2.340415 },
	{ 2007, 20, "02007 - Chabanais", "1 Rue Chabanais -", 48.866866, 2.336560 },
	{ 2006, 20, "02006 - Place Des Victoires", "2 Rue D'Aboukir -", 48.865787, 2.341736 },
	{ 2005, 20, "02005 - Montorgueil Rue Montmartre Version 2", "46 Rue De Montmartre -", 48.864807, 2.345196 },
	{ 2004, 20, "02004 - Reaumur Montorgueil", "83 Allee Pierre Lazaref -", 48.867027, 2.347867 },
	{ 13033, 20, "13033 - Porte D'Italie", "15 Avenue De La Porte D'Italie -", 48.816407, 2.360595 },
	{ 13032, 20, "13032 - Massena", "163 Avenue D'Italie -", 48.819203, 2.359562 },
	{ 2001, 20, "02001 - Sebastopol-Grenata", "12 Rue Greneta -", 48.865202, 2.351654 },
	{ 13030, 20, "13030 - Italie Tolbiac", "88 Avenue D'Italie -", 48.825782, 2.357319 },
	{ 13029, 20, "13029 - Italie", "30 Avenue D'Italie -", 48.829872, 2.356027 },
	{ 3101, 20, "03101 - Porte Saint Martin", "62 Rue Meslay -", 48.868644, 2.355251 },
	{ 13026, 20, "13026 - Place Henocque Version 2", "21 Rue Du Dr Leray Et Landouzy -", 48.823464, 2.353724 },
	{ 13025, 20, "13025 - Place De Rungis", "Face 35 Rue De La Fontaine A Mulard -", 48.822440, 2.347177 },
	{ 13024, 20, "13024 - Bobillot Tolbiac", "81 Rue Bobillot -", 48.825693, 2.350349 },
	{ 13022, 20, "13022 - Butte Aux Cailles", "27 Et 36 Rue De La Butte Aux Cailles -", 48.827572, 2.349138 },
	{ 13021, 20, "13021 - Boussingault - Tolbiac", "55 Rue Boussingault -", 48.826278, 2.341815 },
	{ 13020, 20, "13020 - Mendes France", "Face 15 Rue Paul Klee -", 48.838919, 2.370749 },
	{ 13019, 20, "13019 - Auriol Quai De La Gare", "20 Rue Fernand Braudel -", 48.836429, 2.372503 },
	{ 13017, 20, "13017 - Nationale", "167 Rue Nationale -", 48.832594, 2.362168 },
	{ 13016, 20, "13016 - Primo Levi", "9 Rue Primo Levi -", 48.830800, 2.379538 },
	{ 13015, 20, "13015 - Weiss", "2 Rue Louis Weiss -", 48.832663, 2.371316 },
	{ 14117, 20, "14117 - Mouchotte", "5 Rue Du Commandant Rene Mouchotte -", 48.839363, 2.320630 },
	{ 13013, 20, "13013 - Saint Marcel", "3 Bd Saint Marcel -", 48.839685, 2.361300 },
	{ 14114, 20, "14114 - Place De Catalogne", "4 Rue Alain -", 48.837304, 2.317595 },
	{ 13010, 20, "13010 - Place D Italie Auriol", "Face 11 Place D'Italie -", 48.831489, 2.356205 },
	{ 13009, 20, "13009 - Blanqui Corvisart", "46 Boulevard Auguste Blanqui -", 48.829854, 2.349915 },
	{ 13008, 20, "13008 - Italie Rosalie", "Face 2 Place D'Italie -", 48.831813, 2.355075 },
	{ 13007, 20, "13007 - Le Brun Gobelins", "42 Rue Le Brun -", 48.835067, 2.353374 },
	{ 2022, 20, "02022 - Bonne Nouvelle Saint Fiacre", "20 Rue Saint Fiacre -", 48.870856, 2.345865 },
	{ 2021, 20, "02021 - Clery", "4 Rue De Clery -", 48.867297, 2.344216 },
	{ 2020, 20, "02020 - Opera Casanova", "02 Rue Daniel Casanova -", 48.867620, 2.333304 },
	{ 13002, 20, "13002 - Arago", "55 Bd Arago -", 48.834852, 2.344647 },
	{ 2017, 20, "02017 - Bourse Reaumur", "1 Rue Leon Cladel -", 48.868438, 2.343235 },
	{ 2016, 20, "02016 - Aboukir", "108 Rue D'Aboukir -", 48.868510, 2.349924 },
	{ 2015, 20, "02015 - Opera - Capucines", "25 Rue Louis Le Grand -", 48.870451, 2.333985 },
	{ 2013, 20, "02013 - Richelieu Drouot", "20 Rue Favart -", 48.871611, 2.338399 },
	{ 2012, 20, "02012 - Quatre Septembre", "10 Rue De Choiseul -", 48.869723, 2.336083 },
	{ 2010, 20, "02010 - Boulevard Montmartre", "21 Rue D'Uzes -", 48.870757, 2.343031 },
	{ 2009, 20, "02009 - Bourse", "1 Rue Des Filles Saint Thomas -", 48.868726, 2.339789 },
	{ 18047, 10, "18047 - St Ouen Lamarck", "53 Avenue De Saint Ouen -", 48.891122, 2.326747 },
	{ 2003, 20, "02003 - Allee Pierre Lazaeff", "189 Rue Saint Denis -", 48.866325, 2.350877 },
	{ 2002, 20, "02002 - Montorgueil Etienne Marcel", "32 Rue Etienne Marcel -", 48.864555, 2.346095 },
	{ 18041, 10, "18041 - Martyrs 2", "Face 112 Boulevard De Rochechouart -", 48.882153, 2.340593 },
	{ 19109, 10, "19109 - Place Du Maroc", "27 Rue De Tanger -", 48.886193, 2.368817 },
	{ 18038, 10, "18038 - Rond Point De La Chapelle", "70 Rue De La Chapelle -", 48.895308, 2.359649 },
	{ 18037, 10, "18037 - Amiraux", "48 Rue Boinod -", 48.894491, 2.352248 },
	{ 18036, 10, "18036 - Francis De Croisset", "7 Rue Francis De Croisset -", 48.899435, 2.345870 },
	{ 18034, 10, "18034 - Leibnitz", "50 Rue Leibnitz -", 48.896218, 2.333356 },
	{ 18032, 10, "18032 - Porte De Clignancourt", "Face 59 Rue Belliard -", 48.897512, 2.344261 },
	{ 18031, 10, "18031 - Albert Kahn", "67 Rue Championnet -", 48.895741, 2.345528 },
	{ 5004, 20, "05004 - Saint Jacques Val De Grace", "272 Rue Saint Jacques -", 48.841862, 2.341217 },
	{ 4104, 20, "04104 - Sebastopol Rambuteau", "Face 40 Boulevard Sebastopol -", 48.861859, 2.350045 },
	{ 4103, 20, "04103 - Hotel De Ville", "1 Rue Des Archives -", 48.856978, 2.353844 },
	{ 3014, 20, "03014 - Grenier Saint Lazare", "Face 34 Rue Grenier Saint Lazare -", 48.863036, 2.352756 },
	{ 3013, 20, "03013 - Rue De Sevigne", "36 Rue De Sevigne -", 48.856707, 2.362575 },
	{ 3012, 20, "03012 - Gaite Lyrique", "Face 8 Rue Salomon De Caus -", 48.867458, 2.353357 },
	{ 3011, 20, "03011 - Turbigo", "55 Rue Turbigo -", 48.865588, 2.356095 },
	{ 3010, 20, "03010 - Beaubourg", "46 Rue Beaubourg -", 48.862371, 2.354336 },
	{ 14037, 20, "14037 - Jean Moulin", "56 Avenue Jean Moulin -", 48.825693, 2.321642 },
	{ 14036, 20, "14036 - Boulard Daguerre", "14 Rue Boulard -", 48.834187, 2.329168 },
	{ 14035, 20, "14035 - Maine Gaite", "90 Avenue Du Maine -", 48.837691, 2.322496 },
	{ 14034, 20, "14034 - Rue De L Ouest Chateau", "48 Rue De L'Ouest -", 48.836109, 2.319161 },
	{ 14033, 20, "14033 - Daguerre Gassendi", "31 Rue Frodevaux -", 48.835715, 2.328119 },
	{ 14032, 20, "14032 - Mouton Duvernet - Mairie Du 14Eme", "26 Rue Mouton Duvernet -", 48.832443, 2.325288 },
	{ 14031, 20, "14031 - Didot Chateau", "11 Rue Didot -", 48.833845, 2.321748 },
	{ 14030, 20, "14030 - Losserand - Pernety", "61 Rue Pernety -", 48.834230, 2.317569 },
	{ 14029, 20, "14029 - Gergovie Vercingetorix", "112 Rue Vercingetorix -", 48.834230, 2.313198 },
	{ 14028, 20, "14028 - Plaisance Alesia", "164 Rue Alesia -", 48.831641, 2.315065 },
	{ 14027, 20, "14027 - Alesia Gergovie", "Face 83 Rue De Gergovie -", 48.830788, 2.318863 },
	{ 14026, 20, "14026 - Plantes Moulin Vert", "23 Rue Des Plantes -", 48.829926, 2.323097 },
	{ 14024, 20, "14024 - Raymond Lausserand", "Rue Vercingetorix -", 48.828026, 2.305673 },
	{ 14022, 20, "14022 - Brune Didot", "108 Rue Didot -", 48.826464, 2.313107 },
	{ 3007, 20, "03007 - Archives Pastourelle", "67 Rue Des Archives -", 48.862271, 2.359758 },
	{ 3006, 20, "03006 - Mairie Du 3Eme", "10 Rue Perree -", 48.864481, 2.361625 },
	{ 15122, 13, "15122 - Place Charles Vallin", "Place Charles Vallin -", 48.835494, 2.302538 },
	{ 3004, 20, "03004 - Republique 23", "19 Place De La Republique -", 48.867690, 2.362444 },
	{ 3003, 20, "03003 - Turenne Bretagne", "4 Rue Des Filles Du Calvaire -", 48.861910, 2.365152 },
	{ 3002, 20, "03002 - Saint Gilles", "26 Rue Saint Gilles -", 48.858189, 2.364795 },
	{ 3001, 20, "03001 - Chemin Vert Beaumarchais", "69 Boulevard Beaumarchais -", 48.858090, 2.367710 },
	{ 13044, 20, "13044 - Place Jeanne D'Arc", "20 Place Jeanne D'Arc -", 48.829473, 2.368987 },
	{ 19041, 20, "19041 - Pyrénées Version 2", "101 Rue De Belleville -", 48.874441, 2.385882 },
	{ 19040, 20, "19040 - Telegraphe", "265 Rue De Belleville -", 48.875648, 2.399494 },
	{ 14011, 20, "14011 - Alesia Sarrette", "6 Rue Sarrette -", 48.827590, 2.332000 },
	{ 19039, 10, "19039 - Pailleron", "6 Rue Edouard Pailleron -", 48.879595, 2.374645 },
	{ 19038, 20, "19038 - Jourdain", "9 Rue Lassus -", 48.875527, 2.388975 },
	{ 3008, 20, "03008 - Perle", "22 Rue De La Perle -", 48.859844, 2.361200 },
	{ 14007, 20, "14007 - Saint Jacques Ferrus", "1 Rue Ferrus -", 48.831338, 2.341080 },
	{ 19035, 10, "19035 - Porte Chaumont", "Rue Sigmund Freud / Porte Chaumont -", 48.885921, 2.397885 },
	{ 14005, 20, "14005 - Denfert Rochereau", "2 Avenue Rene Coty -", 48.833297, 2.332640 },
	{ 19033, 10, "19033 - Cambrai", "30 Rue De Cambrai -", 48.895778, 2.381458 },
	{ 3005, 20, "03005 - Turbigo Sainte Elisabeth", "7 Rue Sainte Elisabeth -", 48.865884, 2.359296 },
	{ 19031, 10, "19031 - Manin Crimee Version 2", "8 Rue Manin -", 48.882898, 2.385999 },
	{ 4005, 20, "04005 - Sully Morland", "2 Quai Des Celestins -", 48.851261, 2.362545 },
	{ 4001, 20, "04001 - Notre Dame", "10 Rue D'Arcole -", 48.853546, 2.349063 },
	{ 6103, 20, "06103 - Mezieres Rennes", "16 Rue De Mezieres -", 48.850319, 2.330364 },
	{ 4007, 20, "04007 - Bourdon", "Boulevard Bourbon -", 48.852670, 2.368483 },
	{ 4006, 20, "04006 - Bassin De L'Arsenal", "Face 1 Boulevard Bourbon -", 48.847647, 2.365947 },
	{ 4021, 20, "04021 - Beaubourg Rambuteau", "49 Rue Rambuteau -", 48.861346, 2.352211 },
	{ 4003, 20, "04003 - Pont Saint Louis", "1 Quai Aux Fleurs -", 48.852790, 2.351854 },
	{ 4002, 20, "04002 - Marche Aux Fleurs", "Place Louis Lepine -", 48.855146, 2.347279 },
	{ 5104, 20, "05104 - Buffon", "47 Rue Buffon -", 48.841843, 2.358755 },
	{ 4017, 20, "04017 - Place De L'Hotel De Ville", "7 Place De L'Hotel De Ville -", 48.856880, 2.351079 },
	{ 4016, 20, "04016 - Lobau", "3 Rue Lobau -", 48.855711, 2.353040 },
	{ 4015, 20, "04015 - Mairie Du 4 Eme", "25 Rue Du Pont Louis Philippe -", 48.855845, 2.356350 },
	{ 4014, 20, "04014 - Archives Blancs Manteaux", "29 Rue Des Blancs Manteaux -", 48.859306, 2.355752 },
	{ 4013, 20, "04013 - Francs Bourgeois", "50 Rue Vieille Du Temple -", 48.858532, 2.358462 },
	{ 4012, 20, "04012 - Ecouffes Rivoli", "2 Rue Tiron -", 48.855962, 2.358202 },
	{ 4011, 20, "04011 - Place Du Bataillon Francais De L'Onu", "Face 18 Rue De L'Hotel De Ville -", 48.853841, 2.357221 },
	{ 4009, 20, "04009 - Village Saint Paul", "6 Rue Saint Paul -", 48.852708, 2.361074 },
	{ 5001, 20, "05001 - Saint Germain Harpe", "32 Rue De La Harpe -", 48.851434, 2.343615 },
	{ 15070, 13, "15070 - Blanc", "88 Rue Balard -", 48.838621, 2.278191 },
	{ 15069, 13, "15069 - Boucicaut Faure", "41 Avenue Felix Faure -", 48.841160, 2.288182 },
	{ 15068, 13, "15068 - Boulevard Victor", "Face 5 Boulevard Martial Valin -", 48.838258, 2.270267 },
	{ 15067, 10, "15067 - Desaix", "23 Rue Desaix -", 48.852819, 2.292720 },
	{ 4019, 20, "04019 - Beaubourg Saint Merry", "4 Rue Du Cloitre Saint Merri -", 48.858857, 2.351829 },
	{ 15065, 10, "15065 - Humbert", "23 Rue Emile Zola -", 48.846423, 2.280225 },
	{ 15064, 10, "15064 - Javel", "Dev 5 Avenue Emile Zola -", 48.846342, 2.278577 },
	{ 15063, 13, "15063 - Saint Charles - Convention", "59 Rue De La Convention -", 48.843270, 2.283142 },
	{ 15062, 13, "15062 - Boucicaut", "87 Rue De La Convention -", 48.842067, 2.285731 },
	{ 15061, 13, "15061 - Desnouettes", "12 Square Desnouettes -", 48.834715, 2.284268 },
	{ 15060, 10, "15060 - Mondrian", "9 Place De La Montagne Du Goulet -", 48.844193, 2.277082 },
	{ 15059, 13, "15059 - Citroen", "Rue Balard -", 48.840967, 2.277957 },
	{ 15058, 13, "15058 - Georges Pompidou", "4 Place Du Moulin De Javel -", 48.840029, 2.271559 },
	{ 4010, 20, "04010 - Saint Paul Pavée", "105-109 Terre Plein Saint Paul -", 48.855161, 2.361484 },
	{ 15056, 13, "15056 - Balard", "13 Place Balard -", 48.836536, 2.278479 },
	{ 15055, 13, "15055 - Vasco De Gama", "44 Rue Vasco De Gama -", 48.836692, 2.283871 },
	{ 15054, 13, "15054 - Chandon", "293 Rue Lecourbe -", 48.837924, 2.287328 },
	{ 15053, 13, "15053 - Lecourbe", "250 Rue Lecourbe -", 48.839175, 2.291575 },
	{ 15051, 13, "15051 - Rollet", "1 Place Henri Rollet -", 48.835833, 2.293116 },
	{ 4020, 20, "04020 - Beaubourg Place Michelet", "Face 27 Rue Quincampoix -", 48.859954, 2.350276 },
	{ 15049, 13, "15049 - Porte De Versailles", "2 Avenue Ernest Renan -", 48.832217, 2.287415 },
	{ 13048, 20, "13048 - Tolbiac Wurtz", "20 Rue Wurtz -", 48.826359, 2.343952 },
	{ 15047, 13, "15047 - Dantzig", "Face Au 37 Rue Morillons -", 48.832609, 2.301559 },
	{ 15046, 13, "15046 - Georges Brassens", "42 Rue Des Morillons -", 48.832304, 2.302485 },
	{ 15045, 13, "15045 - Plaine", "Avenue De La Porte De La Plaine -", 48.827941, 2.292401 },
	{ 20041, 20, "20041 - Belleville", "116 Bd De Belleville -", 48.871154, 2.378099 },
	{ 20040, 20, "20040 - Parc De Belleville", "57 & 36 Rue Julien Lacroix -", 48.870271, 2.384120 },
	{ 20039, 20, "20039 - Couronnes", "44 Boulevard De Belleville -", 48.868942, 2.381326 },
	{ 20038, 20, "20038 - Leon Frapie", "6 Rue Leon Frapie -", 48.873359, 2.410296 },
	{ 20037, 20, "20037 - Saint Fargeau", "177 Avenue Gambetta -", 48.871269, 2.403726 },
	{ 15039, 13, "15039 - Charles Vallin", "133 Rue De L'Abbe Groult -", 48.835782, 2.302156 },
	{ 15038, 13, "15038 - Place Adolphe Cherioux", "18 Place Adolphe Cherioux -", 48.839358, 2.300806 },
	{ 15037, 13, "15037 - Groult", "202 Rue Lecourbe -", 48.840399, 2.295386 },
	{ 15036, 13, "15036 - Lambert", "102 Rue De La Croix Nivert -", 48.843041, 2.295125 },
	{ 13035, 20, "13035 - Ivry Tolbiac", "116 Avenue De Choisy -", 48.825970, 2.360232 },
	{ 15034, 10, "15034 - Commerce", "2 Rue Lakanal -", 48.844371, 2.293858 },
	{ 15033, 10, "15033 - Violet", "5 Place Violet -", 48.844828, 2.290507 },
	{ 15032, 13, "15032 - Lourmel", "112 Ave Felix Faure -", 48.838650, 2.281908 },
	{ 15031, 10, "15031 - Theatre", "60 Rue Du Theatre -", 48.848252, 2.289851 },
	{ 15030, 10, "15030 - Linois", "66 Rue Emeriau -", 48.848043, 2.284458 },
	{ 15029, 10, "15029 - Emeriau", "27 Rue Emeriau -", 48.850534, 2.287343 },
	{ 13028, 20, "13028 - Gouthiere", "12 Rue Gouthiere -", 48.820786, 2.351070 },
	{ 13027, 20, "13027 - Mazagrand Coubertin", "Avenue De La Porte De Gentilly -", 48.816256, 2.344100 },
	{ 15025, 10, "15025 - Amette", "26 Rue Dupleix -", 48.851301, 2.296821 },
	{ 15024, 10, "15024 - Laos", "88 Avenue De Suffren -", 48.850746, 2.301057 },
	{ 15021, 10, "15021 - Croix Nivert", "Dev 2 Rue Joseph Louville -", 48.844948, 2.297547 },
	{ 13023, 20, "13023 - Bobillot Verlaine", "30 Rue Bobillot -", 48.828560, 2.353005 },
	{ 15019, 20, "15019 - Vaugirard Cambronne", "3 Rue Paul Barruel -", 48.840195, 2.304400 },
	{ 15018, 20, "15018 - Alleray", "85 Rue Dutot -", 48.836700, 2.307057 },
	{ 15017, 20, "15017 - Procession", "7 Place Falguiere -", 48.836314, 2.310284 },
	{ 15016, 20, "15016 - Dutot", "59 Rue Dutot -", 48.838255, 2.308445 },
	{ 17050, 10, "17050 - Batignolles", "1 Rue Des Batignolles -", 48.883024, 2.323927 },
	{ 15012, 13, "15012 - Mademoiselle", "76 Rue Cambronne -", 48.842954, 2.302533 },
	{ 13014, 20, "13014 - Gare D'Austerlitz", "5 Bis Boulevard De L'Hopital -", 48.842345, 2.363344 },
	{ 15010, 10, "15010 - Cambronne", "Face 3 Bd Garibaldi -", 48.847627, 2.302693 },
	{ 15009, 20, "15009 - Suffren", "140 Avenue De Suffren -", 48.847152, 2.307105 },
	{ 15008, 20, "15008 - Sevres Lecourbe", "Face 4 Boulevard Pasteur -", 48.844798, 2.311001 },
	{ 15005, 20, "15005 - Place Trefouel", "Face 24 Boulevard Pasteur -", 48.842651, 2.312677 },
	{ 15004, 20, "15004 - Vaugirard Pasteur", "Dev 71 Boulevard De Vaugirard -", 48.840521, 2.315292 },
	{ 14015, 20, "14015 - Cite Universitaire", "Face 15 Boulevard Jourdan -", 48.820445, 2.338548 },
	{ 15001, 20, "15001 - Arrivee", "8 Rue De L'Arrivee -", 48.843866, 2.322780 },
	{ 14013, 20, "14013 - Liart Amiral Mouchez", "1 Rue Liard -", 48.821182, 2.342427 },
	{ 18046, 10, "18046 - Fourche", "12 Rue Etienne Jogelle -", 48.887985, 2.325998 },
	{ 18045, 10, "18045 - Ganneron", "2 Rue Pierre Ginier -", 48.886556, 2.326284 },
	{ 14010, 20, "14010 - Jean Moulin Alesia", "12 Avenue Jean Moulin -", 48.827437, 2.325670 },
	{ 14009, 20, "14009 - Coty Tombe D'Issoire", "49 Rue De La Tombe D'Issoire -", 48.830556, 2.333783 },
	{ 14008, 20, "14008 - Mouton Duvernet", "5 Rue Mouton Duvernet -", 48.831392, 2.329549 },
	{ 16024, 10, "16024 - Kennedy Ranelagh", "4 Rue Ranelagh Devant Rer -", 48.852832, 2.280531 },
	{ 14006, 20, "14006 - Saint Jacques Tombe Issoire", "46 Boulevard Saint Jacques -", 48.833261, 2.336724 },
	{ 14004, 20, "14004 - Port Royal Cochin", "111 Bd Port Royal -", 48.838115, 2.341816 },
	{ 14003, 20, "14003 - Raspail Schoelcher", "2 Rue Victor Schoelcher -", 48.836910, 2.331319 },
	{ 14002, 20, "14002 - Raspail Quinet", "Face 4 Bd Edgar Quinet -", 48.839265, 2.330079 },
	{ 5013, 20, "05013 - Ulm Erasme", "13 Rue Erasme -", 48.842419, 2.344539 },
	{ 5012, 20, "05012 - Ulm - Lhomond", "20 Rue De L'Estrapade -", 48.845080, 2.345520 },
	{ 5010, 20, "05010 - Saint Michel Henri Barbusse", "1 Rue Henri Barbusse -", 48.843624, 2.339379 },
	{ 5009, 20, "05009 - Square Viviani", "6 Rue Du Fouarre -", 48.851551, 2.347414 },
	{ 5008, 20, "05008 - St Germain-Dante", "9 Rue De Dante -", 48.850733, 2.346120 },
	{ 5006, 20, "05006 - Saint Jacques Soufflot", "174 Rue Saint Jacques -", 48.846491, 2.343151 },
	{ 5005, 20, "05005 - Saint Jacques Gay Lussac", "27 Rue Gay Lussac -", 48.844613, 2.342007 },
	{ 15002, 20, "15002 - Bourdelle", "26 Avenue Du Maine -", 48.843093, 2.320534 },
	{ 5003, 20, "05003 - Gay Lussac Le Goff", "9 Rue Le Goff -", 48.845961, 2.341340 },
	{ 5002, 20, "05002 - Saint Jacques", "20 Rue Sommerard -", 48.850221, 2.345072 },
	{ 17016, 10, "17016 - Brochant", "3 Rue Brochant -", 48.888038, 2.316976 },
	{ 20036, 20, "20036 - Menilmontant - Pelleport", "164 Rue De Menilmontant -", 48.870417, 2.399079 },
	{ 20035, 20, "20035 - Pyrenees", "262 Rue Des Pyrenees -", 48.869359, 2.395154 },
	{ 20032, 20, "20032 - Amandiers", "55 Rue Des Cendriers -", 48.865902, 2.389048 },
	{ 5035, 20, "05035 - Buffon Austerlitz", "1 Rue Buffon -", 48.843199, 2.363834 },
	{ 5034, 20, "05034 - Censier", "21 Rue Censier -", 48.840540, 2.353784 },
	{ 5033, 20, "05033 - Saint Severin", "42 Rue Saint Severin -", 48.852692, 2.344078 },
	{ 5032, 20, "05032 - Pantheon Carmes", "2 Rue Valette -", 48.846778, 2.346447 },
	{ 5031, 20, "05031 - Lacepede", "2 Rue Lacepede -", 48.843605, 2.354739 },
	{ 5030, 20, "05030 - Sorbonne", "5 Rue De La Sorbonne -", 48.849690, 2.343723 },
	{ 5029, 20, "05029 - Port Royal", "Face 41 Avenue Georges Bernanos -", 48.839948, 2.337296 },
	{ 5028, 20, "05028 - Censier Buffon", "6 Rue Censier -", 48.840998, 2.355310 },
	{ 5027, 20, "05027 - Gobelins", "22 Avenue Des Gobelins -", 48.836999, 2.351618 },
	{ 5026, 20, "05026 - Mouffetard Saint Medard", "3 Rue Pascal -", 48.838923, 2.350012 },
	{ 5023, 20, "05023 - Place Jussieu", "13 Rue Jussieu -", 48.845429, 2.355883 },
	{ 5022, 20, "05022 - Cardinal Lemoine", "40 Rue Bou Langers -", 48.846256, 2.352234 },
	{ 5021, 20, "05021 - Jussieu", "41 Rue Jussieu -", 48.847236, 2.353242 },
	{ 5020, 20, "05020 - Pont De Sully Rive Gauche", "03 Rue Des Fosses Saint Bernard -", 48.849195, 2.356293 },
	{ 5019, 20, "05019 - Poissy", "8-10 Rue De Poissy -", 48.849303, 2.352888 },
	{ 5018, 20, "05018 - Mutualite", "20 Rue Monge -", 48.848207, 2.350246 },
	{ 5017, 20, "05017 - Descartes", "17 Rue Descartes -", 48.846302, 2.349170 },
	{ 5016, 20, "05016 - Contrescarpe-Thouin", "1 Rue Thouin -", 48.844989, 2.349782 },
	{ 5015, 20, "05015 - Mouffetard Epee De Bois", "12 Rue De L'Epee De Bois -", 48.841287, 2.350326 },
	{ 16044, 13, "16044 - Stade Francais", "24 Avenue De La Porte De Saint Cloud -", 48.838669, 2.252376 },
	{ 16043, 10, "16043 - Place De Passy", "2 Place De Passy -", 48.857755, 2.277475 },
	{ 16042, 13, "16042 - Porte De Saint Cloud", "120 Boulevard Murat -", 48.837297, 2.257961 },
	{ 16040, 13, "16040 - Exelmans", "73 Bis Boulevard Exelmans -", 48.843006, 2.259858 },
	{ 16039, 13, "16039 - Versailles Exelmans", "27 Boulevard Exelmans -", 48.840654, 2.264478 },
	{ 16038, 10, "16038 - Rue Molitor", "Rue Molitor -", 48.844951, 2.266078 },
	{ 5007, 20, "05007 - Ecoles Carmes", "39 Rue Des Ecoles -", 48.848782, 2.347264 },
	{ 16036, 10, "16036 - Porte Molitor", "Place De La Porte Molitor -", 48.844963, 2.257064 },
	{ 16035, 10, "16035 - Hyppodrome D Auteuil", "Allee Des Fortifications -", 48.848613, 2.257889 },
	{ 16034, 10, "16034 - Porte D'Auteuil", "76 Rue D'Auteuil -", 48.847931, 2.260600 },
	{ 16033, 10, "16033 - Michel Ange Auteuil", "85 Rue Jean De La Fontaine -", 48.848321, 2.265121 },
	{ 16032, 10, "16032 - Eglise D Auteuil", "Place De L'Eglise D'Auteuil -", 48.847424, 2.268839 },
	{ 16031, 10, "16031 - Boulainvilliers", "51 Rue Des Vignes -", 48.856352, 2.274793 },
	{ 16030, 10, "16030 - Mirabeau", "4 Place De Barcelone -", 48.847723, 2.273360 },
	{ 16029, 10, "16029 - Maison De Radio France", "1 Rue Gros -", 48.851294, 2.277972 },
	{ 13038, 20, "13038 - Choisy Point D'Ivry", "28 Avenue De Choisy -", 48.821898, 2.363333 },
	{ 13037, 20, "13037 - Ivry Baudicourt", "76 Avenue D'Ivry -", 48.824621, 2.363199 },
	{ 13036, 20, "13036 - Tolbiac Nationale", "86 Rue Tolbiac -", 48.827173, 2.366453 },
	{ 16025, 10, "16025 - Fontaine Raynouard", "4 Rue Jean De La Fontaine -", 48.852658, 2.275615 },
	{ 13034, 20, "13034 - Edison", "54 Avenue Edison -", 48.829152, 2.360723 },
	{ 16023, 10, "16023 - Rue De Passy", "1 Rue De Passy -", 48.858388, 2.284216 },
	{ 16022, 10, "16022 - Rue Jean Bologne", "16 Rue Jean Bologne -", 48.857604, 2.279913 },
	{ 13031, 20, "13031 - Italie Maison Blanche", "121 Avenue D'Italie -", 48.821980, 2.358678 },
	{ 16020, 10, "16020 - Porte De Passy", "1 Place De La Porte De Passy -", 48.857254, 2.264427 },
	{ 16019, 10, "16019 - Henri Martin", "Face 98 Av. Henri Martin -", 48.863017, 2.268792 },
	{ 16018, 10, "16018 - Flandrin", "2 Boulevard Flandrin -", 48.864278, 2.272454 },
	{ 16017, 10, "16017 - Rue De Siam", "1 Bis Rue De Siam -", 48.861619, 2.275291 },
	{ 16016, 10, "16016 - Paul Doumer / La Tour", "53 Avenue Paul Doumer -", 48.860094, 2.280850 },
	{ 16015, 10, "16015 - Rue De Bassano", "1 Rue De Bassano -", 48.867991, 2.296058 },
	{ 16014, 10, "16014 - Avenue D Eylau", "4 Avenue D'Eylau -", 48.863619, 2.286431 },
	{ 16013, 10, "16013 - Avenue Henri Martin", "Avenue Henri Martin -", 48.864010, 2.276773 },
	{ 16012, 10, "16012 - Boulevard Flandrin", "68 Boulevard Flandrin -", 48.868628, 2.274206 },
	{ 13041, 20, "13041 - Porte D'Ivry", "4 Avenue D'Ivry -", 48.821465, 2.368995 },
	{ 16010, 10, "16010 - Belles Feuilles", "4 Rue Des Belles Feuilles -", 48.865855, 2.282860 },
	{ 16009, 10, "16009 - Saint Didier", "32 Rue Saint Didier -", 48.866297, 2.285734 },
	{ 16008, 10, "16008 - Galilee Kleber", "1 Rue Galilee -", 48.867369, 2.290501 },
	{ 16007, 10, "16007 - Longchamp", "4 Rue De Longchamp -", 48.864826, 2.293078 },
	{ 16006, 10, "16006 - Rue Lauriston", "60 Rue Lauriston -", 48.869094, 2.289913 },
	{ 16005, 10, "16005 - Poincarre Victor Hugo", "89 Avenue Raymond Poincare -", 48.870161, 2.285076 },
	{ 17107, 10, "17107 - Berthier Stuart Merril", "182 Boulevard Berthier -", 48.885758, 2.293510 },
	{ 17106, 10, "17106 - Berthier Porte De Clichy", "4 Boulevard Berthier -", 48.894355, 2.312843 },
	{ 17105, 10, "17105 - Paladines", "18 Boulevard D'Aurelle De Paladines -", 48.883695, 2.282173 },
	{ 16001, 10, "16001 - Avenue Des Portugais", "2 Avenue Des Portugais -", 48.871171, 2.293549 },
	{ 11107, 20, "11107 - Bibliotheque Faidherbe", "11 Rue Faidherbe -", 48.851470, 2.383518 },
	{ 11105, 20, "11105 - Republique Parmentier", "82 Avenue Parmentier -", 48.864442, 2.375315 },
	{ 11104, 20, "11104 - Charonne Du Bureau", "170 Rue De Charonne -", 48.855798, 2.392756 },
	{ 6032, 20, "06032 - Rennes Sabot", "7 Rue Du Sabot -", 48.852593, 2.331943 },
	{ 6031, 20, "06031 - Saint Michel Sarrazin", "5 Rue Pierre Sarazin -", 48.850769, 2.342484 },
	{ 6030, 20, "06030 - Vaugirard Assas", "74 Rue De Vaugirard -", 48.847920, 2.329874 },
	{ 6029, 20, "06029 - Vaugirard Prince", "Face 1 Rue De Vaugirard -", 48.848792, 2.341340 },
	{ 6028, 20, "06028 - Odeon Quatre Vents", "6 Rue Des Quatre Vents -", 48.851785, 2.338222 },
	{ 6027, 20, "06027 - Vaugirard Desgoffe", "2 Rue Blaise Desgoffe -", 48.846059, 2.324182 },
	{ 6026, 20, "06026 - Saint Placide Cherche Midi", "28 Rue Saint Placide -", 48.849061, 2.325257 },
	{ 6025, 20, "06025 - Rennes - Assas", "16 Rue D'Assas -", 48.849115, 2.328580 },
	{ 6024, 20, "06024 - Saint Germain Des Pres", "55 Rue Des Saints Peres -", 48.854058, 2.330472 },
	{ 6022, 20, "06022 - Marche Saint Germain - Mabillon", "17 Rue Lobineau -", 48.851569, 2.335689 },
	{ 6021, 20, "06021 - Bonaparte Beaux Arts", "17 Rue Des Beaux Arts -", 48.856287, 2.334885 },
	{ 8101, 20, "08101 - Londres Amsterdam", "42 Rue De Londres -", 48.878018, 2.326586 },
	{ 8047, 10, "08047 - George V", "28 Avenue George V -", 48.868145, 2.301181 },
	{ 8003, 10, "08003 - Galille", "63 Rue Galilee -", 48.871703, 2.298508 },
	{ 19004, 10, "19004 - Quai De La Loire", "4 Quai De La Loire -", 48.883038, 2.370873 },
	{ 12030, 20, "12030 - Wattignies", "245 Rue De Charenton -", 48.836727, 2.392041 },
	{ 1028, 20, "01028 - Les Halles - Porte", "Rue Berger -", 48.861239, 2.346749 },
	{ 5014, 20, "05014 - Calvin", "8 Rue Jean Calvin -", 48.841565, 2.348828 },
	{ 18035, 10, "18035 - Porte Montmartre", "Face 66 Rue Rene Binet -", 48.899031, 2.336669 },
	{ 3009, 20, "03009 - Temple 113", "76 Rue Du Temple -", 48.861588, 2.356897 },
	{ 14023, 20, "14023 - Malakoff Pinard", "76-78 Boulevard Adolphe Pinard -", 48.823686, 2.308330 },
	{ 6108, 20, "06108 - Saint Romain Cherche Midi", "20 Rue Saint Romain -", 48.846930, 2.321336 },
	{ 5024, 20, "05024 - Place Monge", "4 Rue Dolomieu -", 48.842670, 2.352396 },
	{ 9102, 20, "09102 - Place D'Estienne D'Orves", "2 Rue De Londres -", 48.876653, 2.330674 },
	{ 19037, 20, "19037 - Porte Des Lilas", "304 Rue De Belleville -", 48.876580, 2.404796 },
	{ 17029, 10, "17029 - Place Aimée Maillart", "29 Rue Pierre Demours -", 48.881516, 2.294631 },
	{ 1001, 20, "01001 - Ile De La Cite Pont Neuf", "41 Quai De L'Horloge -", 48.857123, 2.341831 },
	{ 901, 10, "00901 - Station Mobile 1", "Allee Du Belvedere Paris 19 - 0 75000 Paris -", 48.892746, 2.391255 },
	{ 11011, 20, "11011 - Richard Lenoir", "Face 86 Boulevard Richard Lenoir -", 48.861773, 2.372493 },
	{ 1116, 20, "01116 - Opéra Pyramides", "4 Rue De Ventadour -", 48.866578, 2.334217 },
	{ 9106, 20, "09106 - Auber", "3 Rue Boudreau -", 48.872105, 2.329612 },
	{ 6104, 20, "06104 - Herschel", "7 Rue Herschel -", 48.843238, 2.337799 },
	{ 7101, 20, "07101 - Sevres Babylone", "Boulevard Raspail -", 48.854579, 2.326441 },
	{ 18108, 10, "18108 - Evangile", "61 Rue De L'Evangile -", 48.894812, 2.367868 },
	{ 904, 10, "00904 - Station Mobile 4", "Ecole Militaire-Avenue De La Motte Picquet -", 48.852292, 2.301805 },
	{ 4018, 20, "04018 - Rivoli Sebastopol", "1 Rue Saint Bon -", 48.858057, 2.350017 },
	{ 4101, 20, "04101 - Bastille", "11 Rue De La Bastille -", 48.853848, 2.368402 },
	{ 4107, 20, "04107 - Beaumarchais", "27 Boulevard Beaumarchais -", 48.855600, 2.368172 },
	{ 5102, 20, "05102 - Saint Jacques (2)", "42 Rue Saint Jacques -", 48.849780, 2.344881 },
	{ 5105, 20, "05105 - Geoffroy Saint Hilaire", "8 Rue Geoffroy Saint Hilaire -", 48.838985, 2.357065 },
	{ 5107, 20, "05107 - Pontoise", "1 Rue De Pontoise -", 48.850489, 2.352548 },
	{ 14108, 20, "14108 - Jourdan Le Brix Et Mesnin", "Rue Le Brix Et Mesnin -", 48.822206, 2.327795 },
	{ 18111, 10, "18111 - Feliz Ziem", "2 Rue Felix Ziem -", 48.889531, 2.333411 },
	{ 11103, 20, "11103 - Richard Lenoir", "21 Rue Pelee -", 48.859895, 2.371198 },
	{ 7102, 20, "07102 - Sainte Clothilde", "Face 19 Rue Casimir Perier -", 48.857922, 2.319439 },
	{ 15108, 10, "15108 - Musée Des Télécommunications", "88 - 90 Rue De Lourmel -", 48.844692, 2.287022 },
	{ 18110, 10, "18110 - Departement", "Face 53 Rue Du Departement -", 48.886635, 2.361553 },
	{ 20106, 20, "20106 - Mairie Du 20Ème", "44-46 Avenue Gambetta -", 48.865340, 2.399182 },
	{ 20107, 20, "20107 - Stade Maryse Hilsz", "26 Rue Maryse Hilsz -", 48.851186, 2.412743 },
	{ 20108, 20, "20108 - Hospice Debrousse", "142 Rue De Bagnolet -", 48.861552, 2.405729 },
	{ 11109, 20, "11109 - Republique Pierre Levee", "1 Rue De La Pierre Levee -", 48.866339, 2.371284 },
	{ 12106, 20, "12106 - Barthes Troyes", "3 Rue Roland Barthes -", 48.844219, 2.378786 },
	{ 18114, 10, "18114 - Lepic Veron", "35 Rue Veron -", 48.885173, 2.334502 },
	{ 20030, 20, "20030 - Pere Lachaise", "54 Boulevard Menilmontant -", 48.863332, 2.387342 },
	{ 12105, 20, "12105 - Bercy Villot", "153 Rue De Bercy -", 48.841865, 2.376374 },
	{ 13107, 20, "13107 - Marchand Sante", "12 Passage Victor Marchand -", 48.828902, 2.341937 },
	{ 13109, 20, "13109 - Brillat Savarin", "16 Rue Brillat Savarin -", 48.822206, 2.350403 },
	{ 14107, 20, "14107 - Porte De Montrouge 2", "2 Avenue De La Porte De Montrouge -", 48.823599, 2.322990 },
	{ 5106, 20, "05106 - Cujas", "22 Rue Cujas -", 48.848163, 2.341708 },
	{ 7103, 10, "07103 - Belgrade", "2 Rue De Belgrade -", 48.856183, 2.302782 },
	{ 10110, 10, "10110 - Louis Blanc (Prop 2)", "10 Rue Louis Blanc -", 48.879354, 2.368295 },
	{ 13113, 20, "13113 - Choisy Vistule", "2 Rue De La Viscule -", 48.823633, 2.361578 },
	{ 20104, 20, "20104 - Rue Louis Lumière", "68 Rue Louis Lumiere -", 48.862124, 2.411084 },
	{ 6107, 20, "06107 - Cherche Midi", "29 Rue Du Cherche Midi -", 48.850122, 2.327654 },
	{ 10107, 10, "10107 - Magenta Pare", "9 Rue Ambroise Pare -", 48.881801, 2.352435 },
	{ 10114, 20, "10114 - Hopital Saint Louis", "12 Bis Rue De La Grange Aux Belles -", 48.875130, 2.366712 },
	{ 11101, 20, "11101 - Square Nordling", "15 Rue Charles Delescluze -", 48.852379, 2.380727 },
	{ 11110, 20, "11110 - Square Roquette", "176 Rue De La Roquette -", 48.859396, 2.386562 },
	{ 13106, 20, "13106 - Bobillot Mery", "17 Rue Bobillot -", 48.829872, 2.354298 },
	{ 13122, 20, "13122 - Parc De Choisy", "Face 153 Avenue De Choisy -", 48.828253, 2.358382 },
	{ 10113, 20, "10113 - Parmentier Louvel-Tessier", "151 Avenue Parmentier -", 48.871310, 2.369761 },
	{ 11113, 20, "11113 - Republique Ferry", "Face 140 Boulevard Richard Lenoir -", 48.866403, 2.369622 },
	{ 19020, 10, "19020 - Manin Hautpoul", "4-6 Rue Goubet -", 48.884397, 2.390238 },
	{ 19105, 10, "19105 - Porte Brunet", "Face 1 Avenue Ambroise Rendu -", 48.883505, 2.395770 },
	{ 12108, 20, "12108 - Palais Omnisport", "81 Rue De Bercy -", 48.838826, 2.380892 },
	{ 12110, 20, "12110 - Baron Le Roy Truffaut", "57-61 Rue Des Pirogues De Bercy -", 48.833915, 2.388553 },
	{ 15052, 13, "15052 - Convention", "183 Rue De La Convention -", 48.837397, 2.295497 },
	{ 19101, 20, "19101 - Simon Bolivar", "36 Avenue Simon Bolivar -", 48.875107, 2.382599 },
	{ 11111, 20, "11111 - Charonne Frot", "30-32 Rue Leon Frot -", 48.854866, 2.387103 },
	{ 15104, 13, "15104 - Hôpital Georges Pompidou (Prop 2)", "Face 66 - 70 Rue Leblanc -", 48.837865, 2.275660 },
	{ 15105, 10, "15105 - Suffren Fédération", "84 Rue De La Federation -", 48.852857, 2.297800 },
	{ 7023, 10, "07023 - Bourdonnais Tour Eiffel", "Quai Branly -", 48.860765, 2.295370 },
	{ 7025, 10, "07025 - Suffren Tour Eiffel", "2 Avenue Octave Creard -", 48.856450, 2.293044 },
	{ 12111, 20, "12111 - Decaen Cannebiere", "73 Rue Claude Decaen -", 48.837461, 2.397229 },
	{ 14103, 20, "14103 - Maine Liancourt", "132 / 136 Avenue Du Maine -", 48.835103, 2.323681 },
	{ 14113, 20, "14113 - Arago 2", "36 Rue De La Sante -", 48.835158, 2.341652 },
	{ 8105, 10, "08105 - Francois 1Er Lincoln", "56 Rue Francois 1Er -", 48.869521, 2.302310 },
	{ 9020, 10, "09020 - Toudouze Clauzel", "Face 27 Rue Clauzel -", 48.879430, 2.337282 },
	{ 9034, 20, "09034 - Godot De Mauroy", "2 Rue Godot De Mauroy -", 48.869804, 2.326656 },
	{ 15106, 10, "15106 - Grenelle Violet (Prop3)", "Boulevard De Grenelle -", 48.849755, 2.294575 },
	{ 17047, 10, "17047 - Courcelles - Demoures", "172 Rue De Courcelles -", 48.883719, 2.298731 },
	{ 17101, 10, "17101 - Alexandre Charpentier", "Face 3 Rue Alexandre Charpentier -", 48.884345, 2.288659 },
	{ 19121, 20, "19121 - Belleville Pre Saint Gervais", "195 Rue De Belleville -", 48.875139, 2.392518 },
	{ 9019, 10, "09019 - Victor Masse", "38 Rue Victor Masse -", 48.881164, 2.336519 },
	{ 11002, 20, "11002 - Roquette Thiere", "37 Rue De La Roquette -", 48.855212, 2.373361 },
	{ 20113, 20, "20113 - Parc De Belleville", "30 Rue Piat -", 48.871925, 2.384748 },
	{ 8008, 20, "08008 - Rome Saint Lazare", "1 Rue Joseph Sansboeuf -", 48.875205, 2.322867 },
	{ 8020, 10, "08020 - Metro Rome", "74 Boulevard Des Batignolles -", 48.882152, 2.319744 },
	{ 8108, 20, "08108 - L'Isly", "10-12 Rue De L'Isly -", 48.874747, 2.325224 },
	{ 20103, 20, "20103 - Le Vau Berteaux", "24 Rue Le Vau -", 48.867939, 2.411160 },
	{ 20109, 20, "20109 - Surmelin Haxo", "2 Rue Haxo -", 48.869488, 2.405386 },
	{ 17044, 10, "17044 - Porte De Saint Ouen", "1 Avenue De La Porte De Saint Ouen -", 48.897880, 2.328831 },
	{ 17108, 10, "17108 - Bessieres", "102 Boulevard Bessieres -", 48.896090, 2.317695 },
	{ 9108, 20, "09108 - Rochechouart Maubeuge", "25 Rue De Rochechouart -", 48.878081, 2.344858 },
	{ 13118, 20, "13118 - Patay Regnault", "36-38 Rue Regnault -", 48.824393, 2.376102 },
	{ 20115, 20, "20115 - Porte De Bagnolet", "102 Rue Louis Lumiere -", 48.864596, 2.410406 },
	{ 13110, 20, "13110 - Moulin De La Pointe", "66 Rue Du Moulin De La Pointe -", 48.820938, 2.356282 },
	{ 14112, 20, "14112 - Faubourg Saint Jacques Cassini", "24 Rue Mechain -", 48.835841, 2.338317 },
	{ 14125, 20, "14125 - Dareau", "34 Rue Dareau -", 48.830763, 2.336098 },
	{ 10105, 20, "10105 - Bonne Nouvelle Prop2", "2 Rue De Mazagran -", 48.870145, 2.351164 },
	{ 19103, 10, "19103 - Manin Carrieres", "139 Rue Manin -", 48.884567, 2.391969 },
	{ 19110, 10, "19110 - Macdonald Duchesne", "1 Rue Jacques Duchesne -", 48.898899, 2.374018 },
	{ 20118, 20, "20118 - Orteaux Mouraud", "100 Rue Des Orteaux -", 48.855583, 2.408432 },
	{ 14001, 20, "14001 - Edgar Quinet", "13 Boulevard Edgar Quinet -", 48.841053, 2.324483 },
	{ 20116, 20, "20116 - Haies Reunion", "53 Rue Des Haies -", 48.853870, 2.402314 },
	{ 13101, 20, "13101 - Croulebarbe Reculettes", "67-69 Rue De Croulebarbe -", 48.830933, 2.348676 },
	{ 20121, 20, "20121 - Menilmontant Boyer", "27 Rue Boyer -", 48.868902, 2.392075 },
	{ 8030, 20, "08030 - Montaigne", "25 Rue Bayard -", 48.867293, 2.307557 },
	{ 20122, 20, "20122 - Davout Vitruve", "98 Rue Vitruve -", 48.860409, 2.408956 },
	{ 8103, 20, "08103 - D'Artois Berry", "31 Rue D'Artois -", 48.873755, 2.306286 },
	{ 9023, 20, "09023 - Italiens Laffite", "1 Rue Laffite -", 48.871656, 2.337078 },
	{ 14025, 20, "14025 - Jacquier", "10 Rue Jacquier -", 48.829602, 2.318210 },
	{ 15118, 20, "15118 - Place Bienvenue", "11 Rue De L'Arrivee -", 48.843317, 2.322467 },
	{ 8102, 10, "08102 - Lamenais Washington", "1 Rue Lamennais -", 48.873511, 2.303316 },
	{ 11017, 20, "11017 - Alexandre Dumas", "Face 77 Boulevard De Charonne -", 48.854125, 2.395886 },
	{ 11021, 20, "11021 - Philippe Auguste (20Eme Arr.)", "212 Boulevard Charonne -", 48.858388, 2.390252 },
	{ 11029, 20, "11029 - Menilmontant Oberkampf", "137 Boulevard Menilmontant -", 48.866740, 2.382850 },
	{ 11112, 20, "11112 - Charonnes Valles", "22 Rue Jules Valles -", 48.854337, 2.384964 },
	{ 12037, 20, "12037 - Daumesnil", "53 Boulevard De Reuilly -", 48.839726, 2.397232 },
	{ 12112, 20, "12112 - Charenton Jardinier", "311-313 Rue De Charenton -", 48.833814, 2.394829 },
	{ 12115, 20, "12115 - Porte De Vincennes", "22 Avenue De La Porte De Vincennes -", 48.846313, 2.415473 },
	{ 13111, 20, "13111 - Cimetiere De Gentilly", "Rue De La Poterne Des Peupliers -", 48.818574, 2.353260 },
	{ 13114, 20, "13114 - Nationale Duchamp (Prop 1)", "46 Rue Nationale -", 48.824809, 2.367799 },
	{ 13116, 20, "13116 - Place Du Docteur Yersin", "Face 5 Avenue De La Porte D'Ivry -", 48.820134, 2.372125 },
	{ 13117, 20, "13117 - Stade Georges Carpentier", "95-97 Boulevard Massena -", 48.820387, 2.366245 },
	{ 14101, 20, "14101 - Place Fernand Mourlot", "33 Bd Edgar Quinet -", 48.841718, 2.322576 },
	{ 14110, 20, "14110 - Abbe Carton", "89 Rue De L'Abbe Carton -", 48.827724, 2.320770 },
	{ 15028, 10, "15028 - Dupleix", "54 Boulevard De Grenelle -", 48.851317, 2.291373 },
	{ 15103, 13, "15103 - Square Des Cévennes", "103 Rue Cauchy -", 48.843302, 2.275299 },
	{ 20110, 20, "20110 - Porte Des Lilas", "Face 241 Avenue Gambetta -", 48.875249, 2.405857 },
	{ 14014, 20, "14014 - Stade Charlety", "5 Boulevard Jourdan -", 48.819276, 2.343992 },
	{ 14106, 20, "14106 - Stade Didot", "Face 58 Avenue Marc Sangnier -", 48.825376, 2.310398 },
	{ 14109, 20, "14109 - Tombe Issoire Regnault", "132 Rue De La Tombe Issoire -", 48.824471, 2.331089 },
	{ 14111, 20, "14111 - Denfert-Rochereau Cassini", "18 Rue Cassini -", 48.837557, 2.335975 },
	{ 15110, 13, "15110 - Place Robert Guillemard", "Place Robert Guillemard -", 48.836025, 2.281012 },
	{ 15111, 13, "15111 - Serres", "48 Rue Olivier De Serres -", 48.834737, 2.295595 },
	{ 15114, 20, "15114 - Pasteur Cotentin", "Face 1 Rue Du Cotentin -", 48.838904, 2.316355 },
	{ 17104, 10, "17104 - General Koenig", "Boulevard Aurelle De Paladines -", 48.881853, 2.283470 },
	{ 17117, 10, "17117 - Pereire Saussure", "2 Bis Boulevard Pereire -", 48.888189, 2.310025 },
	{ 18039, 10, "18039 - Eole", "41 Rue D'Aubervilliers -", 48.886939, 2.366828 },
	{ 19112, 10, "19112 - Stade Ladoumegue", "Avenue De La Porte De Pantin -", 48.890137, 2.396827 },
	{ 18028, 10, "18028 - Vauvenargues", "195 Rue Championnet -", 48.893962, 2.332280 },
	{ 10111, 20, "10111 - Bourse Du Travail", "100 Quai De Jemmapes -", 48.873414, 2.364204 },
	{ 19113, 20, "19113 - Pre St Gervais", "27 Rue Du Pre Saint Gervais -", 48.877879, 2.395750 },
	{ 9012, 20, "09012 - Rougemont", "3-5 Rue Rougemont -", 48.871332, 2.345606 },
	{ 19114, 10, "19114 - Manin Secretan", "31 Rue Manin -", 48.879045, 2.378446 },
	{ 19118, 20, "19118 - Bolivar Burnouf", "82 Avenue Simon Bolivar -", 48.876988, 2.374261 },
	{ 20006, 20, "20006 - Pyrénées - Plaine", "33 Rue Des Pyrenees -", 48.850219, 2.406286 },
	{ 20111, 20, "20111 - L'Isle Adam Pyrenées", "60 Rue Villiers De L'Isle Adam -", 48.867183, 2.396283 },
	{ 12025, 20, "12025 - Bercy", "Face 14 Pl. Du Bataillon Du Pacifique -", 48.840111, 2.379886 },
	{ 14104, 20, "14104 - Losserand Boyer-Barret", "4 Rue Boyer Barret -", 48.833197, 2.317174 },
	{ 12101, 20, "12101 - Charenton Prague", "89 Ter Rue De Charenton -", 48.848120, 2.376229 },
	{ 15112, 20, "15112 - Falguière Lebrun", "19 Rue Vigee Lebrun -", 48.838633, 2.311399 },
	{ 12102, 20, "12102 - Diderot Bercy", "224 Rue De Bercy -", 48.846181, 2.370386 },
	{ 13120, 20, "13120 - Vitry Desault", "Rue Pierre Et Joseph Desault -", 48.821157, 2.378808 },
	{ 1008, 20, "01008 - Les Halles Saint Eustache", "Allee Andre Breton -", 48.862794, 2.345687 },
	{ 4105, 20, "04105 - Morland", "17 Boulevard Du Morland -", 48.849930, 2.363293 },
	{ 8549, 10, "08549 - Place Dunant", "39 Avenue George V -", 48.870203, 2.301179 },
	{ 10024, 20, "10024 - Buisson Saint Louis", "2 Rue Du Buisson Saint Louis -", 48.871705, 2.372241 },
	{ 16037, 10, "16037 - Molitor - Michel Ange", "35 Rue Molitor -", 48.845101, 2.262075 },
	{ 16041, 13, "16041 - Versailles", "164 Avenue De Versailles -", 48.840213, 2.263702 },
	{ 17110, 10, "17110 - Legendre", "83 Rue Legendre -", 48.887796, 2.320383 },
	{ 17114, 10, "17114 - Porte De Clichy", "15 Avenue De La Porte De Clichy -", 48.895289, 2.311780 },
	{ 17116, 10, "17116 - Reims", "6 Boulevard De Reims -", 48.891799, 2.300101 },
	{ 18109, 10, "18109 - Riquet Pajol", "55 Rue Pajol -", 48.889601, 2.362850 },
	{ 19119, 10, "19119 - Bouret Pailleron", "20 Rue Edouard Pailleron -", 48.880529, 2.376076 },
	{ 20009, 20, "20009 - Docteur Dejerine", "Rue Des Docteurs Dejerine -", 48.853864, 2.412284 },
	{ 20031, 20, "20031 - Duris", "33 Rue Duris -", 48.865516, 2.387944 },
	{ 20112, 20, "20112 - Jourdain", "3 Rue Du Jourdain -", 48.873945, 2.389601 },
	{ 8104, 10, "08104 - Friedland Chateaubriand", "27/31 Rue De Chateaubriand -", 48.874076, 2.299719 },
	{ 12114, 20, "12114 - Porte De Saint Mande", "33 Avenue Courteline -", 48.843976, 2.414802 },
	{ 11013, 20, "11013 - Nation Volaire", "5 Place De La Nation -", 48.849335, 2.394873 },
	{ 11014, 20, "11014 - Nation Trone", "Face 21 Place De La Nation -", 48.848570, 2.397269 },
	{ 14116, 20, "14116 - Romain Rolland", "49-51 Bd Romain Rolland -", 48.820228, 2.323304 },
	{ 14122, 20, "14122 - Brune", "1 Rue Du Colonel Monteil -", 48.826356, 2.309254 },
	{ 14115, 20, "14115 - Cité Universitaire", "Avenue Maurice D'Ocagne -", 48.823769, 2.316592 },
	{ 2108, 20, "02108 - Vivienne", "42 Rue Vivienne -", 48.871521, 2.341369 },
	{ 7013, 20, "07013 - Place De Breteuil", "17 Rue Duroc -", 48.847387, 2.312443 },
	{ 10040, 20, "10040 - Belleville", "8 Boulevard De La Vilette -", 48.873015, 2.376302 },
	{ 15022, 10, "15022 - Zola", "2 Rue Fremicourt -", 48.846933, 2.295925 },
	{ 15035, 13, "15035 - Place Etienne Pernet", "2 Rue Des Freres Morane -", 48.842411, 2.292307 },
	{ 17119, 10, "17119 - Toqueville", "64 Rue De Toqueville -", 48.884918, 2.310885 },
	{ 19120, 20, "19120 - Alouettes", "20 Rue Carducci -", 48.877515, 2.385735 },
	{ 9101, 20, "09101 - Cadet La Fayette", "24-26 Rue Cadet -", 48.875421, 2.343359 },
	{ 14124, 20, "14124 - Porte D'Arcueil", "Avenue David Weil -", 48.821047, 2.333784 },
	{ 2014, 20, "02014 - Saint Augustin", "1, 3 Rue Daunou -", 48.869202, 2.332609 },
	{ 2107, 20, "02107 - Thorel", "11 Rue Thorel -", 48.869903, 2.349066 },
	{ 13103, 20, "13103 - Saint Marcel", "89 Boulevard De L'Hopital -", 48.838526, 2.360836 },
	{ 18042, 10, "18042 - Pigalle Germain Pillon", "Face 36 Boulevard De Clichy -", 48.882683, 2.336519 },
	{ 18113, 10, "18113 - Lepic", "70, 72 Rue Lepic -", 48.887545, 2.333984 },
	{ 15014, 20, "15014 - Volontaires", "25 Rue Des Volontaires -", 48.843503, 2.306617 },
	{ 2101, 20, "02101 - Bachaumont", "14 Rue Bachaumont -", 48.866155, 2.344856 },
	{ 9113, 20, "09113 - Bleue", "5 Rue Bleue -", 48.875816, 2.347215 },
	{ 17115, 10, "17115 - Porte De Saint Ouen", "22 Avenue De La Porte De Saint Ouen -", 48.898824, 2.329580 },
	{ 18018, 10, "18018 - Carpeaux", "13 Rue Carpeaux -", 48.890816, 2.330822 },
	{ 18104, 10, "18104 - Chapelle", "2 Impasse De La Chapelle -", 48.891965, 2.360111 },
	{ 19102, 20, "19102 - Belleville Rampal", "4 Rue De Rampal -", 48.873050, 2.379858 },
	{ 15113, 20, "15113 - Falguiere Arsonval", "2 Rue D'Arsonval -", 48.840368, 2.313195 },
	{ 19117, 10, "19117 - Euryale Dehaynin", "22 Rue Euryale Dehaynin -", 48.886361, 2.377294 },
	{ 19030, 10, "19030 - Moselle Jaures", "6 Passage De Melun -", 48.884043, 2.376256 },
	{ 15120, 13, "15120 - Avia", "26 Rue Du Colonel Pierre Avia -", 48.829254, 2.274799 },
	{ 15123, 10, "15123 - Rue Du Commerce", "20 Rue Du Commerce -", 48.847949, 2.296592 },
	{ 18122, 10, "18122 - Binet", "5 Rue Binet -", 48.899148, 2.342557 },
	{ 19006, 10, "19006 - Mathis", "6 Rue Mathis -", 48.890775, 2.375253 },
	{ 12107, 20, "12107 - Diderot Bourdan", "146 Boulevard Diderot -", 48.847414, 2.390241 },
	{ 16103, 10, "16103 - Traktir", "3 Rue Traktir -", 48.872824, 2.291409 },
	{ 5110, 20, "05110 - Lacepede", "27 Rue Lacepede -", 48.843794, 2.351852 },
	{ 6002, 20, "06002 - Saint Pères", "1 Rue Saint Benoit -", 48.855586, 2.333264 },
	{ 8113, 20, "08113 - Place St Augustin", "5 Place Saint Augustin -", 48.874944, 2.319406 },
	{ 9031, 20, "09031 - Provence", "69 Rue De Provence -", 48.874217, 2.333126 },
	{ 10036, 10, "10036 - Aqueduc", "80 Rue De L'Aqueduc -", 48.883587, 2.366826 },
	{ 10115, 20, "10115 - Dodu", "1, 3 Rue Des Ecluses Saint Martin -", 48.876478, 2.367830 },
	{ 16104, 10, "16104 - Paul Valéry", "26-32 Rue Paul Valery -", 48.871376, 2.288821 },
	{ 16105, 10, "16105 - Crevaux", "1 Rue Crevaux -", 48.870627, 2.281234 },
	{ 16107, 10, "16107 - Godard", "2 Rue Benjamin Godard -", 48.865870, 2.275708 },
	{ 16108, 10, "16108 - Sablons", "40 Rue Des Sablons -", 48.863770, 2.281418 },
	{ 16110, 10, "16110 - Octave Feuillet", "4, 6 Rue Octave Feuillet -", 48.861006, 2.273126 },
	{ 16111, 10, "16111 - Helie", "4,6 Rue Faustin Helie -", 48.859256, 2.276642 },
	{ 16116, 10, "16116 - Georges Sand", "23 Rue Georges Sand -", 48.849913, 2.268005 },
	{ 17102, 10, "17102 - Alfred Roll", "14 Rue Alfred Roll -", 48.887962, 2.299995 },
	{ 17111, 10, "17111 - Lemercier", "109 Rue Lemercier -", 48.889871, 2.317438 },
	{ 18112, 10, "18112 - Hôpital Bichat", "2 Rue Arthur Ranc -", 48.897871, 2.333125 },
	{ 20024, 20, "20024 - Gambetta - Père Lachaise", "11 Rue Malte Brun -", 48.864387, 2.398323 },
	{ 20029, 20, "20029 - Porte Des Lilas", "57 Rue Des Freres Flavien -", 48.878212, 2.410643 },
	{ 20119, 20, "20119 - Square De Menilmontant", "138 Rue De Menilmontant -", 48.869852, 2.396803 },
	{ 20120, 20, "20120 - Noisy Le Sec", "1 Rue Evariste Galois -", 48.873097, 2.412925 },
	{ 20503, 20, "20503 - Cours De Vincennes Pyrénées", "1 Rue Des Pyrenees -", 48.847954, 2.406256 },
	{ 12109, 20, "12109 - Charolais", "212 Rue De Charenton -", 48.840782, 2.387348 },
	{ 20043, 20, "20043 - Charonne Avron", "48 Boulevard De Charonne -", 48.851409, 2.398566 },
	{ 20105, 20, "20105 - Gaumont", "Avenue Benoit Frachon -", 48.852802, 2.415374 },
	{ 12113, 20, "12113 - Cardinal Lavigerie", "4 Place Du Cardinal Lavigerie -", 48.832290, 2.403758 },
	{ 16112, 10, "16112 - Chernovitz", "1-3 Rue Chernovitz -", 48.856904, 2.282324 },
	{ 19019, 10, "19019 - Petit Honneger", "124 Rue Petit -", 48.886283, 2.393729 },
	{ 14127, 20, "14127 - Odessa", "5-7 Rue D'Odessa -", 48.843066, 2.324305 },
	{ 20034, 20, "20034 - Sorbier - Ménilmontant", "1 Rue Sorbier -", 48.866179, 2.392099 },
	{ 15003, 20, "15003 - Gare De Montparnasse", "Tp Du 1-13 Boulevard De Vaugirard -", 48.841492, 2.318410 },
	{ 10161, 20, "10161 - Gare De L'Est", "Face 129 Rue Du Fbg Saint Martin -", 48.875833, 2.359872 },
	{ 15115, 20, "15115 - Vaugirard", "25-31 Boulevard De Vaugirard -", 48.841402, 2.317838 },
	{ 8115, 10, "08115 - Bassano", "10 Rue Vernet -", 48.871246, 2.300293 },
	{ 13104, 20, "13104 - Gare D'Austerlitz", "Face 109 Quai D'Austerlitz -", 48.844097, 2.365169 },
	{ 16115, 10, "16115 - Raffet", "52 Rue Raffet -", 48.852525, 2.262568 },
	{ 19106, 10, "19106 - Gare Emgp", "35 Rue De La Gare -", 48.901749, 2.372548 },
	{ 16101, 10, "16101 - Malakoff", "161 Avenue Malakoff -", 48.876811, 2.282412 },
	{ 16102, 10, "16102 - Pergolèse/ Marbeau", "52-54 Rue Pergolèse -", 48.873674, 2.281353 },
	{ 10153, 10, "10153 - Gare Du Nord 3", "7 Boulevard De Denain -", 48.879033, 2.354314 },
	{ 18102, 10, "18102 - Rue De La Chapelle", "69 Bis Rue De La Chapelle -", 48.895533, 2.359309 },
	{ 19018, 10, "19018 - Cité De La Musique Version 2", "Face 210 Avenue Jean Jaures -", 48.888656, 2.392586 },
	{ 10032, 20, "10032 - Dodu", "N° 12-14 Rue Claude Vellefaux-", 48.872730, 2.370021 },
	{ 15006, 20, "15006 - Cherche Midi", "Face Au 138 Rue Du Cherche Midi -", 48.844422, 2.317687 },
	{ 15109, 13, "15109 - Cevennes", "65 - 67 Rue Des Cevennes -", 48.842586, 2.280610 },
	{ 18107, 10, "18107 - Chartres", "22-24 Rue De Chartres -", 48.884677, 2.353880 },
	{ 10151, 10, "10151 - Gare Du Nord 1", "8-10 Rue De Dunkerque -", 48.879383, 2.357231 },
	{ 10152, 10, "10152 - Gare Du Nord 2", "3 Boulevard De Denain -", 48.878781, 2.354205 },
	{ 18105, 10, "18105 - Beliard Poissonniers", "157 Bis-159 Rue Des Poissonniers -", 48.897511, 2.352603 },
	{ 17109, 10, "17109 - Bois Le Prêtre", "22 Bd De Bois Le Pretre -", 48.899640, 2.318416 },
	{ 12023, 20, "12023 - Sahel", "15 Avenue Emile Laurent -", 48.840725, 2.410917 },
	{ 12120, 20, "12120 - Conservation", "Route De La Ceinture Du Lac Daumesnil -", 48.827787, 2.418699 },
	{ 12124, 20, "12124 - Pyramide Artillerie", "Route De L'Artillerie -", 48.839375, 2.438337 },
	{ 12125, 20, "12125 - Pyramide Entrée Parc Floral", "Pyramide Entree Parc Floral -", 48.836919, 2.440633 },
	{ 18043, 10, "18043 - Blanche", "55 Boulevard De Clichy -", 48.883483, 2.333098 },
	{ 20132, 20, "20132 - Reunion", "4 Rue De La Reunion -", 48.852503, 2.403988 },
	{ 12119, 20, "12119 - Dom Pérignon Gravelle", "Route Dom Perignon -", 48.825294, 2.409942 },
	{ 12123, 20, "12123 - Chateau De Vincennes", "Cours Des Marechaux -", 48.844228, 2.438659 },
	{ 12126, 20, "12126 - Avenue De Gravelle", "Face 71 Avenue De Gravelle -", 48.824715, 2.415359 },
	{ 903, 20, "00903 - Station Mobile 3", "Fete De L'Oh (Bercy) - Quai Mauriac Ang Pont De Bercy", 48.833209, 2.378696 },
	{ 8110, 20, "08110 - Stockolm Rome", "6 Rue De Stockolm -", 48.877227, 2.322430 },
	{ 20133, 20, "20133 - Rasselins", "2 Rue Des Rasselins -", 48.853263, 2.409723 },
	{ 905, 20, "00905 - Gare De Bercy (Station Mobile 5)", "Gare De Bercy - Angle Rue Corbineau -", 48.838673, 2.381668 },
	{ 906, 20, "00906 - Station Mobile 6", "Garde De L'Est-Parvis Gare De L'Est -", 48.876309, 2.357856 },
	{ 17012, 10, "17012 - Mairie Du 17Eme", "Face 16 Rue Des Batignolles -", 48.884111, 2.322224 },
	{ 20131, 20, "20131 - Repos", "41 Rue Du Repos -", 48.859359, 2.389613 },
	{ 15023, 10, "15023 - La Motte Piquet", "146 Boulevard Grenelle -", 48.848938, 2.298266 },
	{ 14021, 20, "14021 - Place De La Porte De Chatillon", "Boulevard Brune Porte De Chatillon -", 48.824470, 2.318525 },
	{ 12041, 20, "12041 - Bois De Vincennes", "Avenue Daumesnil -", 48.833615, 2.413099 },
	{ 16129, 10, "16129 - Bois De Boulogne / Porte De La Muette 1", "Chemin De La Ceinture Du Lac Interieur / Avenue De Saint Cloud -", 48.858715, 2.258718 },
	{ 16130, 10, "16130 - Bois De Boulogne / Porte De La Muette 2", "Avenue Louis Barthou / Place De La Colombie -", 48.863700, 2.267497 },
	{ 16122, 10, "16122 - Muette Neuilly", "Route De La Muette A Neuilly -", 48.879826, 2.258509 },
	{ 16121, 10, "16121 - Sablons Maillot", "Route Porte Des Sablons / Porte Maillot -", 48.878665, 2.270324 },
	{ 14126, 20, "14126 - Vaillant Couturier", "155 Avenue Paul Vaillant Couturier -", 48.817092, 2.332464 },
	{ 16118, 13, "16118 - Michel Ange", "91 Rue Michel Ange -", 48.840722, 2.258568 },
	{ 15107, 13, "15107 -  Palais Des Sports", "42 Boulevard Victor -", 48.833574, 2.285480 },
	{ 19123, 10, "19123 - Quai De Metz", "7 Quai De Metz -", 48.891283, 2.386497 },
	{ 7003, 20, "7003 - Bon Marche", "Rue Velpeau -", 48.851155, 2.325202 },
	{ 13121, 20, "13121 - Ivry Bruneseau", "Rue Bruneseau -", 48.824928, 2.388653 },
	{ 19124, 10, "19124 - Alexander Flemming", "Rue Alexander Flemming -", 48.881865, 2.403017 },
	{ 21005, 13, "21005 - Morizet (Boulogne-Billancourt)", "20 Avenue Andre Morizet -", 48.835002, 2.241341 },
	{ 19125, 10, "19125 - Ledit De Nantes", "Place Ledit De Nantes -", 48.888814, 2.378481 },
	{ 33003, 10, "33003 - Faure (Aubervilliers)", "Angle Rue Bordier Et Boulevard Felix Faure  -", 48.903721, 2.385759 },
	{ 21010, 13, "21010 - Silly (Boulogne-Billancourt)", "93 Rue De Silly -", 48.835633, 2.232368 },
	{ 21006, 13, "21006 - Paris (Boulogne-Billancourt)", "162 Rue De Paris -", 48.841566, 2.233758 },
	{ 21004, 13, "21004 - Jaures 2 (Boulogne-Billancourt)", "55 Boulevard Jean Jaures -", 48.840537, 2.239588 },
	{ 21008, 13, "21008 - Hugo (Boulogne-Billancourt)", "74 Avenue Victor Hugo -", 48.837999, 2.246155 },
	{ 21017, 13, "21017 - Republique 1 (Boulogne-Billancourt)", "91 Boulevard De La Republipque -", 48.833504, 2.244162 },
	{ 21013, 13, "21013 - Grenier (Boulogne-Billancourt)", "4 Avenue Pierre Grenier -", 48.825589, 2.248573 },
	{ 21015, 13, "21015 - Nationale (Boulogne-Billancourt)", "39 Rue Nationale -", 48.827372, 2.241804 },
	{ 21018, 13, "21018 - Seine (Boulogne-Billancourt)", "Face Au 13 Rue De La Seine -", 48.828331, 2.250474 },
	{ 32606, 10, "32606 - Garde Chasse (Les Lilas)", "49 Rue Du Garde Chasse -", 48.882556, 2.419043 },
	{ 21009, 13, "21009 - Lecorbusier (Boulogne-Billancourt)", "Face Au 1 Rue Lecorbusier -", 48.837472, 2.238750 },
	{ 33012, 0, "33012 - Landy (Aubervilliers)", "Face 2 Rue Du Landy -", 48.915363, 2.376661 },
	{ 21016, 13, "21016 - Point Du Jour (Boulogne-Billancourt)", "118 Rue Du Point Du Jour -", 48.828859, 2.246199 },
	{ 32602, 10, "32602 - Poulmarch (Les Lilas)", "7 Rue Jean Poulmarch -", 48.879152, 2.416422 },
	{ 21019, 13, "21019 - Vaillant (Boulogne-Billancourt)", "71 Avenue Edouard Vaillant -", 48.834764, 2.247618 },
	{ 21020, 13, "21020 - Republique 2 (Boulogne-Billancourt)", "28 Boulevard De La Republique -", 48.832054, 2.253136 },
	{ 21014, 13, "21014 - Hameau Fleuri (Boulogne-Billancourt)", "Face Au 12 Rue Du Hameau Fleurie -", 48.831353, 2.240912 },
	{ 21002, 13, "21002 - Denfert Rochereau (Boulogne-Billancourt)", "Place Denfert Rochereau -", 48.843472, 2.246078 },
	{ 21003, 10, "21003- Jaures 1 (Boulogne-Billancourt)", "2 Boulevard Jean Jaures -", 48.845856, 2.237018 },
	{ 35012, 10, "35012 - Candale (Pantin)", "Face Au 12 Rue Candale -", 48.889408, 2.413984 },
	{ 35007, 10, "35007 - Delessert (Pantin)", "2 Rue  Benjamin Delessert -", 48.893908, 2.418080 },
	{ 21001, 10, "21001 - Transval (Boulogne-Billancourt)", "11 Rue Du Transval -", 48.848113, 2.239097 },
	{ 32604, 10, "32604 - Kock (Les Lilas)", "Face 3 Avenue Paul De Kock -", 48.881773, 2.420746 },
	{ 21306, 13, "21306 - Lafayette (Issy Les Moulineaux)", "Place Lafayette -", 48.829779, 2.264343 },
	{ 21304, 13, "21304 - Blum (Issy Les Moulineaux)", "Face 2 Place Leon Blum -", 48.820915, 2.260898 },
	{ 21307, 13, "21307 - Cresson 1 (Issy Les Moulineaux)", "Face 36 Avenue Victor Cresson -", 48.822510, 2.268505 },
	{ 21310, 13, "21310 - Kleber (Issy Les Moulineaux)", "4 Rue Kleber -", 48.826853, 2.272120 },
	{ 21303, 13, "21303 - Iles (Issy Les Moulineaux)", "Angle Avenue Jean Monnet Et Boulevard Des Iles -", 48.823451, 2.249665 },
	{ 21012, 13, "21012 - Leclerc (Boulogne-Billancourt)", "745 Avenue Du General Leclerc -", 48.830593, 2.234420 },
	{ 21309, 13, "21309 - Cresson 2 (Issy Les Moulineaux)", "1 Bis Avenue Victor Cresson -", 48.823636, 2.272069 },
	{ 21311, 13, "21311 - Gambetta (Issy Les Moulineaux)", "Face Au 40 Boulevard Gambetta -", 48.827333, 2.278435 },
	{ 42501, 13, "42501 - Raspail 1 (Gentilly)", "80 Avenue Raspail -", 48.810540, 2.344018 },
	{ 42505, 20, "42505 - Frerot (Gentilly)", "37 Rue Charles Frerot -", 48.815726, 2.350374 },
	{ 42503, 20, "42503 - Lenine (Gentilly)", "Face 71 Avenue Lenine -", 48.813156, 2.332070 },
	{ 16135, 10, "16135 - Stade Wilmille", "Rond Point Du Marechal Delatre De Tassigny -", 48.871639, 2.274802 },
	{ 43003, 20, "43003 - Paris 2 (Vincennes)", "104 Avenue De Paris -", 48.845684, 2.427741 },
	{ 21305, 13, "21305 - Madaule (Issy Les Moulineaux)", "Place Madaule -", 48.823934, 2.260663 },
	{ 43001, 20, "43001 - Paris 1 (Vincennes)", "168 Avenue De Paris -", 48.846309, 2.420484 },
	{ 43002, 20, "43002 - Lagny (Vincennes)", "1 Bis Rue De Lagny -", 48.848947, 2.425963 },
	{ 43007, 20, "43007 - Vorges (Vincennes)", "4 Avenue Vorges -", 48.848199, 2.439879 },
	{ 21301, 13, "21301 - Saint Vincent (Issy Les Moulineaux)", "21 Rue Saint Vincent -", 48.819463, 2.254136 },
	{ 43010, 20, "43010 - Jarry (Vincennes)", "139 Rue De La Jarry -", 48.849833, 2.451499 },
	{ 21302, 13, "21302 - Briand (Issy Les Moulineaux)", "Place De La Resistance Angle Rue Aristide Briand -", 48.821267, 2.250622 },
	{ 43005, 20, "43005 - Aubert (Vincennes)", "18 Avenue Aubert -", 48.847558, 2.432797 },
	{ 43009, 20, "43009 - Murs Du Parc (Vincennes)", "Avenue Des Murs Du Parc -", 48.846893, 2.453072 },
	{ 23009, 10, "23009 - France (Levallois)", "18 Rue Anatole France -", 48.888704, 2.288369 },
	{ 43004, 20, "43004 - Montreuil (Vincennes)", "43 Rue De Montreuil -", 48.850352, 2.434382 },
	{ 23006, 10, "23006 - Guesde (Levallois)", "8 Rue Jules Guesde -", 48.890566, 2.294746 },
	{ 23007, 10, "23007 - Wilson (Levallois)", "22 Rue Du President Wilson -", 48.890188, 2.292347 },
	{ 42504, 20, "42504 - Malon (Gentilly)", "Face 59 Rue Benoit Malon -", 48.814540, 2.340929 },
	{ 42502, 20, "42502 - Raspail 2 (Gentilly)", "Face Au 79 Avenue Raspail-", 48.813362, 2.346862 },
	{ 21701, 13, "21701 - Larmeroux (Vanves)", "Face 5 Bis Rue Larmeroux -", 48.817232, 2.281808 },
	{ 32603, 10, "32603 - Calmette (Les Lilas)", "1 Allee Docteur Calmette -", 48.881222, 2.424615 },
	{ 32605, 10, "32605 - Hortensias (Les Lilas)", "1 Allee Des Hortensias -", 48.882041, 2.423335 },
	{ 35013, 10, "35013 - Tell (Pantin)", "1 Rue Guillaume Tell -", 48.889709, 2.420649 },
	{ 21703, 13, "21703 - Martinie (Vanves)", "5-7 Avenue Marcel Martinie -", 48.820715, 2.291019 },
	{ 33006, 0, "33006 - Karman (Aubervilliers)", "Face 143 Rue Andre Karman -", 48.910489, 2.385016 },
	{ 41103, 13, "41103 - Briand (Arcueil)", "Avenue Aristide Briand (Carrefour Vache Noire) -", 48.810378, 2.326913 },
	{ 21705, 13, "21705 - Hugo (Vanves)", "11 Avenue Victor Hugo -", 48.822429, 2.286363 },
	{ 35014, 10, "35014 - De Gaulle (Pantin)", "139 Avenue Jean Lolive / Mail Charles De Gaulle -", 48.893819, 2.415858 },
	{ 35011, 10, "35011 - D'Orves (Pantin)", "12 Rue Honore D'Estienne D'Orves -", 48.890617, 2.406504 },
	{ 35006, 10, "35006 - Delizy (Pantin)", "Face Au 23 Rue Delizy -", 48.895333, 2.409713 },
	{ 35009, 10, "35009 - Lolive 1 (Pantin)", "104 Avenue Lolive -", 48.891982, 2.408455 },
	{ 41101, 13, "41101 - Doumer (Arcueil)", "Face Au 11 Avenue Paul Doumer -", 48.806442, 2.337595 },
	{ 21706, 13, "21706 - Bleuzen (Vanves)", "74 Rue Jean Bleuzen -", 48.822927, 2.295836 },
	{ 42706, 20, "42706 - Salengro (Kremlin Bicetre)", "3 Rue Roger Salengro -", 48.814717, 2.361288 },
	{ 23011, 10, "23011 - Bineau (Levallois)", "16 Boulevard Bineau -", 48.886662, 2.284242 },
	{ 23010, 10, "23010 - Voltaire (Levallois)", "47 Rue Voltaire -", 48.892144, 2.284468 },
	{ 41102, 13, "41102 - Renan (Arcueil)", "3 Rue Ernest Renan -", 48.808078, 2.333213 },
	{ 21704, 13, "21704 - Republique (Vanves)", "2 Rue De La Republique -", 48.821719, 2.285438 },
	{ 42705, 20, "42705 - Convention (Le Kremlin Bicetre)", "1 Rue De La Convention -", 48.812488, 2.361178 },
	{ 21702, 13, "21702 - Basch (Vanves)", "6 Avenue Victor Basch -", 48.819061, 2.292096 },
	{ 35001, 0, "35001 - Jaures 1 (Pantin)", "168 Avenue Jean Jaures -", 48.910069, 2.399304 },
	{ 35002, 10, "35002 - Jaures 2 (Pantin)", "130 Rue Jean Jaures -", 48.906683, 2.395578 },
	{ 21707, 13, "21707 - Pasteur (Vanves)", "9 Avenue Pasteur Angle Carrefour Albert Legris -", 48.825074, 2.292717 },
	{ 42702, 13, "42702 - Leclerc (Kremlin Bicetre)", "73 Rue Du General Leclerc -", 48.810844, 2.358157 },
	{ 42701, 13, "42701 - Gide (Le Kremlin Bicetre)", "Face 50 Avenue Charles Gide -", 48.806900, 2.351147 },
	{ 42703, 13, "42703 - Fontainebleau (Kremlin Bicetre)", "93 Avenue De Fontainebleau -", 48.809675, 2.362728 },
	{ 23005, 10, "23005 - Briand (Levallois)", "152 Rue Aristide Briand -", 48.895932, 2.296840 },
	{ 42704, 13, "42704 - Rossel (Le Kremlin Bicetre)", "Rue Rossel / Avenue De La Convention -", 48.811465, 2.357286 },
	{ 35005, 10, "35005 - General Leclerc (Pantin)", "Quai De L'Aisne/Avenue Du General Leclerc", 48.895444, 2.405256 },
	{ 35004, 10, "35004 - Allende (Pantin)", "Avenue De La Gare / Place Du President Salvador Allende -", 48.897612, 2.400325 },
	{ 34007, 10, "34007 - Rosiers (Saint Ouen)", "43-45 Rue Blanqui / Rue Des Rosiers -", 48.905448, 2.337541 },
	{ 33001, 10, "33001 - Emgp (Aubervilliers)", "Emgp Avenue De Porte De Paris / Parking 264 -", 48.903709, 2.369346 },
	{ 32008, 10, "32008 - Emgp Nord (Saint Denis)", "Emgp Parking Entree Nord -", 48.905032, 2.359803 },
	{ 33104, 10, "33104 - Joineau (Pre Saint Gervais)", "Rue Andre Joineau / Place Anatole France -", 48.885154, 2.403975 },
	{ 33102, 10, "33102 - Jaures 1 (Pre Saint Gervais)", "Rue Gabriel Peri Angle Avenue Jaures -", 48.886653, 2.407575 },
	{ 33103, 10, "33103 - Jaures 2 (Pre Saint Gervais)", "34 Avenue Jean Jaures -", 48.884262, 2.408144 },
	{ 23008, 10, "23008 - Republique (Levallois)", "Place De La Republique -", 48.893152, 2.288910 },
	{ 23002, 10, "23002- France (Levallois)", "157 Anatole France -", 48.898262, 2.278982 },
	{ 23004, 10, "23004 - Couturier 2 (Levallois)", "109 Rue  Paul Vaillant Couturier -", 48.898295, 2.293404 },
	{ 23001, 10, "23001 - Couturier 1 (Levallois)", "2 Rue Paul Vaillant Couturier -", 48.893399, 2.277284 },
	{ 31706, 20, "31706 - Chateau (Bagnolet)", "Rue Du Chateau -", 48.863011, 2.415730 },
	{ 31705, 20, "31705 - Champeaux (Bagnolet)", "Rue Des Champeaux (Pres De La Gare Routiere) -", 48.864189, 2.415473 },
	{ 31707, 20, "31707 - Vaillant (Bagnolet)", "Face 70 Rue Edouard Vaillant -", 48.858617, 2.414947 },
	{ 22014, 10, "22014 - Hugo (Neuilly)", "35 Boulevard Victor Hugo -", 48.888699, 2.277725 },
	{ 22012, 10, "22012- Michelis (Neuilly)", "32 Rue De Madeleine Michelis -", 48.882821, 2.277473 },
	{ 22011, 10, "22011 - Montrosier (Neuilly)", "7 Rue Montrosier -", 48.879469, 2.278458 },
	{ 23003, 10, "23003 - Wilson (Levallois)", "132 Rue Du President Wilson -", 48.898291, 2.284612 },
	{ 42208, 20, "42208 - Paris 4 (Charenton)", "178 Rue De Paris -", 48.829263, 2.401304 },
	{ 34005, 10, "34005 - Lesenne (Saint Ouen)", "44 Rue Adrien Lesenne -", 48.902589, 2.348351 },
	{ 33011, 0, "33011 - Faure (Aubervilliers)", "Face 172-174 Boulevard Felix Faure -", 48.911463, 2.374872 },
	{ 42013, 20, "42013 - Barbes (Ivry)", "Rue Barbes / Avenue De Verdun -", 48.816998, 2.371442 },
	{ 34006, 10, "34006 - Michelet (Saint Ouen)", "92 Avenue Michelet -", 48.905636, 2.344262 },
	{ 33009, 10, "33009 - Felix (Aubervilliers)", "120 Boulevard Felix Faure -", 48.908173, 2.378619 },
	{ 33010, 0, "33010 - Hugo (Aubervilliers)", "161 Avenue Victor Hugo -", 48.911084, 2.379453 },
	{ 33007, 0, "33007 - Republique 1 (Aubervilliers)", "2 Avenue De La Republique Sur Chausse -", 48.913878, 2.382251 },
	{ 34002, 10, "34002 - Peri (Saint Ouen)", "128 Avenue Gabriel Peri / Avenue Du Capitaine Glamer -", 48.902554, 2.330779 },
	{ 34004, 10, "34004 - Voltaire (Saint Ouen)", "1 Rue Voltaire -", 48.902437, 2.342380 },
	{ 34008, 10, "34008- Garibaldi (Saint Ouen)", "Face Au 4 Avenue Garibaldi / Avenue Gabriel Peri -", 48.905843, 2.331270 },
	{ 42012, 13, "42012 - Barbusse (Ivry)", "1 Rue Henry Barbusse -", 48.810488, 2.379453 },
	{ 22002, 10, "22002 - Argenson (Neuilly)", "44 Boulevard D'Argenson -", 48.888080, 2.264833 },
	{ 22001, 10, "22001 - Chateau (Neuilly)", "26 Boulevard Du Chateau -", 48.890690, 2.270145 },
	{ 42201, 20, "42201 - Necker (Charenton)", "Rue Necker/ Rue Du Port Aux Lions -", 48.822685, 2.397933 },
	{ 42205, 20, "42205 - Paris 1 (Charenton)", "89 Rue De Paris -", 48.822587, 2.412184 },
	{ 21021, 13, "21021 - Paradis (Boulogne-Billancourt)", "Face Au 128 Rue Des Enfants Du Paradis -", 48.833234, 2.257259 },
	{ 42206, 20, "42206 - Paris 2 (Charenton)", "111 Rue De Paris -", 48.823937, 2.410076 },
	{ 42207, 20, "42207 - Paris 3 (Charenton)", "136 Rue De Paris -", 48.826168, 2.406540 },
	{ 21102, 10, "21102 - Nations Unies (Clichy)", "Place Des Nations Unies -", 48.896844, 2.309584 },
	{ 21104, 10, "21104 - Sanzillon (Clichy)", "64 Rue De Madame De Sanzillon -", 48.903864, 2.318469 },
	{ 42007, 20, "42007- General De Gaulle (Ivry)", "Place Du General De Gaulle -", 48.813088, 2.370569 },
	{ 42008, 20, "42008 - Casanova (Ivry)", "128 Avenue Daniel Casanova -", 48.814747, 2.384016 },
	{ 42015, 20, "42015 - Paul Bert (Ivry)", "En Vis A Vis Du 7 Rue Paul Bert -", 48.818040, 2.372464 },
	{ 21308, 13, "21308 - Lasserre (Issy Les Moulineaux)", "Face Au 27 Rue Lasserre -", 48.821174, 2.272998 },
	{ 22005, 10, "22005- De Gaulle 3 (Neuilly)", "195 Avenue Charles De Gaulle -", 48.884348, 2.260860 },
	{ 34010, 1, "34010 - Diderot 2 (Saint Ouen)", "Face 61-63 Rue Diderot-", 48.911109, 2.334419 },
	{ 34009, 10, "34009 - Maar (Saint Ouen)", "Rue Dora Maar / Gare Rer -", 48.905617, 2.321849 },
	{ 35008, 10, "35008 - Lolive 2 (Pantin)", "132 Rue Jean Lolive -", 48.892752, 2.411945 },
	{ 22013, 10, "22013 - Sainte Foy (Neuilly)", "Face Au 6 Avenue Sainte Foy -", 48.885206, 2.267645 },
	{ 42006, 20, "42006 - Brossolette (Ivry)", "23 Rue Pierre Brossolette -", 48.816797, 2.381595 },
	{ 22007, 10, "22007 - Charcot (Neuilly)", "35-37 Boulevard Du Commandant Charcot -", 48.875583, 2.256090 },
	{ 33005, 10, "33005 - Republique 2 (Aubervilliers)", "Face Au 106 Avenue De La Republique -", 48.907737, 2.388217 },
	{ 42204, 20, "42204 - Briand (Charenton)", "Avenue Jean Jaures / Place Aristide Briand -", 48.823117, 2.413601 },
	{ 35003, 10, "35003 - Vaillant (Pantin)", "Angle Rue General Gosserand Et Avenue Edouard Vaillant -", 48.904535, 2.395289 },
	{ 42203, 20, "42203 - Eluard (Charenton)", "Face Au 7 Rue Paul Eluard -", 48.820036, 2.409812 },
	{ 22008, 10, "22008 - De Gaulle (Neuilly)", "153 Bis Avenue Charles De Gaulle -", 48.883057, 2.264854 },
	{ 22009, 10, "22009 - De Gaulle 2 (Neuilly)", "101 Avenue Charles De Gaulle -", 48.881002, 2.271330 },
	{ 42016, 20, "42016 - Curie (Ivry)", "1 Bis Rue Pierre Et Marie Curie -", 48.815720, 2.376150 },
	{ 34001, 10, "34001 - Fructidor (Saint Ouen)", "Face 10 Rue Fructidor / Face Bat 2 Le Colysee -", 48.901106, 2.324414 },
	{ 42010, 13, "42010 - Robespierre (Ivry)", "1 Rue Robespierre -", 48.810945, 2.383835 },
	{ 42001, 20, "42001 - Jules (Ivry)", "1 Rue Jules Vanzuppe -", 48.820081, 2.393657 },
	{ 21103, 10, "21103 - Hugo (Clichy)", "94-98 Boulevard Victor Hugo -", 48.901546, 2.317488 },
	{ 42009, 13, "42009 - Verdun (Ivry)", "157-165 Avenue De Verdun -", 48.806759, 2.375504 },
	{ 21105, 10, "21105 - Morice (Clichy)", "35-37 Rue Morice -", 48.902686, 2.312867 },
	{ 21110, 10, "21110 - Villeneuve (Clichy)", "Face 51 Rue Villeneuve -", 48.905382, 2.310684 },
	{ 34003, 10, "34003 - Curie (Saint Ouen)", "2 Rue Neuve Pierre Curie -", 48.901412, 2.337187 },
	{ 22004, 10, "22004 - Charles De Gaulle (Neuilly)", "162 Avenue Charles De Gaulle -", 48.884601, 2.262017 },
	{ 22010, 10, "22010 - De Gaulle 4 (Neuilly)", "72, Avenue Charles De Gaulle -", 48.881712, 2.271601 },
	{ 22006, 10, "22006 - Pierret (Neuilly)", "33 Rue Pierret -", 48.882811, 2.260208 },
	{ 21106, 10, "21106 - Morice 2 (Clichy)", "2-4 Rue Morice -", 48.900915, 2.308519 },
	{ 31708, 20, "31708 - Noisy (Bagnolet)", "116-118 Rue De Noisy Le Sec -", 48.874614, 2.415148 },
	{ 34011, 1, "34011 - Dhalenne (Saint Ouen)", "Face Au 61 Rue Albert Dhalenne -", 48.915082, 2.331651 },
	{ 31703, 20, "31703 - Carnot (Bagnolet)", "177, Rue Sadi Carnot -", 48.875273, 2.423814 },
	{ 42014, 20, "42014 - Cachin (Ivry)", "Place Marcel Cachin -", 48.814168, 2.391010 },
	{ 21101, 10, "21101 - Valiton (Clichy)", "4 Rue De Valiton -", 48.902520, 2.297272 },
	{ 42005, 20, "42005 - Gambetta (Ivry)", "1, Place De Leon Gambetta -", 48.814504, 2.402115 },
	{ 22003, 10, "22003 - Bessfroy (Neuilly)", "3 Rue Bessfroy -", 48.886559, 2.261006 },
	{ 21112, 10, "21112 - Debussy (Clichy)", "31/35 Avenue Claude Debussy -", 48.910046, 2.309959 },
	{ 21108, 10, "21108 - Villeneuve 2 (Clichy)", "6-8 Rue Villeneuve -", 48.903161, 2.305232 },
	{ 21109, 10, "21109 - Guichet (Clichy)", "12Bis Rue Du Guichet -", 48.905308, 2.302314 },
	{ 31702, 20, "31702 - Curie (Bagnolet)", "40 Pierre Et Marie Curie -", 48.870519, 2.424065 },
	{ 21111, 10, "21111 - Leriche (Clichy)", "14 Rue Du Professeur Rene Leriche -", 48.908005, 2.307479 },
	{ 42002, 20, "42002 - Gare (Ivry)", "Vis-A-Vis Du 17 Rue De La Gare -", 48.814725, 2.392072 },
	{ 908, 10, "00908 - Porte De La Villette", "Porte De La Villette -", 48.898589, 2.386245 },
	{ 42011, 20, "42011 - Boyer (Ivry)", "26 Quai Marcel Boyer -", 48.822688, 2.392462 },
	{ 42003, 20, "42003 - Insurrection Aout 1944 (Ivry)", "2 Place De L'Insurrection Aout 1944 -", 48.814552, 2.397488 },
	{ 31002, 20, "31002 - Republique (Montreuil)", "38 Rue De La Republique -", 48.852916, 2.419351 },
	{ 42202, 20, "42202 - Ronsard (Charenton)", "1 Rue  Kennedy / Allee Ronsard -", 48.822834, 2.405665 },
	{ 31704, 20, "31704 - Hornet (Bagnolet)", "Face Au 1 Rue Jeanne Hornet -", 48.873940, 2.427886 },
	{ 31709, 20, "31709 - Marcel (Bagnolet)", "Face Au 184 Rue Etienne Marcel -", 48.857227, 2.422640 },
	{ 31701, 20, "31701 - Berton (Bagnolet)", "3 Rue Raoul Berton -", 48.868402, 2.417795 },
	{ 22405, 13, "22405 - Nord (Malakoff)", "Angle Passage Du Nord / Gabriel Peri -", 48.819424, 2.303120 },
	{ 31013, 20, "31013 - Centenaire (Montreuil)", "8 Rue Du Centenaire -", 48.857808, 2.427449 },
	{ 22403, 20, "22403 - Brossolette (Malakoff)", "Face 35 Avenue Pierre Brossolette -", 48.821431, 2.312252 },
	{ 22404, 20, "22404 - Brossolette 2 (Malakoff)", "102 Avenue Pierre Brossolette -", 48.817583, 2.307354 },
	{ 22401, 13, "22401 - De Gaulle (Malakoff)", "Boulevard Charles De Gaulle (Station De Metro) -", 48.822659, 2.298449 },
	{ 22402, 13, "22402 - Crie (Malakoff)", "40 Rue Gabriel Crie -", 48.821752, 2.301880 },
	{ 31003, 20, "31003 - Paris (Montreuil)", "237-241 Rue De Paris -", 48.854678, 2.418114 },
	{ 31006, 20, "31006 - Republique 2 (Montreuil)", "2/4 Place De La Republique -", 48.853460, 2.424268 },
	{ 31009, 20, "31009 - De Gaulle (Montreuil)", "13/15 Place Du General De Gaulle-", 48.867392, 2.434304 },
	{ 22406, 13, "22406 - Moquet (Malakoff)", "81 Rue Guy Moquet -", 48.815208, 2.297965 },
	{ 21107, 10, "21107 - Sincholle (Clichy)", "Rue Bertrand Sincholle -", 48.899548, 2.304199 },
	{ 42004, 20, "42004 - Couturier (Ivry)", "30, Rue Paul Vaillant Couturier -", 48.817985, 2.398091 },
	{ 31001, 20, "31001 - Lagny (Montreuil)", "96 Rue De Lagny -", 48.849256, 2.421592 },
	{ 21206, 20, "21206- Peri (Montrouge)", "35/37 Rue Gabriel Peri -", 48.818269, 2.321290 },
	{ 22407, 13, "22407 - Barbusse (Malakoff)", "Rond Point Henri Barbusse -", 48.814332, 2.287323 },
	{ 21202, 20, "21202- Barbes (Montrouge)", "16 Rue Barbes -", 48.817380, 2.327564 },
	{ 21113, 10, "21113 - Petit (Clichy)", "2, Rue Petit -", 48.899500, 2.296551 },
	{ 21203, 20, "21203 - Briand (Montrouge)", "Place Jules Ferry / Avenue Aristide Briand -", 48.812301, 2.325701 },
	{ 28002, 10, "28002 - Soljenitsyne (Puteaux)", "Rue Alexandre Soljenitsyne -", 48.884304, 2.248895 },
	{ 31004, 20, "31004 - Paris 2 (Montreuil)", "175/179 Rue De Paris -", 48.855340, 2.421997 },
	{ 21211, 20, "21211 - Marne (Montrouge)", "100 Avenue De La Marne -", 48.811974, 2.303560 },
	{ 28003, 10, "28003 - Jaures (Puteaux)", "152 Rue Jean Jaures -", 48.880808, 2.237754 },
	{ 32003, 10, "32003 - Metallurgie (Saint Denis)", "Avenue Du President Wilson / Rue De La Metallurgie -", 48.909400, 2.358796 },
	{ 21208, 20, "21208 - Carves (Montrouge)", "67 Rue Carves Angle Avenue Henri Ginoux -", 48.813137, 2.319972 },
	{ 35010, 10, "35010 - Gervais (Pantin)", "1-3 Rue Du Pre Saint Gervais -", 48.890996, 2.402961 },
	{ 32004, 0, "32004 - Bailly (Saint Denis)", "Avenue Du President Wilson/ Rue De Bailly -", 48.910613, 2.357583 },
	{ 21209, 20, "21209 - Georges Messier (Montrouge)", "35 Rue Moliere -", 48.811554, 2.313290 },
	{ 28001, 10, "28001 - Wallace (Puteaux)", "Face Au 4 Boulevard Richard Wallace -", 48.878763, 2.242514 },
	{ 21502, 10, "21502 - Verdun (Suresnes)", "18 Bis Rue De Verdun / Cour Madelaine -", 48.871201, 2.227418 },
	{ 32001, 10, "32001 - Proudhon (Saint Denis)", "Avenue President Wilson / Rue Proudhon -", 48.906632, 2.358877 },
	{ 21503, 10, "21503 - Ledru Rollin (Suresnes)", "13/15 Rue Ledru Rollin -", 48.870726, 2.229409 },
	{ 21501, 10, "21501 - Sellier (Suresnes)", "Rue De Saint Cloud / Boulevard Henri Sellier -", 48.867641, 2.226677 },
	{ 21204, 20, "21204 - D'Orves (Montrouge)", "Face 44 Rue D'Estiennes D'Orves / Piscine -", 48.815168, 2.320924 },
	{ 32006, 10, "32006 - Eglise Saint Juste (Saint Denis)", "Avenue Du President Wilson / Parking De L'Eglise Saint Juste -", 48.908770, 2.362109 },
	{ 21210, 20, "21210 - Peri 2 (Montrouge)", "8 Rue Gabriel Peri -", 48.817775, 2.324121 },
	{ 21207, 20, "21207 - Verdier (Montrouge)", "Avenue Verdier Angle Avenue De La Republique -", 48.815302, 2.317902 },
	{ 21201, 20, "21201 - Jaures (Montrouge)", "6 Place Jean Jaures / Rue Maurice Arnoux Et Rue Camille Pelletin -", 48.816101, 2.311329 },
	{ 31010, 20, "31010 - Stalingrad (Montreuil)", "67-69 Rue De Stalingrad -", 48.856832, 2.445031 },
	{ 41601, 20, "41601 - General De Gaulle (Saint Mande)", "86 Avenue Du General De Gaulle -", 48.838978, 2.417109 },
	{ 31012, 20, "31012 - Carnot (Montreuil)", "35/37 Rue Carnot -", 48.856017, 2.441515 },
	{ 31008, 20, "31008 - Vincennes (Montreuil)", "7 Bis Rue De Vincennes-", 48.857692, 2.437569 },
	{ 31011, 20, "31011 - Stalingrad 2 (Montreuil)", "27 Rue De Stalingrad-", 48.858999, 2.443210 },
	{ 31005, 20, "31005 - Paris 2  (Montreuil)", "127/129 Rue De Paris -", 48.856218, 2.426588 },
	{ 41605, 20, "41605 - General De Gaulle 2 (Saint Mande)", "120 Avenue General De Gaulle -", 48.836199, 2.418970 },
	{ 41604, 20, "41604 - Lagny (Saint Mande)", "126 Rue Lagny / Angle Avenue Joffre -", 48.849205, 2.418269 },
	{ 15125, 13, "15125 - Aquaboulevard", "2 Avenue De La Porte De Sevres / Aquaboulevard -", 48.836572, 2.278820 },
	{ 41602, 20, "41602 - Digeon (Saint Mande)", "Place Charles Digeon -", 48.843705, 2.417893 },
	{ 13514, 20, "13514 - Gare D'Austerlitz 2", "9 Boulevard De L'Hopital -", 48.841338, 2.363057 },
	{ 21007, 13, "21007 - Rhin Danube (Boulogne Billancourt)", "15 Rond Point Rhin Danube -", 48.840581, 2.228259 },
	{ 41202, 20, "41202 - Charmes (Fontenay Sous Bois)", "Angle Avenue Des Charmes / Avenue Foch -", 48.844535, 2.456294 },
	{ 21011, 13, "21011 - Silly (Boulogne Billancourt)", "153 Rue De Silly - Boulogne Billancourt", 48.833399, 2.237668 },
	{ 41302, 30, "41302 - Charles De Gaulle (Nogent)", "Face Au 60 Avenue Charles De Gaulles -", 48.836519, 2.480224 },
	{ 33013, 0, "33013 - Rechaussiere (Aubervilliers)", "52 Rue Leopold Rechaussiere - Aubervilliers", 48.913757, 2.391577 },
	{ 41603, 20, "41603 - Pasteur (Saint Mande)", "Avenue Pasteur/Avenue De Paris -", 48.845318, 2.423533 },
	{ 22101, 13, "22101 - Gare Routiere ( Saint Cloud)", "Gare Routiere - Arret Tram -", 48.843811, 2.222438 },
	{ 43008, 20, "43008 - Fontenay (Vincennes)", "12 Rue De Fontenay -", 48.847889, 2.445789 },
	{ 41201, 20, "41201 - De Ricard (Fontenay Sous Bois)", "Rue Louis-Xavier De Ricard -", 48.845422, 2.475837 },
	{ 41203, 20, "41203 - Stalingrad (Fontenay Sous Bois)", "14 Avenue Stalingrad -", 48.850261, 2.455163 },
	{ 43401, 20, "43401 - Gare Rer (Joinville)", "Parc Du Stationnement / Gare Rer -", 48.821492, 2.464081 },
	{ 13123, 20, "13123 - Bibliothèque François Mitterand", "53 Quai Francois Mauriac -", 48.834756, 2.376273 },
	{ 43006, 20, "43006 - Milimes (Vincennes)", "30 Avenue Des Milimes -", 48.841413, 2.430389 },
	{ 15126, 13, "15126 - Renan", "Rue Ernest Renan / Parc Des Expositions -", 48.832627, 2.279124 },
	{ 44101, 20, "44101 - Place Mongolfier (Saint Maurice)", "Place Montgolfier -", 48.814999, 2.459370 },
	{ 21205, 20, "21205 - Jaures 2 (Montrouge)", "Avenue Jean Jaures / Rue Roger Salengero -", 48.813943, 2.306689 },
	{ 41301, 20, "41301 - Clemanceau (Nogent)", "2 Rue Georges Clemenceau -", 48.836225, 2.470026 },
	{ 9003, 10, "09003 - Place Barbès", "Place Barbes -", 48.883680, 2.349056 },
//	{ 13151, 13, "13151 - Gare D'Austerlitz", "Gare D'Austerlitz -", 27.140973, -3.404561 },
//	{ 12151, 13, "12151 - Gare De Lyon", "Gare De Lyon", 27.140973, -3.404561 },
	{ 1009, 20, "01009 - Pont Neuf - 14", "14 Rue Du Pont Neuf -", 48.859999, 2.344283 },
	{ 6020, 20, "06020 - Saint Michel Danton", "2 Rue Danton -", 48.852728, 2.342784 },
	{ 6018, 20, "06018 - Michelet Assas", "13 Rue Michelet -", 48.842501, 2.334913 },
	{ 6017, 20, "06017 - Senat Conde", "34 Rue Conde -", 48.849358, 2.337813 },
	{ 6015, 20, "06015 - Mazet Saint Andre Des Arts", "10 Rue Andre Mazet -", 48.853609, 2.338916 },
	{ 6014, 20, "06014 - Pont De Lodi Dauphine", "7 Rue Du Pont De Lodi -", 48.855200, 2.340183 },
	{ 6013, 20, "06013 - Jacques Callot", "1 Rue Jacques Callot -", 48.855092, 2.337500 },
	{ 6012, 20, "06012 - Saint Germain Copeau", "141 Bd Saint Germain -", 48.853286, 2.334626 },
	{ 6010, 20, "06010 - Montparnasse Chevreuse", "5 Rue De Chevreuse -", 48.841647, 2.331577 },
	{ 6009, 20, "06009 - Guynemer Luxembourg", "26 Rue Guynemer -", 48.846796, 2.332434 },
	{ 6008, 20, "06008 - Assas Luxembourg", "90 Rue D'Assas -", 48.844001, 2.333102 },
	{ 6007, 20, "06007 - Vavin", "18 Rue Brea -", 48.842653, 2.329725 },
	{ 6006, 20, "06006 - Notre Dame Des Champs", "41 Rue Notre Dame Des Champs -", 48.844810, 2.329357 },
	{ 6005, 20, "06005 - Montparnasse", "40 Rue Du Montparnasse -", 48.843183, 2.326498 },
	{ 6004, 20, "06004 - Regard", "19 Rue Du Regard -", 48.847272, 2.326905 },
	{ 6003, 20, "06003 - Saint Sulpice", "15 Rue Du Vieux Colombier -", 48.851569, 2.330854 },
	{ 17032, 10, "17032 - Espace Champerret", "12 Rue Jean Oestreicher -", 48.885693, 2.287622 },
	{ 6001, 20, "06001 - Institut", "5 Quai Malaqais -", 48.857546, 2.335634 },
	{ 17030, 10, "17030 - Rennequin Pereire", "143 Boulevard De Pereire -", 48.883494, 2.295242 },
	{ 17028, 10, "17028 - Porte De Courcelle", "34 Boulevard De Reims -", 48.888527, 2.295988 },
	{ 17027, 10, "17027 - Pereire Levallois", "121 Boulevard Pereire -", 48.885130, 2.298321 },
	{ 17026, 10, "17026 - Wagram Courcelles", "105 Rue Jouffroy D'Abbans -", 48.881743, 2.301117 },
	{ 17025, 10, "17025 - Courcelles", "2 Rue De Chazelles -", 48.879236, 2.303421 },
	{ 17024, 10, "17024 - Villiers", "1/3 Place Prosper Goubaux -", 48.881288, 2.316488 },
	{ 17023, 10, "17023 - Avenue De La Porte D'Asnières", "22 Avenue De La Porte D'Asnieres -", 48.890812, 2.302991 },
	{ 17022, 10, "17022 - Place De Wagram", "67 Boulevard Pereire -", 48.887046, 2.304370 },
	{ 17021, 10, "17021 - Wagram (17Eme Arr.)", "Rue Jouffroy D'Abbans -", 48.884027, 2.305299 },
	{ 17020, 10, "17020 - Nicaragua", "49 Rue Jouffroy D'Abbans -", 48.885070, 2.307083 },
	{ 17019, 10, "17019 - Malesherbes", "20 Rue De Phalsbourg -", 48.882644, 2.309101 },
	{ 17018, 10, "17018 - Monceau", "4 Rue De Thann -", 48.880891, 2.309198 },
	{ 17017, 10, "17017 - Pont Cardinet", "167 Rue De Rome -", 48.887094, 2.314237 },
	{ 17015, 10, "17015 - Place De Levis", "19Bis/21 Rue Legendre -", 48.883508, 2.313080 },
	{ 17014, 10, "17014 - Porte De Clichy - Avenue De Clichy", "12 Avenue De La Porte De Clichy -", 48.895442, 2.311984 },
	{ 17013, 10, "17013 - Legendre", "62 Rue Legendre -", 48.885378, 2.316432 },
	{ 17011, 10, "17011 - Porte De Clichy Fragonard", "4 Rue Fragonard -", 48.894131, 2.314670 },
	{ 17010, 10, "17010 - Joncquiere", "90 Rue De La Jonquiere -", 48.894796, 2.318731 },
	{ 17009, 10, "17009 - Bodin Avenue De Clichy", "2 Rue Paul Bodin -", 48.892451, 2.317287 },
	{ 17008, 10, "17008 - Porche Pouchet", "7 Place Arnaud Tzanck -", 48.898733, 2.322478 },
	{ 17007, 10, "17007 - Navier", "Face 57 Rue Navier -", 48.895875, 2.322629 },
	{ 17006, 10, "17006 - Guy Mocquet Davy", "34 Rue Guy Mocquet -", 48.891975, 2.323230 },
	{ 17005, 10, "17005 - Brochant", "43 Rue Brochant -", 48.890195, 2.319946 },
	{ 17003, 10, "17003 - Jacques Kellner", "4-6 Rue Jacques Kellner -", 48.895840, 2.327809 },
	{ 17002, 10, "17002 - La Fourche Rue De La Condamine", "4 Rue De La Condamine -", 48.887868, 2.324390 },
	{ 17001, 10, "17001 - Guy Mocquet", "Rue Guy Mocquet -", 48.892775, 2.326869 },
	{ 18103, 10, "18103 - Charles Hermite", "Face 54 Rue Charles Hermite -", 48.898785, 2.364558 },
	{ 18101, 10, "18101 - Championnet", "32 Rue Championnet -", 48.895552, 2.349767 },
	{ 12028, 20, "12028 - Vivaldi", "42 Allee Vivaldi -", 48.841860, 2.389677 },
	{ 7024, 10, "07024 - Avenue Rapp", "43 Avenue Rapp -", 48.858016, 2.300534 },
	{ 7022, 10, "07022 - Pont De L'Alma", "3 Avenue Bosquet -", 48.861603, 2.302493 },
	{ 7021, 20, "07021 - Bosquet Saint Dominique", "37 Avenue Bosquet -", 48.858700, 2.303816 },
	{ 7020, 20, "07020 - Cler", "Face 3 Rue Du Champ De Mars -", 48.856778, 2.306609 },
	{ 7019, 20, "07019 - Ecole Militaire", "85 Avenue Bosquet -", 48.854647, 2.305576 },
	{ 7018, 20, "07018 - Segur Estrees", "23 Avenue De Segur -", 48.851278, 2.309759 },
	{ 7017, 20, "07017 - La Tour Maubourg", "1 Avenue De La Motte Picquet -", 48.856760, 2.309497 },
	{ 7016, 20, "07016 - Tour Maubourg Universite", "13 Rue Surcouf -", 48.861326, 2.309440 },
	{ 7015, 20, "07015 - Varenne", "9 Boulevard Des Invalides -", 48.856798, 2.315258 },
	{ 7014, 20, "07014 - Saint Francois Xavier", "35 Boulevard Des Invalides -", 48.851630, 2.314743 },
	{ 7012, 20, "07012 - Cite Vaneau", "7 Cite Vaneau -", 48.854291, 2.319468 },
	{ 7011, 20, "07011 - St Dominique", "30 Bis Rue Las Cases -", 48.859063, 2.318744 },
	{ 7010, 20, "07010 - Invalides", "Face 3 Rue De Constantine -", 48.860770, 2.314793 },
	{ 7009, 20, "07009 - Assemblee Nationale", "Face 119 Rue De Lille -", 48.861283, 2.320065 },
	{ 7008, 20, "07008 - Solferino", "10 Rue De Villersexel -", 48.858300, 2.323757 },
	{ 7007, 20, "07007 - Musée D'Orsay", "62 Rue De Lille -", 48.859747, 2.325799 },
	{ 7006, 20, "07006 - Quai Voltaire", "Quai Voltaire -", 48.859046, 2.331193 },
	{ 7005, 20, "07005 - Bac", "Face 2 Boulevard Raspail -", 48.855622, 2.325664 },
	{ 7004, 20, "07004 - Raspail Varenne", "Face 28 Boulevard Raspail -", 48.853177, 2.326359 },
	{ 18033, 10, "18033 - Moskowa", "111 Rue Belliard -", 48.896586, 2.338059 },
	{ 7002, 20, "07002 - Vaneau", "86 Rue Vaneau -", 48.848548, 2.320355 },
	{ 7001, 20, "07001 - Duroc", "63 Boulevard Des Invalides -", 48.847631, 2.316242 },
	{ 18030, 10, "18030 - Simplon", "1 Rue Joseph Dijon -", 48.893683, 2.347450 },
	{ 18029, 10, "18029 - Poteau", "1 Rue Emile Blemont -", 48.894510, 2.341194 },
	{ 18027, 10, "18027 - Damremont Ordener", "102 Rue Damremont -", 48.893351, 2.336519 },
	{ 18026, 10, "18026 - Ruisseau Ordener", "37 Rue Du Ruisseau -", 48.892875, 2.339981 },
	{ 18025, 10, "18025 - Mairie Du 18 Eme", "81 Rue Mont-Cenis -", 48.892722, 2.344342 },
	{ 18024, 10, "18024 - Clignancourt Marcadet", "105 Rue De Clignancourt -", 48.891427, 2.348662 },
	{ 18023, 10, "18023 - Poissonniers Ordener", "57 Rue Ordener -", 48.891103, 2.351238 },
	{ 18022, 10, "18022 - Barbes Marcadet", "57 Rue Marcadet -", 48.890385, 2.349207 },
	{ 18021, 10, "18021 - Marcadet - Ramey", "98 Rue Marcadet -", 48.891032, 2.344860 },
	{ 18020, 10, "18020 - Ruisseau", "31 Rue Francoeur -", 48.891014, 2.339817 },
	{ 18019, 10, "18019 - Montcalm", "2 Rue Montcalm -", 48.891751, 2.335224 },
	{ 18017, 10, "18017 - Pecqueur", "93 Rue Coulaincourt -", 48.889639, 2.338195 },
	{ 18016, 10, "18016 - Francoeur Caulaincourt", "1 Rue Francoeur -", 48.889891, 2.342556 },
	{ 18015, 10, "18015 - Custine", "23 Rue Custine -", 48.888632, 2.346672 },
	{ 18014, 10, "18014 - Doudeauville Leon", "26 Rue Leon -", 48.888362, 2.353622 },
	{ 18013, 10, "18013 - Chateau Rouge", "28 Rue Poulet -", 48.887527, 2.350283 },
	{ 18012, 10, "18012 - Doudeauville Stephenson", "51 Rue Stephenson -", 48.888748, 2.355926 },
	{ 18011, 10, "18011 - Herbert", "85 Rue Pajol -", 48.892890, 2.363437 },
	{ 18010, 10, "18010 - Marx Dormoy", "81 Rue Riquet -", 48.890077, 2.360315 },
	{ 18009, 10, "18009 - Lepine", "12 Rue Jean Francois Lepine -", 48.886106, 2.356770 },
	{ 18008, 10, "18008 - Square Leon", "Face 36 Rue Cave -", 48.886520, 2.353131 },
	{ 18007, 10, "18007 - Goutte D' Or", "65 Rue De La Goutte D'Or -", 48.885127, 2.349819 },
	{ 18006, 10, "18006 - Marche St-Pierre", "Place Saint Pierre -", 48.884453, 2.344450 },
	{ 18005, 10, "18005 - Tardieu", "8 Rue Tardieu -", 48.884112, 2.341656 },
	{ 18004, 10, "18004 - Abbesses", "2 Rue De La Vieuville -", 48.884454, 2.338863 },
	{ 18003, 10, "18003 - Joseph De Maistre Lepic", "2 Rue Joseph De Maistre -", 48.886368, 2.332744 },
	{ 18002, 10, "18002 - Clignancourt", "25 Rue De Clignancourt -", 48.885271, 2.347216 },
	{ 18001, 10, "18001 - Damremont Caulaincourt", "6 Rue Damremont -", 48.887015, 2.332689 },
	{ 14020, 20, "14020 - Porte De Montrouge", "Av. De La Porte De Montrouge -", 48.821217, 2.321058 },
	{ 14019, 20, "14019 - Sarette General Leclerc", "58 Rue Sarrette -", 48.824893, 2.326066 },
	{ 14018, 20, "14018 - Porte D'Orleans", "6 Place Du 25 Aout 1944 -", 48.822871, 2.325059 },
	{ 14017, 20, "14017 - Jourdan Tombe Issoire", "160 Rue Tombe Issoire -", 48.822287, 2.330286 },
	{ 14016, 20, "14016 - Reille Montsouris", "61 Avenue Rene Coty -", 48.824624, 2.336152 },
	{ 8057, 10, "08057 - Hoche", "62 Avenue Hoche -", 48.874894, 2.297552 },
	{ 8056, 10, "08056 - Wagram", "21 Rue Beaujon -", 48.875298, 2.296543 },
	{ 8055, 10, "08055 - Ternes Courcelles", "87 Bd Courcelles -", 48.878237, 2.299130 },
	{ 8053, 10, "08053 - Friedland", "Place Georges Guillaumin -", 48.874652, 2.301707 },
	{ 8052, 10, "08052 - Washington", "2 Rue Balzac -", 48.872540, 2.299774 },
	{ 8051, 10, "08051 - Chaptal", "45 Bd Batignolles -", 48.881828, 2.320330 },
	{ 8050, 20, "08050 - Boetie Ponthieu", "116 Rue De La Boetie -", 48.871535, 2.307473 },
	{ 8049, 10, "08049 - Dunant", "42 Avenue George V -", 48.870140, 2.300866 },
	{ 8048, 10, "08048 - Marceau", "45 Avenue Marceau -", 48.868773, 2.298442 },
	{ 8046, 10, "08046 - Alma Marceau", "2 Rue Marceau -", 48.865125, 2.300093 },
	{ 8045, 10, "08045 - Alma", "Face 3 Avenue Montaigne -", 48.864874, 2.302491 },
	{ 8044, 10, "08044 - Van Dyck", "2 Rue Alfred De Vigny -", 48.878212, 2.305329 },
	{ 8043, 20, "08043 - Hopital Beaujon", "177 Rue Faubourg Saint Honore -", 48.875031, 2.304923 },
	{ 8041, 10, "08041 - Champs Elysees Lincoln", "16 Rue De Lincoln -", 48.870851, 2.303399 },
	{ 8040, 20, "08040 - Champs Elysees Charron", "65 Rue Pierre Charron -", 48.870339, 2.304789 },
	{ 8039, 20, "08039 - Colisee", "6 Rue Du Colisee -", 48.870223, 2.307214 },
	{ 8038, 20, "08038 - Francois 1 Er", "22 Rue Francois 1Er -", 48.866880, 2.306494 },
	{ 8037, 10, "08037 - Malsherbes Monceau", "75 Rue De Monceau -", 48.879517, 2.314363 },
	{ 8036, 20, "08036 - Rio", "39 Rue De Lisbonne -", 48.877431, 2.309826 },
	{ 8035, 20, "08035 - Narvick", "54 Rue De La Bienfaisance -", 48.876596, 2.313056 },
	{ 8034, 20, "08034 - Haussmann Courcelles", "49 Rue De Berri -", 48.874879, 2.308424 },
	{ 8033, 20, "08033 - Saint Philippe Du Roule", "1 Rue Du Cdt Riviere -", 48.872713, 2.309720 },
	{ 8032, 20, "08032 - Matignon", "27 Avenue Matignon -", 48.871591, 2.313862 },
	{ 8031, 20, "08031 - Rond Point Des Champs Elysees", "2 Rue Jean Mermoz -", 48.869622, 2.310730 },
	{ 8029, 20, "08029 - Place Du Canada", "1 Avenue Franklin Roosevelt -", 48.865110, 2.310064 },
	{ 8028, 10, "08028 - Houssaye", "1 Rue Arsene Houssaye -", 48.873321, 2.297553 },
	{ 8027, 20, "08027 - Mairie Du 8 Ème", "28 Rue De Madrid -", 48.877927, 2.318356 },
	{ 8026, 20, "08026 - Messine", "2 Avenue Messine -", 48.875437, 2.315591 },
	{ 8025, 20, "08025 - Miromesnil", "39 Rue De Miromesnil -", 48.873784, 2.315823 },
	{ 8019, 10, "08019 - Europe", "03 Rue De Naples -", 48.879914, 2.321476 },
	{ 8018, 20, "08018 - Saint Augustin", "18 Place Henri Bergson -", 48.876220, 2.319773 },
	{ 8017, 20, "08017 - Rocher", "14 Rue Rocher -", 48.875987, 2.322826 },
	{ 8016, 20, "08016 - Square Louis Xvi", "Dev 32 Rue Pasquier -", 48.873192, 2.323698 },
	{ 8015, 20, "08015 - Roquepine", "4 Rue Roquepine -", 48.873506, 2.320469 },
	{ 8013, 20, "08013 - Marignan", "24 Rue De Marignan -", 48.869684, 2.306561 },
	{ 8011, 10, "08011 - Dublin", "1 Rue Clapeyron -", 48.880813, 2.324514 },
	{ 8010, 10, "08010 - Liege", "22 Rue De Liege -", 48.879564, 2.326585 },
	{ 8009, 20, "08009 - Saint Lazare Rer", "1 Rue De L'Isly -", 48.874729, 2.326627 },
	{ 9111, 20, "09111 - La Fayette Provence", "28 Rue De La Victoire -", 48.875170, 2.338168 },
	{ 8007, 20, "08007 - Haussmann Rome", "1 Rue De Rome -", 48.874145, 2.325687 },
	{ 8005, 20, "08005 - Madeleine", "04 Place De La Madeleine -", 48.869085, 2.324244 },
	{ 8004, 20, "08004 - Malesherbes Pasquier", "Face 4 Bd Malesherbes -", 48.870460, 2.323072 },
	{ 19032, 10, "19032 - Porte D'Aubervillier", "Face 4 Av De La Porte D'Aubervilliers -", 48.898972, 2.370965 },
	{ 8001, 20, "08001 - Petit Palais", "Av. Dutuit -", 48.866684, 2.315744 },
	{ 19029, 10, "19029 - Seine Flandre", "51 Quai De La Seine -", 48.886722, 2.374555 },
	{ 19028, 20, "19028 - Place Des Fetes", "17 Rue Des Fetes -", 48.876397, 2.392137 },
	{ 19027, 10, "19027 - Pre St Gervais Version 2", "Face 109 Boulevard Serurier -", 48.880538, 2.397960 },
	{ 19026, 10, "19026 - Danube", "53 Rue Miguel Hidalgo -", 48.881924, 2.392457 },
	{ 19025, 10, "19025 - Botzaris Version 2", "Face 80 Rue Botzaris -", 48.879517, 2.389034 },
	{ 19024, 20, "19024 - Buttes Chaumont", "28 / 30 Rue Botzaris -", 48.877786, 2.381443 },
	{ 19023, 20, "19023 - Manin Simon Bolivar", "Face 1 Rue Manin -", 48.876340, 2.379861 },
	{ 19022, 10, "19022 - Bolivar", "53 Rue De Meaux -", 48.881303, 2.373283 },
	{ 19021, 10, "19021 - Mairie Du 19 Eme", "4 Rue Armand Carrel -", 48.882522, 2.381365 },
	{ 16028, 10, "16028 - Millet - Jean De La Fontaine", "12 Rue Francois Millet -", 48.850949, 2.272362 },
	{ 19016, 10, "19016 - Ourcq", "78 Rue D'Hautpoul -", 48.886609, 2.386329 },
	{ 19015, 10, "19015 - Thionville", "24 Rue De Thionville -", 48.889154, 2.383551 },
	{ 19014, 10, "19014 - Lorraine", "28 Rue De Lorraine -", 48.886269, 2.383072 },
	{ 19013, 10, "19013 - Laumiere Et Laumiere Bis", "8 & 1 Rue Petit -", 48.884581, 2.380127 },
	{ 19012, 10, "19012 - Lally Tollendal", "5 Rue Lally Tollendal -", 48.882713, 2.374470 },
	{ 19011, 10, "19011 - Rouvet Dampierre Version 2", "2 Rue Rouvet -", 48.893261, 2.384972 },
	{ 19010, 10, "19010 - Porte De La Villette", "Rue Emile Reynaud Sur Tpc -", 48.901321, 2.387638 },
	{ 19007, 10, "19007 - Ourcq-Flandres", "139 Avenue De Flandre -", 48.892580, 2.379029 },
	{ 19005, 10, "19005 - Riquet", "56 Avenue De Flandre -", 48.887845, 2.373615 },
	{ 19003, 10, "19003 - Quai De Seine", "3 Quai De La Seine -", 48.884350, 2.369361 },
	{ 19002, 10, "19002 - Tanger", "45 & 48 Rue Riquet -", 48.889203, 2.370931 },
	{ 19001, 10, "19001 - Ourcq Crimee", "243 Rue De Crimee -", 48.893930, 2.373129 },
	{ 17049, 10, "17049 - Saussure", "116 Bis Rue De Saussure -", 48.888252, 2.310434 },
	{ 17048, 10, "17048 - Tocqueville", "12 Rue De Tocqueville -", 48.882366, 2.313980 },
	{ 17046, 10, "17046 - Mac Mahon", "18 Avenue Marc Mahon -", 48.877481, 2.294607 },
	{ 17045, 10, "17045 - Place Des Ternes - 5", "5 Place Des Ternes -", 48.878417, 2.297781 },
	{ 17042, 10, "17042 - Porte Maillot", "Face 279 Boulevard Pereire -", 48.877629, 2.283938 },
	{ 17041, 10, "17041 - Porte De Villiers", "51 Rue Guersant -", 48.882808, 2.287543 },
	{ 17040, 10, "17040 - Ternes Pereire", "227 Boulevard Pereire Sur Tpc -", 48.879707, 2.288459 },
	{ 17039, 10, "17039 - Place Saint Ferdinand", "26 Rue Saint Ferdinand -", 48.878180, 2.288488 },
	{ 17038, 10, "17038 - Argentine", "42 Avenue De La Grande Armee -", 48.876283, 2.288381 },
	{ 17037, 10, "17037 - Bayern Pereire", "40 Rue Bayen -", 48.881776, 2.292273 },
	{ 17033, 10, "17033 - Carnot", "8 Avenue Carnot -", 48.875485, 2.293709 },
	{ 17031, 10, "17031 - Porte De Champeret", "Place De La Porte De Champeret -", 48.885523, 2.290771 },
	{ 14012, 20, "14012 - Sibelle Alesia", "Face 2 Avenue De La Sibelle -", 48.826754, 2.338657 },
	{ 9038, 10, "09038 - Square Berlioz", "50 Bis Rue Douai -", 48.883204, 2.330782 },
	{ 9037, 10, "09037 - Clichy Parme", "01 Rue De Parme -", 48.881164, 2.328234 },
	{ 9036, 20, "09036 - Athenes Clichy", "4 Rue D'Athenes -", 48.878099, 2.329774 },
	{ 9035, 20, "09035 - Place De Budapest", "38 Rue De Londres -", 48.877677, 2.327267 },
	{ 9033, 20, "09033 - Havre Caumartin", "Face 45 Rue Caumartin -", 48.872887, 2.328358 },
	{ 9032, 20, "09032 - Mathurins", "12 Rue Des Mathurins -", 48.873066, 2.329094 },
	{ 9030, 20, "09030 - Victoir Chaussee D Antin", "79 Rue De La Victoire -", 48.875134, 2.332145 },
	{ 9029, 20, "09029 - Trinite", "62 Rue Saint Lazare -", 48.876841, 2.332867 },
	{ 9028, 10, "09028 - Moncey Blanche", "4 Rue Moncey -", 48.880104, 2.331041 },
	{ 9027, 10, "09027 - Fontaine Douai", "24 Rue De Douai -", 48.882395, 2.333180 },
	{ 9026, 10, "09026 - Bruyere Pigalle", "28 Rue J.B.Pigalle -", 48.879358, 2.333780 },
	{ 9025, 20, "09025 - Taitbout Châteaudun", "77 Rue Taitbout -", 48.876293, 2.335320 },
	{ 9024, 20, "09024 - Lafayette Taitbout", "27 Rue Taitbout -", 48.873345, 2.335293 },
	{ 18040, 10, "18040 - Chapelle Marx Dormoy", "12 Place De La Chapelle -", 48.884586, 2.360135 },
	{ 9022, 20, "09022 - Lafitte Rossini", "19 Rue Rossini -", 48.873327, 2.337909 },
	{ 9021, 20, "09021 - Saint Georges", "56 Rue Saint Georges -", 48.877920, 2.337459 },
	{ 9018, 10, "09018 - Place Pigalle", "05 Rue Duperre -", 48.882054, 2.336750 },
	{ 9017, 10, "09017 - Trudaine Martyrs", "01 Rue Lallier -", 48.881083, 2.340988 },
	{ 9016, 20, "09016 - Martyrs Choron", "24 Rue De Choron -", 48.877812, 2.339789 },
	{ 9015, 20, "09015 - Lamartine", "43 Rue Lamartine -", 48.876599, 2.339680 },
	{ 9014, 20, "09014 - Faubourg Montmartre", "55 Rue Du Faubourg Montmartre -", 48.875215, 2.340675 },
	{ 9013, 20, "09013 - Mairie Du 9Eme", "20 Rue De La Grange Bateliere -", 48.873318, 2.340770 },
	{ 20042, 20, "20042 - Pyrenees Ermitage", "300 Rue Des Pyrenees -", 48.872174, 2.391820 },
	{ 9011, 20, "09011 - Folies Bergeres", "14 Rue Geoffroy Marie -", 48.873956, 2.344544 },
	{ 9010, 20, "09010 - Cadet", "1/3 Rue De Rochechouart -", 48.876706, 2.344367 },
	{ 9009, 20, "09009 - Square Montholon", "26 Rue Montholon -", 48.876518, 2.345920 },
	{ 9008, 10, "09008 - Tour D'Auvergne", "24 Rue D'Auvergne -", 48.879034, 2.343645 },
	{ 9007, 10, "09007 - Condorcet", "34 Rue Condorcet -", 48.880059, 2.345226 },
	{ 9006, 10, "09006 - Trudainre Rochechouart", "81 Rue Dunkerque -", 48.881982, 2.346330 },
	{ 9005, 10, "09005 - Square D'Anvers", "95 Rue De Dunkerque -", 48.882620, 2.344749 },
	{ 9004, 10, "09004 - Rochechouart Gerando", "19 Rue Guerando -", 48.882925, 2.346289 },
	{ 20033, 20, "20033 - Etienne Dolet", "29 Rue Etienne Dollet -", 48.868204, 2.385671 },
	{ 9002, 10, "09002 - Maubeuge Condorcet", "19 Rue D'Abbeville -", 48.879178, 2.349246 },
	{ 9001, 20, "09001 - Poissonniere", "5 Rue De Bellefond -", 48.877461, 2.348659 },
	{ 20028, 20, "20028 - Gambetta Martin Nadaud", "Face 2 Rue Orfila -", 48.865117, 2.394346 },
	{ 20027, 20, "20027 - Porte De Menilmontant", "1 Rue Vidal De La Blache -", 48.869118, 2.409023 },
	{ 20026, 20, "20026 - Pelleport", "121 Avenue Gambetta -", 48.867873, 2.400915 },
	{ 20025, 20, "20025 - Gambetta Gatines", "13 Rue Des Gatines -", 48.865304, 2.397656 },
	{ 20023, 20, "20023 - Pelleport Belgrand", "44 Rue Pelleport -", 48.864843, 2.404004 },
	{ 20021, 20, "20021 - Prairie L Indre", "2 Rue De L'Indre -", 48.862623, 2.403388 },
	{0, 0, NULL, NULL, 0., 0.}
};


struct StationsPluginSimplePrivateParis : StationsPluginSimplePrivate {
  StationsPluginSimplePrivateParis() {
    rect = QRectF(QPointF(48.656667, 2.222438), QPointF(48.915363, 2.550987));
    center = QPointF(48.856667, 2.350987);
    statusUrl = "http://www.velib.paris.fr/service/stationdetails/%1";
    infosUrl = "http://www.velib.paris.fr/service/carto";
  }

  QList < Station * > fetchAll(StationsPlugin *plugin) {
    QList < Station * > list;

    for (int i = 0; stations[i].name; ++i) {
      Station *station = new Station(plugin);

      station->setId(stations[i].number);
      station->setName(QString::fromUtf8(stations[i].name));
      station->setDescription(QString::fromUtf8(stations[i].address));
      station->setPos(QPointF(stations[i].x, stations[i].y));
      station->setRegion(QString("Paris %1").arg(stations[i].arrondissementNumber));
      list.append(station);
    }

    return list;
  }

  QStringList regions() {
    QStringList ret;

    ret << "20";
    ret << "12";
    ret << "13";
    ret << "10";
    ret << "11";
    ret << "16";
    ret << "1";
    ret << "15";
    ret << "2";
    ret << "17";
    ret << "3";
    ret << "14";
    ret << "18";
    ret << "19";
    ret << "5";
    ret << "4";
    ret << "6";
    ret << "8";
    ret << "9";
    ret << "0";
    ret << "7";
    ret << "60";
    ret << "30";
    ret << "50";
    ret << "70";
    ret << "40";

    return ret;
  }
};

#endif /* STATIONS_SIMPLE_PRIVATE_PARIS_H */

