/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STATIONS_SIMPLE_PRIVATE_ROUEN_H
#define STATIONS_SIMPLE_PRIVATE_ROUEN_H

#include "stationspluginsimple_p.h"


static const struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        double x;
        double y;
} stations[] = {
	{ 9, 0, "09 - Republique - Quai Corneille", "Rue De La Republique", 49.437490, 1.096252 },
	{ 16, 0, "16-Ile Lacroix", "Avenue Jacques Chastellain - Parking De La Patinoire", 49.431503, 1.102871 },
	{ 1, 0, "01 - Theatre Des Arts", "Devant N°7 Bis Rue Jeanne D'Arc", 49.439344, 1.088713 },
	{ 10, 0, "10- Place Carnot", "Cours Clemenceau", 49.434041, 1.090275 },
	{ 4, 0, "04- Musee Des Beaux Arts", "Devant N° 39 Allee Eugene Delacroix", 49.444304, 1.094048 },
	{ 12, 0, "12- Place Des Cotonniers", "Place Des Cotonniers", 49.431249, 1.083497 },
	{ 6, 0, "06- Chu - Rue De Germont", "Devant N° 6 Rue Edouard Adam", 49.441201, 1.105986 },
	{ 5, 0, "05- Hotel De Ville", "Rue De L Hopital", 49.442506, 1.098266 },
	{ 14, 0, "14- Balzac - Boulevard De L' Europe", "Boulevard De L' Europe", 49.425823, 1.087913 },
	{ 15, 0, "15-Gare", "Rue Jeanne D'Arc Angle Rue De La Rochefoucauld", 49.448208, 1.093637 },
	{ 11, 0, "11- Clemenceau Joffre", "Cours Clemenceau", 49.434646, 1.087959 },
	{ 3, 0, "03- Vieux Marche", "Place Du Vieux Marche", 49.443535, 1.089231 },
	{ 2, 0, "02- Pasteur - Fac De Droit", "Avenue Pasteur", 49.444220, 1.078164 },
	{ 17, 0, "17- Saint Clement", "Rue Lecuyer Angle Rue Lethuillier Pinel", 49.425874, 1.076425 },
	{ 13, 0, "13- Saint Sever", "Place Saint Sever", 49.430881, 1.086095 },
	{ 7, 0, "07- Chu - Boulevard Gambetta", "Rue D' Amiens", 49.438204, 1.105396 },
	{ 8, 0, "08- Saint Marc", "Rue Armand Carrel", 49.438047, 1.100675 },
	{0, 0, NULL, NULL, 0., 0.}
};


struct StationsPluginSimplePrivateRouen : StationsPluginSimplePrivate {
  StationsPluginSimplePrivateRouen() {
    rect = QRectF(QPointF(49.242367, 1.076425), QPointF(49.448208, 1.298492));
    center = QPointF(49.442367, 1.098492);
    statusUrl = "http://cyclic.rouen.fr/service/stationdetails/%1";
    infosUrl = "http://cyclic.rouen.fr/service/carto";
  }

  QList < Station * > fetchAll(StationsPlugin *plugin) {
    QList < Station * > list;

    for (int i = 0; stations[i].name; ++i) {
      Station *station = new Station(plugin);

      station->setId(stations[i].number);
      station->setName(QString::fromUtf8(stations[i].name));
      station->setDescription(QString::fromUtf8(stations[i].address));
      station->setPos(QPointF(stations[i].x, stations[i].y));
      station->setRegion(QString("Rouen %1").arg(stations[i].arrondissementNumber));
      list.append(station);
    }

    return list;
  }

  QStringList regions() {
    QStringList ret;

    ret << "0";

    return ret;
  }
};

#endif /* STATIONS_SIMPLE_PRIVATE_ROUEN_H */

