/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef STATIONS_SIMPLE_PRIVATE_LYON_H
#define STATIONS_SIMPLE_PRIVATE_LYON_H

#include "stationspluginsimple_p.h"


static const struct {
        int number;
        int arrondissementNumber;
        const char *name;
        const char *address;
        double x;
        double y;
} stations[] = {
	{ 1001, 69381, "1001 - Terreaux / Terme", "Angle Rue D'Algérie", 45.767651, 4.832158 },
	{ 1002, 69381, "1002 - Opéra", "Angle Rue Serlin - Angle Place De La Comédie", 45.767512, 4.836279 },
	{ 1003, 69381, "1003 - Place Sathonay", "Angle Nord-Ouest De La Place", 45.769271, 4.830077 },
	{ 1005, 69381, "1005 - Meissonnier", "Place Meissonier - Angle Sud-Est De La Place", 45.766087, 4.832790 },
	{ 1012, 69381, "1012 - Ampère / Bourse", "Rue De La Bourse - Long Du Collège-Lycée Ampère", 45.765816, 4.836893 },
	{ 1013, 69381, "1013 - Martinière", "Rue De La Martinière", 45.768213, 4.827590 },
	{ 1016, 69381, "1016 - Pêcherie", "Rue De La Platière - Angle Quai De La Pêcherie", 45.765942, 4.831246 },
	{ 1020, 69381, "1020 - Terreaux / Chenavard", "Rue Chenavard - Côté Place Des Terreaux", 45.766892, 4.832908 },
	{ 1021, 69381, "1021 - Terreaux / Beaux Arts", "Rue Herriot - Devant Musée Des Beaux Arts", 45.766920, 4.834285 },
	{ 1022, 69381, "1022 - Place Tolozan", "Place Tolozan - Angle Nord-Est De La Place", 45.769609, 4.837655 },
	{ 1023, 69381, "1023 - Croix Rousse / Perfetti", "Face Au N°23 Bd De La Croix-Rousse", 45.772290, 4.819486 },
	{ 1024, 69381, "1024 - Rouville", "Rue De L'Annonciade, Devant Le Lycée Diderot", 45.769668, 4.824632 },
	{ 1031, 69381, "1031 - Place De La Paix", "Place De La Paix - En Face De La Poste", 45.768040, 4.831725 },
	{ 1032, 69381, "1032 - Pizay", "17 Rue Pizay, À L'Est De La Rue De La République", 45.767205, 4.836388 },
	{ 1034, 69381, "1034 - Carmélites / Burdeau", "Face Au N°30 Montée Des Carmélites", 45.770072, 4.829220 },
	{ 1036, 69381, "1036 - Aveyron", "44 Bd De La Croix-Rousse", 45.774322, 4.832606 },
	{ 1006, 69381, "1006 - Subsistances", "En Face Du N°14 Quai Saint-Vincent", 45.767901, 4.819813 },
	{ 1035, 69381, "1035 - Quai Lassagne", "3 Quai André Lassagne", 45.772206, 4.837909 },
	{ 2001, 69382, "2001 - Bellecour / République", "Angle République / Rue De La Barre", 45.757967, 4.834633 },
	{ 2002, 69382, "2002 - Bellecour / St Exupéry", "Côté Rue Lintier", 45.758267, 4.830436 },
	{ 2003, 69382, "2003 - Place Ampère", "Angle Henry Iv", 45.753048, 4.828264 },
	{ 2004, 69382, "2004 - Perrache / Carnot", "Côté Ouest", 45.750224, 4.826882 },
	{ 2006, 69382, "2006 - Place De L'Hippodrome", "Angle Cours Charlemagne", 45.745586, 4.823529 },
	{ 2007, 69382, "2007 - Patinoire Charlemagne", "Angle Rue Casimir Périer", 45.742619, 4.820482 },
	{ 2008, 69382, "2008 - Place Antonin Poncet", "Côté Rue Des Marroniers", 45.756771, 4.833838 },
	{ 2011, 69382, "2011 - Sala / Rue De Plat", "Face À La Faculté Catholique", 45.756813, 4.828371 },
	{ 2012, 69382, "2012 - Gailleton", "4 Place Gailleton", 45.753460, 4.833351 },
	{ 2013, 69382, "2013 - Célestins", "Côté Nord De La Place, Vers L'Ascenseur", 45.759959, 4.831988 },
	{ 2014, 69382, "2014 - Jacobins", "6 Rue Jean De Tournes, Angle Rue Edouard Herriot", 45.760751, 4.834285 },
	{ 2015, 69382, "2015 - Place De La République", "Côté Est De La Place", 45.760917, 4.836170 },
	{ 2016, 69382, "2016 - Place Regaud", "Angle Rue Tupin / Rue Herriot", 45.763082, 4.834283 },
	{ 2017, 69382, "2017 - République / Ferrandière", "Rue De La République", 45.762195, 4.835957 },
	{ 2022, 69382, "2022 - Place Carnot", "Angle Rue Plessier", 45.751170, 4.826852 },
	{ 2023, 69382, "2023 - Hugo / Ste Hélène", "Entre Rue Victor Hugo Et Rue D'Auvergne", 45.754681, 4.829889 },
	{ 2024, 69382, "2024 - République / Maupin", "Entre Herriot Et République", 45.758744, 4.834073 },
	{ 2025, 69382, "2025 - Mercière / Ferrandière", "Entre Rue De Brest Et Rue Mercière", 45.762060, 4.833203 },
	{ 2026, 69382, "2026 - République / Paufique", "Angle Rue De La République", 45.759386, 4.835396 },
	{ 2028, 69382, "2028 - Sainte Blandine", "Face Station Tram Sainte Blandine", 45.744427, 4.822140 },
	{ 2030, 69382, "2030 - République / Poulaillerie", "Angle Poulaillerie / République", 45.764077, 4.835522 },
	{ 2035, 69382, "2035 - Childebert / République", "Rue Marcel Gabriel Rivière", 45.759884, 4.835754 },
	{ 2036, 69382, "2036 - Place Gourjus", "11 Place Gourjus", 45.759475, 4.830141 },
	{ 2037, 69382, "2037 - Place Des Archives", "18 Rue Dugas Montbel", 45.747910, 4.824907 },
	{ 2038, 69382, "2038 - Hugo / Ainay", "16 Rue Des Remparts D'Ainay, Angle Rue Victor Hugo", 45.753095, 4.829562 },
	{ 2039, 69382, "2039 - Charité / Récamier", "Rue De La Charité, Angle Du Cours Verdun Récamier", 45.749225, 4.829861 },
	{ 2040, 69382, "2040 - Quai Saint Antoine", "Face Au N°10 Quai Saint Antoine, Angle Pont Maréchal Juin", 45.763578, 4.831899 },
	{ 2041, 69382, "2041 - Sala / Charité", "Face Au N°52 Rue Sala", 45.754478, 4.833008 },
	{ 2042, 69382, "2042 - Joffre / Vaubecour", "", 45.751799, 4.824684 },
	{ 3001, 69383, "3001 - Part-Dieu / Vivier Merle", "Derrière La Station De Tram", 45.760285, 4.858587 },
	{ 3002, 69383, "3002 - Part-Dieu / Gare Sncf", "", 45.760187, 4.858728 },
	{ 3003, 69383, "3003 - Part-Dieu / Deruelle", "Face Rue Masséna, Entrée Centre Commercial", 45.763025, 4.854981 },
	{ 3004, 69383, "3004 - Bourse Du Travail", "Angle Rue Moncey / Part-Dieu", 45.759659, 4.848063 },
	{ 3005, 69383, "3005 - Saxe-Gambetta", "Place Victor Basch", 45.753791, 4.848039 },
	{ 3007, 69383, "3007 - Place D'Arsonval", "A Côté Du Stand De Fleurs", 45.743447, 4.878900 },
	{ 3008, 69383, "3008 - Institut Lumière", "Place Ambroise Courtois", 45.745814, 4.870684 },
	{ 3009, 69383, "3009 - Musée Africain", "133 Cours Gambetta", 45.750258, 4.857922 },
	{ 3010, 69383, "3010 - Part-Dieu / Cuirassiers", "Angle Rue Bouchut", 45.759452, 4.855920 },
	{ 3012, 69383, "3012 - Place Du Château", "A Côté De L'Église", 45.749547, 4.887267 },
	{ 3013, 69383, "3013 - Place Antoinette", "Place Antoinette", 45.753633, 4.889021 },
	{ 3015, 69383, "3015 - Servient / Garibaldi", "Angle Rue Garibaldi", 45.760782, 4.852507 },
	{ 3016, 69383, "3016 - Liberté / Part-Dieu", "Angle Rue De La Part-Dieu", 45.759347, 4.842224 },
	{ 3018, 69383, "3018 - Créqui / Voltaire", "Angle Rue Paul Bert", 45.756704, 4.848402 },
	{ 3021, 69383, "3021 - Place De La Ferrandière", "Intersection Ferrandière/Jasseron", 45.759651, 4.869757 },
	{ 3024, 69383, "3024 - Rockefeller / Esquirol", "Intersection Rockefeller / Esquirol", 45.741428, 4.885374 },
	{ 3029, 69383, "3029 - Place Aristide Briand", "Angle Gambetta", 45.753009, 4.850244 },
	{ 3031, 69383, "3031 - Corneille / Servient", "Angle Rue Servient", 45.759935, 4.844513 },
	{ 3032, 69383, "3032 - Lafayette / Créqui", "Angle Cours Lafayette", 45.763463, 4.847121 },
	{ 3037, 69383, "3037 - Paul Bert / Garibaldi", "Rue Paul Bert", 45.757128, 4.853469 },
	{ 3038, 69383, "3038 - Vivier Merle / Paul Bert", "Devant Le Bâtiment De La Cafal", 45.757231, 4.858929 },
	{ 3039, 69383, "3039 - Place Bir-Hakeim", "Au Niveau De La Rue Duvivier", 45.752597, 4.855707 },
	{ 3043, 69383, "3043 - Place Rouget De L'Isle", "Avenue Lacassagne", 45.754014, 4.867227 },
	{ 3044, 69383, "3044 - Quai Augagneur", "Entre Rue De Bonnel Et Rue Rabelais", 45.761970, 4.841050 },
	{ 3051, 69383, "3051 - Place Henri", "Angle Rue Docteur Long/Av. Lacassagne", 45.748171, 4.880560 },
	{ 3053, 69383, "3053 - Gambetta / Jusserand", "Angle Cours Gambetta", 45.751136, 4.855580 },
	{ 3058, 69383, "3058 - Place Du Lac", "Face À La Poste", 45.758820, 4.853878 },
	{ 3066, 69383, "3066 - Kimmerling / Faure", "Angle Avenue Félix Faure / Rue Jean-Pierre Lévy", 45.754268, 4.863463 },
	{ 3067, 69383, "3067 - Hachette", "Devant N°2 Rue Renoir", 45.752897, 4.863958 },
	{ 3071, 69383, "3071 - Bioparc", "Avenue Rockfeller, Angle Rue Eugénie", 45.740436, 4.888206 },
	{ 3079, 69383, "3079 - Place Louise", "Face Au N°4 Place Louise", 45.751210, 4.884817 },
	{ 3080, 69383, "3080 - Part-Dieu / Villette", "", 45.760124, 4.861752 },
	{ 3082, 69383, "3082 - Place Bahadourian", "", 45.757591, 4.845109 },
	{ 3083, 69383, "3083 - Les Halles", "183 Rue André Philip", 45.761524, 4.850483 },
	{ 3084, 69383, "3084 - Desaix", "Face À La Maison De L'Enfance", 45.757266, 4.855198 },
	{ 3085, 69383, "3085 - Sacré Coeur", "Au Niveau Du N°66 Rue Charrial", 45.757835, 4.868392 },
	{ 3086, 69383, "3086 - Feuillat / Lacassagne", "Face Au N°115 Avenue Lacassagne", 45.749552, 4.876019 },
	{ 3087, 69383, "3087 - Part-Dieu / Garibaldi", "Face Au N°4 Bd Eugène Deruelle", 45.762805, 4.852296 },
	{ 3088, 69383, "3088 - Place Guichard", "Face Au N°51 Rue Moncey", 45.758830, 4.846535 },
	{ 3089, 69383, "3089 - Trarieux / Lacassagne", "221 Avenue Lacassagne", 45.745319, 4.888961 },
	{ 3090, 69383, "3090 - Vinatier", "Angle Bd Pinel / Avenue D'Esquirol, Devant Entrée Du Vinatier", 45.741925, 4.893496 },
	{ 3091, 69383, "3091 - Hôpital Neurologique", "59 Bd Pinel", 45.748188, 4.896954 },
	{ 3094, 69383, "3094 - Villette / Paul Bert", "74 Rue De La Villette", 45.757784, 4.861691 },
	{ 3097, 69383, "3097 - Augagneur / Fosse Aux Ours", "Angle Quai Augagneur / Pont De La Guillotière", 45.757202, 4.840370 },
	{ 3099, 69383, "3099 - Place Sainte Anne", "230 Rue Paul Bert", 45.756960, 4.865438 },
	{ 3100, 69383, "3100 - Sisley / Dauphiné", "Face Au N°4 Rue Paul Sisley", 45.752822, 4.868796 },
	{ 3101, 69383, "3101 - Patinoire Baraban", "52 Rue Baraban", 45.762517, 4.868595 },
	{ 3102, 69383, "3102 - Dr Long / Aubépins", "2 Rue De La Caille", 45.752568, 4.894251 },
	{ 3103, 69383, "3103 - Place Danton", "4 Place Danton", 45.754839, 4.857543 },
	{ 4001, 69384, "4001 - Conservatoire", "Au Sud Du N°1 Quai Joseph Gillet", 45.770373, 4.814242 },
	{ 4002, 69384, "4002 - Mairie Du 4°", "Devant La Mairie Du 4°", 45.774205, 4.827762 },
	{ 4003, 69384, "4003 - Place Commandant  Arnaud", "Angle Rue De Belfort", 45.779718, 4.834784 },
	{ 4004, 69384, "4004 - Hénon", "Angle Rue Hénon", 45.779690, 4.827627 },
	{ 4005, 69384, "4005 - Place Bertone", "Rue Du Chariot D'Or", 45.777648, 4.834692 },
	{ 4006, 69384, "4006 - Philippe De Lasalle", "Angle Rue Anselme, Face À L'Iufm", 45.773299, 4.821309 },
	{ 4007, 69384, "4007 - Place Flammarion", "Côté Rue Philippe De Lassalle", 45.779295, 4.820242 },
	{ 4009, 69384, "4009 - Jacquard / Denfert-Rochereau", "Rue Denfert-Rochereau / Angle Rue Jacquart", 45.775928, 4.825419 },
	{ 4011, 69384, "4011 - Place Jean Ambre", "Place Jean Ambre", 45.781497, 4.832837 },
	{ 4012, 69384, "4012 - Place Adrien Godien", "Angle Montée De La Boucle", 45.779176, 4.840947 },
	{ 4014, 69384, "4014 - Philippe De Lassalle / Pillement", "Angle Rue Pillement", 45.777415, 4.820489 },
	{ 4017, 69384, "4017 - Place Des Tapis", "Angle Bvd De La Croix-Rousse", 45.776098, 4.829472 },
	{ 4021, 69384, "4021 - Tabareau", "Angle Bvd De La Croix-Rousse", 45.774051, 4.825189 },
	{ 4022, 69384, "4022 - Place De La Croix-Rousse", "Prox. Grande Rue De La Croix-Rousse", 45.776068, 4.832498 },
	{ 4023, 69384, "4023 - Pont Mazaryk", "Face Au 45 Quai Gillet", 45.778229, 4.810643 },
	{ 4025, 69384, "4025 - Parc Cerisaie", "Rue Chazière", 45.775385, 4.817867 },
	{ 4041, 69384, "4041 - Boussange / Austerlitz", "1Bis Rue Aimé Boussange", 45.775507, 4.835059 },
	{ 4042, 69384, "4042 - Stade Grégory Coupet", "63 Rue Philippe De Lassalle", 45.781795, 4.820602 },
	{ 5001, 69385, "5001 - Place Varillon (Funiculaire St Just)", "Devant Le N°63 Rue De Trion", 45.757201, 4.815302 },
	{ 5002, 69385, "5002 - Place Des Compagnons De La Chanson", "Angle Rue Des Aqueducs", 45.756480, 4.796687 },
	{ 5004, 69385, "5004 - St Jean", "Entre La Cathédrale Et Le Funiculaire", 45.760489, 4.826562 },
	{ 5005, 69385, "5005 - Saint Paul", "Près De La Gare De St Paul", 45.766262, 4.827360 },
	{ 5006, 69385, "5006 - Quai Romain Rolland", "Face Ancien Palais De Justice", 45.762069, 4.828835 },
	{ 5007, 69385, "5007 - Place De Trion", "Place De Trion", 45.757931, 4.813182 },
	{ 5008, 69385, "5008 - Sainte Irénée", "Place Sainte Irénée", 45.755441, 4.812724 },
	{ 5009, 69385, "5009 - Place Fousseret", "Angle Quai De Bondy", 45.764691, 4.828942 },
	{ 5015, 69385, "5015 - Fulchiron", "Devant Le N°41 Rue De La Quarantaine", 45.752006, 4.821659 },
	{ 5016, 69385, "5016 - Mairie Du 5°", "Devant La Mairie Du 5°", 45.757570, 4.800959 },
	{ 5026, 69385, "5026 - Rue De La Baleine", "Angle Quai Romain Rolland", 45.763469, 4.828961 },
	{ 5029, 69385, "5029 - Place Gerson", "Prox. Quai Pierre Scize", 45.767049, 4.826981 },
	{ 5030, 69385, "5030 - Charcot / Résidence Universitaire", "Angle Rue Du Fort Ste Irénée / Charcot", 45.754803, 4.807370 },
	{ 5033, 69385, "5033 - César Geoffray", "", 45.749997, 4.784099 },
	{ 5036, 69385, "5036 - La Salette", "Rue Du Commandant Charcot", 45.749691, 4.795607 },
	{ 5040, 69385, "5040 - Place Crépu", "127 Quai Fulchiron", 45.757879, 4.826220 },
	{ 5041, 69385, "5041 - L'Homme De La Roche", "55 Quai Pierre Scize", 45.766558, 4.820006 },
	{ 5044, 69385, "5044 - Champvert", "85 Rue Du Docteur Locard", 45.759802, 4.796624 },
	{ 5045, 69385, "5045 - Valdo / Rivet", "Rue Jeunet", 45.750486, 4.788771 },
	{ 5047, 69385, "5047 - Albéric Pont", "2Bis Rue Du Docteur Albéric Pont", 45.753447, 4.804456 },
	{ 5050, 69385, "5050 - Théâtres Romains", "50 Rue De L'Antiquaille", 45.758367, 4.821083 },
	{ 5053, 69385, "5053 - Saint Just", "Face Au N°8 Rue De Trion", 45.756087, 4.819311 },
	{ 5054, 69385, "5054 - Champvert", "192 Avenue Barthélémy Buyer", 45.763902, 4.792711 },
	{ 5055, 69385, "5055 - Buyer / Apollinaire", "150M À L'Ouest Du 101 Avenue Barthélémy Buyer", 45.761803, 4.803058 },
	{ 5031, 69385, "5031 - Ménival / Joliot Curie", "Rue Joliot Curie", 45.754666, 4.788242 },
	{ 5049, 69385, "5049 - Lycée Branly", "Rue Mère Elisabeth Rivet", 45.753316, 4.792850 },
	{ 6002, 69386, "6002 - Porte Des Enfants Du Rhône", "Le Long Des Grilles, Côté Ouest De La Porte", 45.777384, 4.844878 },
	{ 6003, 69386, "6003 - Avenue Verguin", "Devant L'Entrée Du Parc", 45.772916, 4.856324 },
	{ 6004, 69386, "6004 - Foch", "Angle Rue Vendôme", 45.768856, 4.844762 },
	{ 6005, 69386, "6005 - Place Edgar Quinet", "Devant Le Lycée", 45.765771, 4.844729 },
	{ 6006, 69386, "6006 - Boulevard Des Belges", "Boulevard Des Belges - Angle Rue Duquesne", 45.773325, 4.851827 },
	{ 6007, 69386, "6007 - Masséna", "Angle Cours Vitton", 45.769621, 4.852406 },
	{ 6008, 69386, "6008 - Gare Des Brotteaux", "Place Jules Ferry, À L'Angle Rue Des Emeraudes Et Rue Curie", 45.768417, 4.859067 },
	{ 6011, 69386, "6011 - Mairie Du 6°", "Angle Rue Boileau", 45.768404, 4.849496 },
	{ 6012, 69386, "6012 - Place Puvis De Chavannes", "Angle Rue Vendôme", 45.771777, 4.844580 },
	{ 6016, 69386, "6016 - Viabert / Thiers", "Angle Avenue Thiers", 45.765993, 4.862089 },
	{ 6020, 69386, "6020 - Musée Guimet", "Angle Rue Morellet", 45.774532, 4.848379 },
	{ 6021, 69386, "6021 - Garibaldi", "Entre Rue Crillon Et Rue Sully", 45.770861, 4.849968 },
	{ 6022, 69386, "6022 - Place Maréchal Lyautey", "Pierre Corneille/Cours Franklin Roosevelt", 45.768835, 4.842536 },
	{ 6023, 69386, "6023 - Quai Sarail", "Niveau Rue De Sèze", 45.766835, 4.841136 },
	{ 6024, 69386, "6024 - Tronchet / Anatole France", "Angle Bvd Anatole France", 45.770738, 4.856776 },
	{ 6028, 69386, "6028 - Recammier / Tête D'Or", "Angle Rue Tête D'Or", 45.764353, 4.853428 },
	{ 6031, 69386, "6031 - Lafayette / Corneille", "Angle Cours Lafayette", 45.763755, 4.843739 },
	{ 6032, 69386, "6032 - Préfecture / Sarrail", "Angle Rue Vauban", 45.764794, 4.841613 },
	{ 6035, 69386, "6035 - Cité Internationale", "Face Parvis Du Palais Des Congrès", 45.785427, 4.854121 },
	{ 6036, 69386, "6036 - Musée D'Art Contemporain", "Allée Achille Lignon", 45.783936, 4.852451 },
	{ 6037, 69386, "6037 - Cité Internationale / Interpol", "Allée Achille Lignon", 45.782311, 4.849341 },
	{ 6040, 69386, "6040 - Les Halles", "A Proximité De La Place De L'Europe", 45.764160, 4.849868 },
	{ 6041, 69386, "6041 - Cité Internationale / Tête D'Or Nord", "Allée Achille Lignon", 45.784616, 4.859636 },
	{ 6042, 69386, "6042 - Cité Internationale / Résidence Hôtelière", "Allée Achille Lignon", 45.784861, 4.855612 },
	{ 6043, 69386, "6043 - Cité Internationale / Cinéma", "", 45.784741, 4.852212 },
	{ 6044, 69386, "6044 - Charmettes / Bellecombe", "Angle Rue De La Viabert / Rue Sainte-Geneviève", 45.766375, 4.865081 },
	{ 6045, 69386, "6045 - Brotteaux / Vauban", "44 Bd Des Brotteaux", 45.766301, 4.856830 },
	{ 6001, 69386, "6001 - Gare Des Brotteaux", "Place Jules Ferry", 45.766855, 4.858973 },
	{ 7001, 69387, "7001 - Place Gabriel Péri", "Place Gabriel Péri", 45.754872, 4.843735 },
	{ 7002, 69387, "7002 - Universités Lyon Iii / Lyon Ii", "Quai Claude Bernard", 45.751336, 4.836350 },
	{ 7003, 69387, "7003 - Gambetta / Garibaldi", "Cours Gambette - Prolongement Rue Rachais", 45.751807, 4.852531 },
	{ 7004, 69387, "7004 - Mairie Du 7Ème", "Place Jean Macé - Face À La Mairie", 45.746226, 4.841976 },
	{ 7005, 69387, "7005 - Debourg", "Avenue Debourg - Angle Avenue Jean Jaurès", 45.731484, 4.833279 },
	{ 7006, 69387, "7006 - Gerland", "Avenue Jean Jaurès - Au Niveau Du Square Galtier", 45.727184, 4.831041 },
	{ 7007, 69387, "7007 - Farge / Ayasse", "117 Bd Yves Farge", 45.735749, 4.827691 },
	{ 7008, 69387, "7008 - Jean Jaurès / Guillotière", "Avenue Jean Jaurès - Angle Rue De La Guillotière", 45.752584, 4.846336 },
	{ 7009, 69387, "7009 - Jean Jaurès", "Avenue Jean Jaurès - Proche Métro Jean Jaurès", 45.737799, 4.837582 },
	{ 7010, 69387, "7010 - Centre Berthelot", "Rue Pasteur - Angle Avenue Berthelot", 45.747363, 4.836046 },
	{ 7011, 69387, "7011 - Berthelot / Garibaldi", "Rue Garibaldi - Angle Avenue Berthelot", 45.743724, 4.847272 },
	{ 7012, 69387, "7012 - Place Des Pavillons", "Place Des Pavillons - Devant La Bibliothèque", 45.729506, 4.829687 },
	{ 7013, 69387, "7013 - Halle Tony Garnier", "Avenue Tony Garnier Angle Voie Nouvelle (100 M Après Angle Avenue Debourg)", 45.731254, 4.823929 },
	{ 7014, 69387, "7014 - Marseille / Félissent", "Rue Felissent, Angle Rue De Marseille", 45.753015, 4.841375 },
	{ 7016, 69387, "7016 - Place Saint Louis", "Rue De La Madeleine - Angle Rue St Lazarre", 45.748805, 4.847572 },
	{ 7018, 69387, "7018 - Lycée Louise Labé", "", 45.740264, 4.832106 },
	{ 7020, 69387, "7020 - Parc De Gerland", "Allée Pierre De Coubertin", 45.724098, 4.827127 },
	{ 7021, 69387, "7021 - Challemel Lacour / Gerland", "Rue De Gerland - Angle Rue Challemel Lacour", 45.729810, 4.838135 },
	{ 7022, 69387, "7022 - Jaurès / Lagrange", "", 45.744001, 4.841274 },
	{ 7023, 69387, "7023 - Berthelot / Route De Vienne", "Route De Vienne - Angle Avenue Berthelot", 45.742624, 4.850511 },
	{ 7024, 69387, "7024 - Bancel / Chevreul", "", 45.748502, 4.840561 },
	{ 7030, 69387, "7030 - Quartier Général Frère", "", 45.743226, 4.834248 },
	{ 7031, 69387, "7031 - Jaurès / Gerland", "Place Jean Jaurès, Côté Rue De Gerland", 45.739892, 4.840367 },
	{ 7033, 69387, "7033 - St Luc / St Joseph", "Sur Le Quai Haut", 45.749778, 4.835123 },
	{ 7034, 69387, "7034 - Piscine Du Rhône", "Sur Le Quai Devant L'Entrée De La Piscine", 45.753714, 4.838317 },
	{ 7035, 69387, "7035 - Marseille / Université", "Angle Rue De Marseille", 45.750938, 4.839362 },
	{ 7038, 69387, "7038 - Place Stalingrad", "Angle Rue De La Guillotiere", 45.749563, 4.852986 },
	{ 7039, 69387, "7039 - Guillotière / Madeleine", "Angle Rue De La Madeleine", 45.751041, 4.848037 },
	{ 7041, 69387, "7041 - Domer / Chevreul", "Rue Domer/Angle Rue Chevreul", 45.746691, 4.844479 },
	{ 7045, 69387, "7045 - Parc Des Berges", "Face Au N°40 Avenue Leclerc", 45.737757, 4.824485 },
	{ 7046, 69387, "7046 - Place De L'Ecole", "Angle Rue De St Cloud", 45.730085, 4.827790 },
	{ 7049, 69387, "7049 - Cité Scolaire Internationale", "26 Avenue Tony Garnier", 45.728327, 4.823650 },
	{ 7052, 69387, "7052 - Université Lyon I", "50 Avenue Tony Garnier", 45.726729, 4.826116 },
	{ 7053, 69387, "7053 - Jaurès / Thibaudière", "", 45.750269, 4.845189 },
	{ 7055, 69387, "7055 - Servant / Jaboulay", "Face Au N°30 Rue Renan", 45.746764, 4.842010 },
	{ 7056, 69387, "7056 - Place Raspail", "Angle Cours Gambetta", 45.755762, 4.840692 },
	{ 7057, 69387, "7057 - Jaurès / Bollier", "Face Au N°219 Avenue Jean Jaurès", 45.734686, 4.835454 },
	{ 7061, 69387, "7061 - Jaurès / Université", "", 45.748548, 4.843235 },
	{ 7062, 69387, "7062 - Garibaldi / Domer", "", 45.747732, 4.851595 },
	{ 7064, 69387, "7064 - Crous", "Angle Rue Chevreul Et Rue Camille Roy", 45.745404, 4.847855 },
	{ 8001, 69388, "8001 - Université Lyon Iii", "Devant Entrée Principale De L'Université", 45.748341, 4.861491 },
	{ 8002, 69388, "8002 - Place Ambroise Courtois", "Face Au Cours Albert Thomas", 45.745339, 4.871586 },
	{ 8003, 69388, "8003 - Claude Bernard Lyon I", "Devant Entrée De La Fac", 45.738555, 4.886580 },
	{ 8004, 69388, "8004 - Mairie Du 8°", "Devant La Mairie Du 8°", 45.735211, 4.872693 },
	{ 8006, 69388, "8006 - Place Du 8 Mai 1945", "Rue Professeur Beauvisage/Angle Bd Des Etats-Unis", 45.729657, 4.867750 },
	{ 8007, 69388, "8007 - Frères Lumière", "Angle Rue Villon", 45.744984, 4.866432 },
	{ 8008, 69388, "8008 - Beauvisage / Pressensé", "Rue Du Professeur Beauvisage", 45.727893, 4.863514 },
	{ 8009, 69388, "8009 - Jean Xxiii / Mermoz", "Boulevard Jean Xxiii - Angle De La Rue Mermoz", 45.736580, 4.869913 },
	{ 8010, 69388, "8010 - Place Mendès France", "", 45.739979, 4.859460 },
	{ 8011, 69388, "8011 - Place Lebret", "Côté Route De Vienne", 45.735477, 4.853041 },
	{ 8015, 69388, "8015 - Boulevard Jean Xxiii", "Angle Bd Jean Xxiii Et Rue Maryse Bastié", 45.740306, 4.874182 },
	{ 8020, 69388, "8020 - Moulin À Vent", "Angle Rue Du Moulin À Vent / Route De Vienne", 45.729938, 4.853866 },
	{ 8021, 69388, "8021 - Paul Santy", "Place Général André - Face Au 126 Avenue Paul Santy", 45.728286, 4.877618 },
	{ 8024, 69388, "8024 - Mermoz / Michelet", "Angle Av Michelet", 45.733242, 4.878629 },
	{ 8025, 69388, "8025 - Santos Dumont / Louis Jouvet", "", 45.744465, 4.860990 },
	{ 8030, 69388, "8030 - Laënnec", "Angle Rue Nungesser Et Coli", 45.741379, 4.879734 },
	{ 8034, 69388, "8034 - Berthelot / Villon", "Angle Avenue Berthelot", 45.738289, 4.862756 },
	{ 8035, 69388, "8035 - Sans Souci", "Rue Edouard Rochet", 45.747254, 4.865282 },
	{ 8037, 69388, "8037 - Cazeneuve", "Rue Paul Cazeneuve - Angle Du Boulevard Des Etats-Unis", 45.734091, 4.863221 },
	{ 8038, 69388, "8038 - Albert Thomas / Villon", "Angle Rue Villon", 45.746775, 4.867280 },
	{ 8039, 69388, "8039 - Pierre Delore", "Angle Rue Pierre Delore / Route De Vienne", 45.738746, 4.852283 },
	{ 8040, 69388, "8040 - Ambroise Paré", "Face Au 54 Boulevard Ambroise Paré", 45.736245, 4.883733 },
	{ 8041, 69388, "8041 - Pinel", "Bd Pinel, 100M Après Angle Mermoz", 45.729419, 4.886600 },
	{ 8042, 69388, "8042 - Francis De Pressensé", "Avenue Francis De Pressensé Angle Rue Paul Cazeneuve", 45.731473, 4.860262 },
	{ 8051, 69388, "8051 - Hôpital St Jean De Dieu", "313 Route De Vienne", 45.724275, 4.854149 },
	{ 8052, 69388, "8052 - Clinique Monplaisir", "2 Avenue Des Frères Lumière", 45.747017, 4.859613 },
	{ 8053, 69388, "8053 - Lumière / Trouilhet", "", 45.743539, 4.870079 },
	{ 8054, 69388, "8054 - Martinière Monplaisir", "34 Rue Antoine Lumière", 45.740852, 4.868203 },
	{ 8056, 69388, "8056 - Delore / Audibert Et Lavirotte", "69 Rue Audibert Et Lavirotte", 45.735800, 4.856809 },
	{ 8057, 69388, "8057 - Vienne / Montagny", "184 Route De Vienne", 45.732365, 4.853417 },
	{ 8058, 69388, "8058 - Longefer / Krüger", "10 Rue Krüger", 45.738649, 4.878040 },
	{ 8059, 69388, "8059 - Laënnec / Pinel", "Rue Guillaume Paradin Angle Pinel", 45.735351, 4.889581 },
	{ 8060, 69388, "8060 - Santy / Beauvisage", "Face Au N°9 Rue Pierre Verger", 45.731756, 4.874244 },
	{ 8061, 69388, "8061 - Stade Vuillermet", "184 Avenue Paul Santy", 45.725338, 4.881416 },
	{ 8029, 69388, "8029 - Etats-Unis / Lévigne", "", 45.732217, 4.865141 },
	{ 9002, 69389, "9002 - Mairie Du 9°", "Prox. Métro Valmy", 45.774187, 4.805625 },
	{ 9003, 69389, "9003 - Place Valmy", "Rue Roquette / Angle Rue De Bourgogne", 45.775647, 4.805315 },
	{ 9004, 69389, "9004 - Gare De Vaise", "Face Entrée De La Gare", 45.779795, 4.804706 },
	{ 9006, 69389, "9006 - Théâtre Nouvelle Génération", "Rue Tissot / Angle Rue De Bourgogne", 45.777212, 4.803345 },
	{ 9008, 69389, "9008 - L'Île Barbe", "", 45.797396, 4.829081 },
	{ 9010, 69389, "9010 - Piscine De Vaise", "En Face Du N°37 Avenue Sidoine Apollinaire", 45.770946, 4.796537 },
	{ 9011, 69389, "9011 - Conservatoire", "Quai Chauveau / Angle Pont Koenig", 45.769787, 4.812673 },
	{ 9013, 69389, "9013 - Quai Paul Sédallian", "Angle Rue De La Navigation", 45.787389, 4.814371 },
	{ 9014, 69389, "9014 - Quai Du Commerce", "Angle Rue Emile Duport", 45.783435, 4.811458 },
	{ 9020, 69389, "9020 - Bourbonnais", "Angle Rue Horand / Rue Masset", 45.773463, 4.800349 },
	{ 9022, 69389, "9022 - Rue Masaryk / Saint Cyr", "Angle Rue Chinard/Rue St Cyr", 45.778559, 4.807037 },
	{ 9029, 69389, "9029 - Saint Pierre De Vaise", "Place Vanderpol/Angle St Pierre De Vaise", 45.773104, 4.807811 },
	{ 9032, 69389, "9032 - Place Du Port Mouton", "Quai Arloing, Côté Saône", 45.773839, 4.809501 },
	{ 9033, 69389, "9033 - Gorge De Loup", "", 45.767361, 4.805637 },
	{ 9040, 69389, "9040 - Place Rodiaceta", "53 Rue Chapeau Rouge", 45.771010, 4.807610 },
	{ 9041, 69389, "9041 - Carret / Sédallian", "30 Quai Paul Sédallian", 45.792572, 4.820632 },
	{ 9042, 69389, "9042 - Clinique Saint Louis", "92 Rue Du Bourbonnais", 45.773666, 4.795418 },
	{ 9043, 69389, "9043 - Marietton Ouest", "78 Rue Marietton", 45.776097, 4.799712 },
	{ 9044, 69389, "9044 - Masset / Saint Pierre De Vaise", "Rue Saint Pierre De Vaise", 45.770482, 4.800897 },
	{ 9049, 69389, "9049 - Sergent Berthet / Gorge De Loup", "6 Rue Gorge De Loup", 45.770139, 4.805155 },
	{ 9052, 69389, "9052 - Balmont", "332 Bd De Balmont", 45.789320, 4.799157 },
	{ 9050, 69389, "9050 - Le Château", "", 45.783659, 4.794436 },
	{ 9051, 69389, "9051 - Andreï Sakharov", "", 45.786524, 4.797070 },
	{ 10002, 69266, "10002 - Insa", "Avenue Albert Einstein Au Niveau Du Virage", 45.782195, 4.876877 },
	{ 10004, 69266, "10004 - Tonkin", "Rue Salvador Allende / Angle Promenade Du Lys", 45.776226, 4.862644 },
	{ 10005, 69266, "10005 - Boulevard Du 11 Novembre", "Face Entrée Du Parc De La Tête D'Or", 45.779697, 4.859865 },
	{ 10006, 69266, "10006 - Charpennes", "Place Charles Hernu / Côté Sud", 45.770232, 4.863130 },
	{ 10007, 69266, "10007 - Piaton / Condorcet", "Av Piaton / Angle Condorcet", 45.774220, 4.867501 },
	{ 10008, 69266, "10008 - Salengro / Vaillant", "Rue Roger Salengro - Angle Rue Vaillant", 45.778663, 4.879432 },
	{ 10011, 69266, "10011 - Gratte Ciel", "", 45.769217, 4.880582 },
	{ 10012, 69266, "10012 - Zola / France", "Rue De France/Angle Cours Emile Zola", 45.767986, 4.887216 },
	{ 10013, 69266, "10013 - Cusset", "", 45.765047, 4.901130 },
	{ 10014, 69266, "10014 - Gare Laurent Bonnevay", "", 45.765129, 4.909815 },
	{ 10016, 69266, "10016 - Place De La Paix", "En Face Du N°10 Place De La Paix", 45.752105, 4.914640 },
	{ 10018, 69266, "10018 - Tolstoï / Florian", "Rue Florian/Angle Cours Tolstoï", 45.761721, 4.880735 },
	{ 10021, 69266, "10021 - Grandclément", "Angle Cours Tolstoï", 45.759717, 4.889860 },
	{ 10024, 69266, "10024 - Maisons Neuves", "Place Des Maisons Neuves/Côté Rue Jean Jaurès", 45.755956, 4.877343 },
	{ 10025, 69266, "10025 - Totem", "", 45.763627, 4.873309 },
	{ 10027, 69266, "10027 - Mairie De Villeurbanne", "Avenue Aristide Briand, En Face De La Mairie", 45.766879, 4.879967 },
	{ 10028, 69266, "10028 - Ecole De Musique", "Cours De La République/Angle Anatole France", 45.767539, 4.873963 },
	{ 10031, 69266, "10031 - Croix-Luizet", "", 45.780587, 4.883355 },
	{ 10032, 69266, "10032 - Primat / Decorps", "Rue Antoine Primat/Angle Rue Decorps", 45.758182, 4.898602 },
	{ 10034, 69266, "10034 - Docteur Damidot", "Devant La Mjc", 45.761793, 4.886154 },
	{ 10035, 69266, "10035 - Boiron Grangé", "", 45.762956, 4.900400 },
	{ 10036, 69266, "10036 - Stalingrad", "Boulevard Stalingrad/Angle Rue Charlie Chaplin", 45.774314, 4.859079 },
	{ 10038, 69266, "10038 - Condorcet", "Bvd 11 Nov./Prox. Arret Tram Condorcet", 45.779105, 4.866526 },
	{ 10039, 69266, "10039 - Bouvier", "Rue Professeur Bouvier/Angle Rue Du 8 Mai 1945", 45.779455, 4.891498 },
	{ 10041, 69266, "10041 - Kimmerling", "", 45.752977, 4.898862 },
	{ 10043, 69266, "10043 - Salengro / Feyssine", "", 45.783016, 4.890583 },
	{ 10046, 69266, "10046 - Charmettes/Zola", "Rue Des Charmettes/Angle Cours Emile Zola", 45.770752, 4.867150 },
	{ 10047, 69266, "10047 - Lherminier/Pressensé", "Avenue Du Cdt Lherminier/Angle Rue F. De Pressensé", 45.771177, 4.884994 },
	{ 10048, 69266, "10048 - Place Marengo", "", 45.759249, 4.875885 },
	{ 10049, 69266, "10049 - Pressensé", "Rue Francis De Pressensé/Angle 8 Mai 1945", 45.769185, 4.896720 },
	{ 10053, 69266, "10053 - Rosselini / 11 Novembre", "", 45.779413, 4.862899 },
	{ 10054, 69266, "10054 - Stalingrad / Meliès", "", 45.776711, 4.859520 },
	{ 10055, 69266, "10055 - Condorcet / Galline", "Avenue Galline/Angle Av. De Condorcet", 45.776459, 4.867112 },
	{ 10056, 69266, "10056 - 11 Novembre / Gaston Berger", "Avenue Du 11 Nov./Angle Av Gaston Berger", 45.779117, 4.871949 },
	{ 10058, 69266, "10058 - Métro Flachet", "", 45.767131, 4.892147 },
	{ 10059, 69266, "10059 - Anatole France / Zola", "Rue Anatole France", 45.768881, 4.884238 },
	{ 10060, 69266, "10060 - Saint Exupéry", "Avenue Antoine Saint Exupery", 45.758793, 4.878972 },
	{ 10061, 69266, "10061 - République", "Cours Emile Zola/Angle Cours De La République", 45.770789, 4.872956 },
	{ 10063, 69266, "10063 - Perrin / Jean Jaurès", "", 45.758366, 4.885494 },
	{ 10064, 69266, "10064 - 4 Août 1789", "Angle Rue Rollet/Rue Du 4 Août", 45.764827, 4.884316 },
	{ 10070, 69266, "10070 - Stade Cyprian", "", 45.752283, 4.901419 },
	{ 10071, 69266, "10071 - Lycée Marie Curie", "", 45.761565, 4.896451 },
	{ 10072, 69266, "10072 - Jacques Brel", "Rue Jacques Brel/Angle Rue Korel", 45.774139, 4.864013 },
	{ 10073, 69266, "10073 - Institut D'Art Contemporain", "Rue Docteur Dolard / Angle Rue 4 Septembre", 45.761540, 4.872459 },
	{ 10074, 69266, "10074 - Zola / Passage Rey", "Cours E. Zola / Angle Passage Rey", 45.770053, 4.876945 },
	{ 10075, 69266, "10075 - Gabriel Péri", "Angle Cours André Philip", 45.772305, 4.865696 },
	{ 10079, 69266, "10079 - Anatole France / Barbusse", "Rue Anatole France/Angle Av Barbusse", 45.768135, 4.879158 },
	{ 10080, 69266, "10080 - Vaillant / Perroncel", "", 45.775431, 4.880287 },
	{ 10083, 69266, "10083 - Château Gaillard / Bienvenus", "", 45.777804, 4.883980 },
	{ 10086, 69266, "10086 - Anatole France", "Angle Rue De Préssensé / Flachet", 45.769841, 4.889523 },
	{ 10087, 69266, "10087 - Baratin", "Face Au 115 Rue Pierre Baratin", 45.760538, 4.900666 },
	{ 10088, 69266, "10088 - 4 Août 1789 / Pressensé", "", 45.766248, 4.897868 },
	{ 10089, 69266, "10089 - Colin / Ottavi", "Rue Colin - Angle Rue Ottavi", 45.773143, 4.874254 },
	{ 10091, 69266, "10091 - Château Gaillard / Fort", "", 45.774756, 4.888036 },
	{ 10092, 69266, "10092 - Montgolfier / Château Gaillard", "41 Rue Montgolfier", 45.771584, 4.890404 },
	{ 10101, 69266, "10101 - Einstein / Boulevard Du 11 Novembre", "", 45.779479, 4.874328 },
	{ 10110, 69266, "10110 - Mémoire Et Société", "", 45.759617, 4.882815 },
	{ 10111, 69266, "10111 - Charles Hernu", "", 45.770338, 4.862255 },
	{ 10112, 69266, "10112 - Place De La Reconnaissance", "", 45.754541, 4.885135 },
	{ 10113, 69266, "10113 - Gare De Villeurbanne", "4 Avenue Paul Krüger", 45.755772, 4.891486 },
	{ 10114, 69266, "10114 - Bel Air / Les Brosses", "En Face Du N°2 Avenue De Bel Air", 45.758089, 4.910619 },
	{ 10115, 69266, "10115 - Place D'Espagne / Stade Krüger", "133 Avenue Paul Krüger", 45.754103, 4.905661 },
	{ 10116, 69266, "10116 - Blum / Faÿs", "171 Rue Léon Blum", 45.760616, 4.906207 },
	{ 10117, 69266, "10117 - La Perallière", "", 45.764569, 4.892330 },
	{ 10118, 69266, "10118 - Voyant / Chambord", "92 Rue Voyant", 45.767158, 4.900596 },
	{ 10119, 69266, "10119 - Villeurbanne Saint Jean", "", 45.776498, 4.901319 },
	{ 10120, 69266, "10120 - Salengro / Descartes", "39 Rue Roger Salengro", 45.776257, 4.871626 },
	{ 10121, 69266, "10121 - Parc Du Centre", "Angle Rue Billon / Rue F. De Pressense", 45.771930, 4.879056 },
	{ 10122, 69266, "10122 - Verdun / Desgrand", "13 Rue De Verdun", 45.784057, 4.897083 },
	{ 10001, 69266, "10001 - Iut Feyssine", "", 45.785638, 4.882407 },
	{ 10103, 69266, "10103 - La Doua / Rue Des Sports", "", 45.784490, 4.877401 },
	{ 10084, 69266, "10084 - La Doua / Avenue Des Arts", "", 45.783638, 4.871665 },
	{ 10102, 69266, "10102 - La Doua / Rue Gaston Berger", "", 45.780950, 4.871324 },
	{ 10030, 69266, "10030 - Greuze", "", 45.774044, 4.893820 },
	{ 11001, 69034, "11001 - Gare De Cuire", "", 45.786065, 4.833799 },
	{ 11002, 69034, "11002 - Saint Clair", "49 Cours Aristide Briand", 45.785735, 4.848301 },
	{ 12001, 69256, "12001 - La Soie", "Rue De La Poudrette", 45.760818, 4.920601 },
	{0, 0, NULL, NULL, 0., 0.}
};


struct StationsPluginSimplePrivateLyon : StationsPluginSimplePrivate {
  StationsPluginSimplePrivateLyon() {
    rect = QRectF(QPointF(45.560747, 4.784099), QPointF(45.797396, 5.052350));
    center = QPointF(45.760747, 4.852350);
    statusUrl = "";
    infosUrl = "";
  }

  QList < Station * > fetchAll(StationsPlugin *plugin) {
    QList < Station * > list;

    for (int i = 0; stations[i].name; ++i) {
      Station *station = new Station(plugin);

      station->setId(stations[i].number);
      station->setName(QString::fromUtf8(stations[i].name));
      station->setDescription(QString::fromUtf8(stations[i].address));
      station->setPos(QPointF(stations[i].x, stations[i].y));
      station->setRegion(QString("Lyon %1").arg(stations[i].arrondissementNumber));
      list.append(station);
    }

    return list;
  }

  QStringList regions() {
    QStringList ret;

    ret << "69381";
    ret << "69382";
    ret << "69383";
    ret << "69384";
    ret << "69385";
    ret << "69386";
    ret << "69387";
    ret << "69388";
    ret << "69389";
    ret << "69266";
    ret << "69034";
    ret << "69256";

    return ret;
  }
};

#endif /* STATIONS_SIMPLE_PRIVATE_LYON_H */

