/*
 * Copyright (C) 2010 Corentin Chary <corentin.chary@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "lyon_p.h"
#include "station.h"

static struct {
        int codePostal;
        int numStation;
        const char *nomStation;
        const char *infoStation;
        double x;
        double y;
} stations[] = {
        { 69381, 1001, "1001 - Terreaux / Terme", "Angle rue d'Algérie", 45.76765100000000, 4.832158000000000 },
        { 69381, 1002, "1002 - Opéra", "Angle rue Serlin - Angle place de la comédie", 45.76751200000000, 4.836279000000000 },
        { 69381, 1003, "1003 - Place Sathonay", "Angle nord-ouest de la place", 45.76927100000000, 4.830077000000000 },
        { 69381, 1005, "1005 - Meissonnier", "Place Meissonier - Angle Sud-Est de la place", 45.76608700000000, 4.832790000000000 },
        { 69381, 1012, "1012 - Ampère / Bourse", "Rue de la Bourse - Long du Collège-Lycée Ampère", 45.76581600000000, 4.836893000000000 },
        { 69381, 1013, "1013 - Martinière", "Rue de la Martinière", 45.76821300000000, 4.827590000000000 },
        { 69381, 1016, "1016 - Pêcherie", "Rue de la Platière - Angle quai de la Pêcherie", 45.76594200000000, 4.831246000000000 },
        { 69381, 1020, "1020 - Terreaux / Chenavard", "Rue Chenavard - Côté place des Terreaux", 45.76689200000000, 4.832908000000000 },
        { 69381, 1021, "1021 - Terreaux / Beaux Arts", "Rue Herriot - Devant Musée des Beaux Arts", 45.76692000000000, 4.834285000000000 },
        { 69381, 1022, "1022 - Place Tolozan", "Place Tolozan - Angle nord-est de la place", 45.76960900000000, 4.837655000000000 },
        { 69381, 1023, "1023 - Croix Rousse / Perfetti", "Face au n°23 bd de la Croix-Rousse", 45.77229000000000, 4.819486000000000 },
        { 69381, 1024, "1024 - Rouville", "rue de l'Annonciade, devant le lycée Diderot", 45.76966800000000, 4.824632000000000 },
        { 69381, 1031, "1031 - Place de la Paix", "Place de la Paix - En face de La Poste", 45.76804000000000, 4.831725000000000 },
        { 69381, 1032, "1032 - Pizay", "17 rue Pizay, à l'est de la rue de la République", 45.76720500000000, 4.836388000000000 },
        { 69381, 1034, "1034 - Carmélites / Burdeau", "Face au n°30 montée des Carmélites", 45.77007200000000, 4.829220000000000 },
        { 69381, 1036, "1036 - Aveyron", "44 bd de la Croix-Rousse", 45.77432200000000, 4.832606000000000 },
        { 69381, 1006, "1006 - Subsistances", "En face du n°14 quai Saint-Vincent", 45.76790100000000, 4.819813000000000 },
        { 69381, 1035, "1035 - Quai Lassagne", "3 quai André Lassagne", 45.77220600000000, 4.837909000000000 },
        { 69382, 2001, "2001 - Bellecour / République", "Angle République / rue de la Barre", 45.75796700000000, 4.834633000000000 },
        { 69382, 2002, "2002 - Bellecour / St Exupéry", "Côté rue Lintier", 45.75826700000000, 4.830436000000000 },
        { 69382, 2003, "2003 - Place Ampère", "Angle Henry IV", 45.75304800000000, 4.828264000000000 },
        { 69382, 2004, "2004 - Perrache / Carnot", "Côté ouest", 45.75022400000000, 4.826882000000000 },
        { 69382, 2006, "2006 - Place de l'hippodrome", "Angle cours Charlemagne", 45.74558600000000, 4.823529000000000 },
        { 69382, 2007, "2007 - Patinoire Charlemagne", "Angle rue Casimir Périer", 45.74261900000000, 4.820482000000000 },
        { 69382, 2008, "2008 - Place Antonin Poncet", "Côté rue des Marroniers", 45.75677100000000, 4.833838000000000 },
        { 69382, 2011, "2011 - Sala / Rue de Plat", "Face à la faculté catholique", 45.75681300000000, 4.828371000000000 },
        { 69382, 2012, "2012 - Gailleton", "4 place Gailleton", 45.75346000000000, 4.833351000000000 },
        { 69382, 2013, "2013 - Célestins", "Côté nord de la place, vers l'ascenseur", 45.75995900000000, 4.831988000000000 },
        { 69382, 2014, "2014 - Jacobins", "6 rue Jean de Tournes, angle rue Edouard Herriot", 45.76075100000000, 4.834285000000000 },
        { 69382, 2015, "2015 - Place de la République", "Côté est de la place", 45.76091700000000, 4.836170000000000 },
        { 69382, 2016, "2016 - Place Regaud", "Angle rue Tupin / rue Herriot", 45.76308200000000, 4.834283000000000 },
        { 69382, 2017, "2017 - République / Ferrandière", "Rue de la République", 45.76219500000000, 4.835957000000000 },
        { 69382, 2022, "2022 - Place Carnot", "Angle rue Plessier", 45.75117000000000, 4.826852000000000 },
        { 69382, 2023, "2023 - Hugo / Ste Hélène", "Entre rue Victor Hugo et rue d'Auvergne", 45.75468100000000, 4.829889000000000 },
        { 69382, 2024, "2024 - République / Maupin", "Entre Herriot et République", 45.75874400000000, 4.834073000000000 },
        { 69382, 2025, "2025 - Mercière / Ferrandière", "Entre rue de Brest et rue Mercière", 45.76206000000000, 4.833203000000000 },
        { 69382, 2026, "2026 - République / Paufique", "Angle rue de la République", 45.75938600000000, 4.835396000000000 },
        { 69382, 2028, "2028 - Sainte Blandine", "Face station tram Sainte Blandine", 45.74442700000000, 4.822140000000000 },
        { 69382, 2030, "2030 - République / Poulaillerie", "Angle Poulaillerie / République", 45.76407700000000, 4.835522000000000 },
        { 69382, 2035, "2035 - Childebert / République", "Rue Marcel Gabriel Rivière", 45.75988400000000, 4.835754000000000 },
        { 69382, 2036, "2036 - Place Gourjus", "11 place Gourjus", 45.75947500000000, 4.830141000000000 },
        { 69382, 2037, "2037 - Place des Archives", "18 rue Dugas Montbel", 45.74791000000000, 4.824907000000000 },
        { 69382, 2038, "2038 - Hugo / Ainay", "16 rue des remparts d'Ainay, angle rue Victor Hugo", 45.75309500000000, 4.829562000000000 },
        { 69382, 2039, "2039 - Charité / Récamier", "Rue de la Charité, angle du cours Verdun Récamier", 45.74922500000000, 4.829861000000000 },
        { 69382, 2040, "2040 - Quai Saint Antoine", "Face au n°10 quai Saint Antoine, angle pont Maréchal Juin", 45.76357800000000, 4.831899000000000 },
        { 69382, 2041, "2041 - Sala / Charité", "Face au n°52 rue Sala", 45.75447800000000, 4.833008000000000 },
        { 69382, 2042, "2042 - Joffre / Vaubecour", "", 45.75179900000000, 4.824684000000000 },
        { 69383, 3001, "3001 - Part-Dieu / Vivier Merle", "Derrière la station de tram", 45.76028500000000, 4.858587000000000 },
        { 69383, 3002, "3002 - Part-Dieu / Gare SNCF", "", 45.76018700000000, 4.858728000000000 },
        { 69383, 3003, "3003 - Part-Dieu / Deruelle", "Face rue Masséna, entrée centre commercial", 45.76302500000000, 4.854981000000000 },
        { 69383, 3004, "3004 - Bourse du Travail", "Angle rue Moncey / Part-Dieu", 45.75965900000000, 4.848063000000000 },
        { 69383, 3005, "3005 - Saxe-Gambetta", "Place Victor Basch", 45.75379100000000, 4.848039000000000 },
        { 69383, 3007, "3007 - Place d'Arsonval", "A côté du stand de fleurs", 45.74344700000000, 4.878900000000000 },
        { 69383, 3008, "3008 - Institut Lumière", "Place Ambroise Courtois", 45.74581400000000, 4.870684000000000 },
        { 69383, 3009, "3009 - Musée Africain", "133 cours Gambetta", 45.75025800000000, 4.857922000000000 },
        { 69383, 3010, "3010 - Part-Dieu / Cuirassiers", "Angle rue Bouchut", 45.75945200000000, 4.855920000000000 },
        { 69383, 3012, "3012 - Place du Château", "A côté de l'église", 45.74954700000000, 4.887267000000000 },
        { 69383, 3013, "3013 - Place Antoinette", "Place Antoinette", 45.75363300000000, 4.889021000000000 },
        { 69383, 3015, "3015 - Servient / Garibaldi", "Angle rue Garibaldi", 45.76078200000000, 4.852507000000000 },
        { 69383, 3016, "3016 - Liberté / Part-Dieu", "Angle rue de la Part-Dieu", 45.75934700000000, 4.842224000000000 },
        { 69383, 3018, "3018 - Créqui / Voltaire", "Angle rue Paul Bert", 45.75670400000000, 4.848402000000000 },
        { 69383, 3021, "3021 - Place de la Ferrandière", "Intersection Ferrandière/Jasseron", 45.75965100000000, 4.869757000000000 },
        { 69383, 3024, "3024 - Rockefeller / Esquirol", "Intersection Rockefeller / Esquirol", 45.74142800000000, 4.885374000000000 },
        { 69383, 3029, "3029 - Place Aristide Briand", "Angle Gambetta", 45.75300900000000, 4.850244000000000 },
        { 69383, 3031, "3031 - Corneille / Servient", "Angle rue Servient", 45.75993500000000, 4.844513000000000 },
        { 69383, 3032, "3032 - Lafayette / Créqui", "Angle cours Lafayette", 45.76346300000000, 4.847121000000000 },
        { 69383, 3037, "3037 - Paul Bert / Garibaldi", "Rue Paul Bert", 45.75712800000000, 4.853469000000000 },
        { 69383, 3038, "3038 - Vivier Merle / Paul Bert", "Devant le bâtiment de la CAFAL", 45.75723100000000, 4.858929000000000 },
        { 69383, 3039, "3039 - Place Bir-Hakeim", "Au niveau de la rue Duvivier", 45.75259700000000, 4.855707000000000 },
        { 69383, 3043, "3043 - Place Rouget de l'Isle", "Avenue Lacassagne", 45.75401400000000, 4.867227000000000 },
        { 69383, 3044, "3044 - Quai Augagneur", "Entre rue de Bonnel et rue Rabelais", 45.76197000000000, 4.841050000000000 },
        { 69383, 3051, "3051 - Place Henri", "Angle rue Docteur Long/av. Lacassagne", 45.74817100000000, 4.880560000000000 },
        { 69383, 3053, "3053 - Gambetta / Jusserand", "Angle cours Gambetta", 45.75113600000000, 4.855580000000000 },
        { 69383, 3058, "3058 - Place du Lac", "Face à la poste", 45.75882000000000, 4.853878000000000 },
        { 69383, 3066, "3066 - Kimmerling / Faure", "Angle avenue Félix Faure / rue Jean-Pierre Lévy", 45.75426800000000, 4.863463000000000 },
        { 69383, 3067, "3067 - Hachette", "Devant n°2 rue Renoir", 45.75289700000000, 4.863958000000000 },
        { 69383, 3071, "3071 - Bioparc", "Avenue Rockfeller, angle rue Eugénie", 45.74043600000000, 4.888206000000000 },
        { 69383, 3079, "3079 - Place Louise", "Face au n°4 place Louise", 45.75121000000000, 4.884817000000000 },
        { 69383, 3080, "3080 - Part-Dieu / Villette", "", 45.76012400000000, 4.861752000000000 },
        { 69383, 3082, "3082 - Place Bahadourian", "", 45.75759100000000, 4.845109000000000 },
        { 69383, 3083, "3083 - Les Halles", "183 rue André Philip", 45.76152400000000, 4.850483000000000 },
        { 69383, 3084, "3084 - Desaix", "Face à la Maison de l'Enfance", 45.75726600000000, 4.855198000000000 },
        { 69383, 3085, "3085 - Sacré Coeur", "Au niveau du n°66 rue Charrial", 45.75783500000000, 4.868392000000000 },
        { 69383, 3086, "3086 - Feuillat / Lacassagne", "Face au n°115 avenue Lacassagne", 45.74955200000000, 4.876019000000000 },
        { 69383, 3087, "3087 - Part-Dieu / Garibaldi", "Face au n°4 bd Eugène Deruelle", 45.76280500000000, 4.852296000000000 },
        { 69383, 3088, "3088 - Place Guichard", "Face au n°51 rue Moncey", 45.75883000000000, 4.846535000000000 },
        { 69383, 3089, "3089 - Trarieux / Lacassagne", "221 avenue Lacassagne", 45.74531900000000, 4.888961000000000 },
        { 69383, 3090, "3090 - Vinatier", "Angle bd Pinel / avenue d'Esquirol, devant entrée du Vinatier", 45.74192500000000, 4.893496000000000 },
        { 69383, 3091, "3091 - Hôpital Neurologique", "59 bd Pinel", 45.74818800000000, 4.896954000000000 },
        { 69383, 3094, "3094 - Villette / Paul Bert", "74 rue de la Villette", 45.75778400000000, 4.861691000000000 },
        { 69383, 3097, "3097 - Augagneur / Fosse aux Ours", "Angle quai Augagneur / pont de la Guillotière", 45.75720200000000, 4.840370000000000 },
        { 69383, 3099, "3099 - Place Sainte Anne", "230 rue Paul Bert", 45.75696000000000, 4.865438000000000 },
        { 69383, 3100, "3100 - Sisley / Dauphiné", "Face au n°4 rue Paul Sisley", 45.75282200000000, 4.868796000000000 },
        { 69383, 3101, "3101 - Patinoire Baraban", "52 rue Baraban", 45.76251700000000, 4.868595000000000 },
        { 69383, 3102, "3102 - Dr Long / Aubépins", "2 rue de la Caille", 45.75256800000000, 4.894251000000000 },
        { 69383, 3103, "3103 - Place Danton", "4 place Danton", 45.75483900000000, 4.857543000000000 },
        { 69384, 4001, "4001 - Conservatoire", "Au sud du n°1 quai Joseph Gillet", 45.77037300000000, 4.814242000000000 },
        { 69384, 4002, "4002 - Mairie du 4°", "Devant la mairie du 4°", 45.77420500000000, 4.827762000000000 },
        { 69384, 4003, "4003 - Place Commandant  Arnaud", "Angle rue de Belfort", 45.77971800000000, 4.834784000000000 },
        { 69384, 4004, "4004 - Hénon", "Angle rue Hénon", 45.77969000000000, 4.827627000000000 },
        { 69384, 4005, "4005 - Place Bertone", "Rue du Chariot d'Or", 45.77764800000000, 4.834692000000000 },
        { 69384, 4006, "4006 - Philippe de Lasalle", "Angle rue Anselme, face à l'IUFM", 45.77329900000000, 4.821309000000000 },
        { 69384, 4007, "4007 - Place Flammarion", "Côté Rue Philippe de Lassalle", 45.77929500000000, 4.820242000000000 },
        { 69384, 4009, "4009 - Jacquard / Denfert-Rochereau", "Rue Denfert-Rochereau / Angle rue Jacquart", 45.77592800000000, 4.825419000000000 },
        { 69384, 4011, "4011 - Place Jean Ambre", "Place Jean Ambre", 45.78149700000000, 4.832837000000000 },
        { 69384, 4012, "4012 - Place Adrien Godien", "Angle montée de la Boucle", 45.77917600000000, 4.840947000000000 },
        { 69384, 4014, "4014 - Philippe de Lassalle / Pillement", "Angle rue Pillement", 45.77741500000000, 4.820489000000000 },
        { 69384, 4017, "4017 - Place des Tapis", "Angle Bvd de la Croix-Rousse", 45.77609800000000, 4.829472000000000 },
        { 69384, 4021, "4021 - Tabareau", "Angle Bvd de la Croix-Rousse", 45.77405100000000, 4.825189000000000 },
        { 69384, 4022, "4022 - Place de la Croix-Rousse", "Prox. Grande rue de la Croix-Rousse", 45.77606800000000, 4.832498000000000 },
        { 69384, 4023, "4023 - Pont Mazaryk", "Face au 45 quai Gillet", 45.77822900000000, 4.810643000000000 },
        { 69384, 4025, "4025 - Parc Cerisaie", "Rue Chazière", 45.77538500000000, 4.817867000000000 },
        { 69384, 4041, "4041 - Boussange / Austerlitz", "1bis rue Aimé Boussange", 45.77550700000000, 4.835059000000000 },
        { 69384, 4042, "4042 - Stade Grégory Coupet", "63 rue Philippe de Lassalle", 45.78179500000000, 4.820602000000000 },
        { 69385, 5001, "5001 - Place Varillon (funiculaire St Just)", "Devant le n°63 rue de Trion", 45.75720100000000, 4.815302000000000 },
        { 69385, 5002, "5002 - Place des Compagnons de la chanson", "Angle rue des Aqueducs", 45.75648000000000, 4.796687000000000 },
        { 69385, 5004, "5004 - St Jean", "Entre la cathédrale et le funiculaire", 45.76048900000000, 4.826562000000000 },
        { 69385, 5005, "5005 - Saint Paul", "Près de la gare de St Paul", 45.76626200000000, 4.827360000000000 },
        { 69385, 5006, "5006 - Quai Romain Rolland", "Face ancien Palais de Justice", 45.76206900000000, 4.828835000000000 },
        { 69385, 5007, "5007 - Place de Trion", "Place de Trion", 45.75793100000000, 4.813182000000000 },
        { 69385, 5008, "5008 - Sainte Irénée", "Place Sainte Irénée", 45.75544100000000, 4.812724000000000 },
        { 69385, 5009, "5009 - Place Fousseret", "angle quai de Bondy", 45.76469100000000, 4.828942000000000 },
        { 69385, 5015, "5015 - Fulchiron", "Devant le n°41 rue de la Quarantaine", 45.75200600000000, 4.821659000000000 },
        { 69385, 5016, "5016 - Mairie du 5°", "Devant la mairie du 5°", 45.75757000000000, 4.800959000000000 },
        { 69385, 5026, "5026 - Rue de la Baleine", "Angle quai Romain Rolland", 45.76346900000000, 4.828961000000000 },
        { 69385, 5029, "5029 - Place Gerson", "Prox. Quai Pierre Scize", 45.76704900000000, 4.826981000000000 },
        { 69385, 5030, "5030 - Charcot / Résidence Universitaire", "Angle rue du fort Ste Irénée / Charcot", 45.75480300000000, 4.807370000000000 },
        { 69385, 5033, "5033 - César Geoffray", "", 45.74999700000000, 4.784099000000000 },
        { 69385, 5036, "5036 - La Salette", "Rue du commandant Charcot", 45.74969100000000, 4.795607000000000 },
        { 69385, 5040, "5040 - Place Crépu", "127 quai Fulchiron", 45.75787900000000, 4.826220000000000 },
        { 69385, 5041, "5041 - L'Homme de la Roche", "55 quai Pierre Scize", 45.76655800000000, 4.820006000000000 },
        { 69385, 5044, "5044 - Champvert", "85 rue du docteur Locard", 45.75980200000000, 4.796624000000000 },
        { 69385, 5045, "5045 - Valdo / Rivet", "Rue Jeunet", 45.75048600000000, 4.788771000000000 },
        { 69385, 5047, "5047 - Albéric Pont", "2bis rue du docteur Albéric Pont", 45.75344700000000, 4.804456000000000 },
        { 69385, 5050, "5050 - Théâtres Romains", "50 rue de l'Antiquaille", 45.75836700000000, 4.821083000000000 },
        { 69385, 5053, "5053 - Saint Just", "Face au n°8 rue de Trion", 45.75608700000000, 4.819311000000000 },
        { 69385, 5054, "5054 - Champvert", "192 avenue Barthélémy Buyer", 45.76390200000000, 4.792711000000000 },
        { 69385, 5055, "5055 - Buyer / Apollinaire", "150m à l'ouest du 101 avenue Barthélémy Buyer", 45.76180300000000, 4.803058000000000 },
        { 69385, 5031, "5031 - Ménival / Joliot Curie", "Rue Joliot Curie", 45.75466600000000, 4.788242000000000 },
        { 69385, 5049, "5049 - Lycée Branly", "Rue Mère Elisabeth Rivet", 45.75331600000000, 4.792850000000000 },
        { 69386, 6002, "6002 - Porte des Enfants du Rhône", "Le long des grilles, côté ouest de la porte", 45.77738400000000, 4.844878000000000 },
        { 69386, 6003, "6003 - Avenue Verguin", "Devant l'entrée du parc", 45.77291600000000, 4.856324000000000 },
        { 69386, 6004, "6004 - Foch", "Angle rue Vendôme", 45.76885600000000, 4.844762000000000 },
        { 69386, 6005, "6005 - Place Edgar Quinet", "Devant le lycée", 45.76577100000000, 4.844729000000000 },
        { 69386, 6006, "6006 - Boulevard des Belges", "Boulevard des Belges - Angle rue Duquesne", 45.77332500000000, 4.851827000000000 },
        { 69386, 6007, "6007 - Masséna", "Angle Cours Vitton", 45.76962100000000, 4.852406000000000 },
        { 69386, 6008, "6008 - Gare des Brotteaux", "Place Jules Ferry, à l'angle rue des Emeraudes et rue Curie", 45.76841700000000, 4.859067000000000 },
        { 69386, 6011, "6011 - Mairie du 6°", "Angle rue Boileau", 45.76840400000000, 4.849496000000000 },
        { 69386, 6012, "6012 - Place Puvis de Chavannes", "Angle rue Vendôme", 45.77177700000000, 4.844580000000000 },
        { 69386, 6016, "6016 - Viabert / Thiers", "Angle avenue Thiers", 45.76599300000000, 4.862089000000000 },
        { 69386, 6020, "6020 - Musée Guimet", "Angle rue Morellet", 45.77453200000000, 4.848379000000000 },
        { 69386, 6021, "6021 - Garibaldi", "Entre rue Crillon et rue Sully", 45.77086100000000, 4.849968000000000 },
        { 69386, 6022, "6022 - Place Maréchal Lyautey", "Pierre Corneille/cours Franklin Roosevelt", 45.76883500000000, 4.842536000000000 },
        { 69386, 6023, "6023 - Quai Sarail", "Niveau rue de Sèze", 45.76683500000000, 4.841136000000000 },
        { 69386, 6024, "6024 - Tronchet / Anatole France", "Angle bvd Anatole France", 45.77073800000000, 4.856776000000000 },
        { 69386, 6028, "6028 - Recammier / Tête d'Or", "Angle rue Tête d'Or", 45.76435300000000, 4.853428000000000 },
        { 69386, 6031, "6031 - Lafayette / Corneille", "Angle cours Lafayette", 45.76375500000000, 4.843739000000000 },
        { 69386, 6032, "6032 - Préfecture / Sarrail", "Angle rue Vauban", 45.76479400000000, 4.841613000000000 },
        { 69386, 6035, "6035 - Cité Internationale", "Face parvis du palais des congrès", 45.78542700000000, 4.854121000000000 },
        { 69386, 6036, "6036 - Musée d'Art Contemporain", "Allée Achille Lignon", 45.78393600000000, 4.852451000000000 },
        { 69386, 6037, "6037 - Cité Internationale / Interpol", "Allée Achille Lignon", 45.78231100000000, 4.849341000000000 },
        { 69386, 6040, "6040 - Les Halles", "A proximité de la place de l'Europe", 45.76416000000000, 4.849868000000000 },
        { 69386, 6041, "6041 - Cité Internationale / Tête d'Or Nord", "Allée Achille Lignon", 45.78461600000000, 4.859636000000000 },
        { 69386, 6042, "6042 - Cité Internationale / Résidence Hôtelière", "Allée Achille Lignon", 45.78486100000000, 4.855612000000000 },
        { 69386, 6043, "6043 - Cité Internationale / Cinéma", "", 45.78474100000000, 4.852212000000000 },
        { 69386, 6044, "6044 - Charmettes / Bellecombe", "Angle rue de la Viabert / rue Sainte-Geneviève", 45.76637500000000, 4.865081000000000 },
        { 69386, 6045, "6045 - Brotteaux / Vauban", "44 bd des Brotteaux", 45.76630100000000, 4.856830000000000 },
        { 69386, 6001, "6001 - Gare Des Brotteaux", "Place Jules Ferry", 45.76685500000000, 4.858973000000000 },
        { 69387, 7001, "7001 - Place Gabriel Péri", "Place Gabriel Péri", 45.75487200000000, 4.843735000000000 },
        { 69387, 7002, "7002 - Universités Lyon III / Lyon II", "Quai Claude Bernard", 45.75133600000000, 4.836350000000000 },
        { 69387, 7003, "7003 - Gambetta / Garibaldi", "Cours Gambette - Prolongement rue Rachais", 45.75180700000000, 4.852531000000000 },
        { 69387, 7004, "7004 - Mairie du 7ème", "Place Jean Macé - Face à la mairie", 45.74622600000000, 4.841976000000000 },
        { 69387, 7005, "7005 - Debourg", "Avenue Debourg - Angle avenue Jean Jaurès", 45.73148400000000, 4.833279000000000 },
        { 69387, 7006, "7006 - Gerland", "Avenue Jean Jaurès - Au niveau du square Galtier", 45.72718400000000, 4.831041000000000 },
        { 69387, 7007, "7007 - Farge / Ayasse", "117 bd Yves farge", 45.73574865000000, 4.827690790000000 },
        { 69387, 7008, "7008 - Jean Jaurès / Guillotière", "Avenue Jean Jaurès - Angle rue de la Guillotière", 45.75258400000000, 4.846336000000000 },
        { 69387, 7009, "7009 - Jean Jaurès", "Avenue Jean Jaurès - Proche métro Jean Jaurès", 45.73779900000000, 4.837582000000000 },
        { 69387, 7010, "7010 - Centre Berthelot", "Rue Pasteur - Angle avenue Berthelot", 45.74736300000000, 4.836046000000000 },
        { 69387, 7011, "7011 - Berthelot / Garibaldi", "Rue Garibaldi - Angle avenue Berthelot", 45.74372400000000, 4.847272000000000 },
        { 69387, 7012, "7012 - Place des Pavillons", "Place des Pavillons - Devant la bibliothèque", 45.72950600000000, 4.829687000000000 },
        { 69387, 7013, "7013 - Halle Tony Garnier", "Avenue Tony Garnier angle voie nouvelle (100 m après angle avenue Debourg)", 45.73125400000000, 4.823929000000000 },
        { 69387, 7014, "7014 - Marseille / Félissent", "Rue Felissent, angle rue de Marseille", 45.75301500000000, 4.841375000000000 },
        { 69387, 7016, "7016 - Place Saint Louis", "Rue de la Madeleine - Angle rue St Lazarre", 45.74880500000000, 4.847572000000000 },
        { 69387, 7018, "7018 - Lycée Louise Labé", "", 45.74026400000000, 4.832106000000000 },
        { 69387, 7020, "7020 - Parc de Gerland", "Allée Pierre de Coubertin", 45.72409800000000, 4.827127000000000 },
        { 69387, 7021, "7021 - Challemel Lacour / Gerland", "Rue de Gerland - Angle rue Challemel Lacour", 45.72981000000000, 4.838135000000000 },
        { 69387, 7022, "7022 - Jaurès / Lagrange", "", 45.74400100000000, 4.841274000000000 },
        { 69387, 7023, "7023 - Berthelot / Route de Vienne", "Route de Vienne - Angle avenue Berthelot", 45.74262400000000, 4.850511000000000 },
        { 69387, 7024, "7024 - Bancel / Chevreul", "", 45.74850200000000, 4.840561000000000 },
        { 69387, 7030, "7030 - Quartier Général Frère", "", 45.74322600000000, 4.834248000000000 },
        { 69387, 7031, "7031 - Jaurès / Gerland", "Place Jean Jaurès, côté rue de Gerland", 45.73989200000000, 4.840367000000000 },
        { 69387, 7033, "7033 - St Luc / St Joseph", "Sur le quai haut", 45.74977800000000, 4.835123000000000 },
        { 69387, 7034, "7034 - Piscine du Rhône", "Sur le quai devant l'entrée de la piscine", 45.75371400000000, 4.838317000000000 },
        { 69387, 7035, "7035 - Marseille / Université", "Angle rue de Marseille", 45.75093800000000, 4.839362000000000 },
        { 69387, 7038, "7038 - Place Stalingrad", "Angle Rue de la Guillotiere", 45.74956300000000, 4.852986000000000 },
        { 69387, 7039, "7039 - Guillotière / Madeleine", "Angle rue de la Madeleine", 45.75104100000000, 4.848037000000000 },
        { 69387, 7041, "7041 - Domer / Chevreul", "Rue Domer/angle rue Chevreul", 45.74669100000000, 4.844479000000000 },
        { 69387, 7045, "7045 - Parc des Berges", "Face au n°40 avenue Leclerc", 45.73775700000000, 4.824485000000000 },
        { 69387, 7046, "7046 - Place de l'Ecole", "Angle rue de St Cloud", 45.73008500000000, 4.827790000000000 },
        { 69387, 7049, "7049 - Cité Scolaire Internationale", "26 avenue Tony Garnier", 45.72832700000000, 4.823650000000000 },
        { 69387, 7052, "7052 - Université Lyon I", "50 avenue Tony Garnier", 45.72672900000000, 4.826116000000000 },
        { 69387, 7053, "7053 - Jaurès / Thibaudière", "", 45.75026900000000, 4.845189000000000 },
        { 69387, 7055, "7055 - Servant / Jaboulay", "Face au n°30 rue Renan", 45.74676400000000, 4.842010000000000 },
        { 69387, 7056, "7056 - Place Raspail", "Angle cours Gambetta", 45.75576200000000, 4.840692000000000 },
        { 69387, 7057, "7057 - Jaurès / Bollier", "Face au n°219 avenue Jean Jaurès", 45.73468600000000, 4.835454000000000 },
        { 69387, 7061, "7061 - Jaurès / Université", "", 45.74854800000000, 4.843235000000000 },
        { 69387, 7062, "7062 - Garibaldi / Domer", "", 45.74773200000000, 4.851595000000000 },
        { 69387, 7064, "7064 - CROUS", "Angle rue Chevreul et rue Camille Roy", 45.74540400000000, 4.847855000000000 },
        { 69388, 8001, "8001 - Université Lyon III", "Devant entrée principale de l'université", 45.74834100000000, 4.861491000000000 },
        { 69388, 8002, "8002 - Place Ambroise Courtois", "Face au cours Albert Thomas", 45.74533900000000, 4.871586000000000 },
        { 69388, 8003, "8003 - Claude Bernard Lyon I", "Devant entrée de la fac", 45.73855500000000, 4.886580000000000 },
        { 69388, 8004, "8004 - Mairie du 8°", "Devant la mairie du 8°", 45.73521100000000, 4.872693000000000 },
        { 69388, 8006, "8006 - Place du 8 mai 1945", "Rue Professeur Beauvisage/Angle bd des Etats-Unis", 45.72965700000000, 4.867750000000000 },
        { 69388, 8007, "8007 - Frères Lumière", "Angle rue Villon", 45.74498400000000, 4.866432000000000 },
        { 69388, 8008, "8008 - Beauvisage / Pressensé", "Rue du Professeur Beauvisage", 45.72789300000000, 4.863514000000000 },
        { 69388, 8009, "8009 - Jean XXIII / Mermoz", "Boulevard Jean XXIII - Angle de la rue Mermoz", 45.73658000000000, 4.869913000000000 },
        { 69388, 8010, "8010 - Place Mendès France", "", 45.73997900000000, 4.859460000000000 },
        { 69388, 8011, "8011 - Place Lebret", "Côté route de Vienne", 45.73547700000000, 4.853041000000000 },
        { 69388, 8015, "8015 - Boulevard Jean XXIII", "Angle bd Jean XXIII et rue Maryse Bastié", 45.74030600000000, 4.874182000000000 },
        { 69388, 8020, "8020 - Moulin à Vent", "Angle rue du Moulin à Vent / route de Vienne", 45.72993800000000, 4.853866000000000 },
        { 69388, 8021, "8021 - Paul Santy", "Place Général André - Face au 126 avenue Paul Santy", 45.72828600000000, 4.877618000000000 },
        { 69388, 8024, "8024 - Mermoz / Michelet", "Angle av Michelet", 45.73324200000000, 4.878629000000000 },
        { 69388, 8025, "8025 - Santos Dumont / Louis Jouvet", "", 45.74446500000000, 4.860990000000000 },
        { 69388, 8030, "8030 - Laënnec", "Angle rue Nungesser et Coli", 45.74137900000000, 4.879734000000000 },
        { 69388, 8034, "8034 - Berthelot / Villon", "Angle avenue Berthelot", 45.73828900000000, 4.862756000000000 },
        { 69388, 8035, "8035 - Sans Souci", "Rue Edouard Rochet", 45.74725400000000, 4.865282000000000 },
        { 69388, 8037, "8037 - Cazeneuve", "Rue Paul Cazeneuve - Angle du boulevard des Etats-Unis", 45.73409100000000, 4.863221000000000 },
        { 69388, 8038, "8038 - Albert Thomas / Villon", "Angle rue Villon", 45.74677500000000, 4.867280000000000 },
        { 69388, 8039, "8039 - Pierre Delore", "Angle rue Pierre Delore / route de Vienne", 45.73874600000000, 4.852283000000000 },
        { 69388, 8040, "8040 - Ambroise Paré", "Face au 54 Boulevard Ambroise Paré", 45.73624500000000, 4.883733000000000 },
        { 69388, 8041, "8041 - Pinel", "Bd pinel, 100m après angle Mermoz", 45.72941900000000, 4.886600000000000 },
        { 69388, 8042, "8042 - Francis de Pressensé", "Avenue Francis de Pressensé angle rue Paul Cazeneuve", 45.73147300000000, 4.860262000000000 },
        { 69388, 8051, "8051 - Hôpital St Jean de Dieu", "313 route de Vienne", 45.72427500000000, 4.854149000000000 },
        { 69388, 8052, "8052 - Clinique Monplaisir", "2 avenue des Frères Lumière", 45.74701720000000, 4.859613300000000 },
        { 69388, 8053, "8053 - Lumière / Trouilhet", "", 45.74353900000000, 4.870079000000000 },
        { 69388, 8054, "8054 - Martinière Monplaisir", "34 rue Antoine Lumière", 45.74085200000000, 4.868203000000000 },
        { 69388, 8056, "8056 - Delore / Audibert et Lavirotte", "69 rue Audibert et Lavirotte", 45.73580000000000, 4.856809000000000 },
        { 69388, 8057, "8057 - Vienne / Montagny", "184 route de Vienne", 45.73236500000000, 4.853417000000000 },
        { 69388, 8058, "8058 - Longefer / Krüger", "10 rue Krüger", 45.73864900000000, 4.878040000000000 },
        { 69388, 8059, "8059 - Laënnec / Pinel", "rue Guillaume Paradin angle Pinel", 45.73535100000000, 4.889581000000000 },
        { 69388, 8060, "8060 - Santy / Beauvisage", "Face au n°9 rue Pierre Verger", 45.73175600000000, 4.874244000000000 },
        { 69388, 8061, "8061 - Stade Vuillermet", "184 avenue Paul Santy", 45.72533800000000, 4.881416000000000 },
        { 69388, 8029, "8029 - Etats-Unis / Lévigne", "", 45.73221700000000, 4.865141000000000 },
        { 69389, 9002, "9002 - Mairie du 9°", "Prox. métro Valmy", 45.77418700000000, 4.805625000000000 },
        { 69389, 9003, "9003 - Place Valmy", "Rue Roquette / angle rue de Bourgogne", 45.77564700000000, 4.805315000000000 },
        { 69389, 9004, "9004 - Gare de Vaise", "Face entrée de la gare", 45.77979500000000, 4.804706000000000 },
        { 69389, 9006, "9006 - Théâtre nouvelle Génération", "Rue Tissot / angle rue de Bourgogne", 45.77721200000000, 4.803345000000000 },
        { 69389, 9008, "9008 - L'île Barbe", "", 45.79739600000000, 4.829081000000000 },
        { 69389, 9010, "9010 - Piscine de Vaise", "En face du n°37 avenue Sidoine Apollinaire", 45.77094600000000, 4.796537000000000 },
        { 69389, 9011, "9011 - Conservatoire", "Quai Chauveau / angle Pont Koenig", 45.76978700000000, 4.812673000000000 },
        { 69389, 9013, "9013 - Quai Paul Sédallian", "Angle rue de la Navigation", 45.78738900000000, 4.814371000000000 },
        { 69389, 9014, "9014 - Quai du Commerce", "Angle rue Emile Duport", 45.78343500000000, 4.811458000000000 },
        { 69389, 9020, "9020 - Bourbonnais", "Angle rue Horand / rue Masset", 45.77346300000000, 4.800349000000000 },
        { 69389, 9022, "9022 - Rue Masaryk / Saint Cyr", "Angle rue Chinard/rue St Cyr", 45.77855900000000, 4.807037000000000 },
        { 69389, 9029, "9029 - Saint Pierre de Vaise", "Place Vanderpol/Angle St Pierre de Vaise", 45.77310400000000, 4.807811000000000 },
        { 69389, 9032, "9032 - Place du Port Mouton", "Quai Arloing, Côté Saône", 45.77383900000000, 4.809501000000000 },
        { 69389, 9033, "9033 - Gorge de Loup", "", 45.76736100000000, 4.805637000000000 },
        { 69389, 9040, "9040 - Place Rodiaceta", "53 rue Chapeau Rouge", 45.77101000000000, 4.807610000000000 },
        { 69389, 9041, "9041 - Carret / Sédallian", "30 quai Paul Sédallian", 45.79257200000000, 4.820632000000000 },
        { 69389, 9042, "9042 - Clinique Saint Louis", "92 rue du Bourbonnais", 45.77366600000000, 4.795418000000000 },
        { 69389, 9043, "9043 - Marietton Ouest", "78 rue Marietton", 45.77609700000000, 4.799712000000000 },
        { 69389, 9044, "9044 - Masset / Saint Pierre de Vaise", "Rue Saint Pierre de Vaise", 45.77048200000000, 4.800897000000000 },
        { 69389, 9049, "9049 - Sergent Berthet / Gorge de Loup", "6 rue Gorge de Loup", 45.77013900000000, 4.805155000000000 },
        { 69389, 9052, "9052 - Balmont", "332 bd de Balmont", 45.78932000000000, 4.799157000000000 },
        { 69389, 9050, "9050 - Le Château", "", 45.78365900000000, 4.794436000000000 },
        { 69389, 9051, "9051 - Andreï Sakharov", "", 45.78652400000000, 4.797070000000000 },
        { 69266, 10002, "10002 - INSA", "Avenue Albert Einstein au niveau du virage", 45.78219500000000, 4.876877000000000 },
        { 69266, 10004, "10004 - Tonkin", "Rue Salvador Allende / Angle promenade du Lys", 45.77622600000000, 4.862644000000000 },
        { 69266, 10005, "10005 - Boulevard du 11 novembre", "Face Entrée du Parc de la Tête d'Or", 45.77969700000000, 4.859865000000000 },
        { 69266, 10006, "10006 - Charpennes", "Place Charles Hernu / côté sud", 45.77023200000000, 4.863130000000000 },
        { 69266, 10007, "10007 - Piaton / Condorcet", "Av Piaton / angle Condorcet", 45.77422000000000, 4.867501000000000 },
        { 69266, 10008, "10008 - Salengro / Vaillant", "Rue Roger Salengro - Angle rue Vaillant", 45.77866300000000, 4.879432000000000 },
        { 69266, 10011, "10011 - Gratte Ciel", "", 45.76921700000000, 4.880582000000000 },
        { 69266, 10012, "10012 - Zola / France", "Rue de France/Angle Cours Emile Zola", 45.76798600000000, 4.887216000000000 },
        { 69266, 10013, "10013 - Cusset", "", 45.76504700000000, 4.901130000000000 },
        { 69266, 10014, "10014 - Gare Laurent Bonnevay", "", 45.76512900000000, 4.909815000000000 },
        { 69266, 10016, "10016 - Place de la Paix", "En face du n°10 place de la Paix", 45.75210500000000, 4.914640000000000 },
        { 69266, 10018, "10018 - Tolstoï / Florian", "Rue Florian/Angle Cours Tolstoï", 45.76172100000000, 4.880735000000000 },
        { 69266, 10021, "10021 - Grandclément", "Angle cours Tolstoï", 45.75971700000000, 4.889860000000000 },
        { 69266, 10024, "10024 - Maisons Neuves", "Place des Maisons Neuves/Côté rue Jean Jaurès", 45.75595600000000, 4.877343000000000 },
        { 69266, 10025, "10025 - Totem", "", 45.76362700000000, 4.873309000000000 },
        { 69266, 10027, "10027 - Mairie de Villeurbanne", "Avenue Aristide Briand, en face de la mairie", 45.76687900000000, 4.879967000000000 },
        { 69266, 10028, "10028 - Ecole de musique", "Cours de la République/Angle Anatole France", 45.76753900000000, 4.873963000000000 },
        { 69266, 10031, "10031 - Croix-Luizet", "", 45.78058657000000, 4.883354890000000 },
        { 69266, 10032, "10032 - Primat / Decorps", "Rue Antoine Primat/Angle rue Decorps", 45.75818200000000, 4.898602000000000 },
        { 69266, 10034, "10034 - Docteur Damidot", "Devant la MJC", 45.76179300000000, 4.886154000000000 },
        { 69266, 10035, "10035 - Boiron Grangé", "", 45.76295600000000, 4.900400000000000 },
        { 69266, 10036, "10036 - Stalingrad", "Boulevard Stalingrad/angle rue Charlie Chaplin", 45.77431400000000, 4.859079000000000 },
        { 69266, 10038, "10038 - Condorcet", "Bvd 11 Nov./prox. arret tram Condorcet", 45.77910500000000, 4.866526000000000 },
        { 69266, 10039, "10039 - Bouvier", "Rue Professeur Bouvier/Angle rue du 8 mai 1945", 45.77945500000000, 4.891498000000000 },
        { 69266, 10041, "10041 - Kimmerling", "", 45.75297700000000, 4.898862000000000 },
        { 69266, 10043, "10043 - Salengro / Feyssine", "", 45.78301600000000, 4.890583000000000 },
        { 69266, 10046, "10046 - Charmettes/Zola", "Rue des Charmettes/Angle Cours Emile Zola", 45.77075200000000, 4.867150000000000 },
        { 69266, 10047, "10047 - Lherminier/Pressensé", "Avenue du Cdt Lherminier/Angle rue F. de Pressensé", 45.77117700000000, 4.884994000000000 },
        { 69266, 10048, "10048 - Place Marengo", "", 45.75924900000000, 4.875885000000000 },
        { 69266, 10049, "10049 - Pressensé", "Rue Francis de Pressensé/angle 8 mai 1945", 45.76918500000000, 4.896720000000000 },
        { 69266, 10053, "10053 - Rosselini / 11 Novembre", "", 45.77941300000000, 4.862899000000000 },
        { 69266, 10054, "10054 - Stalingrad / Meliès", "", 45.77671100000000, 4.859520000000000 },
        { 69266, 10055, "10055 - Condorcet / Galline", "Avenue Galline/angle av. de Condorcet", 45.77645900000000, 4.867112000000000 },
        { 69266, 10056, "10056 - 11 novembre / Gaston Berger", "Avenue du 11 Nov./angle av Gaston Berger", 45.77911700000000, 4.871949000000000 },
        { 69266, 10058, "10058 - Métro Flachet", "", 45.76713100000000, 4.892147000000000 },
        { 69266, 10059, "10059 - Anatole France / Zola", "Rue Anatole France", 45.76888100000000, 4.884238000000000 },
        { 69266, 10060, "10060 - Saint Exupéry", "Avenue Antoine Saint Exupery", 45.75879300000000, 4.878972000000000 },
        { 69266, 10061, "10061 - République", "Cours Emile Zola/Angle cours de la République", 45.77078900000000, 4.872956000000000 },
        { 69266, 10063, "10063 - Perrin / Jean Jaurès", "", 45.75836600000000, 4.885494000000000 },
        { 69266, 10064, "10064 - 4 Août 1789", "Angle Rue Rollet/Rue du 4 août", 45.76482700000000, 4.884316000000000 },
        { 69266, 10070, "10070 - Stade Cyprian", "", 45.75228300000000, 4.901419000000000 },
        { 69266, 10071, "10071 - Lycée Marie Curie", "", 45.76156500000000, 4.896451000000000 },
        { 69266, 10072, "10072 - Jacques Brel", "Rue Jacques Brel/angle rue Korel", 45.77413900000000, 4.864013000000000 },
        { 69266, 10073, "10073 - Institut d'Art Contemporain", "Rue Docteur Dolard / Angle rue 4 Septembre", 45.76154000000000, 4.872459000000000 },
        { 69266, 10074, "10074 - Zola / passage Rey", "Cours E. Zola / Angle passage Rey", 45.77005300000000, 4.876945000000000 },
        { 69266, 10075, "10075 - Gabriel Péri", "Angle cours André Philip", 45.77230500000000, 4.865696000000000 },
        { 69266, 10079, "10079 - Anatole France / Barbusse", "Rue Anatole France/Angle av Barbusse", 45.76813500000000, 4.879158000000000 },
        { 69266, 10080, "10080 - Vaillant / Perroncel", "", 45.77543100000000, 4.880287000000000 },
        { 69266, 10083, "10083 - Château Gaillard / Bienvenus", "", 45.77780400000000, 4.883980000000000 },
        { 69266, 10086, "10086 - Anatole France", "Angle Rue de Préssensé / Flachet", 45.76984100000000, 4.889523000000000 },
        { 69266, 10087, "10087 - Baratin", "Face au 115 rue Pierre Baratin", 45.76053800000000, 4.900666000000000 },
        { 69266, 10088, "10088 - 4 août 1789 / Pressensé", "", 45.76624800000000, 4.897868000000000 },
        { 69266, 10089, "10089 - Colin / Ottavi", "Rue Colin - Angle rue Ottavi", 45.77314300000000, 4.874254000000000 },
        { 69266, 10091, "10091 - Château Gaillard / Fort", "", 45.77475600000000, 4.888036000000000 },
        { 69266, 10092, "10092 - Montgolfier / Château Gaillard", "41 rue Montgolfier", 45.77158400000000, 4.890404000000000 },
        { 69266, 10101, "10101 - Einstein / Boulevard du 11 Novembre", "", 45.77947900000000, 4.874328000000000 },
        { 69266, 10110, "10110 - Mémoire et Société", "", 45.75961700000000, 4.882815000000000 },
        { 69266, 10111, "10111 - Charles Hernu", "", 45.77033800000000, 4.862255000000000 },
        { 69266, 10112, "10112 - Place de la Reconnaissance", "", 45.75454100000000, 4.885135000000000 },
        { 69266, 10113, "10113 - Gare de Villeurbanne", "4 avenue Paul Krüger", 45.75577200000000, 4.891486000000000 },
        { 69266, 10114, "10114 - Bel Air / Les Brosses", "En face du n°2 avenue de Bel Air", 45.75808900000000, 4.910619000000000 },
        { 69266, 10115, "10115 - Place d'Espagne / Stade Krüger", "133 avenue Paul Krüger", 45.75410300000000, 4.905661000000000 },
        { 69266, 10116, "10116 - Blum / Faÿs", "171 rue Léon Blum", 45.76061600000000, 4.906207000000000 },
        { 69266, 10117, "10117 - La Perallière", "", 45.76456900000000, 4.892330000000000 },
        { 69266, 10118, "10118 - Voyant / Chambord", "92 rue Voyant", 45.76715800000000, 4.900596000000000 },
        { 69266, 10119, "10119 - Villeurbanne Saint Jean", "", 45.77649800000000, 4.901319000000000 },
        { 69266, 10120, "10120 - Salengro / Descartes", "39 rue Roger Salengro", 45.77625700000000, 4.871626000000000 },
        { 69266, 10121, "10121 - Parc du Centre", "Angle Rue Billon / Rue F. De Pressense", 45.77193000000000, 4.879056000000000 },
        { 69266, 10122, "10122 - Verdun / Desgrand", "13 rue de Verdun", 45.78405700000000, 4.897083000000000 },
        { 69266, 10001, "10001 - IUT Feyssine", "", 45.78563800000000, 4.882407000000000 },
        { 69266, 10103, "10103 - La Doua / Rue des Sports", "", 45.78449000000000, 4.877401000000000 },
        { 69266, 10084, "10084 - La Doua / avenue des Arts", "", 45.78363800000000, 4.871665000000000 },
        { 69266, 10102, "10102 - La Doua / rue Gaston Berger", "", 45.78095000000000, 4.871324000000000 },
        { 69266, 10030, "10030 - Greuze", "", 45.77404400000000, 4.893820000000000 },
        { 69034, 11001, "11001 - Gare de Cuire", "", 45.78606500000000, 4.833799000000000 },
        { 69034, 11002, "11002 - Saint Clair", "49 cours Aristide Briand", 45.78573500000000, 4.848301000000000 },
        { 69256, 12001, "12001 - La Soie", "Rue de la Poudrette", 45.76081800000000, 4.920601000000000 },
        {0, 0, NULL, NULL, 0., 0.}
};

QList < Station * > builtinStationsPluginLyon(StationsPlugin *plugin)
{
  QList < Station * > list;

  for (int i = 0; stations[i].numStation; ++i) {
    Station *station = new Station(plugin);

    station->setId(stations[i].numStation);
    station->setName(QString::fromUtf8(stations[i].nomStation));
    station->setDescription(QString::fromUtf8(stations[i].infoStation));
    station->setPos(QPointF(stations[i].x, stations[i].y));
    station->setRegion(QString("%1").arg(stations[i].codePostal));
    list.append(station);
  }

  return list;
}

