#!/usr/bin/python

#Stuff to import
import sys
from PyQt4 import QtCore
from PyQt4 import QtGui
import Image
import code

CURRENTVERSION = "0.2.6"

class MainWindow(QtGui.QMainWindow):
    def __init__(self):
        
        #Create window
        QtGui.QMainWindow.__init__(self)
        
        self.fullScreen = False

        #Initial Settings
        self.resize(800,480)
        self.setWindowTitle('London Tube Map 0.2.6')
        
        #Open Image
        self.ChargerScene()

        ################
        #Menu Bar#
        ################
        #Fullscreen
        fullsc = QtGui.QAction('Fullscreen', self)
        fullsc.setShortcut('Ctrl+X')
        self.connect(fullsc, QtCore.SIGNAL('triggered()'), self.fullscreen)
        
        #About
        abt = QtGui.QAction('About', self)
        fullsc.setShortcut('Ctrl+A')
        self.connect(abt, QtCore.SIGNAL('triggered()'), self.showAbout)
        
        #Alternative 
        altImg = QtGui.QAction('Alternative ', self)
        altImg.setShortcut('Ctrl+I')
        self.connect(altImg, QtCore.SIGNAL('triggered()'), self.alternative)
        
        #Connect to Menu Bar
        menubar = self.menuBar()
        file = menubar.addMenu('&Fichier')
        file.addAction(fullsc)
        file.addAction(altImg)
        file.addAction(abt)
        
        
        #About page
    def showAbout(self):
        aboutString = "London Tube Map: v" + CURRENTVERSION + "\nAmir Bendjazia (benjezzy@gmail.com)\nMaemo Forums: El Amir, \nTwitter: benjezzy \nMany thanks to everyone who helped! "
        QtGui.QMessageBox.information(self, "About Tfl App", aboutString)
        
    def ChargerScene(self):
        #Load image
        objImg = QtGui.QImage("/opt/ltm/images/map.png")

        #Create central Label
        self.cadre = QtGui.QLabel(self)
        self.cadre.setPixmap(QtGui.QPixmap.fromImage(objImg))
        self.area = QtGui.QScrollArea(self)
        self.area.setWidget(self.cadre)
        self.setCentralWidget(self.area)
        
        #Set up initial scroll bar locations
        self.area.verticalScrollBar().setValue(500)
        self.area.horizontalScrollBar().setValue(500)


#Create application object
app=QtGui.QApplication(sys.argv)
#create main window
main=MainWindow()
#display window
main.show()
#Close the App
sys.exit(app.exec_())