#!/usr/bin/env python

import gobject
import gtk
import os
import pango
import hildon
import datetime
from portrait import FremantleRotation

app_name = "LED quickSAVE App"
app_version = "1.0"
initial_mode = FremantleRotation.ALWAYS

kwh_cost = "06 \xc2\xa2"
rtw = "24/7 (168 hours)"
el = "Incandescent (40w to 100w)"


def selection_changed(selector, dunno, seltype):
    global kwhbutton
    global rtwbutton
    global elbutton
    global kwh_cost
    global rtw
    global el
    current_selection = selector.get_current_text()
    if seltype=="kwh":
        kwhbutton.set_label(current_selection)
        kwh_cost = current_selection
    elif seltype=="rtw":
        rtwbutton.set_label(current_selection)
        rtw = current_selection 
    elif seltype=="el":
        elbutton.set_label(current_selection)
        el = current_selection 
    stack = hildon.WindowStack.get_default()
    stack.pop_1()

def create_kwh_selector():
    selector = hildon.TouchSelector(text = True)
    selector.connect("changed", selection_changed, "kwh")
    for i in range(6, 26, 2):
        label = "%(#)02d \xc2\xa2" % {"#":i}
        selector.append_text(label)
    selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
    return selector
    
def create_rtw_selector():
    selector = hildon.TouchSelector(text = True)
    selector.connect("changed", selection_changed, "rtw")
    label = "24/7 (168 hours)"
    selector.append_text(label)
    label = "24/6 (144 hours)"
    selector.append_text(label)
    label = "24/5 (120 hours)"
    selector.append_text(label)
    label = "16/7 (112 hours)"
    selector.append_text(label)
    label = "16/6 (96 hours)"
    selector.append_text(label)
    label = "16/5 (80 hours)"
    selector.append_text(label)
    label = "12/7 (84 hours)"
    selector.append_text(label)
    label = "12/6 (72 hours)"
    selector.append_text(label)
    label = "12/5 (60 hours)"
    selector.append_text(label)
    label = "10/5 (50 hours)"
    selector.append_text(label)
    selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
    return selector

def create_el_selector():
    selector = hildon.TouchSelector(text = True)
    selector.connect("changed", selection_changed, "el")
    label = "Incandescent (40w to 100w)"
    selector.append_text(label)
    label = "Halogen"
    selector.append_text(label)
    label = "High Bay"
    selector.append_text(label)
    label = "Low Bay"
    selector.append_text(label)
    label = "MR 16"
    selector.append_text(label)
    label = "Parking Fixture"
    selector.append_text(label)
    label = "Quad Pin Fluorescent"
    selector.append_text(label)
    label = "T-12"
    selector.append_text(label)
    label = "T-8"
    selector.append_text(label)
    label = "T-5"
    selector.append_text(label)
    selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
    return selector
def kwhlist(arg):
    win = hildon.StackableWindow()
    selector = create_kwh_selector()
    win.add(selector)
    win.show_all()
    
def rtwlist(arg):
    win = hildon.StackableWindow()
    selector = create_rtw_selector()
    win.add(selector)
    win.show_all()
    
def ellist(arg):
    win = hildon.StackableWindow()
    selector = create_el_selector()
    win.add(selector)
    win.show_all()
    
def results(widget, data):
    global kwh_cost
    global rtw
    global el
    def done(arg):
        stack = hildon.WindowStack.get_default()
        stack.pop_1()
    def seelss(arg):
        print "visiting LSS"
        os.system("dbus-send --system --type=method_call --dest=com.nokia.osso_browser /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:\"www.ledsavingsolutions.com/contact-us\"")
    def email(arg,paytime,paydate,roi):
        print "emailing"
        subj="N900 User Interested in LED Lighting Retrofit"
        os.system("dbus-send --type=method_call --dest=com.nokia.modest /com/nokia/modest com.nokia.modest.MailTo string:\"mailto:?subject="+subj+"&body=Payback Time in Years: "+paytime+"%0ABreak-even point: "+paydate+" Return on Investment (ROI): "+roi[:-2]+"%25\"")
    kwharray = ["06 \xc2\xa2", "8 \xc2\xa2", "10 \xc2\xa2", "12 \xc2\xa2", "14 \xc2\xa2", "16 \xc2\xa2", "18 \xc2\xa2", "20 \xc2\xa2", "22 \xc2\xa2", "24 \xc2\xa2"]
    rtwarray = ["24/7 (168 hours)", "24/6 (144 hours)", "24/5 (120 hours)", "16/7 (112 hours)", "16/6 (96 hours)", "16/5 (80 hours)", "12/7 (84 hours)", "12/6 (72 hours)", "12/5 (60 hours)", "10/5 (50 hours)"]
    elarray = ["Incandescent (40w to 100w)", "Halogen", "High Bay", "Low Bay", "MR 16", "Parking Fixture", "Quad Pin Fluorescent", "T-12", "T-8", "T-5"]
    print kwh_cost
    kwhindex = kwharray.index(kwh_cost)
    rtwindex = rtwarray.index(rtw)
    elindex = elarray.index(el)
    bulbs = [[63.3, 5.4, 36.7], [50, 6, 40.04], [465, 100, 419.75], [210, 30, 219.6], [25, 3, 29.92], [75, 16, 129.8], [52.5, 9, 95.26], [90, 30, 109.8], [35, 15, 65], [30, 15, 64.95]]
    hours = [168, 144, 120, 112, 96, 80, 84, 72, 60, 50]
    oc = (bulbs[elindex][0]/1000.0)*hours[rtwindex]*52*(kwhindex*0.02+0.06)
    lc = (bulbs[elindex][1]/1000.0)*hours[rtwindex]*52*(kwhindex*0.02+0.06)
    retcost = bulbs[elindex][2]
    days=datetime.timedelta((retcost/(oc-lc)-0.09)*365)
    d=datetime.date.today()+days
    paydate=d.strftime("%B %d, %Y")
    print "---> ", hours[rtwindex]*52*(kwhindex*0.02+0.06)
    paytime = '%.2f' % (retcost/(oc-lc)-0.09)
    roi = '%2.2f%%' % ((oc-lc)/retcost*100)
    print paytime, roi
    win = hildon.StackableWindow()
    win.set_title("Results")
    bg_img=gtk.gdk.pixbuf_new_from_file("Images/bgsmall.jpg")
    bg_pixmap, mask=bg_img.render_pixmap_and_mask()
    hbox1 = gtk.HBox()
    hbox2 = gtk.HBox()
    hbox3 = gtk.HBox()
    hbox4 = gtk.HBox()
    label1 = gtk.Label("Payback Time in Years:")
    label4 = gtk.Label(paytime)
    label2 = gtk.Label("Break-Even Point:")
    label5 = gtk.Label(paydate)
    label3 = gtk.Label("Return on Investment (ROI):")
    label6 = gtk.Label(roi)
    sitebutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    emailbutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    sitebutton.set_label("See LED Saving Solutions")
    emailbutton.set_label("E-mail Results")
    donebutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    donebutton.set_label("Done")
    sitebutton.connect("clicked", seelss)
    emailbutton.connect("clicked", email, paytime, paydate, roi)
    donebutton.connect("clicked", done)
    hbox1.pack_start(label1, False, False, 0)
    hbox1.pack_end(label4, False, False, 0)
    hbox2.pack_start(label2, False, False, 0)
    hbox2.pack_end(label5, False, False, 0)
    hbox3.pack_start(label3, False, False, 0)
    hbox3.pack_end(label6, False, False,0)
    hbox4.pack_start(sitebutton, True, True, 0)
    hbox4.pack_end(emailbutton, True, True, 0)
    vbox=gtk.VBox()
    vbox.pack_start(hbox1, False, False, 0)
    vbox.pack_start(hbox2, False, False, 0)
    vbox.pack_start(hbox3, False, False, 0)
    vbox.pack_start(hbox4, False, False, 0)
    darea=gtk.DrawingArea()
    vbox.pack_start(darea, True, True, 0)
    vbox.pack_start(donebutton, False, False, 0)
    win.add(vbox)
    win.show_all()
    def expose_event(darea, event):
        colormap=darea.get_colormap()
        colors = {}
        colors["c0"]=colormap.alloc_color('#FF0000', True, True)
        colors["c1"]=colormap.alloc_color('#FF3300', True, True)
        colors["c2"]=colormap.alloc_color('#FF6600', True, True)
        colors["c3"]=colormap.alloc_color('#FF9900', True, True)
        colors["c4"]=colormap.alloc_color('#FFCC00', True, True)
        colors["c5"]=colormap.alloc_color('#CCFF00', True, True)
        colors["c6"]=colormap.alloc_color('#99FF00', True, True)
        colors["c7"]=colormap.alloc_color('#66FF00', True, True)
        colors["c8"]=colormap.alloc_color('#33FF00', True, True)
        colors["c9"]=colormap.alloc_color('#00FF00', True, True)
        black=colormap.alloc_color('#000000', True, True)
        x, y, width, height = darea.get_allocation()
        drawable = darea.window
        gc = drawable.new_gc(black)
        drawable.draw_rectangle(gc, True, 0, 0, width, height)
        for i in range(9-kwhindex, 10):
            gc.set_foreground(colors["c"+str(i)])
            drawable.draw_rectangle(gc, True, 0, height/10*i, width/3-2, height/10)
        for i in range(rtwindex, 10):
            gc.set_foreground(colors["c"+str(i)])
            drawable.draw_rectangle(gc, True, width/3+2, height/10*i, width/3-2, height/10)
        for i in range(elindex, 10):
            gc.set_foreground(colors["c"+str(i)])
            drawable.draw_rectangle(gc, True, width/3*2+2, height/10*i, width/3-2, height/10)
    darea.connect("expose-event", expose_event)
    
    win.window.set_back_pixmap(bg_pixmap, gtk.FALSE)
 
# This is a callback function. The data arguments are ignored in this example.
def start(widget, data):
    global kwhbutton
    global rtwbutton
    global elbutton
    print "Hello World!"
    win = hildon.StackableWindow()
    win.set_title("Enter data")
    bg_img=gtk.gdk.pixbuf_new_from_file("Images/bgsmall.jpg")
    bg_pixmap, mask=bg_img.render_pixmap_and_mask()
    picklabel = gtk.Label("Pick a whole property or a key section to check your score.")
    picklabel.set_line_wrap(True)
    picklabel.set_size_request(450, -1)
    kwhlabel = gtk.Label("kWh Cost")
    kwhbutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    kwhbutton.set_label("6 \xc2\xa2")
    rtwlabel = gtk.Label("Run Time/Week")
    rtwbutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    rtwbutton.set_label("24/7 (168 hours)")
    ellabel = gtk.Label("Existing Lighting")
    elbutton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    elbutton.set_label("Incandescent (40w to 100w)")
    disclaimer = gtk.Label("The Payback Time in Years and the Return on Investment (ROI) are based on industry average pricing in 2010 and are intended to serve only as a \"Benchmarking\" tool to guide comparative decisions between different types of lighting retrofit applications.")
    disclaimer.set_line_wrap(True)
    disclaimer.modify_font(pango.FontDescription("sans 10"))
    resultsbutton=hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    resultsbutton.set_label("Done")
    vbox = gtk.VBox(False, 0)
    vbox.pack_start(picklabel, True, True, 0)
    vbox.pack_start(kwhlabel, True, True, 0)
    vbox.pack_start(kwhbutton, False, False, 0)
    vbox.pack_start(rtwlabel, True, True, 0)
    vbox.pack_start(rtwbutton, False, False, 0)
    vbox.pack_start(ellabel, True, True, 0)
    vbox.pack_start(elbutton, False, False, 0)
    vbox.pack_start(disclaimer, False, False, 0)
    vbox.pack_start(resultsbutton, True, False, 0)
    win.add(vbox)
    kwhbutton.connect("clicked", kwhlist)
    rtwbutton.connect("clicked", rtwlist)
    elbutton.connect("clicked", ellist)
    resultsbutton.connect("clicked", results, None)
    win.show_all()
    win.window.set_back_pixmap(bg_pixmap, gtk.FALSE)
 
def main():
    # Get an instance of HildonProgram. It is an object used to represent an
    # application running in the Hildon framework.
    program = hildon.Program.get_instance()
 
    # create a new hildon window
    window = hildon.StackableWindow()
    window.set_title("LED quickSAVE App")
    rotation_object = FremantleRotation(app_name, window, app_version, initial_mode)
         
    # Registers a window as belonging to the program
    program.add_window(window)
    
    
    bg_img=gtk.gdk.pixbuf_new_from_file("Images/bgsmall.jpg")
    bg_pixmap, mask=bg_img.render_pixmap_and_mask()
 
    # When the window is given the "delete_event" signal (this is given by the
    # window manager, usually by the "close" option, or on the titlebar), we
    # ask it to call the delete_event () function as defined above. The data
    # passed to the callback function is None and is ignored in the callback
    # function.
    window.connect("delete_event", gtk.main_quit, None)

    vbox = gtk.VBox()

    backgroundimage = gtk.image_new_from_file("Images/Default-horiz.jpg")
    vbox.pack_start(backgroundimage, True, True, 0)
    backgroundimage.show()
 
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
    button.set_label("Start")
 
    # When the button is given the "clicked" signal, we ask it to call the
    # hello () function as defined above. The data passed to the callback
    # function is None and is ignored in the callback function.
    button.connect("clicked", start, None)
 
    vbox.pack_start(button, False, False, 0)
    button.show()

    # This packs the button into the window (a GTK+ container).
    window.add(vbox)
 
    # The final step is to display this newly created widget and all widgets it
    # contains.
    window.show_all()
    window.window.set_back_pixmap(bg_pixmap, gtk.FALSE)
 
    # All GTK+ applications must have a gtk_main(). Control ends here and waits
    # for an event to occur (like a key press or mouse event).
    gtk.main()
 
if __name__ == "__main__":
    main()
