import Qt 4.7

Rectangle {
    id: background
    width: 480
    height: 770
    color: "black"
    smooth: true

    MouseArea {
        id: drag
        anchors.fill: parent
        drag.target: background
        drag.axis: "XAxis"
        //drag.maximumX: 0
        //drag.minimumX: 0

        onReleased: {
            //ziehung_title.text = background.x
            if(background.x>150){pyfunc.ende();}
            else if(background.x<-150){pyfunc.minimize(); background.x = 0}
            else {background.x = 0}
        }
    }

    // Update des Textstrings, wenn ein Tipp generiert wird
    function updateTipp(str) {
            gen_tipp.text = str; gen_tipp.anchors.horizontalCenter = background.horizontalCenter;
        }
    // Update des Textes, der die Zahlen der letzten Ziehung beinhaltet
    function updateZiehung(str) {
            vergangene_ziehung.text = str
    }
    // Update des Textes bzgl. des letzten Ziehungsdatum
    function updateZiehdatum(str) {
            ziehung_title.text = str
    }
    // Update des Textes der die Zusatzzahl angibt
    function updateZZ(str) {
        zusatzzahl.text = str
    }
    // Update des Textes der die Superzahl angibt
    function updateSZ(str) {
        superzahl.text = str
    }
    // Update des Textes der Spiel77 ausgibt
    function updateSpiel77(str) {
        spiel77.text = str
    }
    // Update des Textes der Super6 ausgibt
    function updateSuper6(str) {
        super6.text = str
    }


    Rectangle {
        id: workspace
        width: background.width
        height: background.height
        color: "#eff0f1"
        radius: 20
    }

    Rectangle {
        id: banner_p1
        width: background.width
        height: 60
        radius: 20
        color: "#faae00"

        Rectangle {
            id: banner_p2
            width: background.width
            height: 15
            color:  "#faae00"
            anchors.bottom: banner_p1.bottom
    }
        Image {
            id: lotto_icon
            source: "lotto.png"
            height: 50
            width: 50
            anchors.top: banner_p1.top
            anchors.topMargin: 5
            anchors.left: banner_p1.left
            anchors.leftMargin: 20
        }

        Text {
            id: banner_title
            color: "white"
            text: "Lotto"
            style: Text.Normal
            font.family: "Nokia Pure Text Light"
            font.pointSize: 32
            anchors.left: lotto_icon.right
            anchors.top: banner_p1.top
    }
    }

    Text {
        id: ziehung_title
        objectName: "ziehung_title"
        anchors.top: parent.top
        anchors.topMargin: 70
        anchors.left: parent.left
        anchors.leftMargin: 20
        font.pointSize: 18
        color: "#faae00"
        text: "Ziehung vom: Mittwoch, 23.02.1999"
        font.family: "Nokia Pure Text"
    }

    Rectangle {
        id: ziehungs_box
        width: 440
        height: 70
        anchors.top: ziehung_title.bottom
        anchors.topMargin: 10
        anchors.horizontalCenter: parent.horizontalCenter
        radius: 15
        color: "white"
        border.width: 1
        border.color: "#cdcecf"

        Text {
            id: vergangene_ziehung
            x: 15
            y: -1
            objectName: "vergangene_ziehung"
            anchors.horizontalCenter: parent.horizontalCenter
            color: "black"
            text: "11, 12, 13, 14, 15, 16"
            anchors.horizontalCenterOffset: 0
            font.pointSize: 32
            font.bold: true
            font.family: "Nokia Pure Text"
            verticalAlignment: Text.AlignVCenter


            PropertyAnimation on y {
                to: 10; duration: 1500; easing.type: Easing.OutBounce
            }
        }   
    }

    Rectangle { id: spiel77_rec
        color: "white"
        width: 440
        height: 40
        radius: 10
        border.color: "#cdcecf"
        anchors.horizontalCenter: parent.horizontalCenter
        y: 220

    }

    Text {  id: spiel77
        objectName: "spiel77"
        font.pointSize: 24
        color: "black"
        text: "Spiel 77: 1 2 3 4 5 6 7"
        font.family: "Nokia Pure Text"
        anchors.horizontalCenter: parent.horizontalCenter

        PropertyAnimation on y {
            to: 220; duration: 1500; easing.type: Easing.OutBounce

        }
    }

    Rectangle { id: super6_rec
        color: "white"
        width: 440
        height:  40
        radius: 10
        anchors.horizontalCenter: parent.horizontalCenter
        y: 290
        border.color: "#cdcecf"
    }

    Text {  id: super6
        objectName: "super6"
        font.pointSize: 24
        color: "black"
        text: "Super 6: 1 2 3 4 5 6"
        font.family: "Nokia Pure Text"
        anchors.horizontalCenter: parent.horizontalCenter

        PropertyAnimation on y {
            to: 290; duration: 1500; easing.type: Easing.OutBounce
        }
    }

    Rectangle { id: zusatzzahl_rec
        color: "white"
        width: 440
        height: 40
        radius: 10
        anchors.horizontalCenter: parent.horizontalCenter
        y: 360
        border.color: "#cdcecf"
    }

    Text {  id: zusatzzahl
        objectName: "zusatzzahl"
        font.pointSize: 24
        color: "black"
        text: "Zusatzzahl: 27"
        font.family: "Nokia Pure Text"
        anchors.horizontalCenter: parent.horizontalCenter

        PropertyAnimation on y {
            to: 360; duration: 1500; easing.type: Easing.OutBounce
        }
    }

    Rectangle { id: superzahl_rec
        color: "white"
        width: 440
        height: 40
        radius: 10
        anchors.horizontalCenter: parent.horizontalCenter
        y: 430
        border.color: "#cdcecf"

    }

    Text {  id: superzahl
        objectName: "superzahl"
        font.pointSize: 24
        color: "black"
        text: "Superzahl: 10"
        font.family: "Nokia Pure Text"
        anchors.horizontalCenter: parent.horizontalCenter

        PropertyAnimation on y {
            to: 430; duration: 1500; easing.type: Easing.OutBounce
        }
    }

    Text {
        id: gen_tipp
        color: "#faae00"
        text: "  ,  ,  ,  ,  ,  "
        font.family: "Nokia Pure Text Light"
        font.pointSize: 32
        y: 600

        PropertyAnimation on x {
            to: 150; duration: 1500;
    }
}

    Rectangle {
        id: statusbar_p1
        width: workspace.width-workspace.border.width
        height: 70
        anchors.bottom: parent.bottom
        radius: 15
        gradient: Gradient {
            GradientStop {position: 0.4; color: "#e4e5e6"}
            GradientStop {position: 1.0; color: "#d0d2d2"}
        }

        Rectangle {
            id: shadow_statusbar
            width: parent.width
            height: 2
            color: "#dddede"
            anchors.bottom: statusbar_p1.top
            anchors.bottomMargin: 2
        }

        Rectangle {
            id: statusbar_p2
            width: workspace.width-workspace.border.width
            height: 15
            anchors.top: parent.top
            gradient: Gradient {
                GradientStop {position: 0.0; color: "#e7e8e9"}
                GradientStop {position: 0.4; color: "#e4e5e6"}
            }
        }

    }

    Rectangle {
        id: gen_button
        width: 140
        height: 50
        anchors.centerIn: statusbar_p1
        radius: 20
        border.color: "#cdcecf"
        //color: gen_button_mouse.pressed ? "white" : "lightgrey"
        gradient: Gradient {
                        GradientStop {position: 0.0; color: "#e7e8e9"}
                        GradientStop {position: 1.0; color: "#d0d2d2"}
        }

        Text {
            id: gen_button_text
            width: 50
            height: 50
            text: "+"
            verticalAlignment: Text.AlignVCenter
            font.family: "Nokia Pure Text"
            color: gen_button_mouse.pressed ? "lightgrey" : "black"
            font.pointSize: 50
            anchors.centerIn: parent
        }
    }

    MouseArea {
        id: gen_button_mouse
        objectName: "gen_button_mouse"
        anchors.fill: gen_button
    }
}




