#!/usr/bin/env python
#-*- coding: utf-8 -*-

#Copyleft: Code is released under the conditions of the GNU General Public License Version 3.

#Autor: Gabriel Böhme
#Mail: m.gabrielboehme@googlemail.com


#Importe
import sys
import random
import urllib2
from PyQt4.QtGui import QApplication, QMainWindow, QLabel, QMessageBox, QComboBox
from PyQt4.uic import loadUi

#--------------------------------------------------------------------------------------------------

#Klasse für das Hauptfenster
class LottoWindow(QMainWindow):
	def __init__(self):
		QMainWindow.__init__(self)	
		self.ui = loadUi("lotto.ui")
		self.ui.show()
		
		#Datum der letzten Ziehung auf die Oberfläche bringen		
		zd = self.ziehdatum()
		self.ui.letztes_datum.setText('Ziehung vom: %s' % zd)

		#Zahlen der letzten Ziehung auf die Oberfläche bringen:
		#Ziehung
		zlz = self.last_ziehung(ziehung=[])
		zlz = zlz[:6]
		self.ui.letzte_nums.setText('%s' % " ".join(zlz)) 
		
		#Zusatzzahl
		zz = self.zusatzzahl()
		self.ui.zz.setText('Zusatzzahl: %s' % zz)
	
		#Superzahl 
		sz = self.superzahl()
		self.ui.sz.setText('Superzahl: %s' % sz)
		
		#Spiel77
		s77 = self.last_spiel77(spiel77=[])
		s77 = s77[6:13]
		self.ui.spiel77.setText('Spiel 77:  %s' % " ".join(s77))
		
		#Super6
		s6 = self.last_super6(super6=[])
		s6 = s6[13:]
		self.ui.super6.setText('Super 6:  %s' % " ".join(s6))

		#buttons für zahlengenerator und Menü
		self.ui.button_zahlen.clicked.connect(self.lotto_fun)
		self.ui.action_ueber.triggered.connect(self.zeige_ueber)

#--------------------------------------------------------------------------------------------------

#Funktionen zur Lotto-Zahlen Generierung
	def lotto_fun(self):
		land = self.ui.laender_box.currentIndex()
		if land == 0:
			win = self.generate_numbers(1,50)
		else:
			win = self.generate_numbers(1,46)
		
		#Zahlen angeben: letzte/Tipp		
		self.ui.ziehung.setText('%s' % win)
		#self.ui.last1.setText('%s' % win)
		#self.save_last_num(win)


	def generate_numbers(self, range_start, range_end):
		#"Mischung der Kugeln"	
		numbers = range(range_start, range_end)
		random.shuffle(numbers)

		#Ziehung der Nummern
		winnum = numbers[:6]
		win = winnum.sort()
		winnum = '%s' % winnum		
		win = winnum[1:-1]

		return win

#--------------------------------------------------------------------------------------------------

#Funktionen zur Anzeige/Parsing der letzten Ziehungs-Ergebnisse:

	#datum der letzten ziehung
	def ziehdatum(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for ziehdatum in url.readlines():
				if ziehdatum.startswith('<h2>Zahlen der Ziehung vom'):
					ziehdatum = ziehdatum[27:-6]
					return ziehdatum
		
		except:
			ziehdatum = ' '
			return ziehdatum



	#6 zahlen aus der ziehung
	def last_ziehung(self, ziehung):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):	
					zahlen = lines[14:-8]						
					ziehung.append(zahlen)
			return ziehung	
		
		except:	 
			ziehung = ' '
			return ziehung		
		
		

	#spiel77
	def last_spiel77(self, spiel77):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):			
					zahlen = lines[14:-8]						
					spiel77.append(zahlen)
			return spiel77
		
		except:
			spiel77 = ' '
			return spiel77


	#super6
	def last_super6(self, super6):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for lines in url.readlines():
				if lines.startswith('        <span>'):			
					zahlen = lines[14:-8]						
					super6.append(zahlen)
			return super6

		except:
			super6 = ' '
			return super6


	#zusatzzahl
	def zusatzzahl(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for zz in url.readlines():
				if zz.startswith('    ZZ: <span>'):
					zz = zz[14:-20]
					return zz

		except:
			zz = ' '
			return zz


	#superzahl
	def superzahl(self):
		try:
			url = urllib2.urlopen('http://m.lotto.de/')
			for sz in url.readlines():
				if sz.startswith('    SZ: <span>'):
					sz = sz[14:-8]
					return sz
		
		except:
			sz = ' '
			return sz

#--------------------------------------------------------------------------------------------------
	
#Funktionen für Menü-Einträge
	#Menü - Über: Text
	def zeige_ueber(self):
        	QMessageBox.about(self, 
                          u"Über diese App",u"""<b>Lotto</b>
                          <p>Diese kleine App zeigt die Ergebnisse der letzten Lotto-Ziehung an, 
                  inkl. Super- und Zusatzzahl sowie Spiel77 und Super6. Weiterhin lässt sich ein 
                zufälligen Tipp von 6 Zahlen generieren. Sowohl für das deutsche "6aus49", 
			als auch das "6aus45" System. 
				
				<p>Der Quellcode steht unter GPL Version 3.
				<p>Autor: Gabriel Böhme
				<p>Mail: m.gabrielboehme@googlemail.com""")
	
#--------------------------------------------------------------------------------------------------

#Starten des Programms
if __name__ == "__main__":
	#Qt Umgebung
	app = QApplication(sys.argv)
	#Objekt (Fenster) wird aus Klasse geschaffen
	fenster = LottoWindow()
	#START
	sys.exit(app.exec_())


