#include "QDNSItemModel.h"

QDNSItemModel::QDNSItemModel(QObject *parent) 
    : QStandardItemModel(parent), m_securityItem(0), m_istrusted(unknown)
{
}

QDNSItemModel::~QDNSItemModel()
{
}

void QDNSItemModel::setSecurityStatus(QStandardItem *item,
                                      securityStatus istrusted)
{
    m_securityItem = item;
    m_istrusted = istrusted;
}

QVariant QDNSItemModel::data(const QModelIndex &index, int role) const
{
#if defined(Q_WS_MAEMO_5) || defined(MAEMO_CHANGES)
#define CHANGEROLE Qt::ForegroundRole
#else
#define CHANGEROLE Qt::BackgroundRole
#endif

    if (role == CHANGEROLE) {
        if (m_istrusted == validated)
            return QColor(150,255,150);
        if (m_istrusted == trusted)
            return QColor(255,255,150);
        if (m_istrusted == unknown)
            return QColor(150,255,255);
    }
#if !defined(Q_WS_MAEMO_5) && !defined(MAEMO_CHANGES)
    if (role == Qt::ForegroundRole) {
        return QColor(0,0,0);
    }
#endif
    
    return QStandardItemModel::data(index, role);
}
