#ifndef BOOK_H
#define BOOK_H

#include <QObject>
#include <QtXml>
#include "item.h"

class Enemy : public QObject
{
    Q_OBJECT
public:
    explicit Enemy(QObject *parent = 0);

    QString Name;
    int CombatSkill;
    int Endurance;
    bool CanBeEvaded;

    QStringList DisciplineImmunities;
    QStringList WoundedBy;
    QString EnterScript;
    QString ExitScript;
    QString RoundScript;
    QString DamageScript;

public slots:
    bool IsDead();
    void SetEndurance(int value) { Endurance = value; }
};

class Choice : public QObject
{
    Q_OBJECT

public:
    explicit Choice(QObject *parent = 0);
    //Choice(const Choice& choice);

    bool Enabled;
    int Target;
    QString Text;
    bool Random;
    int MinValue;
    int MaxValue;

    QString Script;

private:
    bool m_Abort;

public slots:
    bool IsEnabled() { return Enabled;}
    void SetEnabled(bool value) { Enabled = value; }
    void Abort() { m_Abort = true; }
    bool IsAborted() { return m_Abort; }
    void Accept() {m_Abort = false; }
};

class Section : public QObject
{
    Q_OBJECT
public:
    explicit Section(QObject *parent = 0);

    int Number;
    QString Text;
    QList<Choice*> Choices;
    QList<Enemy*> Enemies;

    QString EnterScript;
    QString ExitScript;
    QString ShowScript;

    bool HasRandomChoices();
    int UserChoicesCount();

    bool AutoSave;
    int MustEat;
    int DidntEatEnduranceLoss;
    bool CanHunt;
    int GoldCrowns;
    QList<Item*> Items;
    QList<ShopItem*> ShopItems;

    bool HasPickableItems();
    Choice* GetChoiceFromTarget(int);

public slots:
    Choice* GetChoice(int);
    int GetWeaponsCount();
    int GetEnemiesCount();
    void RemoveEnemies();
    void SetMustEat(int value) { MustEat = value; }
};


class Book : public QObject
{
    Q_OBJECT
public:
    enum series{
        Unknown,
        Kai,
        Magnakai,
        GrandMaster,
        NewOrder,
    };

    explicit Book(QObject *parent = 0);

    QString FileName;
    int Version;
    int Revision;
    QString FunctionsScript;
    QString BaseDirectory;
    QString Serie;
    QString Title;
    QString Authors;
    int Number;
    QString ScriptedBy;
    QHash<int, Section*> Sections;

    bool Load(QString filename, bool full=true);
    bool Save(QString filename);
    QString GetVersion();
    int GetSerie();

private:
    Choice* ParseChoice(Section* section, QXmlStreamReader* reader);
    Enemy* ParseEnemy(Section* section, QXmlStreamReader* reader);
    Weapon* ParseWeapon(Section* section, QXmlStreamReader* reader);
    Item* ParseItem(Section* section, QXmlStreamReader* reader);
    ShopItem* ParseShopItem(Section* section, QXmlStreamReader* reader);
    QString GetAttribute(QXmlStreamAttributes attrs, QString name, QString defaultValue="");
};

#endif // BOOK_H
