#include "commonstatic.h"

CommonStatic::CommonStatic()
{
}

void CommonStatic::Message(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.exec();
}

QMessageBox::StandardButton CommonStatic::ConfirmMessage(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Question);
    if (title.isEmpty())
        title = QObject::tr("Confirm");
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    return (QMessageBox::StandardButton)msgBox.exec();
}

QSettings* CommonStatic::GeneralSettings(QObject * parent)
{
    QString filename = QSettings().fileName();
    filename = filename.replace(".ini", QString("_general.ini"), Qt::CaseInsensitive);
    return new QSettings(filename, QSettings::IniFormat, parent);
}

void CommonStatic::CenterWindow(QWidget* w){
    if (w->parent() != NULL){
        QWidget* p = qobject_cast<QWidget*>(w->parent());
        if (p != NULL){
            int newX = p->pos().x() + p->width() - w->width();
            int newY = p->pos().y() + p->height() - w->height();
            if (newX < 0)
                newX = 0;
            if (newY < 0)
                newY = 0;
            w->move(newX, newY);
        }
    }
}
