#ifndef INPUTNUMBERWINDOW_H
#define INPUTNUMBERWINDOW_H

#include <QDialog>

namespace Ui {
class InputNumberWindow;
}

class InputNumberWindow : public QDialog
{
    Q_OBJECT
    
public:
    explicit InputNumberWindow(QWidget *parent = 0, QString title="", int min=0, int max=100);
    ~InputNumberWindow();
    
    int GetValue();

private:
    Ui::InputNumberWindow *ui;

    int m_Value;
    int m_MinValue;
    int m_MaxValue;

private slots:
    void MinusSlot();
    void PlusSlot();
    void OkSlot();
    void ValueChangedSlot(QString value);
};

#endif // INPUTNUMBERWINDOW_H
