#ifndef DOWNLOADWINDOW_H
#define DOWNLOADWINDOW_H

#include <QDialog>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QFile>
#include <QCloseEvent>
#include "core/books.h"

namespace Ui {
    class DownloadWindow;
}

class DownloadWindow : public QDialog
{
    Q_OBJECT

public:
    explicit DownloadWindow(QWidget *parent=0, BookEntry* book=0, QString url="", QString filename="");
    ~DownloadWindow();

private:
    Ui::DownloadWindow *ui;

    bool m_CanClose;
    bool m_Error;
    QString m_Url;
    QString m_TempFilename;
    QString m_Filename;
    BookEntry* m_Book;
    QFile* m_File;
    QNetworkAccessManager* m_Nam;
    QNetworkReply* m_CurrentReply;

    QString GetSize(qint64 size);

public slots:
    int exec();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void ReqReadyReadSlot();
    void ReqErrorSlot(QNetworkReply::NetworkError error);
    void ReqDownloadProgressSlot(qint64 bytesReceived, qint64 bytesTotal);
    void ReqFinishedSlot(QNetworkReply* reply);
    void CancelSlot();

};

#endif // DOWNLOADWINDOW_H
