#ifndef BOOKWINDOW_H
#define BOOKWINDOW_H

#include <QMainWindow>
#include <QScriptEngine>
#include <QPushButton>
#include "core/book.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BookWindow;
}

class BookWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit BookWindow(QWidget *parent = 0);
    ~BookWindow();

    void Save(QString filename, Player* player, int book, int section);
    void Init();
    static QString GetBookSaveFilename(int number);

private:
    Ui::BookWindow *ui;

    QList<QPushButton*> m_ChoiceButtons;
    QFont m_Font;
    QSettings* m_Settings;
    RandomNumberPicker* m_RandomPicker;
    int m_DiceValue;
    QScriptEngine m_Engine;
    QScriptValue m_Functions;
    bool m_Fought;
    int m_Ate;
    Player* m_Player;
    Book* m_Book;
    Section* m_Section;
    bool m_Loaded;
    int m_PickGoldCrowns;
    QList<Item*> m_PickItems;

    void SetVisibleChoiceButtons(int number);
    void ShowSection(int section);
    void ShowSectionChoices(int section);
    void ExitSection();
    void UpdateToolbar();
    void EvaluateRandomChoice(int number);
    void LoadBookFunctions();
    bool ExecuteSystemScript(QString name);
    bool ExecuteScript(QString name, QString script);
    void ExecuteChoiceScript(Choice* choice);
    void EndMission();    
    void SetChoicesText();
    void SetChoiceText(QPushButton*, QString);    
    bool Load(QString filename="");
    QString GetTempSaveFilename();

protected:
    void resizeEvent(QResizeEvent *event);

private slots:
    void LoadFinishedSlot(bool);
    void GoSlot();

    void ChoiceSlot();
    void FightSlot();
    void PickItemsSlot();
    void StatusSlot();
    void GetRandomSlot();
    void RandomSlot(int);
    void EndSlot();

    void RulesSlot();
    void AboutSlot();
    void MapSlot();
    void BookInfoSlot();
    void ShopSlot();
    void ScrollToTopSlot();

public slots:
    void Print(QString);
    void MessageBox(QString title, QString message);
    QString ChooseWeapon(QString title);
    QString ChooseItem(QString title);
    QString ChooseItemExceptMeals(QString title);
    QString ChooseSpecialItem(QString title);
    void AddBonusDiscipline();
    bool LoadNextBook();
    void show();

    void ClearPickItems();
    // Add gold crowns to the pick item window.
    // If goldCrowns is < 0 then the number will be picked using a random number
    void AddPickGoldCrowns(int goldCrowns);
    void AddPickRandomGoldCrowns(int bonus);
    Item* AddPickItem(QString name, bool special);
    Item* AddMealPickItem(QString name);
    Weapon* AddWeaponPickItem(QString name, QString className);
    Item* AddHealingPickItem(QString name, int enduranceDelta);
    int PickItems(int max);
    int SelectGoldCrowns(int min);
    int GetRandomNumber();
    int GetRandomNumberWithBonus(int bonus);
    void DisableChoiceButton(int);
    void EnableChoiceButton(int);
    void DoChoice(int number);
    void DisableFightButton();
    void EnableFightButton();

    void PlayCartwheel();
    void PlayPortholes();
    int InputNumber(QString, int, int);
};

#endif // BOOKWINDOW_H
